/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.usb;

import android.content.ActivityNotFoundException;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.net.LocalSocket;
import android.net.LocalSocketAddress;
import android.os.Environment;
import android.os.FileUtils;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import android.util.Base64;
import android.util.Slog;
import com.android.server.FgThread;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.security.MessageDigest;
import java.util.Arrays;

public class UsbDebuggingManager
implements Runnable {
    private static final String TAG = "UsbDebuggingManager";
    private static final boolean DEBUG = false;
    private final String ADBD_SOCKET = "adbd";
    private final String ADB_DIRECTORY = "misc/adb";
    private final String ADB_KEYS_FILE = "adb_keys";
    private final int BUFFER_SIZE = 4096;
    private final Context mContext;
    private final Handler mHandler = new UsbDebuggingHandler(FgThread.get().getLooper());
    private Thread mThread;
    private boolean mAdbEnabled = false;
    private String mFingerprints;
    private LocalSocket mSocket = null;
    private OutputStream mOutputStream = null;

    public UsbDebuggingManager(Context context) {
        this.mContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void listenToSocket() throws IOException {
        block5: {
            try {
                byte[] buffer = new byte[4096];
                LocalSocketAddress address = new LocalSocketAddress("adbd", LocalSocketAddress.Namespace.RESERVED);
                InputStream inputStream = null;
                this.mSocket = new LocalSocket();
                this.mSocket.connect(address);
                this.mOutputStream = this.mSocket.getOutputStream();
                inputStream = this.mSocket.getInputStream();
                while (true) {
                    int count;
                    if ((count = inputStream.read(buffer)) < 0) {
                        break block5;
                    }
                    if (buffer[0] != 80 || buffer[1] != 75) break;
                    String key = new String(Arrays.copyOfRange(buffer, 2, count));
                    Slog.d(TAG, "Received public key: " + key);
                    Message msg = this.mHandler.obtainMessage(5);
                    msg.obj = key;
                    this.mHandler.sendMessage(msg);
                }
                Slog.e(TAG, "Wrong message: " + new String(Arrays.copyOfRange(buffer, 0, 2)));
            }
            finally {
                this.closeSocket();
            }
        }
    }

    @Override
    public void run() {
        while (this.mAdbEnabled) {
            try {
                this.listenToSocket();
            }
            catch (Exception e) {
                SystemClock.sleep(1000L);
            }
        }
    }

    private void closeSocket() {
        try {
            this.mOutputStream.close();
        }
        catch (IOException e) {
            Slog.e(TAG, "Failed closing output stream: " + e);
        }
        try {
            this.mSocket.close();
        }
        catch (IOException ex) {
            Slog.e(TAG, "Failed closing socket: " + ex);
        }
    }

    private void sendResponse(String msg) {
        if (this.mOutputStream != null) {
            try {
                this.mOutputStream.write(msg.getBytes());
            }
            catch (IOException ex) {
                Slog.e(TAG, "Failed to write response:", ex);
            }
        }
    }

    private String getFingerprints(String key) {
        MessageDigest digester;
        String hex = "0123456789ABCDEF";
        StringBuilder sb = new StringBuilder();
        try {
            digester = MessageDigest.getInstance("MD5");
        }
        catch (Exception ex) {
            Slog.e(TAG, "Error getting digester: " + ex);
            return "";
        }
        byte[] base64_data = key.split("\\s+")[0].getBytes();
        byte[] digest = digester.digest(Base64.decode(base64_data, 0));
        for (int i = 0; i < digest.length; ++i) {
            sb.append(hex.charAt(digest[i] >> 4 & 0xF));
            sb.append(hex.charAt(digest[i] & 0xF));
            if (i >= digest.length - 1) continue;
            sb.append(":");
        }
        return sb.toString();
    }

    private void startConfirmation(String key, String fingerprints) {
        String nameString = Resources.getSystem().getString(0x1040041);
        ComponentName componentName = ComponentName.unflattenFromString(nameString);
        if (this.startConfirmationActivity(componentName, key, fingerprints) || this.startConfirmationService(componentName, key, fingerprints)) {
            return;
        }
        Slog.e(TAG, "unable to start customAdbPublicKeyConfirmationComponent " + nameString + " as an Activity or a Service");
    }

    private boolean startConfirmationActivity(ComponentName componentName, String key, String fingerprints) {
        PackageManager packageManager = this.mContext.getPackageManager();
        Intent intent = this.createConfirmationIntent(componentName, key, fingerprints);
        intent.addFlags(0x10000000);
        if (packageManager.resolveActivity(intent, 65536) != null) {
            try {
                this.mContext.startActivity(intent);
                return true;
            }
            catch (ActivityNotFoundException e) {
                Slog.e(TAG, "unable to start adb whitelist activity: " + componentName, e);
            }
        }
        return false;
    }

    private boolean startConfirmationService(ComponentName componentName, String key, String fingerprints) {
        Intent intent = this.createConfirmationIntent(componentName, key, fingerprints);
        try {
            if (this.mContext.startService(intent) != null) {
                return true;
            }
        }
        catch (SecurityException e) {
            Slog.e(TAG, "unable to start adb whitelist service: " + componentName, e);
        }
        return false;
    }

    private Intent createConfirmationIntent(ComponentName componentName, String key, String fingerprints) {
        Intent intent = new Intent();
        intent.setClassName(componentName.getPackageName(), componentName.getClassName());
        intent.putExtra("key", key);
        intent.putExtra("fingerprints", fingerprints);
        return intent;
    }

    private File getUserKeyFile() {
        File dataDir = Environment.getDataDirectory();
        File adbDir = new File(dataDir, "misc/adb");
        if (!adbDir.exists()) {
            Slog.e(TAG, "ADB data directory does not exist");
            return null;
        }
        return new File(adbDir, "adb_keys");
    }

    private void writeKey(String key) {
        try {
            File keyFile = this.getUserKeyFile();
            if (keyFile == null) {
                return;
            }
            if (!keyFile.exists()) {
                keyFile.createNewFile();
                FileUtils.setPermissions(keyFile.toString(), 416, -1, -1);
            }
            FileOutputStream fo = new FileOutputStream(keyFile, true);
            fo.write(key.getBytes());
            fo.write(10);
            fo.close();
        }
        catch (IOException ex) {
            Slog.e(TAG, "Error writing key:" + ex);
        }
    }

    private void deleteKeyFile() {
        File keyFile = this.getUserKeyFile();
        if (keyFile != null) {
            keyFile.delete();
        }
    }

    public void setAdbEnabled(boolean enabled) {
        this.mHandler.sendEmptyMessage(enabled ? 1 : 2);
    }

    public void allowUsbDebugging(boolean alwaysAllow, String publicKey) {
        Message msg = this.mHandler.obtainMessage(3);
        msg.arg1 = alwaysAllow ? 1 : 0;
        msg.obj = publicKey;
        this.mHandler.sendMessage(msg);
    }

    public void denyUsbDebugging() {
        this.mHandler.sendEmptyMessage(4);
    }

    public void clearUsbDebuggingKeys() {
        this.mHandler.sendEmptyMessage(6);
    }

    public void dump(FileDescriptor fd, PrintWriter pw) {
        pw.println("  USB Debugging State:");
        pw.println("    Connected to adbd: " + (this.mOutputStream != null));
        pw.println("    Last key received: " + this.mFingerprints);
        pw.println("    User keys:");
        try {
            pw.println(FileUtils.readTextFile(new File("/data/misc/adb/adb_keys"), 0, null));
        }
        catch (IOException e) {
            pw.println("IOException: " + e);
        }
        pw.println("    System keys:");
        try {
            pw.println(FileUtils.readTextFile(new File("/adb_keys"), 0, null));
        }
        catch (IOException e) {
            pw.println("IOException: " + e);
        }
    }

    class UsbDebuggingHandler
    extends Handler {
        private static final int MESSAGE_ADB_ENABLED = 1;
        private static final int MESSAGE_ADB_DISABLED = 2;
        private static final int MESSAGE_ADB_ALLOW = 3;
        private static final int MESSAGE_ADB_DENY = 4;
        private static final int MESSAGE_ADB_CONFIRM = 5;
        private static final int MESSAGE_ADB_CLEAR = 6;

        public UsbDebuggingHandler(Looper looper) {
            super(looper);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    if (UsbDebuggingManager.this.mAdbEnabled) break;
                    UsbDebuggingManager.this.mAdbEnabled = true;
                    UsbDebuggingManager.this.mThread = new Thread((Runnable)UsbDebuggingManager.this, UsbDebuggingManager.TAG);
                    UsbDebuggingManager.this.mThread.start();
                    break;
                }
                case 2: {
                    if (!UsbDebuggingManager.this.mAdbEnabled) break;
                    UsbDebuggingManager.this.mAdbEnabled = false;
                    UsbDebuggingManager.this.closeSocket();
                    try {
                        UsbDebuggingManager.this.mThread.join();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    UsbDebuggingManager.this.mThread = null;
                    UsbDebuggingManager.this.mOutputStream = null;
                    UsbDebuggingManager.this.mSocket = null;
                    break;
                }
                case 3: {
                    String key = (String)msg.obj;
                    String fingerprints = UsbDebuggingManager.this.getFingerprints(key);
                    if (!fingerprints.equals(UsbDebuggingManager.this.mFingerprints)) {
                        Slog.e(UsbDebuggingManager.TAG, "Fingerprints do not match. Got " + fingerprints + ", expected " + UsbDebuggingManager.this.mFingerprints);
                        break;
                    }
                    if (msg.arg1 == 1) {
                        UsbDebuggingManager.this.writeKey(key);
                    }
                    UsbDebuggingManager.this.sendResponse("OK");
                    break;
                }
                case 4: {
                    UsbDebuggingManager.this.sendResponse("NO");
                    break;
                }
                case 5: {
                    String key = (String)msg.obj;
                    UsbDebuggingManager.this.mFingerprints = UsbDebuggingManager.this.getFingerprints(key);
                    UsbDebuggingManager.this.startConfirmation(key, UsbDebuggingManager.this.mFingerprints);
                    break;
                }
                case 6: {
                    UsbDebuggingManager.this.deleteKeyFile();
                }
            }
        }
    }
}

