/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.usb;

import android.alsa.AlsaCardsParser;
import android.alsa.AlsaDevicesParser;
import android.content.Context;
import android.content.Intent;
import android.hardware.usb.UsbConfiguration;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.os.Bundle;
import android.os.ParcelFileDescriptor;
import android.os.UserHandle;
import android.util.Slog;
import com.android.internal.annotations.GuardedBy;
import com.android.server.usb.UsbSettingsManager;
import java.io.File;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;

public class UsbHostManager {
    private static final String TAG = UsbHostManager.class.getSimpleName();
    private static final boolean DEBUG_AUDIO = false;
    private final HashMap<String, UsbDevice> mDevices = new HashMap();
    private final String[] mHostBlacklist;
    private final Context mContext;
    private final Object mLock = new Object();
    private UsbDevice mNewDevice;
    private UsbConfiguration mNewConfiguration;
    private UsbInterface mNewInterface;
    private ArrayList<UsbConfiguration> mNewConfigurations;
    private ArrayList<UsbInterface> mNewInterfaces;
    private ArrayList<UsbEndpoint> mNewEndpoints;
    private int mConnectedUsbCard = -1;
    private int mConnectedUsbDeviceNum = -1;
    private boolean mConnectedHasPlayback = false;
    private boolean mConnectedHasCapture = false;
    private boolean mConnectedHasMIDI = false;
    @GuardedBy(value="mLock")
    private UsbSettingsManager mCurrentSettings;

    public UsbHostManager(Context context) {
        this.mContext = context;
        this.mHostBlacklist = context.getResources().getStringArray(17235992);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentSettings(UsbSettingsManager settings) {
        Object object = this.mLock;
        synchronized (object) {
            this.mCurrentSettings = settings;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UsbSettingsManager getCurrentSettings() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mCurrentSettings;
        }
    }

    private boolean isBlackListed(String deviceName) {
        int count = this.mHostBlacklist.length;
        for (int i = 0; i < count; ++i) {
            if (!deviceName.startsWith(this.mHostBlacklist[i])) continue;
            return true;
        }
        return false;
    }

    private boolean isBlackListed(int clazz, int subClass, int protocol) {
        if (clazz == 9) {
            return true;
        }
        return clazz == 3 && subClass == 1;
    }

    private void sendDeviceNotification(int card, int device, boolean enabled, boolean hasPlayback, boolean hasCapture, boolean hasMIDI) {
        Intent intent = new Intent("android.media.action.USB_AUDIO_DEVICE_PLUG");
        intent.addFlags(0x20000000);
        intent.addFlags(0x40000000);
        intent.putExtra("state", enabled ? 1 : 0);
        intent.putExtra("card", card);
        intent.putExtra("device", device);
        intent.putExtra("hasPlayback", hasPlayback);
        intent.putExtra("hasCapture", hasCapture);
        intent.putExtra("hasMIDI", hasMIDI);
        this.mContext.sendStickyBroadcastAsUser(intent, UserHandle.ALL);
    }

    private boolean waitForAlsaFile(int card, int device, boolean capture) {
        int kNumRetries = 5;
        int kSleepTime = 500;
        String alsaDevPath = "/dev/snd/pcmC" + card + "D" + device + (capture ? "c" : "p");
        File alsaDevFile = new File(alsaDevPath);
        boolean exists = false;
        for (int retry = 0; !exists && retry < 5; ++retry) {
            exists = alsaDevFile.exists();
            if (exists) continue;
            try {
                Thread.sleep(500L);
                continue;
            }
            catch (IllegalThreadStateException ex) {
                Slog.d(TAG, "usb: IllegalThreadStateException while waiting for ALSA file.");
                continue;
            }
            catch (InterruptedException ex) {
                Slog.d(TAG, "usb: InterruptedException while waiting for ALSA file.");
            }
        }
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean beginUsbDeviceAdded(String deviceName, int vendorID, int productID, int deviceClass, int deviceSubclass, int deviceProtocol, String manufacturerName, String productName, String serialNumber) {
        if (this.isBlackListed(deviceName) || this.isBlackListed(deviceClass, deviceSubclass, deviceProtocol)) {
            return false;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mDevices.get(deviceName) != null) {
                Slog.w(TAG, "device already on mDevices list: " + deviceName);
                return false;
            }
            if (this.mNewDevice != null) {
                Slog.e(TAG, "mNewDevice is not null in endUsbDeviceAdded");
                return false;
            }
            this.mNewDevice = new UsbDevice(deviceName, vendorID, productID, deviceClass, deviceSubclass, deviceProtocol, manufacturerName, productName, serialNumber);
            this.mNewConfigurations = new ArrayList();
            this.mNewInterfaces = new ArrayList();
            this.mNewEndpoints = new ArrayList();
        }
        return true;
    }

    private void addUsbConfiguration(int id2, String name, int attributes, int maxPower) {
        if (this.mNewConfiguration != null) {
            this.mNewConfiguration.setInterfaces(this.mNewInterfaces.toArray(new UsbInterface[this.mNewInterfaces.size()]));
            this.mNewInterfaces.clear();
        }
        this.mNewConfiguration = new UsbConfiguration(id2, name, attributes, maxPower);
        this.mNewConfigurations.add(this.mNewConfiguration);
    }

    private void addUsbInterface(int id2, String name, int altSetting, int Class2, int subClass, int protocol) {
        if (this.mNewInterface != null) {
            this.mNewInterface.setEndpoints(this.mNewEndpoints.toArray(new UsbEndpoint[this.mNewEndpoints.size()]));
            this.mNewEndpoints.clear();
        }
        this.mNewInterface = new UsbInterface(id2, altSetting, name, Class2, subClass, protocol);
        this.mNewInterfaces.add(this.mNewInterface);
    }

    private void addUsbEndpoint(int address, int attributes, int maxPacketSize, int interval) {
        this.mNewEndpoints.add(new UsbEndpoint(address, attributes, maxPacketSize, interval));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endUsbDeviceAdded() {
        if (this.mNewInterface != null) {
            this.mNewInterface.setEndpoints(this.mNewEndpoints.toArray(new UsbEndpoint[this.mNewEndpoints.size()]));
        }
        if (this.mNewConfiguration != null) {
            this.mNewConfiguration.setInterfaces(this.mNewInterfaces.toArray(new UsbInterface[this.mNewInterfaces.size()]));
        }
        boolean kUsbClassId_Audio = true;
        boolean isAudioDevice = false;
        for (int ntrfaceIndex = 0; !isAudioDevice && ntrfaceIndex < this.mNewInterfaces.size(); ++ntrfaceIndex) {
            UsbInterface ntrface = this.mNewInterfaces.get(ntrfaceIndex);
            if (ntrface.getInterfaceClass() != 1) continue;
            isAudioDevice = true;
        }
        Object ntrfaceIndex = this.mLock;
        synchronized (ntrfaceIndex) {
            if (this.mNewDevice != null) {
                this.mNewDevice.setConfigurations(this.mNewConfigurations.toArray(new UsbConfiguration[this.mNewConfigurations.size()]));
                this.mDevices.put(this.mNewDevice.getDeviceName(), this.mNewDevice);
                Slog.d(TAG, "Added device " + this.mNewDevice);
                this.getCurrentSettings().deviceAttached(this.mNewDevice);
            } else {
                Slog.e(TAG, "mNewDevice is null in endUsbDeviceAdded");
            }
            this.mNewDevice = null;
            this.mNewConfigurations = null;
            this.mNewInterfaces = null;
            this.mNewEndpoints = null;
        }
        if (!isAudioDevice) {
            return;
        }
        AlsaCardsParser cardsParser = new AlsaCardsParser();
        cardsParser.scan();
        AlsaDevicesParser devicesParser = new AlsaDevicesParser();
        devicesParser.scan();
        this.mConnectedUsbCard = cardsParser.getNumCardRecords() - 1;
        this.mConnectedUsbDeviceNum = 0;
        this.mConnectedHasPlayback = devicesParser.hasPlaybackDevices(this.mConnectedUsbCard);
        this.mConnectedHasCapture = devicesParser.hasCaptureDevices(this.mConnectedUsbCard);
        this.mConnectedHasMIDI = devicesParser.hasMIDIDevices(this.mConnectedUsbCard);
        if (this.mConnectedHasPlayback && !this.waitForAlsaFile(this.mConnectedUsbCard, this.mConnectedUsbDeviceNum, false)) {
            return;
        }
        if (this.mConnectedHasCapture && !this.waitForAlsaFile(this.mConnectedUsbCard, this.mConnectedUsbDeviceNum, true)) {
            return;
        }
        this.sendDeviceNotification(this.mConnectedUsbCard, this.mConnectedUsbDeviceNum, true, this.mConnectedHasPlayback, this.mConnectedHasCapture, this.mConnectedHasMIDI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void usbDeviceRemoved(String deviceName) {
        if (this.mConnectedUsbCard != -1 && this.mConnectedUsbDeviceNum != -1) {
            this.sendDeviceNotification(this.mConnectedUsbCard, this.mConnectedUsbDeviceNum, false, this.mConnectedHasPlayback, this.mConnectedHasCapture, this.mConnectedHasMIDI);
            this.mConnectedUsbCard = -1;
            this.mConnectedUsbDeviceNum = -1;
            this.mConnectedHasPlayback = false;
            this.mConnectedHasCapture = false;
            this.mConnectedHasMIDI = false;
        }
        Object object = this.mLock;
        synchronized (object) {
            UsbDevice device = this.mDevices.remove(deviceName);
            if (device != null) {
                this.getCurrentSettings().deviceDetached(device);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void systemReady() {
        Object object = this.mLock;
        synchronized (object) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    UsbHostManager.this.monitorUsbHostBus();
                }
            };
            new Thread(null, runnable, "UsbService host thread").start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getDeviceList(Bundle devices) {
        Object object = this.mLock;
        synchronized (object) {
            for (String name : this.mDevices.keySet()) {
                devices.putParcelable(name, this.mDevices.get(name));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParcelFileDescriptor openDevice(String deviceName) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.isBlackListed(deviceName)) {
                throw new SecurityException("USB device is on a restricted bus");
            }
            UsbDevice device = this.mDevices.get(deviceName);
            if (device == null) {
                throw new IllegalArgumentException("device " + deviceName + " does not exist or is restricted");
            }
            this.getCurrentSettings().checkPermission(device);
            return this.nativeOpenDevice(deviceName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(FileDescriptor fd, PrintWriter pw) {
        Object object = this.mLock;
        synchronized (object) {
            pw.println("  USB Host State:");
            for (String name : this.mDevices.keySet()) {
                pw.println("    " + name + ": " + this.mDevices.get(name));
            }
        }
    }

    private native void monitorUsbHostBus();

    private native ParcelFileDescriptor nativeOpenDevice(String var1);
}

