/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.usb;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.hardware.usb.IUsbManager;
import android.hardware.usb.UsbAccessory;
import android.hardware.usb.UsbDevice;
import android.os.Bundle;
import android.os.ParcelFileDescriptor;
import android.os.UserHandle;
import android.os.UserManager;
import android.util.SparseArray;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.IndentingPrintWriter;
import com.android.server.SystemService;
import com.android.server.usb.UsbDeviceManager;
import com.android.server.usb.UsbHostManager;
import com.android.server.usb.UsbSettingsManager;
import java.io.File;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.Writer;

public class UsbService
extends IUsbManager.Stub {
    private static final String TAG = "UsbService";
    private final Context mContext;
    private UsbDeviceManager mDeviceManager;
    private UsbHostManager mHostManager;
    private final Object mLock = new Object();
    @GuardedBy(value="mLock")
    private final SparseArray<UsbSettingsManager> mSettingsByUser = new SparseArray();
    private BroadcastReceiver mUserReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            int userId = intent.getIntExtra("android.intent.extra.user_handle", -1);
            String action = intent.getAction();
            if ("android.intent.action.USER_SWITCHED".equals(action)) {
                UsbService.this.setCurrentUser(userId);
            } else if ("android.intent.action.USER_STOPPED".equals(action)) {
                Object object = UsbService.this.mLock;
                synchronized (object) {
                    UsbService.this.mSettingsByUser.remove(userId);
                }
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UsbSettingsManager getSettingsForUser(int userId) {
        Object object = this.mLock;
        synchronized (object) {
            UsbSettingsManager settings = this.mSettingsByUser.get(userId);
            if (settings == null) {
                settings = new UsbSettingsManager(this.mContext, new UserHandle(userId));
                this.mSettingsByUser.put(userId, settings);
            }
            return settings;
        }
    }

    public UsbService(Context context) {
        this.mContext = context;
        PackageManager pm = this.mContext.getPackageManager();
        if (pm.hasSystemFeature("android.hardware.usb.host")) {
            this.mHostManager = new UsbHostManager(context);
        }
        if (new File("/sys/class/android_usb").exists()) {
            this.mDeviceManager = new UsbDeviceManager(context);
        }
        this.setCurrentUser(0);
        IntentFilter userFilter = new IntentFilter();
        userFilter.addAction("android.intent.action.USER_SWITCHED");
        userFilter.addAction("android.intent.action.USER_STOPPED");
        this.mContext.registerReceiver(this.mUserReceiver, userFilter, null, null);
    }

    private void setCurrentUser(int userId) {
        UsbSettingsManager userSettings = this.getSettingsForUser(userId);
        if (this.mHostManager != null) {
            this.mHostManager.setCurrentSettings(userSettings);
        }
        if (this.mDeviceManager != null) {
            this.mDeviceManager.setCurrentSettings(userSettings);
        }
    }

    public void systemReady() {
        if (this.mDeviceManager != null) {
            this.mDeviceManager.systemReady();
        }
        if (this.mHostManager != null) {
            this.mHostManager.systemReady();
        }
    }

    @Override
    public void getDeviceList(Bundle devices) {
        if (this.mHostManager != null) {
            this.mHostManager.getDeviceList(devices);
        }
    }

    @Override
    public ParcelFileDescriptor openDevice(String deviceName) {
        if (this.mHostManager != null) {
            return this.mHostManager.openDevice(deviceName);
        }
        return null;
    }

    @Override
    public UsbAccessory getCurrentAccessory() {
        if (this.mDeviceManager != null) {
            return this.mDeviceManager.getCurrentAccessory();
        }
        return null;
    }

    @Override
    public ParcelFileDescriptor openAccessory(UsbAccessory accessory) {
        if (this.mDeviceManager != null) {
            return this.mDeviceManager.openAccessory(accessory);
        }
        return null;
    }

    @Override
    public void setDevicePackage(UsbDevice device, String packageName, int userId) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_USB", null);
        this.getSettingsForUser(userId).setDevicePackage(device, packageName);
    }

    @Override
    public void setAccessoryPackage(UsbAccessory accessory, String packageName, int userId) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_USB", null);
        this.getSettingsForUser(userId).setAccessoryPackage(accessory, packageName);
    }

    @Override
    public boolean hasDevicePermission(UsbDevice device) {
        int userId = UserHandle.getCallingUserId();
        return this.getSettingsForUser(userId).hasPermission(device);
    }

    @Override
    public boolean hasAccessoryPermission(UsbAccessory accessory) {
        int userId = UserHandle.getCallingUserId();
        return this.getSettingsForUser(userId).hasPermission(accessory);
    }

    @Override
    public void requestDevicePermission(UsbDevice device, String packageName, PendingIntent pi) {
        int userId = UserHandle.getCallingUserId();
        this.getSettingsForUser(userId).requestPermission(device, packageName, pi);
    }

    @Override
    public void requestAccessoryPermission(UsbAccessory accessory, String packageName, PendingIntent pi) {
        int userId = UserHandle.getCallingUserId();
        this.getSettingsForUser(userId).requestPermission(accessory, packageName, pi);
    }

    @Override
    public void grantDevicePermission(UsbDevice device, int uid) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_USB", null);
        int userId = UserHandle.getUserId(uid);
        this.getSettingsForUser(userId).grantDevicePermission(device, uid);
    }

    @Override
    public void grantAccessoryPermission(UsbAccessory accessory, int uid) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_USB", null);
        int userId = UserHandle.getUserId(uid);
        this.getSettingsForUser(userId).grantAccessoryPermission(accessory, uid);
    }

    @Override
    public boolean hasDefaults(String packageName, int userId) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_USB", null);
        return this.getSettingsForUser(userId).hasDefaults(packageName);
    }

    @Override
    public void clearDefaults(String packageName, int userId) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_USB", null);
        this.getSettingsForUser(userId).clearDefaults(packageName);
    }

    @Override
    public void setCurrentFunction(String function, boolean makeDefault) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_USB", null);
        UserManager userManager = (UserManager)this.mContext.getSystemService("user");
        if (userManager.hasUserRestriction("no_usb_file_transfer")) {
            if (this.mDeviceManager != null) {
                this.mDeviceManager.setCurrentFunctions("none", false);
            }
            return;
        }
        if (this.mDeviceManager == null) {
            throw new IllegalStateException("USB device mode not supported");
        }
        this.mDeviceManager.setCurrentFunctions(function, makeDefault);
    }

    @Override
    public void setMassStorageBackingFile(String path) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_USB", null);
        if (this.mDeviceManager == null) {
            throw new IllegalStateException("USB device mode not supported");
        }
        this.mDeviceManager.setMassStorageBackingFile(path);
    }

    @Override
    public void allowUsbDebugging(boolean alwaysAllow, String publicKey) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_USB", null);
        this.mDeviceManager.allowUsbDebugging(alwaysAllow, publicKey);
    }

    @Override
    public void denyUsbDebugging() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_USB", null);
        this.mDeviceManager.denyUsbDebugging();
    }

    @Override
    public void clearUsbDebuggingKeys() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_USB", null);
        this.mDeviceManager.clearUsbDebuggingKeys();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump(FileDescriptor fd, PrintWriter writer, String[] args) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.DUMP", TAG);
        IndentingPrintWriter pw = new IndentingPrintWriter((Writer)writer, "  ");
        pw.println("USB Manager State:");
        if (this.mDeviceManager != null) {
            this.mDeviceManager.dump(fd, pw);
        }
        if (this.mHostManager != null) {
            this.mHostManager.dump(fd, pw);
        }
        Object object = this.mLock;
        synchronized (object) {
            for (int i = 0; i < this.mSettingsByUser.size(); ++i) {
                int userId = this.mSettingsByUser.keyAt(i);
                UsbSettingsManager settings = this.mSettingsByUser.valueAt(i);
                pw.increaseIndent();
                pw.println("Settings for user " + userId + ":");
                settings.dump(fd, pw);
                pw.decreaseIndent();
            }
        }
        pw.decreaseIndent();
    }

    public static class Lifecycle
    extends SystemService {
        private UsbService mUsbService;

        public Lifecycle(Context context) {
            super(context);
        }

        @Override
        public void onStart() {
            this.mUsbService = new UsbService(this.getContext());
            this.publishBinderService("usb", this.mUsbService);
        }

        @Override
        public void onBootPhase(int phase) {
            if (phase == 550) {
                this.mUsbService.systemReady();
            }
        }
    }
}

