/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.voiceinteraction;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.soundtrigger.IRecognitionStatusCallback;
import android.hardware.soundtrigger.SoundTrigger;
import android.hardware.soundtrigger.SoundTriggerModule;
import android.os.PowerManager;
import android.os.RemoteException;
import android.telephony.PhoneStateListener;
import android.telephony.TelephonyManager;
import android.util.Slog;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.UUID;

public class SoundTriggerHelper
implements SoundTrigger.StatusListener {
    static final String TAG = "SoundTriggerHelper";
    static final boolean DBG = false;
    public static final int STATUS_ERROR = Integer.MIN_VALUE;
    public static final int STATUS_OK = 0;
    private static final int INVALID_VALUE = Integer.MIN_VALUE;
    final SoundTrigger.ModuleProperties moduleProperties;
    private SoundTriggerModule mModule;
    private final Object mLock = new Object();
    private final Context mContext;
    private final TelephonyManager mTelephonyManager;
    private final PhoneStateListener mPhoneStateListener;
    private final PowerManager mPowerManager;
    private IRecognitionStatusCallback mActiveListener;
    private int mKeyphraseId = Integer.MIN_VALUE;
    private int mCurrentSoundModelHandle = Integer.MIN_VALUE;
    private UUID mCurrentSoundModelUuid = null;
    private SoundTrigger.RecognitionConfig mRecognitionConfig = null;
    private boolean mRequested = false;
    private boolean mCallActive = false;
    private boolean mIsPowerSaveMode = false;
    private boolean mServiceDisabled = false;
    private boolean mStarted = false;
    private PowerSaveModeListener mPowerSaveModeListener;

    SoundTriggerHelper(Context context) {
        ArrayList<SoundTrigger.ModuleProperties> modules = new ArrayList<SoundTrigger.ModuleProperties>();
        int status = SoundTrigger.listModules(modules);
        this.mContext = context;
        this.mTelephonyManager = (TelephonyManager)context.getSystemService("phone");
        this.mPowerManager = (PowerManager)context.getSystemService("power");
        this.mPhoneStateListener = new MyCallStateListener();
        if (status != 0 || modules.size() == 0) {
            Slog.w(TAG, "listModules status=" + status + ", # of modules=" + modules.size());
            this.moduleProperties = null;
            this.mModule = null;
        } else {
            this.moduleProperties = modules.get(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int startRecognition(int keyphraseId, SoundTrigger.KeyphraseSoundModel soundModel, IRecognitionStatusCallback listener, SoundTrigger.RecognitionConfig recognitionConfig) {
        if (soundModel == null || listener == null || recognitionConfig == null) {
            return Integer.MIN_VALUE;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mStarted) {
                this.mCallActive = this.mTelephonyManager.getCallState() != 0;
                this.mTelephonyManager.listen(this.mPhoneStateListener, 32);
                if (this.mPowerSaveModeListener == null) {
                    this.mPowerSaveModeListener = new PowerSaveModeListener();
                    this.mContext.registerReceiver(this.mPowerSaveModeListener, new IntentFilter("android.os.action.POWER_SAVE_MODE_CHANGED"));
                }
                this.mIsPowerSaveMode = this.mPowerManager.isPowerSaveMode();
            }
            if (this.moduleProperties == null) {
                Slog.w(TAG, "Attempting startRecognition without the capability");
                return Integer.MIN_VALUE;
            }
            if (this.mModule == null) {
                this.mModule = SoundTrigger.attachModule(this.moduleProperties.id, this, null);
                if (this.mModule == null) {
                    Slog.w(TAG, "startRecognition cannot attach to sound trigger module");
                    return Integer.MIN_VALUE;
                }
            }
            if (this.mCurrentSoundModelHandle != Integer.MIN_VALUE && (!soundModel.uuid.equals(this.mCurrentSoundModelUuid) || this.mStarted)) {
                Slog.w(TAG, "Unloading previous sound model");
                int status = this.mModule.unloadSoundModel(this.mCurrentSoundModelHandle);
                if (status != 0) {
                    Slog.w(TAG, "unloadSoundModel call failed with " + status);
                }
                this.mCurrentSoundModelHandle = Integer.MIN_VALUE;
                this.mCurrentSoundModelUuid = null;
                this.mStarted = false;
            }
            if (this.mActiveListener != null && this.mActiveListener.asBinder() != listener.asBinder()) {
                Slog.w(TAG, "Canceling previous recognition");
                try {
                    this.mActiveListener.onError(Integer.MIN_VALUE);
                }
                catch (RemoteException e) {
                    Slog.w(TAG, "RemoteException in onDetectionStopped", e);
                }
                this.mActiveListener = null;
            }
            int soundModelHandle = this.mCurrentSoundModelHandle;
            if (this.mCurrentSoundModelHandle == Integer.MIN_VALUE || this.mCurrentSoundModelUuid == null) {
                int[] handle = new int[]{Integer.MIN_VALUE};
                int status = this.mModule.loadSoundModel(soundModel, handle);
                if (status != 0) {
                    Slog.w(TAG, "loadSoundModel call failed with " + status);
                    return status;
                }
                if (handle[0] == Integer.MIN_VALUE) {
                    Slog.w(TAG, "loadSoundModel call returned invalid sound model handle");
                    return Integer.MIN_VALUE;
                }
                soundModelHandle = handle[0];
            }
            this.mRequested = true;
            this.mKeyphraseId = keyphraseId;
            this.mCurrentSoundModelHandle = soundModelHandle;
            this.mCurrentSoundModelUuid = soundModel.uuid;
            this.mRecognitionConfig = recognitionConfig;
            this.mActiveListener = listener;
            return this.updateRecognitionLocked(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int stopRecognition(int keyphraseId, IRecognitionStatusCallback listener) {
        if (listener == null) {
            return Integer.MIN_VALUE;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.moduleProperties == null || this.mModule == null) {
                Slog.w(TAG, "Attempting stopRecognition without the capability");
                return Integer.MIN_VALUE;
            }
            if (this.mActiveListener == null) {
                Slog.w(TAG, "Attempting stopRecognition without a successful startRecognition");
                return Integer.MIN_VALUE;
            }
            if (this.mActiveListener.asBinder() != listener.asBinder()) {
                Slog.w(TAG, "Attempting stopRecognition for another recognition");
                return Integer.MIN_VALUE;
            }
            this.mRequested = false;
            int status = this.updateRecognitionLocked(false);
            if (status != 0) {
                return status;
            }
            status = this.mModule.unloadSoundModel(this.mCurrentSoundModelHandle);
            if (status != 0) {
                Slog.w(TAG, "unloadSoundModel call failed with " + status);
            }
            this.internalClearStateLocked();
            return status;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopAllRecognitions() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.moduleProperties == null || this.mModule == null) {
                return;
            }
            if (this.mCurrentSoundModelHandle == Integer.MIN_VALUE) {
                return;
            }
            this.mRequested = false;
            int status = this.updateRecognitionLocked(false);
            status = this.mModule.unloadSoundModel(this.mCurrentSoundModelHandle);
            if (status != 0) {
                Slog.w(TAG, "unloadSoundModel call failed with " + status);
            }
            this.internalClearStateLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRecognition(SoundTrigger.RecognitionEvent event) {
        if (event == null || !(event instanceof SoundTrigger.KeyphraseRecognitionEvent)) {
            Slog.w(TAG, "Invalid recognition event!");
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mActiveListener == null) {
                Slog.w(TAG, "received onRecognition event without any listener for it");
                return;
            }
            switch (event.status) {
                case 1: {
                    this.onRecognitionAbortLocked();
                    break;
                }
                case 2: {
                    this.onRecognitionFailureLocked();
                    break;
                }
                case 0: {
                    this.onRecognitionSuccessLocked((SoundTrigger.KeyphraseRecognitionEvent)event);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSoundModelUpdate(SoundTrigger.SoundModelEvent event) {
        if (event == null) {
            Slog.w(TAG, "Invalid sound model event!");
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.onSoundModelUpdatedLocked(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onServiceStateChange(int state) {
        Object object = this.mLock;
        synchronized (object) {
            this.onServiceStateChangedLocked(1 == state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onServiceDied() {
        Slog.e(TAG, "onServiceDied!!");
        Object object = this.mLock;
        synchronized (object) {
            this.onServiceDiedLocked();
        }
    }

    private void onCallStateChangedLocked(boolean callActive) {
        if (this.mCallActive == callActive) {
            return;
        }
        this.mCallActive = callActive;
        this.updateRecognitionLocked(true);
    }

    private void onPowerSaveModeChangedLocked(boolean isPowerSaveMode) {
        if (this.mIsPowerSaveMode == isPowerSaveMode) {
            return;
        }
        this.mIsPowerSaveMode = isPowerSaveMode;
        this.updateRecognitionLocked(true);
    }

    private void onSoundModelUpdatedLocked(SoundTrigger.SoundModelEvent event) {
    }

    private void onServiceStateChangedLocked(boolean disabled) {
        if (disabled == this.mServiceDisabled) {
            return;
        }
        this.mServiceDisabled = disabled;
        this.updateRecognitionLocked(true);
    }

    private void onRecognitionAbortLocked() {
        Slog.w(TAG, "Recognition aborted");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onRecognitionFailureLocked() {
        Slog.w(TAG, "Recognition failure");
        try {
            if (this.mActiveListener != null) {
                this.mActiveListener.onError(Integer.MIN_VALUE);
            }
        }
        catch (RemoteException e) {
            Slog.w(TAG, "RemoteException in onError", e);
        }
        finally {
            this.internalClearStateLocked();
        }
    }

    private void onRecognitionSuccessLocked(SoundTrigger.KeyphraseRecognitionEvent event) {
        Slog.i(TAG, "Recognition success");
        SoundTrigger.KeyphraseRecognitionExtra[] keyphraseExtras = event.keyphraseExtras;
        if (keyphraseExtras == null || keyphraseExtras.length == 0) {
            Slog.w(TAG, "Invalid keyphrase recognition event!");
            return;
        }
        if (this.mKeyphraseId != keyphraseExtras[0].id) {
            Slog.w(TAG, "received onRecognition event for a different keyphrase");
            return;
        }
        try {
            if (this.mActiveListener != null) {
                this.mActiveListener.onDetected(event);
            }
        }
        catch (RemoteException e) {
            Slog.w(TAG, "RemoteException in onDetected", e);
        }
        this.mStarted = false;
        this.mRequested = this.mRecognitionConfig.allowMultipleTriggers;
        if (this.mRequested) {
            this.updateRecognitionLocked(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onServiceDiedLocked() {
        try {
            if (this.mActiveListener != null) {
                this.mActiveListener.onError(-32);
            }
        }
        catch (RemoteException e) {
            Slog.w(TAG, "RemoteException in onError", e);
        }
        finally {
            this.internalClearStateLocked();
            if (this.mModule != null) {
                this.mModule.detach();
                this.mModule = null;
            }
        }
    }

    private int updateRecognitionLocked(boolean notify) {
        boolean start;
        if (this.mModule == null || this.moduleProperties == null || this.mCurrentSoundModelHandle == Integer.MIN_VALUE || this.mActiveListener == null) {
            return 0;
        }
        boolean bl = start = this.mRequested && !this.mCallActive && !this.mServiceDisabled && !this.mIsPowerSaveMode;
        if (start == this.mStarted) {
            return 0;
        }
        if (start) {
            int status = this.mModule.startRecognition(this.mCurrentSoundModelHandle, this.mRecognitionConfig);
            if (status != 0) {
                Slog.w(TAG, "startRecognition failed with " + status);
                if (notify) {
                    try {
                        this.mActiveListener.onError(status);
                    }
                    catch (RemoteException e) {
                        Slog.w(TAG, "RemoteException in onError", e);
                    }
                }
            } else {
                this.mStarted = true;
                if (notify) {
                    try {
                        this.mActiveListener.onRecognitionResumed();
                    }
                    catch (RemoteException e) {
                        Slog.w(TAG, "RemoteException in onRecognitionResumed", e);
                    }
                }
            }
            return status;
        }
        int status = this.mModule.stopRecognition(this.mCurrentSoundModelHandle);
        if (status != 0) {
            Slog.w(TAG, "stopRecognition call failed with " + status);
            if (notify) {
                try {
                    this.mActiveListener.onError(status);
                }
                catch (RemoteException e) {
                    Slog.w(TAG, "RemoteException in onError", e);
                }
            }
        } else {
            this.mStarted = false;
            if (notify) {
                try {
                    this.mActiveListener.onRecognitionPaused();
                }
                catch (RemoteException e) {
                    Slog.w(TAG, "RemoteException in onRecognitionPaused", e);
                }
            }
        }
        return status;
    }

    private void internalClearStateLocked() {
        this.mStarted = false;
        this.mRequested = false;
        this.mKeyphraseId = Integer.MIN_VALUE;
        this.mCurrentSoundModelHandle = Integer.MIN_VALUE;
        this.mCurrentSoundModelUuid = null;
        this.mRecognitionConfig = null;
        this.mActiveListener = null;
        this.mTelephonyManager.listen(this.mPhoneStateListener, 0);
        if (this.mPowerSaveModeListener != null) {
            this.mContext.unregisterReceiver(this.mPowerSaveModeListener);
            this.mPowerSaveModeListener = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        Object object = this.mLock;
        synchronized (object) {
            pw.print("  module properties=");
            pw.println(this.moduleProperties == null ? "null" : this.moduleProperties);
            pw.print("  keyphrase ID=");
            pw.println(this.mKeyphraseId);
            pw.print("  sound model handle=");
            pw.println(this.mCurrentSoundModelHandle);
            pw.print("  sound model UUID=");
            pw.println(this.mCurrentSoundModelUuid == null ? "null" : this.mCurrentSoundModelUuid);
            pw.print("  current listener=");
            pw.println(this.mActiveListener == null ? "null" : this.mActiveListener.asBinder());
            pw.print("  requested=");
            pw.println(this.mRequested);
            pw.print("  started=");
            pw.println(this.mStarted);
            pw.print("  call active=");
            pw.println(this.mCallActive);
            pw.print("  power save mode active=");
            pw.println(this.mIsPowerSaveMode);
            pw.print("  service disabled=");
            pw.println(this.mServiceDisabled);
        }
    }

    class PowerSaveModeListener
    extends BroadcastReceiver {
        PowerSaveModeListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            if (!"android.os.action.POWER_SAVE_MODE_CHANGED".equals(intent.getAction())) {
                return;
            }
            boolean active = SoundTriggerHelper.this.mPowerManager.isPowerSaveMode();
            Object object = SoundTriggerHelper.this.mLock;
            synchronized (object) {
                SoundTriggerHelper.this.onPowerSaveModeChangedLocked(active);
            }
        }
    }

    class MyCallStateListener
    extends PhoneStateListener {
        MyCallStateListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCallStateChanged(int state, String arg1) {
            Object object = SoundTriggerHelper.this.mLock;
            synchronized (object) {
                SoundTriggerHelper.this.onCallStateChangedLocked(0 != state);
            }
        }
    }
}

