/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.voiceinteraction;

import android.app.ActivityManager;
import android.app.AppGlobals;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.IPackageManager;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.database.ContentObserver;
import android.hardware.soundtrigger.IRecognitionStatusCallback;
import android.hardware.soundtrigger.SoundTrigger;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Parcel;
import android.os.RemoteException;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.provider.Settings;
import android.service.voice.IVoiceInteractionService;
import android.service.voice.IVoiceInteractionSession;
import android.service.voice.VoiceInteractionServiceInfo;
import android.text.TextUtils;
import android.util.Slog;
import com.android.internal.app.IVoiceInteractionManagerService;
import com.android.internal.app.IVoiceInteractor;
import com.android.internal.content.PackageMonitor;
import com.android.internal.os.BackgroundThread;
import com.android.server.SystemService;
import com.android.server.UiThread;
import com.android.server.voiceinteraction.DatabaseHelper;
import com.android.server.voiceinteraction.SoundTriggerHelper;
import com.android.server.voiceinteraction.VoiceInteractionManagerServiceImpl;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.List;

public class VoiceInteractionManagerService
extends SystemService {
    static final String TAG = "VoiceInteractionManagerService";
    static final boolean DEBUG = false;
    final Context mContext;
    final ContentResolver mResolver;
    final DatabaseHelper mDbHelper;
    final SoundTriggerHelper mSoundTriggerHelper;
    private final VoiceInteractionManagerServiceStub mServiceStub = new VoiceInteractionManagerServiceStub();

    public VoiceInteractionManagerService(Context context) {
        super(context);
        this.mContext = context;
        this.mResolver = context.getContentResolver();
        this.mDbHelper = new DatabaseHelper(context);
        this.mSoundTriggerHelper = new SoundTriggerHelper(context);
    }

    @Override
    public void onStart() {
        this.publishBinderService("voiceinteraction", this.mServiceStub);
    }

    @Override
    public void onBootPhase(int phase) {
        if (phase == 600) {
            this.mServiceStub.systemRunning(this.isSafeMode());
        }
    }

    @Override
    public void onStartUser(int userHandle) {
        this.mServiceStub.initForUser(userHandle);
    }

    @Override
    public void onSwitchUser(int userHandle) {
        this.mServiceStub.switchUser(userHandle);
    }

    class VoiceInteractionManagerServiceStub
    extends IVoiceInteractionManagerService.Stub {
        VoiceInteractionManagerServiceImpl mImpl;
        private boolean mSafeMode;
        private int mCurUser;
        PackageMonitor mPackageMonitor = new PackageMonitor(){

            @Override
            public boolean onHandleForceStop(Intent intent, String[] packages, int uid, boolean doit) {
                return super.onHandleForceStop(intent, packages, uid, doit);
            }

            @Override
            public void onHandleUserStop(Intent intent, int userHandle) {
            }

            @Override
            public void onSomePackagesChanged() {
                int userHandle = this.getChangingUserId();
                ComponentName curInteractor = VoiceInteractionManagerServiceStub.this.getCurInteractor(userHandle);
                ComponentName curRecognizer = VoiceInteractionManagerServiceStub.this.getCurRecognizer(userHandle);
                if (curRecognizer == null) {
                    if (this.anyPackagesAppearing() && (curRecognizer = VoiceInteractionManagerServiceStub.this.findAvailRecognizer(null, userHandle)) != null) {
                        VoiceInteractionManagerServiceStub.this.setCurRecognizer(curRecognizer, userHandle);
                    }
                    return;
                }
                if (curInteractor != null) {
                    int change = this.isPackageDisappearing(curInteractor.getPackageName());
                    if (change == 3) {
                        VoiceInteractionManagerServiceStub.this.setCurInteractor(null, userHandle);
                        VoiceInteractionManagerServiceStub.this.setCurRecognizer(null, userHandle);
                        VoiceInteractionManagerServiceStub.this.initForUser(userHandle);
                        return;
                    }
                    change = this.isPackageAppearing(curInteractor.getPackageName());
                    if (change != 0 && VoiceInteractionManagerServiceStub.this.mImpl != null && curInteractor.getPackageName().equals(VoiceInteractionManagerServiceStub.this.mImpl.mComponent.getPackageName())) {
                        VoiceInteractionManagerServiceStub.this.switchImplementationIfNeededLocked(true);
                    }
                    return;
                }
                int change = this.isPackageDisappearing(curRecognizer.getPackageName());
                if (change == 3 || change == 2) {
                    VoiceInteractionManagerServiceStub.this.setCurRecognizer(VoiceInteractionManagerServiceStub.this.findAvailRecognizer(null, userHandle), userHandle);
                } else if (this.isPackageModified(curRecognizer.getPackageName())) {
                    VoiceInteractionManagerServiceStub.this.setCurRecognizer(VoiceInteractionManagerServiceStub.this.findAvailRecognizer(curRecognizer.getPackageName(), userHandle), userHandle);
                }
            }
        };

        VoiceInteractionManagerServiceStub() {
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            try {
                return super.onTransact(code, data, reply, flags);
            }
            catch (RuntimeException e) {
                if (!(e instanceof SecurityException)) {
                    Slog.wtf(VoiceInteractionManagerService.TAG, "VoiceInteractionManagerService Crash", e);
                }
                throw e;
            }
        }

        public void initForUser(int userHandle) {
            String curInteractorStr = Settings.Secure.getStringForUser(VoiceInteractionManagerService.this.mContext.getContentResolver(), "voice_interaction_service", userHandle);
            ComponentName curRecognizer = this.getCurRecognizer(userHandle);
            VoiceInteractionServiceInfo curInteractorInfo = null;
            if (curInteractorStr == null && curRecognizer != null && (curInteractorInfo = this.findAvailInteractor(userHandle, curRecognizer)) != null) {
                curRecognizer = null;
            }
            if (curRecognizer != null) {
                IPackageManager pm = AppGlobals.getPackageManager();
                ServiceInfo interactorInfo = null;
                ServiceInfo recognizerInfo = null;
                ComponentName curInteractor = !TextUtils.isEmpty(curInteractorStr) ? ComponentName.unflattenFromString(curInteractorStr) : null;
                try {
                    recognizerInfo = pm.getServiceInfo(curRecognizer, 0, userHandle);
                    if (curInteractor != null) {
                        interactorInfo = pm.getServiceInfo(curInteractor, 0, userHandle);
                    }
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
                if (recognizerInfo != null && (curInteractor == null || interactorInfo != null)) {
                    return;
                }
            }
            if (curInteractorInfo == null) {
                curInteractorInfo = this.findAvailInteractor(userHandle, null);
            }
            if (curInteractorInfo != null) {
                this.setCurInteractor(new ComponentName(curInteractorInfo.getServiceInfo().packageName, curInteractorInfo.getServiceInfo().name), userHandle);
                if (curInteractorInfo.getRecognitionService() != null) {
                    this.setCurRecognizer(new ComponentName(curInteractorInfo.getServiceInfo().packageName, curInteractorInfo.getRecognitionService()), userHandle);
                    return;
                }
            }
            if ((curRecognizer = this.findAvailRecognizer(null, userHandle)) != null) {
                if (curInteractorInfo == null) {
                    this.setCurInteractor(null, userHandle);
                }
                this.setCurRecognizer(curRecognizer, userHandle);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void systemRunning(boolean safeMode) {
            this.mSafeMode = safeMode;
            this.mPackageMonitor.register(VoiceInteractionManagerService.this.mContext, BackgroundThread.getHandler().getLooper(), UserHandle.ALL, true);
            new SettingsObserver(UiThread.getHandler());
            VoiceInteractionManagerServiceStub voiceInteractionManagerServiceStub = this;
            synchronized (voiceInteractionManagerServiceStub) {
                this.mCurUser = ActivityManager.getCurrentUser();
                this.switchImplementationIfNeededLocked(false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void switchUser(int userHandle) {
            VoiceInteractionManagerServiceStub voiceInteractionManagerServiceStub = this;
            synchronized (voiceInteractionManagerServiceStub) {
                this.mCurUser = userHandle;
                this.switchImplementationIfNeededLocked(false);
            }
        }

        void switchImplementationIfNeededLocked(boolean force) {
            if (!this.mSafeMode) {
                String curService = Settings.Secure.getStringForUser(VoiceInteractionManagerService.this.mResolver, "voice_interaction_service", this.mCurUser);
                ComponentName serviceComponent = null;
                if (curService != null && !curService.isEmpty()) {
                    try {
                        serviceComponent = ComponentName.unflattenFromString(curService);
                    }
                    catch (RuntimeException e) {
                        Slog.wtf(VoiceInteractionManagerService.TAG, "Bad voice interaction service name " + curService, e);
                        serviceComponent = null;
                    }
                }
                if (force || this.mImpl == null || this.mImpl.mUser != this.mCurUser || !this.mImpl.mComponent.equals(serviceComponent)) {
                    VoiceInteractionManagerService.this.mSoundTriggerHelper.stopAllRecognitions();
                    if (this.mImpl != null) {
                        this.mImpl.shutdownLocked();
                    }
                    if (serviceComponent != null) {
                        this.mImpl = new VoiceInteractionManagerServiceImpl(VoiceInteractionManagerService.this.mContext, UiThread.getHandler(), this, this.mCurUser, serviceComponent);
                        this.mImpl.startLocked();
                    } else {
                        this.mImpl = null;
                    }
                }
            }
        }

        VoiceInteractionServiceInfo findAvailInteractor(int userHandle, ComponentName recognizer) {
            List<ResolveInfo> available = VoiceInteractionManagerService.this.mContext.getPackageManager().queryIntentServicesAsUser(new Intent("android.service.voice.VoiceInteractionService"), 0, userHandle);
            int numAvailable = available.size();
            if (numAvailable == 0) {
                Slog.w(VoiceInteractionManagerService.TAG, "no available voice interaction services found for user " + userHandle);
                return null;
            }
            VoiceInteractionServiceInfo foundInfo = null;
            for (int i = 0; i < numAvailable; ++i) {
                ServiceInfo cur = available.get((int)i).serviceInfo;
                if ((cur.applicationInfo.flags & 1) == 0) continue;
                ComponentName comp = new ComponentName(cur.packageName, cur.name);
                try {
                    VoiceInteractionServiceInfo info = new VoiceInteractionServiceInfo(VoiceInteractionManagerService.this.mContext.getPackageManager(), comp, userHandle);
                    if (info.getParseError() == null) {
                        if (recognizer != null && !info.getServiceInfo().packageName.equals(recognizer.getPackageName())) continue;
                        if (foundInfo == null) {
                            foundInfo = info;
                            continue;
                        }
                        Slog.w(VoiceInteractionManagerService.TAG, "More than one voice interaction service, picking first " + new ComponentName(foundInfo.getServiceInfo().packageName, foundInfo.getServiceInfo().name) + " over " + new ComponentName(cur.packageName, cur.name));
                        continue;
                    }
                    Slog.w(VoiceInteractionManagerService.TAG, "Bad interaction service " + comp + ": " + info.getParseError());
                    continue;
                }
                catch (PackageManager.NameNotFoundException e) {
                    Slog.w(VoiceInteractionManagerService.TAG, "Failure looking up interaction service " + comp);
                    continue;
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            return foundInfo;
        }

        ComponentName getCurInteractor(int userHandle) {
            String curInteractor = Settings.Secure.getStringForUser(VoiceInteractionManagerService.this.mContext.getContentResolver(), "voice_interaction_service", userHandle);
            if (TextUtils.isEmpty(curInteractor)) {
                return null;
            }
            return ComponentName.unflattenFromString(curInteractor);
        }

        void setCurInteractor(ComponentName comp, int userHandle) {
            Settings.Secure.putStringForUser(VoiceInteractionManagerService.this.mContext.getContentResolver(), "voice_interaction_service", comp != null ? comp.flattenToShortString() : "", userHandle);
        }

        ComponentName findAvailRecognizer(String prefPackage, int userHandle) {
            List<ResolveInfo> available = VoiceInteractionManagerService.this.mContext.getPackageManager().queryIntentServicesAsUser(new Intent("android.speech.RecognitionService"), 0, userHandle);
            int numAvailable = available.size();
            if (numAvailable == 0) {
                Slog.w(VoiceInteractionManagerService.TAG, "no available voice recognition services found for user " + userHandle);
                return null;
            }
            if (prefPackage != null) {
                for (int i = 0; i < numAvailable; ++i) {
                    ServiceInfo serviceInfo = available.get((int)i).serviceInfo;
                    if (!prefPackage.equals(serviceInfo.packageName)) continue;
                    return new ComponentName(serviceInfo.packageName, serviceInfo.name);
                }
            }
            if (numAvailable > 1) {
                Slog.w(VoiceInteractionManagerService.TAG, "more than one voice recognition service found, picking first");
            }
            ServiceInfo serviceInfo = available.get((int)0).serviceInfo;
            return new ComponentName(serviceInfo.packageName, serviceInfo.name);
        }

        ComponentName getCurRecognizer(int userHandle) {
            String curRecognizer = Settings.Secure.getStringForUser(VoiceInteractionManagerService.this.mContext.getContentResolver(), "voice_recognition_service", userHandle);
            if (TextUtils.isEmpty(curRecognizer)) {
                return null;
            }
            return ComponentName.unflattenFromString(curRecognizer);
        }

        void setCurRecognizer(ComponentName comp, int userHandle) {
            Settings.Secure.putStringForUser(VoiceInteractionManagerService.this.mContext.getContentResolver(), "voice_recognition_service", comp != null ? comp.flattenToShortString() : "", userHandle);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void startSession(IVoiceInteractionService service, Bundle args) {
            VoiceInteractionManagerServiceStub voiceInteractionManagerServiceStub = this;
            synchronized (voiceInteractionManagerServiceStub) {
                if (this.mImpl == null || this.mImpl.mService == null || service.asBinder() != this.mImpl.mService.asBinder()) {
                    throw new SecurityException("Caller is not the current voice interaction service");
                }
                int callingPid = Binder.getCallingPid();
                int callingUid = Binder.getCallingUid();
                long caller = Binder.clearCallingIdentity();
                try {
                    this.mImpl.startSessionLocked(callingPid, callingUid, args);
                }
                finally {
                    Binder.restoreCallingIdentity(caller);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean deliverNewSession(IBinder token, IVoiceInteractionSession session, IVoiceInteractor interactor) {
            VoiceInteractionManagerServiceStub voiceInteractionManagerServiceStub = this;
            synchronized (voiceInteractionManagerServiceStub) {
                boolean bl;
                if (this.mImpl == null) {
                    throw new SecurityException("deliverNewSession without running voice interaction service");
                }
                int callingPid = Binder.getCallingPid();
                int callingUid = Binder.getCallingUid();
                long caller = Binder.clearCallingIdentity();
                try {
                    bl = this.mImpl.deliverNewSessionLocked(callingPid, callingUid, token, session, interactor);
                }
                catch (Throwable throwable) {
                    Binder.restoreCallingIdentity(caller);
                    throw throwable;
                }
                Binder.restoreCallingIdentity(caller);
                return bl;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int startVoiceActivity(IBinder token, Intent intent, String resolvedType) {
            VoiceInteractionManagerServiceStub voiceInteractionManagerServiceStub = this;
            synchronized (voiceInteractionManagerServiceStub) {
                int n;
                if (this.mImpl == null) {
                    Slog.w(VoiceInteractionManagerService.TAG, "startVoiceActivity without running voice interaction service");
                    return -6;
                }
                int callingPid = Binder.getCallingPid();
                int callingUid = Binder.getCallingUid();
                long caller = Binder.clearCallingIdentity();
                if (!SystemProperties.getBoolean("persist.test.voice_interaction", false)) {
                    throw new SecurityException("Voice interaction not supported");
                }
                try {
                    n = this.mImpl.startVoiceActivityLocked(callingPid, callingUid, token, intent, resolvedType);
                }
                catch (Throwable throwable) {
                    Binder.restoreCallingIdentity(caller);
                    throw throwable;
                }
                Binder.restoreCallingIdentity(caller);
                return n;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void finish(IBinder token) {
            VoiceInteractionManagerServiceStub voiceInteractionManagerServiceStub = this;
            synchronized (voiceInteractionManagerServiceStub) {
                if (this.mImpl == null) {
                    Slog.w(VoiceInteractionManagerService.TAG, "finish without running voice interaction service");
                    return;
                }
                int callingPid = Binder.getCallingPid();
                int callingUid = Binder.getCallingUid();
                long caller = Binder.clearCallingIdentity();
                try {
                    this.mImpl.finishLocked(callingPid, callingUid, token);
                }
                finally {
                    Binder.restoreCallingIdentity(caller);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SoundTrigger.KeyphraseSoundModel getKeyphraseSoundModel(int keyphraseId, String bcp47Locale) {
            VoiceInteractionManagerServiceStub voiceInteractionManagerServiceStub = this;
            synchronized (voiceInteractionManagerServiceStub) {
                if (VoiceInteractionManagerService.this.mContext.checkCallingPermission("android.permission.MANAGE_VOICE_KEYPHRASES") != 0) {
                    throw new SecurityException("Caller does not hold the permission android.permission.MANAGE_VOICE_KEYPHRASES");
                }
            }
            if (bcp47Locale == null) {
                throw new IllegalArgumentException("Illegal argument(s) in getKeyphraseSoundModel");
            }
            int callingUid = UserHandle.getCallingUserId();
            long caller = Binder.clearCallingIdentity();
            try {
                SoundTrigger.KeyphraseSoundModel keyphraseSoundModel = VoiceInteractionManagerService.this.mDbHelper.getKeyphraseSoundModel(keyphraseId, callingUid, bcp47Locale);
                return keyphraseSoundModel;
            }
            finally {
                Binder.restoreCallingIdentity(caller);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int updateKeyphraseSoundModel(SoundTrigger.KeyphraseSoundModel model) {
            VoiceInteractionManagerServiceStub voiceInteractionManagerServiceStub = this;
            synchronized (voiceInteractionManagerServiceStub) {
                if (VoiceInteractionManagerService.this.mContext.checkCallingPermission("android.permission.MANAGE_VOICE_KEYPHRASES") != 0) {
                    throw new SecurityException("Caller does not hold the permission android.permission.MANAGE_VOICE_KEYPHRASES");
                }
                if (model == null) {
                    throw new IllegalArgumentException("Model must not be null");
                }
            }
            long caller = Binder.clearCallingIdentity();
            try {
                if (VoiceInteractionManagerService.this.mDbHelper.updateKeyphraseSoundModel(model)) {
                    VoiceInteractionManagerServiceStub voiceInteractionManagerServiceStub2 = this;
                    synchronized (voiceInteractionManagerServiceStub2) {
                        if (this.mImpl != null && this.mImpl.mService != null) {
                            this.mImpl.notifySoundModelsChangedLocked();
                        }
                    }
                    int n = 0;
                    return n;
                }
                int n = Integer.MIN_VALUE;
                return n;
            }
            finally {
                Binder.restoreCallingIdentity(caller);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int deleteKeyphraseSoundModel(int keyphraseId, String bcp47Locale) {
            VoiceInteractionManagerServiceStub voiceInteractionManagerServiceStub = this;
            synchronized (voiceInteractionManagerServiceStub) {
                if (VoiceInteractionManagerService.this.mContext.checkCallingPermission("android.permission.MANAGE_VOICE_KEYPHRASES") != 0) {
                    throw new SecurityException("Caller does not hold the permission android.permission.MANAGE_VOICE_KEYPHRASES");
                }
            }
            if (bcp47Locale == null) {
                throw new IllegalArgumentException("Illegal argument(s) in deleteKeyphraseSoundModel");
            }
            int callingUid = UserHandle.getCallingUserId();
            long caller = Binder.clearCallingIdentity();
            boolean deleted = false;
            try {
                deleted = VoiceInteractionManagerService.this.mDbHelper.deleteKeyphraseSoundModel(keyphraseId, callingUid, bcp47Locale);
                int n = deleted ? 0 : Integer.MIN_VALUE;
                return n;
            }
            finally {
                if (deleted) {
                    VoiceInteractionManagerServiceStub voiceInteractionManagerServiceStub2 = this;
                    synchronized (voiceInteractionManagerServiceStub2) {
                        if (this.mImpl != null && this.mImpl.mService != null) {
                            this.mImpl.notifySoundModelsChangedLocked();
                        }
                    }
                }
                Binder.restoreCallingIdentity(caller);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isEnrolledForKeyphrase(IVoiceInteractionService service, int keyphraseId, String bcp47Locale) {
            VoiceInteractionManagerServiceStub voiceInteractionManagerServiceStub = this;
            synchronized (voiceInteractionManagerServiceStub) {
                if (this.mImpl == null || this.mImpl.mService == null || service.asBinder() != this.mImpl.mService.asBinder()) {
                    throw new SecurityException("Caller is not the current voice interaction service");
                }
            }
            if (bcp47Locale == null) {
                throw new IllegalArgumentException("Illegal argument(s) in isEnrolledForKeyphrase");
            }
            int callingUid = UserHandle.getCallingUserId();
            long caller = Binder.clearCallingIdentity();
            try {
                SoundTrigger.KeyphraseSoundModel model = VoiceInteractionManagerService.this.mDbHelper.getKeyphraseSoundModel(keyphraseId, callingUid, bcp47Locale);
                boolean bl = model != null;
                return bl;
            }
            finally {
                Binder.restoreCallingIdentity(caller);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SoundTrigger.ModuleProperties getDspModuleProperties(IVoiceInteractionService service) {
            VoiceInteractionManagerServiceStub voiceInteractionManagerServiceStub = this;
            synchronized (voiceInteractionManagerServiceStub) {
                SoundTrigger.ModuleProperties moduleProperties;
                if (this.mImpl == null || this.mImpl.mService == null || service == null || service.asBinder() != this.mImpl.mService.asBinder()) {
                    throw new SecurityException("Caller is not the current voice interaction service");
                }
                long caller = Binder.clearCallingIdentity();
                try {
                    moduleProperties = VoiceInteractionManagerService.this.mSoundTriggerHelper.moduleProperties;
                }
                catch (Throwable throwable) {
                    Binder.restoreCallingIdentity(caller);
                    throw throwable;
                }
                Binder.restoreCallingIdentity(caller);
                return moduleProperties;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int startRecognition(IVoiceInteractionService service, int keyphraseId, String bcp47Locale, IRecognitionStatusCallback callback, SoundTrigger.RecognitionConfig recognitionConfig) {
            VoiceInteractionManagerServiceStub voiceInteractionManagerServiceStub = this;
            synchronized (voiceInteractionManagerServiceStub) {
                if (this.mImpl == null || this.mImpl.mService == null || service == null || service.asBinder() != this.mImpl.mService.asBinder()) {
                    throw new SecurityException("Caller is not the current voice interaction service");
                }
                if (callback == null || recognitionConfig == null || bcp47Locale == null) {
                    throw new IllegalArgumentException("Illegal argument(s) in startRecognition");
                }
            }
            int callingUid = UserHandle.getCallingUserId();
            long caller = Binder.clearCallingIdentity();
            try {
                SoundTrigger.KeyphraseSoundModel soundModel = VoiceInteractionManagerService.this.mDbHelper.getKeyphraseSoundModel(keyphraseId, callingUid, bcp47Locale);
                if (soundModel == null || soundModel.uuid == null || soundModel.keyphrases == null) {
                    Slog.w(VoiceInteractionManagerService.TAG, "No matching sound model found in startRecognition");
                    int n = Integer.MIN_VALUE;
                    return n;
                }
                int n = VoiceInteractionManagerService.this.mSoundTriggerHelper.startRecognition(keyphraseId, soundModel, callback, recognitionConfig);
                return n;
            }
            finally {
                Binder.restoreCallingIdentity(caller);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int stopRecognition(IVoiceInteractionService service, int keyphraseId, IRecognitionStatusCallback callback) {
            VoiceInteractionManagerServiceStub voiceInteractionManagerServiceStub = this;
            synchronized (voiceInteractionManagerServiceStub) {
                if (this.mImpl == null || this.mImpl.mService == null || service == null || service.asBinder() != this.mImpl.mService.asBinder()) {
                    throw new SecurityException("Caller is not the current voice interaction service");
                }
            }
            long caller = Binder.clearCallingIdentity();
            try {
                int n = VoiceInteractionManagerService.this.mSoundTriggerHelper.stopRecognition(keyphraseId, callback);
                return n;
            }
            finally {
                Binder.restoreCallingIdentity(caller);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
            if (VoiceInteractionManagerService.this.mContext.checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
                pw.println("Permission Denial: can't dump PowerManager from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
                return;
            }
            VoiceInteractionManagerServiceStub voiceInteractionManagerServiceStub = this;
            synchronized (voiceInteractionManagerServiceStub) {
                pw.println("VOICE INTERACTION MANAGER (dumpsys voiceinteraction)\n");
                if (this.mImpl == null) {
                    pw.println("  (No active implementation)");
                    return;
                }
                this.mImpl.dumpLocked(fd, pw, args);
            }
            VoiceInteractionManagerService.this.mSoundTriggerHelper.dump(fd, pw, args);
        }

        class SettingsObserver
        extends ContentObserver {
            SettingsObserver(Handler handler) {
                super(handler);
                ContentResolver resolver = VoiceInteractionManagerService.this.mContext.getContentResolver();
                resolver.registerContentObserver(Settings.Secure.getUriFor("voice_interaction_service"), false, this);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onChange(boolean selfChange) {
                VoiceInteractionManagerServiceStub voiceInteractionManagerServiceStub = VoiceInteractionManagerServiceStub.this;
                synchronized (voiceInteractionManagerServiceStub) {
                    VoiceInteractionManagerServiceStub.this.switchImplementationIfNeededLocked(false);
                }
            }
        }
    }
}

