/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wallpaper;

import android.app.ActivityManagerNative;
import android.app.AppGlobals;
import android.app.IUserSwitchObserver;
import android.app.IWallpaperManager;
import android.app.IWallpaperManagerCallback;
import android.app.PendingIntent;
import android.app.WallpaperInfo;
import android.app.WallpaperManager;
import android.app.backup.BackupManager;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.content.pm.IPackageManager;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.pm.UserInfo;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.Binder;
import android.os.Bundle;
import android.os.Environment;
import android.os.FileObserver;
import android.os.FileUtils;
import android.os.IBinder;
import android.os.IRemoteCallback;
import android.os.ParcelFileDescriptor;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.os.SELinux;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.UserHandle;
import android.os.UserManager;
import android.service.wallpaper.IWallpaperConnection;
import android.service.wallpaper.IWallpaperEngine;
import android.service.wallpaper.IWallpaperService;
import android.util.Slog;
import android.util.SparseArray;
import android.util.Xml;
import android.view.Display;
import android.view.IWindowManager;
import android.view.WindowManager;
import com.android.internal.content.PackageMonitor;
import com.android.internal.util.FastXmlSerializer;
import com.android.internal.util.JournaledFile;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class WallpaperManagerService
extends IWallpaperManager.Stub {
    static final String TAG = "WallpaperManagerService";
    static final boolean DEBUG = false;
    final Object mLock = new Object[0];
    static final long MIN_WALLPAPER_CRASH_TIME = 10000L;
    static final String WALLPAPER = "wallpaper";
    static final String WALLPAPER_INFO = "wallpaper_info.xml";
    final Context mContext;
    final IWindowManager mIWindowManager;
    final IPackageManager mIPackageManager;
    final MyPackageMonitor mMonitor;
    WallpaperData mLastWallpaper;
    final ComponentName mImageWallpaper;
    SparseArray<WallpaperData> mWallpaperMap = new SparseArray();
    int mCurrentUserId;

    public WallpaperManagerService(Context context) {
        this.mContext = context;
        this.mImageWallpaper = ComponentName.unflattenFromString(context.getResources().getString(17039391));
        this.mIWindowManager = IWindowManager.Stub.asInterface(ServiceManager.getService("window"));
        this.mIPackageManager = AppGlobals.getPackageManager();
        this.mMonitor = new MyPackageMonitor();
        this.mMonitor.register(context, null, UserHandle.ALL, true);
        WallpaperManagerService.getWallpaperDir(0).mkdirs();
        this.loadSettingsLocked(0);
    }

    private static File getWallpaperDir(int userId) {
        return Environment.getUserSystemDirectory(userId);
    }

    @Override
    protected void finalize() throws Throwable {
        super.finalize();
        for (int i = 0; i < this.mWallpaperMap.size(); ++i) {
            WallpaperData wallpaper = this.mWallpaperMap.valueAt(i);
            wallpaper.wallpaperObserver.stopWatching();
        }
    }

    public void systemRunning() {
        WallpaperData wallpaper = this.mWallpaperMap.get(0);
        this.switchWallpaper(wallpaper, null);
        wallpaper.wallpaperObserver = new WallpaperObserver(wallpaper);
        wallpaper.wallpaperObserver.startWatching();
        IntentFilter userFilter = new IntentFilter();
        userFilter.addAction("android.intent.action.USER_REMOVED");
        userFilter.addAction("android.intent.action.USER_STOPPING");
        this.mContext.registerReceiver(new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                String action = intent.getAction();
                if ("android.intent.action.USER_REMOVED".equals(action)) {
                    WallpaperManagerService.this.onRemoveUser(intent.getIntExtra("android.intent.extra.user_handle", -10000));
                }
            }
        }, userFilter);
        try {
            ActivityManagerNative.getDefault().registerUserSwitchObserver(new IUserSwitchObserver.Stub(){

                @Override
                public void onUserSwitching(int newUserId, IRemoteCallback reply) {
                    WallpaperManagerService.this.switchUser(newUserId, reply);
                }

                @Override
                public void onUserSwitchComplete(int newUserId) throws RemoteException {
                }
            });
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getName() {
        if (Binder.getCallingUid() != 1000) {
            throw new RuntimeException("getName() can only be called from the system process");
        }
        Object object = this.mLock;
        synchronized (object) {
            return this.mWallpaperMap.get((int)0).name;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onStoppingUser(int userId) {
        if (userId < 1) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            WallpaperData wallpaper = this.mWallpaperMap.get(userId);
            if (wallpaper != null) {
                if (wallpaper.wallpaperObserver != null) {
                    wallpaper.wallpaperObserver.stopWatching();
                    wallpaper.wallpaperObserver = null;
                }
                this.mWallpaperMap.remove(userId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onRemoveUser(int userId) {
        if (userId < 1) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.onStoppingUser(userId);
            File wallpaperFile = new File(WallpaperManagerService.getWallpaperDir(userId), WALLPAPER);
            wallpaperFile.delete();
            File wallpaperInfoFile = new File(WallpaperManagerService.getWallpaperDir(userId), WALLPAPER_INFO);
            wallpaperInfoFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void switchUser(int userId, IRemoteCallback reply) {
        Object object = this.mLock;
        synchronized (object) {
            this.mCurrentUserId = userId;
            WallpaperData wallpaper = this.mWallpaperMap.get(userId);
            if (wallpaper == null) {
                wallpaper = new WallpaperData(userId);
                this.mWallpaperMap.put(userId, wallpaper);
                this.loadSettingsLocked(userId);
            }
            if (wallpaper.wallpaperObserver == null) {
                wallpaper.wallpaperObserver = new WallpaperObserver(wallpaper);
                wallpaper.wallpaperObserver.startWatching();
            }
            this.switchWallpaper(wallpaper, reply);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void switchWallpaper(WallpaperData wallpaper, IRemoteCallback reply) {
        Object object = this.mLock;
        synchronized (object) {
            RuntimeException e = null;
            try {
                ComponentName cname;
                ComponentName componentName = cname = wallpaper.wallpaperComponent != null ? wallpaper.wallpaperComponent : wallpaper.nextWallpaperComponent;
                if (this.bindWallpaperComponentLocked(cname, true, false, wallpaper, reply)) {
                    return;
                }
            }
            catch (RuntimeException e1) {
                e = e1;
            }
            Slog.w(TAG, "Failure starting previous wallpaper", e);
            this.clearWallpaperLocked(false, wallpaper.userId, reply);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearWallpaper() {
        Object object = this.mLock;
        synchronized (object) {
            this.clearWallpaperLocked(false, UserHandle.getCallingUserId(), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    void clearWallpaperLocked(boolean defaultFailed, int userId, IRemoteCallback reply) {
        IllegalArgumentException e;
        long ident;
        WallpaperData wallpaper;
        block12: {
            block11: {
                wallpaper = this.mWallpaperMap.get(userId);
                File f = new File(WallpaperManagerService.getWallpaperDir(userId), WALLPAPER);
                if (f.exists()) {
                    f.delete();
                }
                ident = Binder.clearCallingIdentity();
                e = null;
                wallpaper.imageWallpaperPending = false;
                if (userId == this.mCurrentUserId) break block11;
                Binder.restoreCallingIdentity(ident);
                return;
            }
            if (!this.bindWallpaperComponentLocked(defaultFailed ? this.mImageWallpaper : null, true, false, wallpaper, reply)) break block12;
            Binder.restoreCallingIdentity(ident);
            return;
        }
        try {
            block14: {
                break block14;
                {
                    catch (IllegalArgumentException e1) {
                        e = e1;
                    }
                }
            }
            Slog.e(TAG, "Default wallpaper component not found!", e);
            this.clearWallpaperComponentLocked(wallpaper);
            if (reply != null) {
                try {
                    reply.sendResult(null);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasNamedWallpaper(String name) {
        Object object = this.mLock;
        synchronized (object) {
            List<UserInfo> users;
            long ident = Binder.clearCallingIdentity();
            try {
                users = ((UserManager)this.mContext.getSystemService("user")).getUsers();
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
            for (UserInfo user : users) {
                WallpaperData wd = this.mWallpaperMap.get(user.id);
                if (wd == null) {
                    this.loadSettingsLocked(user.id);
                    wd = this.mWallpaperMap.get(user.id);
                }
                if (wd == null || !name.equals(wd.name)) continue;
                return true;
            }
        }
        return false;
    }

    private Point getDefaultDisplaySize() {
        Point p = new Point();
        WindowManager wm = (WindowManager)this.mContext.getSystemService("window");
        Display d = wm.getDefaultDisplay();
        d.getRealSize(p);
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDimensionHints(int width, int height) throws RemoteException {
        this.checkPermission("android.permission.SET_WALLPAPER_HINTS");
        Object object = this.mLock;
        synchronized (object) {
            int userId = UserHandle.getCallingUserId();
            WallpaperData wallpaper = this.mWallpaperMap.get(userId);
            if (wallpaper == null) {
                throw new IllegalStateException("Wallpaper not yet initialized for user " + userId);
            }
            if (width <= 0 || height <= 0) {
                throw new IllegalArgumentException("width and height must be > 0");
            }
            Point displaySize = this.getDefaultDisplaySize();
            width = Math.max(width, displaySize.x);
            height = Math.max(height, displaySize.y);
            if (width != wallpaper.width || height != wallpaper.height) {
                wallpaper.width = width;
                wallpaper.height = height;
                this.saveSettingsLocked(wallpaper);
                if (this.mCurrentUserId != userId) {
                    return;
                }
                if (wallpaper.connection != null) {
                    if (wallpaper.connection.mEngine != null) {
                        try {
                            wallpaper.connection.mEngine.setDesiredSize(width, height);
                        }
                        catch (RemoteException remoteException) {
                            // empty catch block
                        }
                        this.notifyCallbacksLocked(wallpaper);
                    } else if (wallpaper.connection.mService != null) {
                        wallpaper.connection.mDimensionsChanged = true;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getWidthHint() throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            WallpaperData wallpaper = this.mWallpaperMap.get(UserHandle.getCallingUserId());
            return wallpaper.width;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getHeightHint() throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            WallpaperData wallpaper = this.mWallpaperMap.get(UserHandle.getCallingUserId());
            return wallpaper.height;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDisplayPadding(Rect padding) {
        this.checkPermission("android.permission.SET_WALLPAPER_HINTS");
        Object object = this.mLock;
        synchronized (object) {
            int userId = UserHandle.getCallingUserId();
            WallpaperData wallpaper = this.mWallpaperMap.get(userId);
            if (wallpaper == null) {
                throw new IllegalStateException("Wallpaper not yet initialized for user " + userId);
            }
            if (padding.left < 0 || padding.top < 0 || padding.right < 0 || padding.bottom < 0) {
                throw new IllegalArgumentException("padding must be positive: " + padding);
            }
            if (!padding.equals(wallpaper.padding)) {
                wallpaper.padding.set(padding);
                this.saveSettingsLocked(wallpaper);
                if (this.mCurrentUserId != userId) {
                    return;
                }
                if (wallpaper.connection != null) {
                    if (wallpaper.connection.mEngine != null) {
                        try {
                            wallpaper.connection.mEngine.setDisplayPadding(padding);
                        }
                        catch (RemoteException remoteException) {
                            // empty catch block
                        }
                        this.notifyCallbacksLocked(wallpaper);
                    } else if (wallpaper.connection.mService != null) {
                        wallpaper.connection.mPaddingChanged = true;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParcelFileDescriptor getWallpaper(IWallpaperManagerCallback cb, Bundle outParams) {
        Object object = this.mLock;
        synchronized (object) {
            int callingUid = Binder.getCallingUid();
            int wallpaperUserId = 0;
            wallpaperUserId = callingUid == 1000 ? this.mCurrentUserId : UserHandle.getUserId(callingUid);
            WallpaperData wallpaper = this.mWallpaperMap.get(wallpaperUserId);
            try {
                if (outParams != null) {
                    outParams.putInt("width", wallpaper.width);
                    outParams.putInt("height", wallpaper.height);
                }
                wallpaper.callbacks.register(cb);
                File f = new File(WallpaperManagerService.getWallpaperDir(wallpaperUserId), WALLPAPER);
                if (!f.exists()) {
                    return null;
                }
                return ParcelFileDescriptor.open(f, 0x10000000);
            }
            catch (FileNotFoundException e) {
                Slog.w(TAG, "Error getting wallpaper", e);
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WallpaperInfo getWallpaperInfo() {
        int userId = UserHandle.getCallingUserId();
        Object object = this.mLock;
        synchronized (object) {
            WallpaperData wallpaper = this.mWallpaperMap.get(userId);
            if (wallpaper.connection != null) {
                return wallpaper.connection.mInfo;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParcelFileDescriptor setWallpaper(String name) {
        this.checkPermission("android.permission.SET_WALLPAPER");
        Object object = this.mLock;
        synchronized (object) {
            ParcelFileDescriptor parcelFileDescriptor;
            int userId = UserHandle.getCallingUserId();
            WallpaperData wallpaper = this.mWallpaperMap.get(userId);
            if (wallpaper == null) {
                throw new IllegalStateException("Wallpaper not yet initialized for user " + userId);
            }
            long ident = Binder.clearCallingIdentity();
            try {
                ParcelFileDescriptor pfd = this.updateWallpaperBitmapLocked(name, wallpaper);
                if (pfd != null) {
                    wallpaper.imageWallpaperPending = true;
                }
                parcelFileDescriptor = pfd;
            }
            catch (Throwable throwable) {
                Binder.restoreCallingIdentity(ident);
                throw throwable;
            }
            Binder.restoreCallingIdentity(ident);
            return parcelFileDescriptor;
        }
    }

    ParcelFileDescriptor updateWallpaperBitmapLocked(String name, WallpaperData wallpaper) {
        if (name == null) {
            name = "";
        }
        try {
            File dir = WallpaperManagerService.getWallpaperDir(wallpaper.userId);
            if (!dir.exists()) {
                dir.mkdir();
                FileUtils.setPermissions(dir.getPath(), 505, -1, -1);
            }
            File file = new File(dir, WALLPAPER);
            ParcelFileDescriptor fd = ParcelFileDescriptor.open(file, 0x3C000000);
            if (!SELinux.restorecon(file)) {
                return null;
            }
            wallpaper.name = name;
            return fd;
        }
        catch (FileNotFoundException e) {
            Slog.w(TAG, "Error setting wallpaper", e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setWallpaperComponent(ComponentName name) {
        this.checkPermission("android.permission.SET_WALLPAPER_COMPONENT");
        Object object = this.mLock;
        synchronized (object) {
            int userId = UserHandle.getCallingUserId();
            WallpaperData wallpaper = this.mWallpaperMap.get(userId);
            if (wallpaper == null) {
                throw new IllegalStateException("Wallpaper not yet initialized for user " + userId);
            }
            long ident = Binder.clearCallingIdentity();
            try {
                wallpaper.imageWallpaperPending = false;
                this.bindWallpaperComponentLocked(name, false, true, wallpaper, null);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }
    }

    boolean bindWallpaperComponentLocked(ComponentName componentName, boolean force, boolean fromUser, WallpaperData wallpaper, IRemoteCallback reply) {
        if (!force && wallpaper.connection != null && (wallpaper.wallpaperComponent == null ? componentName == null : wallpaper.wallpaperComponent.equals(componentName))) {
            return true;
        }
        try {
            int serviceUserId;
            ServiceInfo si;
            if (componentName == null && (componentName = WallpaperManager.getDefaultWallpaperComponent(this.mContext)) == null) {
                componentName = this.mImageWallpaper;
            }
            if ((si = this.mIPackageManager.getServiceInfo(componentName, 4224, serviceUserId = wallpaper.userId)) == null) {
                Slog.w(TAG, "Attempted wallpaper " + componentName + " is unavailable");
                return false;
            }
            if (!"android.permission.BIND_WALLPAPER".equals(si.permission)) {
                String msg = "Selected service does not require android.permission.BIND_WALLPAPER: " + componentName;
                if (fromUser) {
                    throw new SecurityException(msg);
                }
                Slog.w(TAG, msg);
                return false;
            }
            WallpaperInfo wi = null;
            Intent intent = new Intent("android.service.wallpaper.WallpaperService");
            if (componentName != null && !componentName.equals(this.mImageWallpaper)) {
                List<ResolveInfo> ris = this.mIPackageManager.queryIntentServices(intent, intent.resolveTypeIfNeeded(this.mContext.getContentResolver()), 128, serviceUserId);
                for (int i = 0; i < ris.size(); ++i) {
                    ServiceInfo rsi = ris.get((int)i).serviceInfo;
                    if (!rsi.name.equals(si.name) || !rsi.packageName.equals(si.packageName)) continue;
                    try {
                        wi = new WallpaperInfo(this.mContext, ris.get(i));
                        break;
                    }
                    catch (XmlPullParserException e) {
                        if (fromUser) {
                            throw new IllegalArgumentException(e);
                        }
                        Slog.w(TAG, e);
                        return false;
                    }
                    catch (IOException e) {
                        if (fromUser) {
                            throw new IllegalArgumentException(e);
                        }
                        Slog.w(TAG, e);
                        return false;
                    }
                }
                if (wi == null) {
                    String msg = "Selected service is not a wallpaper: " + componentName;
                    if (fromUser) {
                        throw new SecurityException(msg);
                    }
                    Slog.w(TAG, msg);
                    return false;
                }
            }
            WallpaperConnection newConn = new WallpaperConnection(wi, wallpaper);
            intent.setComponent(componentName);
            intent.putExtra("android.intent.extra.client_label", 17040694);
            intent.putExtra("android.intent.extra.client_intent", PendingIntent.getActivityAsUser(this.mContext, 0, Intent.createChooser(new Intent("android.intent.action.SET_WALLPAPER"), this.mContext.getText(17040695)), 0, null, new UserHandle(serviceUserId)));
            if (!this.mContext.bindServiceAsUser(intent, newConn, 0x20000001, new UserHandle(serviceUserId))) {
                String msg = "Unable to bind service: " + componentName;
                if (fromUser) {
                    throw new IllegalArgumentException(msg);
                }
                Slog.w(TAG, msg);
                return false;
            }
            if (wallpaper.userId == this.mCurrentUserId && this.mLastWallpaper != null) {
                this.detachWallpaperLocked(this.mLastWallpaper);
            }
            wallpaper.wallpaperComponent = componentName;
            wallpaper.connection = newConn;
            newConn.mReply = reply;
            try {
                if (wallpaper.userId == this.mCurrentUserId) {
                    this.mIWindowManager.addWindowToken(newConn.mToken, 2013);
                    this.mLastWallpaper = wallpaper;
                }
            }
            catch (RemoteException remoteException) {}
        }
        catch (RemoteException e) {
            String msg = "Remote exception for " + componentName + "\n" + e;
            if (fromUser) {
                throw new IllegalArgumentException(msg);
            }
            Slog.w(TAG, msg);
            return false;
        }
        return true;
    }

    void detachWallpaperLocked(WallpaperData wallpaper) {
        if (wallpaper.connection != null) {
            if (wallpaper.connection.mReply != null) {
                try {
                    wallpaper.connection.mReply.sendResult(null);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
                wallpaper.connection.mReply = null;
            }
            if (wallpaper.connection.mEngine != null) {
                try {
                    wallpaper.connection.mEngine.destroy();
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            this.mContext.unbindService(wallpaper.connection);
            try {
                this.mIWindowManager.removeWindowToken(wallpaper.connection.mToken);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            wallpaper.connection.mService = null;
            wallpaper.connection.mEngine = null;
            wallpaper.connection = null;
        }
    }

    void clearWallpaperComponentLocked(WallpaperData wallpaper) {
        wallpaper.wallpaperComponent = null;
        this.detachWallpaperLocked(wallpaper);
    }

    void attachServiceLocked(WallpaperConnection conn, WallpaperData wallpaper) {
        block2: {
            try {
                conn.mService.attach(conn, conn.mToken, 2013, false, wallpaper.width, wallpaper.height, wallpaper.padding);
            }
            catch (RemoteException e) {
                Slog.w(TAG, "Failed attaching wallpaper; clearing", e);
                if (wallpaper.wallpaperUpdating) break block2;
                this.bindWallpaperComponentLocked(null, false, false, wallpaper, null);
            }
        }
    }

    private void notifyCallbacksLocked(WallpaperData wallpaper) {
        int n = wallpaper.callbacks.beginBroadcast();
        for (int i = 0; i < n; ++i) {
            try {
                ((IWallpaperManagerCallback)wallpaper.callbacks.getBroadcastItem(i)).onWallpaperChanged();
                continue;
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        wallpaper.callbacks.finishBroadcast();
        Intent intent = new Intent("android.intent.action.WALLPAPER_CHANGED");
        this.mContext.sendBroadcastAsUser(intent, new UserHandle(this.mCurrentUserId));
    }

    private void checkPermission(String permission2) {
        if (0 != this.mContext.checkCallingOrSelfPermission(permission2)) {
            throw new SecurityException("Access denied to process: " + Binder.getCallingPid() + ", must have permission " + permission2);
        }
    }

    private static JournaledFile makeJournaledFile(int userId) {
        String base = new File(WallpaperManagerService.getWallpaperDir(userId), WALLPAPER_INFO).getAbsolutePath();
        return new JournaledFile(new File(base), new File(base + ".tmp"));
    }

    private void saveSettingsLocked(WallpaperData wallpaper) {
        JournaledFile journal = WallpaperManagerService.makeJournaledFile(wallpaper.userId);
        FileOutputStream stream = null;
        try {
            stream = new FileOutputStream(journal.chooseForWrite(), false);
            FastXmlSerializer out = new FastXmlSerializer();
            out.setOutput(stream, "utf-8");
            out.startDocument(null, true);
            out.startTag(null, "wp");
            out.attribute(null, "width", Integer.toString(wallpaper.width));
            out.attribute(null, "height", Integer.toString(wallpaper.height));
            if (wallpaper.padding.left != 0) {
                out.attribute(null, "paddingLeft", Integer.toString(wallpaper.padding.left));
            }
            if (wallpaper.padding.top != 0) {
                out.attribute(null, "paddingTop", Integer.toString(wallpaper.padding.top));
            }
            if (wallpaper.padding.right != 0) {
                out.attribute(null, "paddingRight", Integer.toString(wallpaper.padding.right));
            }
            if (wallpaper.padding.bottom != 0) {
                out.attribute(null, "paddingBottom", Integer.toString(wallpaper.padding.bottom));
            }
            out.attribute(null, "name", wallpaper.name);
            if (wallpaper.wallpaperComponent != null && !wallpaper.wallpaperComponent.equals(this.mImageWallpaper)) {
                out.attribute(null, "component", wallpaper.wallpaperComponent.flattenToShortString());
            }
            out.endTag(null, "wp");
            out.endDocument();
            stream.close();
            journal.commit();
        }
        catch (IOException e) {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            journal.rollback();
        }
    }

    private void migrateFromOld() {
        File oldWallpaper = new File("/data/data/com.android.settings/files/wallpaper");
        File oldInfo = new File("/data/system/wallpaper_info.xml");
        if (oldWallpaper.exists()) {
            File newWallpaper = new File(WallpaperManagerService.getWallpaperDir(0), WALLPAPER);
            oldWallpaper.renameTo(newWallpaper);
        }
        if (oldInfo.exists()) {
            File newInfo = new File(WallpaperManagerService.getWallpaperDir(0), WALLPAPER_INFO);
            oldInfo.renameTo(newInfo);
        }
    }

    private int getAttributeInt(XmlPullParser parser, String name, int defValue) {
        String value = parser.getAttributeValue(null, name);
        if (value == null) {
            return defValue;
        }
        return Integer.parseInt(value);
    }

    private void loadSettingsLocked(int userId) {
        int baseSize;
        WallpaperData wallpaper;
        JournaledFile journal = WallpaperManagerService.makeJournaledFile(userId);
        FileInputStream stream = null;
        File file = journal.chooseForRead();
        if (!file.exists()) {
            this.migrateFromOld();
        }
        if ((wallpaper = this.mWallpaperMap.get(userId)) == null) {
            wallpaper = new WallpaperData(userId);
            this.mWallpaperMap.put(userId, wallpaper);
        }
        boolean success = false;
        try {
            int type;
            stream = new FileInputStream(file);
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(stream, null);
            do {
                String tag;
                if ((type = parser.next()) != 2 || !"wp".equals(tag = parser.getName())) continue;
                wallpaper.width = Integer.parseInt(parser.getAttributeValue(null, "width"));
                wallpaper.height = Integer.parseInt(parser.getAttributeValue(null, "height"));
                wallpaper.padding.left = this.getAttributeInt(parser, "paddingLeft", 0);
                wallpaper.padding.top = this.getAttributeInt(parser, "paddingTop", 0);
                wallpaper.padding.right = this.getAttributeInt(parser, "paddingRight", 0);
                wallpaper.padding.bottom = this.getAttributeInt(parser, "paddingBottom", 0);
                wallpaper.name = parser.getAttributeValue(null, "name");
                String comp = parser.getAttributeValue(null, "component");
                ComponentName componentName = wallpaper.nextWallpaperComponent = comp != null ? ComponentName.unflattenFromString(comp) : null;
                if (wallpaper.nextWallpaperComponent != null && !"android".equals(wallpaper.nextWallpaperComponent.getPackageName())) continue;
                wallpaper.nextWallpaperComponent = this.mImageWallpaper;
            } while (type != 1);
            success = true;
        }
        catch (FileNotFoundException e) {
            Slog.w(TAG, "no current wallpaper -- first boot?");
        }
        catch (NullPointerException e) {
            Slog.w(TAG, "failed parsing " + file + " " + e);
        }
        catch (NumberFormatException e) {
            Slog.w(TAG, "failed parsing " + file + " " + e);
        }
        catch (XmlPullParserException e) {
            Slog.w(TAG, "failed parsing " + file + " " + e);
        }
        catch (IOException e) {
            Slog.w(TAG, "failed parsing " + file + " " + e);
        }
        catch (IndexOutOfBoundsException e) {
            Slog.w(TAG, "failed parsing " + file + " " + e);
        }
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        if (!success) {
            wallpaper.width = -1;
            wallpaper.height = -1;
            wallpaper.padding.set(0, 0, 0, 0);
            wallpaper.name = "";
        }
        if (wallpaper.width < (baseSize = this.getMaximumSizeDimension())) {
            wallpaper.width = baseSize;
        }
        if (wallpaper.height < baseSize) {
            wallpaper.height = baseSize;
        }
    }

    private int getMaximumSizeDimension() {
        WindowManager wm = (WindowManager)this.mContext.getSystemService("window");
        Display d = wm.getDefaultDisplay();
        return d.getMaximumSizeDimension();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void settingsRestored() {
        if (Binder.getCallingUid() != 1000) {
            throw new RuntimeException("settingsRestored() can only be called from the system process");
        }
        WallpaperData wallpaper = null;
        boolean success = false;
        Object object = this.mLock;
        synchronized (object) {
            this.loadSettingsLocked(0);
            wallpaper = this.mWallpaperMap.get(0);
            if (wallpaper.nextWallpaperComponent != null && !wallpaper.nextWallpaperComponent.equals(this.mImageWallpaper)) {
                if (!this.bindWallpaperComponentLocked(wallpaper.nextWallpaperComponent, false, false, wallpaper, null)) {
                    this.bindWallpaperComponentLocked(null, false, false, wallpaper, null);
                }
                success = true;
            } else {
                success = "".equals(wallpaper.name) ? true : this.restoreNamedResourceLocked(wallpaper);
                if (success) {
                    this.bindWallpaperComponentLocked(wallpaper.nextWallpaperComponent, false, false, wallpaper, null);
                }
            }
        }
        if (!success) {
            Slog.e(TAG, "Failed to restore wallpaper: '" + wallpaper.name + "'");
            wallpaper.name = "";
            WallpaperManagerService.getWallpaperDir(0).delete();
        }
        object = this.mLock;
        synchronized (object) {
            this.saveSettingsLocked(wallpaper);
        }
    }

    /*
     * Exception decompiling
     */
    boolean restoreNamedResourceLocked(WallpaperData wallpaper) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
            pw.println("Permission Denial: can't dump wallpaper service from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            pw.println("Current Wallpaper Service state:");
            for (int i = 0; i < this.mWallpaperMap.size(); ++i) {
                WallpaperData wallpaper = this.mWallpaperMap.valueAt(i);
                pw.println(" User " + wallpaper.userId + ":");
                pw.print("  mWidth=");
                pw.print(wallpaper.width);
                pw.print(" mHeight=");
                pw.println(wallpaper.height);
                pw.print("  mPadding=");
                pw.println(wallpaper.padding);
                pw.print("  mName=");
                pw.println(wallpaper.name);
                pw.print("  mWallpaperComponent=");
                pw.println(wallpaper.wallpaperComponent);
                if (wallpaper.connection == null) continue;
                WallpaperConnection conn = wallpaper.connection;
                pw.print("  Wallpaper connection ");
                pw.print(conn);
                pw.println(":");
                if (conn.mInfo != null) {
                    pw.print("    mInfo.component=");
                    pw.println(conn.mInfo.getComponent());
                }
                pw.print("    mToken=");
                pw.println(conn.mToken);
                pw.print("    mService=");
                pw.println(conn.mService);
                pw.print("    mEngine=");
                pw.println(conn.mEngine);
                pw.print("    mLastDiedTime=");
                pw.println(wallpaper.lastDiedTime - SystemClock.uptimeMillis());
            }
        }
    }

    class MyPackageMonitor
    extends PackageMonitor {
        MyPackageMonitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPackageUpdateFinished(String packageName, int uid) {
            Object object = WallpaperManagerService.this.mLock;
            synchronized (object) {
                if (WallpaperManagerService.this.mCurrentUserId != this.getChangingUserId()) {
                    return;
                }
                WallpaperData wallpaper = WallpaperManagerService.this.mWallpaperMap.get(WallpaperManagerService.this.mCurrentUserId);
                if (wallpaper != null && wallpaper.wallpaperComponent != null && wallpaper.wallpaperComponent.getPackageName().equals(packageName)) {
                    wallpaper.wallpaperUpdating = false;
                    ComponentName comp = wallpaper.wallpaperComponent;
                    WallpaperManagerService.this.clearWallpaperComponentLocked(wallpaper);
                    if (!WallpaperManagerService.this.bindWallpaperComponentLocked(comp, false, false, wallpaper, null)) {
                        Slog.w(WallpaperManagerService.TAG, "Wallpaper no longer available; reverting to default");
                        WallpaperManagerService.this.clearWallpaperLocked(false, wallpaper.userId, null);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPackageModified(String packageName) {
            Object object = WallpaperManagerService.this.mLock;
            synchronized (object) {
                if (WallpaperManagerService.this.mCurrentUserId != this.getChangingUserId()) {
                    return;
                }
                WallpaperData wallpaper = WallpaperManagerService.this.mWallpaperMap.get(WallpaperManagerService.this.mCurrentUserId);
                if (wallpaper != null) {
                    if (wallpaper.wallpaperComponent == null || !wallpaper.wallpaperComponent.getPackageName().equals(packageName)) {
                        return;
                    }
                    this.doPackagesChangedLocked(true, wallpaper);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPackageUpdateStarted(String packageName, int uid) {
            Object object = WallpaperManagerService.this.mLock;
            synchronized (object) {
                if (WallpaperManagerService.this.mCurrentUserId != this.getChangingUserId()) {
                    return;
                }
                WallpaperData wallpaper = WallpaperManagerService.this.mWallpaperMap.get(WallpaperManagerService.this.mCurrentUserId);
                if (wallpaper != null && wallpaper.wallpaperComponent != null && wallpaper.wallpaperComponent.getPackageName().equals(packageName)) {
                    wallpaper.wallpaperUpdating = true;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean onHandleForceStop(Intent intent, String[] packages, int uid, boolean doit) {
            Object object = WallpaperManagerService.this.mLock;
            synchronized (object) {
                boolean changed = false;
                if (WallpaperManagerService.this.mCurrentUserId != this.getChangingUserId()) {
                    return false;
                }
                WallpaperData wallpaper = WallpaperManagerService.this.mWallpaperMap.get(WallpaperManagerService.this.mCurrentUserId);
                if (wallpaper != null) {
                    boolean res = this.doPackagesChangedLocked(doit, wallpaper);
                    changed |= res;
                }
                return changed;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSomePackagesChanged() {
            Object object = WallpaperManagerService.this.mLock;
            synchronized (object) {
                if (WallpaperManagerService.this.mCurrentUserId != this.getChangingUserId()) {
                    return;
                }
                WallpaperData wallpaper = WallpaperManagerService.this.mWallpaperMap.get(WallpaperManagerService.this.mCurrentUserId);
                if (wallpaper != null) {
                    this.doPackagesChangedLocked(true, wallpaper);
                }
            }
        }

        boolean doPackagesChangedLocked(boolean doit, WallpaperData wallpaper) {
            int change;
            boolean changed = false;
            if (wallpaper.wallpaperComponent != null && ((change = this.isPackageDisappearing(wallpaper.wallpaperComponent.getPackageName())) == 3 || change == 2)) {
                changed = true;
                if (doit) {
                    Slog.w(WallpaperManagerService.TAG, "Wallpaper uninstalled, removing: " + wallpaper.wallpaperComponent);
                    WallpaperManagerService.this.clearWallpaperLocked(false, wallpaper.userId, null);
                }
            }
            if (wallpaper.nextWallpaperComponent != null && ((change = this.isPackageDisappearing(wallpaper.nextWallpaperComponent.getPackageName())) == 3 || change == 2)) {
                wallpaper.nextWallpaperComponent = null;
            }
            if (wallpaper.wallpaperComponent != null && this.isPackageModified(wallpaper.wallpaperComponent.getPackageName())) {
                try {
                    WallpaperManagerService.this.mContext.getPackageManager().getServiceInfo(wallpaper.wallpaperComponent, 0);
                }
                catch (PackageManager.NameNotFoundException e) {
                    Slog.w(WallpaperManagerService.TAG, "Wallpaper component gone, removing: " + wallpaper.wallpaperComponent);
                    WallpaperManagerService.this.clearWallpaperLocked(false, wallpaper.userId, null);
                }
            }
            if (wallpaper.nextWallpaperComponent != null && this.isPackageModified(wallpaper.nextWallpaperComponent.getPackageName())) {
                try {
                    WallpaperManagerService.this.mContext.getPackageManager().getServiceInfo(wallpaper.nextWallpaperComponent, 0);
                }
                catch (PackageManager.NameNotFoundException e) {
                    wallpaper.nextWallpaperComponent = null;
                }
            }
            return changed;
        }
    }

    class WallpaperConnection
    extends IWallpaperConnection.Stub
    implements ServiceConnection {
        final WallpaperInfo mInfo;
        final Binder mToken = new Binder();
        IWallpaperService mService;
        IWallpaperEngine mEngine;
        WallpaperData mWallpaper;
        IRemoteCallback mReply;
        boolean mDimensionsChanged = false;
        boolean mPaddingChanged = false;

        public WallpaperConnection(WallpaperInfo info, WallpaperData wallpaper) {
            this.mInfo = info;
            this.mWallpaper = wallpaper;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onServiceConnected(ComponentName name, IBinder service) {
            Object object = WallpaperManagerService.this.mLock;
            synchronized (object) {
                if (this.mWallpaper.connection == this) {
                    this.mService = IWallpaperService.Stub.asInterface(service);
                    WallpaperManagerService.this.attachServiceLocked(this, this.mWallpaper);
                    WallpaperManagerService.this.saveSettingsLocked(this.mWallpaper);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onServiceDisconnected(ComponentName name) {
            Object object = WallpaperManagerService.this.mLock;
            synchronized (object) {
                this.mService = null;
                this.mEngine = null;
                if (this.mWallpaper.connection == this) {
                    Slog.w(WallpaperManagerService.TAG, "Wallpaper service gone: " + this.mWallpaper.wallpaperComponent);
                    if (!this.mWallpaper.wallpaperUpdating && this.mWallpaper.userId == WallpaperManagerService.this.mCurrentUserId) {
                        if (this.mWallpaper.lastDiedTime != 0L && this.mWallpaper.lastDiedTime + 10000L > SystemClock.uptimeMillis()) {
                            Slog.w(WallpaperManagerService.TAG, "Reverting to built-in wallpaper!");
                            WallpaperManagerService.this.clearWallpaperLocked(true, this.mWallpaper.userId, null);
                        } else {
                            this.mWallpaper.lastDiedTime = SystemClock.uptimeMillis();
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void attachEngine(IWallpaperEngine engine) {
            Object object = WallpaperManagerService.this.mLock;
            synchronized (object) {
                this.mEngine = engine;
                if (this.mDimensionsChanged) {
                    try {
                        this.mEngine.setDesiredSize(this.mWallpaper.width, this.mWallpaper.height);
                    }
                    catch (RemoteException e) {
                        Slog.w(WallpaperManagerService.TAG, "Failed to set wallpaper dimensions", e);
                    }
                    this.mDimensionsChanged = false;
                }
                if (this.mPaddingChanged) {
                    try {
                        this.mEngine.setDisplayPadding(this.mWallpaper.padding);
                    }
                    catch (RemoteException e) {
                        Slog.w(WallpaperManagerService.TAG, "Failed to set wallpaper padding", e);
                    }
                    this.mPaddingChanged = false;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void engineShown(IWallpaperEngine engine) {
            Object object = WallpaperManagerService.this.mLock;
            synchronized (object) {
                if (this.mReply != null) {
                    long ident = Binder.clearCallingIdentity();
                    try {
                        this.mReply.sendResult(null);
                    }
                    catch (RemoteException e) {
                        Binder.restoreCallingIdentity(ident);
                    }
                    this.mReply = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ParcelFileDescriptor setWallpaper(String name) {
            Object object = WallpaperManagerService.this.mLock;
            synchronized (object) {
                if (this.mWallpaper.connection == this) {
                    return WallpaperManagerService.this.updateWallpaperBitmapLocked(name, this.mWallpaper);
                }
                return null;
            }
        }
    }

    static class WallpaperData {
        int userId;
        File wallpaperFile;
        boolean imageWallpaperPending;
        String name = "";
        ComponentName wallpaperComponent;
        ComponentName nextWallpaperComponent;
        WallpaperConnection connection;
        long lastDiedTime;
        boolean wallpaperUpdating;
        WallpaperObserver wallpaperObserver;
        private RemoteCallbackList<IWallpaperManagerCallback> callbacks = new RemoteCallbackList();
        int width = -1;
        int height = -1;
        final Rect padding = new Rect(0, 0, 0, 0);

        WallpaperData(int userId) {
            this.userId = userId;
            this.wallpaperFile = new File(WallpaperManagerService.getWallpaperDir(userId), WallpaperManagerService.WALLPAPER);
        }
    }

    private class WallpaperObserver
    extends FileObserver {
        final WallpaperData mWallpaper;
        final File mWallpaperDir;
        final File mWallpaperFile;

        public WallpaperObserver(WallpaperData wallpaper) {
            super(WallpaperManagerService.getWallpaperDir(wallpaper.userId).getAbsolutePath(), 1672);
            this.mWallpaperDir = WallpaperManagerService.getWallpaperDir(wallpaper.userId);
            this.mWallpaper = wallpaper;
            this.mWallpaperFile = new File(this.mWallpaperDir, WallpaperManagerService.WALLPAPER);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onEvent(int event, String path) {
            if (path == null) {
                return;
            }
            Object object = WallpaperManagerService.this.mLock;
            synchronized (object) {
                long origId = Binder.clearCallingIdentity();
                BackupManager bm = new BackupManager(WallpaperManagerService.this.mContext);
                bm.dataChanged();
                Binder.restoreCallingIdentity(origId);
                File changedFile = new File(this.mWallpaperDir, path);
                if (this.mWallpaperFile.equals(changedFile)) {
                    boolean written;
                    WallpaperManagerService.this.notifyCallbacksLocked(this.mWallpaper);
                    boolean bl = written = event == 8 || event == 128;
                    if (this.mWallpaper.wallpaperComponent == null || event != 8 || this.mWallpaper.imageWallpaperPending) {
                        if (written) {
                            this.mWallpaper.imageWallpaperPending = false;
                        }
                        WallpaperManagerService.this.bindWallpaperComponentLocked(WallpaperManagerService.this.mImageWallpaper, true, false, this.mWallpaper, null);
                        WallpaperManagerService.this.saveSettingsLocked(this.mWallpaper);
                    }
                }
            }
        }
    }
}

