/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.webkit;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Binder;
import android.os.Process;
import android.util.Slog;
import android.webkit.IWebViewUpdateService;
import android.webkit.WebViewFactory;
import com.android.server.SystemService;

public class WebViewUpdateService
extends SystemService {
    private static final String TAG = "WebViewUpdateService";
    private static final int WAIT_TIMEOUT_MS = 5000;
    private boolean mRelroReady32Bit = false;
    private boolean mRelroReady64Bit = false;
    private BroadcastReceiver mWebViewUpdatedReceiver;

    public WebViewUpdateService(Context context) {
        super(context);
    }

    @Override
    public void onStart() {
        this.mWebViewUpdatedReceiver = new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                String webviewPackage = "package:" + WebViewFactory.getWebViewPackageName();
                if (webviewPackage.equals(intent.getDataString())) {
                    WebViewUpdateService.this.onWebViewUpdateInstalled();
                }
            }
        };
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.PACKAGE_REPLACED");
        filter.addDataScheme("package");
        this.getContext().registerReceiver(this.mWebViewUpdatedReceiver, filter);
        this.publishBinderService("webviewupdate", new BinderService());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onWebViewUpdateInstalled() {
        Slog.d(TAG, "WebView Package updated!");
        WebViewUpdateService webViewUpdateService = this;
        synchronized (webViewUpdateService) {
            this.mRelroReady32Bit = false;
            this.mRelroReady64Bit = false;
        }
        WebViewFactory.onWebViewUpdateInstalled();
    }

    private class BinderService
    extends IWebViewUpdateService.Stub {
        private BinderService() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void notifyRelroCreationCompleted(boolean is64Bit, boolean success) {
            if (Binder.getCallingUid() != 1037 && Binder.getCallingUid() != 1000) {
                return;
            }
            WebViewUpdateService webViewUpdateService = WebViewUpdateService.this;
            synchronized (webViewUpdateService) {
                if (is64Bit) {
                    WebViewUpdateService.this.mRelroReady64Bit = true;
                } else {
                    WebViewUpdateService.this.mRelroReady32Bit = true;
                }
                WebViewUpdateService.this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void waitForRelroCreationCompleted(boolean is64Bit) {
            if (Binder.getCallingPid() == Process.myPid()) {
                throw new IllegalStateException("Cannot create a WebView from the SystemServer");
            }
            long NS_PER_MS = 1000000L;
            long timeoutTimeMs = System.nanoTime() / 1000000L + 5000L;
            boolean relroReady = is64Bit ? WebViewUpdateService.this.mRelroReady64Bit : WebViewUpdateService.this.mRelroReady32Bit;
            WebViewUpdateService webViewUpdateService = WebViewUpdateService.this;
            synchronized (webViewUpdateService) {
                long timeNowMs;
                while (!relroReady && (timeNowMs = System.nanoTime() / 1000000L) < timeoutTimeMs) {
                    try {
                        WebViewUpdateService.this.wait(timeoutTimeMs - timeNowMs);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    relroReady = is64Bit ? WebViewUpdateService.this.mRelroReady64Bit : WebViewUpdateService.this.mRelroReady32Bit;
                }
            }
            if (!relroReady) {
                Slog.w(WebViewUpdateService.TAG, "creating relro file timed out");
            }
        }
    }
}

