/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.content.Context;
import android.os.IBinder;
import android.os.SystemClock;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.util.TimeUtils;
import android.view.SurfaceControl;
import android.view.WindowManagerPolicy;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import com.android.server.wm.AppTokenList;
import com.android.server.wm.AppWindowAnimator;
import com.android.server.wm.AppWindowToken;
import com.android.server.wm.DisplayContent;
import com.android.server.wm.ScreenRotationAnimation;
import com.android.server.wm.Task;
import com.android.server.wm.TaskStack;
import com.android.server.wm.WindowList;
import com.android.server.wm.WindowManagerService;
import com.android.server.wm.WindowState;
import com.android.server.wm.WindowStateAnimator;
import com.android.server.wm.WindowToken;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;

public class WindowAnimator {
    private static final String TAG = "WindowAnimator";
    private static final long KEYGUARD_ANIM_TIMEOUT_MS = 1000L;
    final WindowManagerService mService;
    final Context mContext;
    final WindowManagerPolicy mPolicy;
    boolean mAnimating;
    final Runnable mAnimationRunnable;
    long mCurrentTime;
    private int mAnimTransactionSequence;
    WindowState mWindowDetachedWallpaper = null;
    WindowStateAnimator mUniverseBackground = null;
    int mAboveUniverseLayer = 0;
    int mBulkUpdateParams = 0;
    Object mLastWindowFreezeSource;
    SparseArray<DisplayContentsAnimator> mDisplayContentsAnimators = new SparseArray(2);
    boolean mInitialized = false;
    boolean mKeyguardGoingAway;
    boolean mKeyguardGoingAwayToNotificationShade;
    boolean mKeyguardGoingAwayDisableWindowAnimations;
    static final int KEYGUARD_NOT_SHOWN = 0;
    static final int KEYGUARD_ANIMATING_IN = 1;
    static final int KEYGUARD_SHOWN = 2;
    static final int KEYGUARD_ANIMATING_OUT = 3;
    int mForceHiding = 0;

    private String forceHidingToString() {
        switch (this.mForceHiding) {
            case 0: {
                return "KEYGUARD_NOT_SHOWN";
            }
            case 1: {
                return "KEYGUARD_ANIMATING_IN";
            }
            case 2: {
                return "KEYGUARD_SHOWN";
            }
            case 3: {
                return "KEYGUARD_ANIMATING_OUT";
            }
        }
        return "KEYGUARD STATE UNKNOWN " + this.mForceHiding;
    }

    WindowAnimator(WindowManagerService service) {
        this.mService = service;
        this.mContext = service.mContext;
        this.mPolicy = service.mPolicy;
        this.mAnimationRunnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                HashMap<IBinder, WindowState> hashMap = WindowAnimator.this.mService.mWindowMap;
                synchronized (hashMap) {
                    WindowAnimator.this.mService.mAnimationScheduled = false;
                    WindowAnimator.this.animateLocked();
                }
            }
        };
    }

    void addDisplayLocked(int displayId) {
        this.getDisplayContentsAnimatorLocked(displayId);
        if (displayId == 0) {
            this.mInitialized = true;
        }
    }

    void removeDisplayLocked(int displayId) {
        DisplayContentsAnimator displayAnimator = this.mDisplayContentsAnimators.get(displayId);
        if (displayAnimator != null && displayAnimator.mScreenRotationAnimation != null) {
            displayAnimator.mScreenRotationAnimation.kill();
            displayAnimator.mScreenRotationAnimation = null;
        }
        this.mDisplayContentsAnimators.delete(displayId);
    }

    void hideWallpapersLocked(WindowState w) {
        WindowState wallpaperTarget = this.mService.mWallpaperTarget;
        WindowState lowerWallpaperTarget = this.mService.mLowerWallpaperTarget;
        ArrayList<WindowToken> wallpaperTokens = this.mService.mWallpaperTokens;
        if (wallpaperTarget == w && lowerWallpaperTarget == null || wallpaperTarget == null) {
            int numTokens = wallpaperTokens.size();
            for (int i = numTokens - 1; i >= 0; --i) {
                WindowToken token = wallpaperTokens.get(i);
                int numWindows = token.windows.size();
                for (int j = numWindows - 1; j >= 0; --j) {
                    WindowState wallpaper = (WindowState)token.windows.get(j);
                    WindowStateAnimator winAnimator = wallpaper.mWinAnimator;
                    if (winAnimator.mLastHidden) continue;
                    winAnimator.hide();
                    this.mService.dispatchWallpaperVisibility(wallpaper, false);
                    this.setPendingLayoutChanges(0, 4);
                }
                token.hidden = true;
            }
        }
    }

    private void updateAppWindowsLocked(int displayId) {
        ArrayList<TaskStack> stacks = this.mService.getDisplayContentLocked(displayId).getStacks();
        for (int stackNdx = stacks.size() - 1; stackNdx >= 0; --stackNdx) {
            boolean wasAnimating;
            AppWindowAnimator appAnimator;
            TaskStack stack = stacks.get(stackNdx);
            ArrayList<Task> tasks = stack.getTasks();
            for (int taskNdx = tasks.size() - 1; taskNdx >= 0; --taskNdx) {
                AppTokenList tokens = tasks.get((int)taskNdx).mAppTokens;
                for (int tokenNdx = tokens.size() - 1; tokenNdx >= 0; --tokenNdx) {
                    appAnimator = ((AppWindowToken)tokens.get((int)tokenNdx)).mAppAnimator;
                    boolean bl = wasAnimating = appAnimator.animation != null && appAnimator.animation != AppWindowAnimator.sDummyAnimation;
                    if (appAnimator.stepAnimationLocked(this.mCurrentTime)) {
                        this.mAnimating = true;
                        continue;
                    }
                    if (!wasAnimating) continue;
                    this.setAppLayoutChanges(appAnimator, 4, "appToken " + appAnimator.mAppToken + " done");
                }
            }
            AppTokenList exitingAppTokens = stack.mExitingAppTokens;
            int NEAT = exitingAppTokens.size();
            for (int i = 0; i < NEAT; ++i) {
                appAnimator = ((AppWindowToken)exitingAppTokens.get((int)i)).mAppAnimator;
                boolean bl = wasAnimating = appAnimator.animation != null && appAnimator.animation != AppWindowAnimator.sDummyAnimation;
                if (appAnimator.stepAnimationLocked(this.mCurrentTime)) {
                    this.mAnimating = true;
                    continue;
                }
                if (!wasAnimating) continue;
                this.setAppLayoutChanges(appAnimator, 4, "exiting appToken " + appAnimator.mAppToken + " done");
            }
        }
    }

    private void updateWindowsLocked(int displayId) {
        ++this.mAnimTransactionSequence;
        WindowList windows = this.mService.getWindowListLocked(displayId);
        ArrayList<WindowStateAnimator> unForceHiding = null;
        boolean wallpaperInUnForceHiding = false;
        WindowState wallpaper = null;
        if (this.mKeyguardGoingAway) {
            for (int i = windows.size() - 1; i >= 0; --i) {
                WindowState win = (WindowState)windows.get(i);
                if (!this.mPolicy.isKeyguardHostWindow(win.mAttrs)) continue;
                WindowStateAnimator winAnimator = win.mWinAnimator;
                if ((win.mAttrs.privateFlags & 0x400) != 0) {
                    if (winAnimator.mAnimating) break;
                    winAnimator.mAnimation = new AlphaAnimation(1.0f, 1.0f);
                    winAnimator.mAnimation.setDuration(1000L);
                    winAnimator.mAnimationIsEntrance = false;
                    break;
                }
                this.mKeyguardGoingAway = false;
                winAnimator.clearAnimation();
                break;
            }
        }
        this.mForceHiding = 0;
        WindowState imeTarget = this.mService.mInputMethodTarget;
        boolean showImeOverKeyguard = imeTarget != null && imeTarget.isVisibleNow() && (imeTarget.getAttrs().flags & 0x80000) != 0;
        WindowState winShowWhenLocked = (WindowState)this.mPolicy.getWinShowWhenLockedLw();
        AppWindowToken appShowWhenLocked = winShowWhenLocked == null ? null : winShowWhenLocked.mAppToken;
        for (int i = windows.size() - 1; i >= 0; --i) {
            AppWindowAnimator appAnimator;
            WindowState win = (WindowState)windows.get(i);
            WindowStateAnimator winAnimator = win.mWinAnimator;
            int flags = win.mAttrs.flags;
            if (winAnimator.mSurfaceControl != null) {
                boolean wasAnimating = winAnimator.mWasAnimating;
                boolean nowAnimating = winAnimator.stepAnimationLocked(this.mCurrentTime);
                if (wasAnimating && !winAnimator.mAnimating && this.mService.mWallpaperTarget == win) {
                    this.mBulkUpdateParams |= 2;
                    this.setPendingLayoutChanges(0, 4);
                    this.mService.debugLayoutRepeats("updateWindowsAndWallpaperLocked 2", this.getPendingLayoutChanges(0));
                }
                if (this.mPolicy.isForceHiding(win.mAttrs)) {
                    if (!wasAnimating && nowAnimating) {
                        this.mBulkUpdateParams |= 4;
                        this.setPendingLayoutChanges(displayId, 4);
                        this.mService.debugLayoutRepeats("updateWindowsAndWallpaperLocked 3", this.getPendingLayoutChanges(displayId));
                        this.mService.mFocusMayChange = true;
                    } else if (this.mKeyguardGoingAway && !nowAnimating) {
                        Slog.e(TAG, "Timeout waiting for animation to startup");
                        this.mPolicy.startKeyguardExitAnimation(0L, 0L);
                        this.mKeyguardGoingAway = false;
                    }
                    if (win.isReadyForDisplay()) {
                        this.mForceHiding = nowAnimating ? (winAnimator.mAnimationIsEntrance ? 1 : 3) : (win.isDrawnLw() ? 2 : 0);
                    }
                } else if (this.mPolicy.canBeForceHidden(win, win.mAttrs)) {
                    boolean changed;
                    boolean hideWhenLocked;
                    boolean bl = hideWhenLocked = !(win.mIsImWindow && showImeOverKeyguard || appShowWhenLocked != null && appShowWhenLocked == win.mAppToken);
                    if (this.mForceHiding == 1 && (!winAnimator.isAnimating() || hideWhenLocked) || this.mForceHiding == 2 && hideWhenLocked) {
                        changed = win.hideLw(false, false);
                    } else {
                        changed = win.showLw(false, false);
                        if (changed) {
                            WindowState currentFocus;
                            if ((this.mBulkUpdateParams & 4) != 0 && win.isVisibleNow()) {
                                if (unForceHiding == null) {
                                    unForceHiding = new ArrayList<WindowStateAnimator>();
                                }
                                unForceHiding.add(winAnimator);
                                if ((flags & 0x100000) != 0) {
                                    wallpaperInUnForceHiding = true;
                                }
                            }
                            if ((currentFocus = this.mService.mCurrentFocus) == null || currentFocus.mLayer < win.mLayer) {
                                this.mService.mFocusMayChange = true;
                            }
                        }
                    }
                    if (changed && (flags & 0x100000) != 0) {
                        this.mBulkUpdateParams |= 2;
                        this.setPendingLayoutChanges(0, 4);
                        this.mService.debugLayoutRepeats("updateWindowsAndWallpaperLocked 4", this.getPendingLayoutChanges(0));
                    }
                }
            }
            AppWindowToken atoken = win.mAppToken;
            if (winAnimator.mDrawState == 3 && (atoken == null || atoken.allDrawn) && winAnimator.performShowLocked()) {
                this.setPendingLayoutChanges(displayId, 8);
                this.mService.debugLayoutRepeats("updateWindowsAndWallpaperLocked 5", this.getPendingLayoutChanges(displayId));
            }
            if ((appAnimator = winAnimator.mAppAnimator) != null && appAnimator.thumbnail != null) {
                if (appAnimator.thumbnailTransactionSeq != this.mAnimTransactionSequence) {
                    appAnimator.thumbnailTransactionSeq = this.mAnimTransactionSequence;
                    appAnimator.thumbnailLayer = 0;
                }
                if (appAnimator.thumbnailLayer < winAnimator.mAnimLayer) {
                    appAnimator.thumbnailLayer = winAnimator.mAnimLayer;
                }
            }
            if (!win.mIsWallpaper) continue;
            wallpaper = win;
        }
        if (unForceHiding != null) {
            Animation a;
            boolean startKeyguardExit = true;
            for (int i = unForceHiding.size() - 1; i >= 0; --i) {
                Animation a2 = null;
                if (!this.mKeyguardGoingAwayDisableWindowAnimations) {
                    a2 = this.mPolicy.createForceHideEnterAnimation(wallpaperInUnForceHiding, this.mKeyguardGoingAwayToNotificationShade);
                }
                if (a2 == null) continue;
                WindowStateAnimator winAnimator = (WindowStateAnimator)unForceHiding.get(i);
                winAnimator.setAnimation(a2);
                winAnimator.keyguardGoingAwayAnimation = true;
                if (!startKeyguardExit || !this.mKeyguardGoingAway) continue;
                this.mPolicy.startKeyguardExitAnimation(this.mCurrentTime + a2.getStartOffset(), a2.getDuration());
                this.mKeyguardGoingAway = false;
                startKeyguardExit = false;
            }
            if (!wallpaperInUnForceHiding && wallpaper != null && !this.mKeyguardGoingAwayDisableWindowAnimations && (a = this.mPolicy.createForceHideWallpaperExitAnimation(this.mKeyguardGoingAwayToNotificationShade)) != null) {
                WindowStateAnimator animator2 = wallpaper.mWinAnimator;
                animator2.setAnimation(a);
            }
        }
    }

    private void updateWallpaperLocked(int displayId) {
        this.mService.getDisplayContentLocked(displayId).resetAnimationBackgroundAnimator();
        WindowList windows = this.mService.getWindowListLocked(displayId);
        WindowState detachedWallpaper = null;
        for (int i = windows.size() - 1; i >= 0; --i) {
            TaskStack stack;
            int color2;
            AppWindowAnimator appAnimator;
            WindowState win = (WindowState)windows.get(i);
            WindowStateAnimator winAnimator = win.mWinAnimator;
            if (winAnimator.mSurfaceControl == null) continue;
            int flags = win.mAttrs.flags;
            if (winAnimator.mAnimating) {
                if (winAnimator.mAnimation != null) {
                    TaskStack stack2;
                    int color3;
                    if ((flags & 0x100000) != 0 && winAnimator.mAnimation.getDetachWallpaper()) {
                        detachedWallpaper = win;
                    }
                    if ((color3 = winAnimator.mAnimation.getBackgroundColor()) != 0 && (stack2 = win.getStack()) != null) {
                        stack2.setAnimationBackground(winAnimator, color3);
                    }
                }
                this.mAnimating = true;
            }
            if ((appAnimator = winAnimator.mAppAnimator) == null || appAnimator.animation == null || !appAnimator.animating) continue;
            if ((flags & 0x100000) != 0 && appAnimator.animation.getDetachWallpaper()) {
                detachedWallpaper = win;
            }
            if ((color2 = appAnimator.animation.getBackgroundColor()) == 0 || (stack = win.getStack()) == null) continue;
            stack.setAnimationBackground(winAnimator, color2);
        }
        if (this.mWindowDetachedWallpaper != detachedWallpaper) {
            this.mWindowDetachedWallpaper = detachedWallpaper;
            this.mBulkUpdateParams |= 2;
        }
    }

    private void testTokenMayBeDrawnLocked(int displayId) {
        ArrayList<Task> tasks = this.mService.getDisplayContentLocked(displayId).getTasks();
        int numTasks = tasks.size();
        for (int taskNdx = 0; taskNdx < numTasks; ++taskNdx) {
            AppTokenList tokens = tasks.get((int)taskNdx).mAppTokens;
            int numTokens = tokens.size();
            for (int tokenNdx = 0; tokenNdx < numTokens; ++tokenNdx) {
                AppWindowToken wtoken = (AppWindowToken)tokens.get(tokenNdx);
                AppWindowAnimator appAnimator = wtoken.mAppAnimator;
                boolean allDrawn = wtoken.allDrawn;
                if (allDrawn == appAnimator.allDrawn) continue;
                appAnimator.allDrawn = allDrawn;
                if (!allDrawn) continue;
                if (appAnimator.freezingScreen) {
                    appAnimator.showAllWindowsLocked();
                    this.mService.unsetAppFreezingScreenLocked(wtoken, false, true);
                    this.setAppLayoutChanges(appAnimator, 4, "testTokenMayBeDrawnLocked: freezingScreen");
                    continue;
                }
                this.setAppLayoutChanges(appAnimator, 8, "testTokenMayBeDrawnLocked");
                if (this.mService.mOpeningApps.contains(wtoken)) continue;
                this.mAnimating |= appAnimator.showAllWindowsLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void animateLocked() {
        if (!this.mInitialized) {
            return;
        }
        this.mCurrentTime = SystemClock.uptimeMillis();
        this.mBulkUpdateParams = 8;
        boolean wasAnimating = this.mAnimating;
        this.mAnimating = false;
        SurfaceControl.openTransaction();
        SurfaceControl.setAnimationTransaction();
        try {
            int displayId;
            int i;
            int numDisplays = this.mDisplayContentsAnimators.size();
            for (i = 0; i < numDisplays; ++i) {
                displayId = this.mDisplayContentsAnimators.keyAt(i);
                this.updateAppWindowsLocked(displayId);
                DisplayContentsAnimator displayAnimator = this.mDisplayContentsAnimators.valueAt(i);
                ScreenRotationAnimation screenRotationAnimation = displayAnimator.mScreenRotationAnimation;
                if (screenRotationAnimation != null && screenRotationAnimation.isAnimating()) {
                    if (screenRotationAnimation.stepAnimationLocked(this.mCurrentTime)) {
                        this.mAnimating = true;
                    } else {
                        this.mBulkUpdateParams |= 1;
                        screenRotationAnimation.kill();
                        displayAnimator.mScreenRotationAnimation = null;
                        if (this.mService.mAccessibilityController != null && displayId == 0) {
                            this.mService.mAccessibilityController.onRotationChangedLocked(this.mService.getDefaultDisplayContentLocked(), this.mService.mRotation);
                        }
                    }
                }
                this.updateWindowsLocked(displayId);
                this.updateWallpaperLocked(displayId);
                WindowList windows = this.mService.getWindowListLocked(displayId);
                int N = windows.size();
                for (int j = 0; j < N; ++j) {
                    ((WindowState)windows.get((int)j)).mWinAnimator.prepareSurfaceLocked(true);
                }
            }
            for (i = 0; i < numDisplays; ++i) {
                displayId = this.mDisplayContentsAnimators.keyAt(i);
                this.testTokenMayBeDrawnLocked(displayId);
                ScreenRotationAnimation screenRotationAnimation = this.mDisplayContentsAnimators.valueAt((int)i).mScreenRotationAnimation;
                if (screenRotationAnimation != null) {
                    screenRotationAnimation.updateSurfacesInTransaction();
                }
                this.mAnimating |= this.mService.getDisplayContentLocked(displayId).animateDimLayers();
                if (this.mService.mAccessibilityController == null || displayId != 0) continue;
                this.mService.mAccessibilityController.drawMagnifiedRegionBorderIfNeededLocked();
            }
            if (this.mAnimating) {
                this.mService.scheduleAnimationLocked();
            }
            this.mService.setFocusedStackLayer();
            if (this.mService.mWatermark != null) {
                this.mService.mWatermark.drawIfNeeded();
            }
        }
        catch (RuntimeException e) {
            Slog.wtf(TAG, "Unhandled exception in Window Manager", e);
        }
        finally {
            SurfaceControl.closeTransaction();
        }
        boolean hasPendingLayoutChanges = false;
        int numDisplays = this.mService.mDisplayContents.size();
        for (int displayNdx = 0; displayNdx < numDisplays; ++displayNdx) {
            DisplayContent displayContent = this.mService.mDisplayContents.valueAt(displayNdx);
            int pendingChanges = this.getPendingLayoutChanges(displayContent.getDisplayId());
            if ((pendingChanges & 4) != 0) {
                this.mBulkUpdateParams |= 0x20;
            }
            if (pendingChanges == 0) continue;
            hasPendingLayoutChanges = true;
        }
        boolean doRequest = false;
        if (this.mBulkUpdateParams != 0) {
            doRequest = this.mService.copyAnimToLayoutParamsLocked();
        }
        if (hasPendingLayoutChanges || doRequest) {
            this.mService.requestTraversalLocked();
        }
        if (!this.mAnimating && wasAnimating) {
            this.mService.requestTraversalLocked();
        }
    }

    static String bulkUpdateParamsToString(int bulkUpdateParams) {
        StringBuilder builder = new StringBuilder(128);
        if ((bulkUpdateParams & 1) != 0) {
            builder.append(" UPDATE_ROTATION");
        }
        if ((bulkUpdateParams & 2) != 0) {
            builder.append(" WALLPAPER_MAY_CHANGE");
        }
        if ((bulkUpdateParams & 4) != 0) {
            builder.append(" FORCE_HIDING_CHANGED");
        }
        if ((bulkUpdateParams & 8) != 0) {
            builder.append(" ORIENTATION_CHANGE_COMPLETE");
        }
        if ((bulkUpdateParams & 0x10) != 0) {
            builder.append(" TURN_ON_SCREEN");
        }
        return builder.toString();
    }

    public void dumpLocked(PrintWriter pw, String prefix, boolean dumpAll) {
        String subPrefix = "  " + prefix;
        String subSubPrefix = "  " + subPrefix;
        for (int i = 0; i < this.mDisplayContentsAnimators.size(); ++i) {
            pw.print(prefix);
            pw.print("DisplayContentsAnimator #");
            pw.print(this.mDisplayContentsAnimators.keyAt(i));
            pw.println(":");
            DisplayContentsAnimator displayAnimator = this.mDisplayContentsAnimators.valueAt(i);
            WindowList windows = this.mService.getWindowListLocked(this.mDisplayContentsAnimators.keyAt(i));
            int N = windows.size();
            for (int j = 0; j < N; ++j) {
                WindowStateAnimator wanim = ((WindowState)windows.get((int)j)).mWinAnimator;
                pw.print(subPrefix);
                pw.print("Window #");
                pw.print(j);
                pw.print(": ");
                pw.println(wanim);
            }
            if (displayAnimator.mScreenRotationAnimation != null) {
                pw.print(subPrefix);
                pw.println("mScreenRotationAnimation:");
                displayAnimator.mScreenRotationAnimation.printTo(subSubPrefix, pw);
                continue;
            }
            if (!dumpAll) continue;
            pw.print(subPrefix);
            pw.println("no ScreenRotationAnimation ");
        }
        pw.println();
        if (dumpAll) {
            pw.print(prefix);
            pw.print("mAnimTransactionSequence=");
            pw.print(this.mAnimTransactionSequence);
            pw.print(" mForceHiding=");
            pw.println(this.forceHidingToString());
            pw.print(prefix);
            pw.print("mCurrentTime=");
            pw.println(TimeUtils.formatUptime(this.mCurrentTime));
        }
        if (this.mBulkUpdateParams != 0) {
            pw.print(prefix);
            pw.print("mBulkUpdateParams=0x");
            pw.print(Integer.toHexString(this.mBulkUpdateParams));
            pw.println(WindowAnimator.bulkUpdateParamsToString(this.mBulkUpdateParams));
        }
        if (this.mWindowDetachedWallpaper != null) {
            pw.print(prefix);
            pw.print("mWindowDetachedWallpaper=");
            pw.println(this.mWindowDetachedWallpaper);
        }
        if (this.mUniverseBackground != null) {
            pw.print(prefix);
            pw.print("mUniverseBackground=");
            pw.print(this.mUniverseBackground);
            pw.print(" mAboveUniverseLayer=");
            pw.println(this.mAboveUniverseLayer);
        }
    }

    int getPendingLayoutChanges(int displayId) {
        if (displayId < 0) {
            return 0;
        }
        return this.mService.getDisplayContentLocked((int)displayId).pendingLayoutChanges;
    }

    void setPendingLayoutChanges(int displayId, int changes) {
        if (displayId >= 0) {
            this.mService.getDisplayContentLocked((int)displayId).pendingLayoutChanges |= changes;
        }
    }

    void setAppLayoutChanges(AppWindowAnimator appAnimator, int changes, String s) {
        SparseIntArray displays = new SparseIntArray(2);
        WindowList windows = appAnimator.mAppToken.allAppWindows;
        for (int i = windows.size() - 1; i >= 0; --i) {
            int displayId = ((WindowState)windows.get(i)).getDisplayId();
            if (displayId < 0 || displays.indexOfKey(displayId) >= 0) continue;
            this.setPendingLayoutChanges(displayId, changes);
            this.mService.debugLayoutRepeats(s, this.getPendingLayoutChanges(displayId));
            displays.put(displayId, changes);
        }
    }

    private DisplayContentsAnimator getDisplayContentsAnimatorLocked(int displayId) {
        DisplayContentsAnimator displayAnimator = this.mDisplayContentsAnimators.get(displayId);
        if (displayAnimator == null) {
            displayAnimator = new DisplayContentsAnimator();
            this.mDisplayContentsAnimators.put(displayId, displayAnimator);
        }
        return displayAnimator;
    }

    void setScreenRotationAnimationLocked(int displayId, ScreenRotationAnimation animation) {
        if (displayId >= 0) {
            this.getDisplayContentsAnimatorLocked((int)displayId).mScreenRotationAnimation = animation;
        }
    }

    ScreenRotationAnimation getScreenRotationAnimationLocked(int displayId) {
        if (displayId < 0) {
            return null;
        }
        return this.getDisplayContentsAnimatorLocked((int)displayId).mScreenRotationAnimation;
    }

    private class DisplayContentsAnimator {
        ScreenRotationAnimation mScreenRotationAnimation = null;

        private DisplayContentsAnimator() {
        }
    }
}

