/*
 * Decompiled with CFR 0.152.
 */
package dalvik.system;

import android.system.ErrnoException;
import android.system.OsConstants;
import android.system.StructStat;
import com.google.errorprone.annotations.DoNotMock;
import dalvik.system.DexFile;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipFile;
import libcore.io.IoUtils;
import libcore.io.Libcore;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class DexPathList
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String DEX_SUFFIX = ".dex";
    private ClassLoader definingContext;
    private Element[] dexElements;
    private File[] nativeLibraryDirectories;
    private IOException[] dexElementsSuppressedExceptions;

    private void $$robo$$dalvik_system_DexPathList$__constructor__(ClassLoader definingContext, String dexPath, String libraryPath, File optimizedDirectory) {
        if (definingContext == null) {
            throw new NullPointerException("definingContext == null");
        }
        if (dexPath == null) {
            throw new NullPointerException("dexPath == null");
        }
        if (optimizedDirectory != null) {
            if (!optimizedDirectory.exists()) {
                throw new IllegalArgumentException("optimizedDirectory doesn't exist: " + optimizedDirectory);
            }
            if (!optimizedDirectory.canRead() || !optimizedDirectory.canWrite()) {
                throw new IllegalArgumentException("optimizedDirectory not readable/writable: " + optimizedDirectory);
            }
        }
        this.definingContext = definingContext;
        ArrayList<IOException> suppressedExceptions = new ArrayList<IOException>();
        this.dexElements = DexPathList.makeDexElements(DexPathList.splitDexPath(dexPath), optimizedDirectory, suppressedExceptions);
        this.dexElementsSuppressedExceptions = suppressedExceptions.size() > 0 ? suppressedExceptions.toArray(new IOException[suppressedExceptions.size()]) : null;
        this.nativeLibraryDirectories = DexPathList.splitLibraryPath(libraryPath);
    }

    private final String $$robo$$dalvik_system_DexPathList$toString() {
        return "DexPathList[" + Arrays.toString(this.dexElements) + ",nativeLibraryDirectories=" + Arrays.toString(this.nativeLibraryDirectories) + "]";
    }

    private final File[] $$robo$$dalvik_system_DexPathList$getNativeLibraryDirectories() {
        return this.nativeLibraryDirectories;
    }

    private static final ArrayList<File> $$robo$$dalvik_system_DexPathList$splitDexPath(String path) {
        return DexPathList.splitPaths(path, null, false);
    }

    private static final File[] $$robo$$dalvik_system_DexPathList$splitLibraryPath(String path) {
        ArrayList<File> result = DexPathList.splitPaths(path, System.getProperty("java.library.path"), true);
        return result.toArray(new File[result.size()]);
    }

    private static final ArrayList<File> $$robo$$dalvik_system_DexPathList$splitPaths(String path1, String path2, boolean wantDirectories) {
        ArrayList<File> result = new ArrayList<File>();
        DexPathList.splitAndAdd(path1, wantDirectories, result);
        DexPathList.splitAndAdd(path2, wantDirectories, result);
        return result;
    }

    private static final void $$robo$$dalvik_system_DexPathList$splitAndAdd(String searchPath, boolean directoriesOnly, ArrayList<File> resultList) {
        if (searchPath == null) {
            return;
        }
        for (String path : searchPath.split(":")) {
            try {
                StructStat sb = Libcore.os.stat(path);
                if (directoriesOnly && !OsConstants.S_ISDIR(sb.st_mode)) continue;
                resultList.add(new File(path));
            }
            catch (ErrnoException errnoException) {
                // empty catch block
            }
        }
    }

    private static final Element[] $$robo$$dalvik_system_DexPathList$makeDexElements(ArrayList<File> files, File optimizedDirectory, ArrayList<IOException> suppressedExceptions) {
        ArrayList<Element> elements = new ArrayList<Element>();
        for (File file : files) {
            File zip = null;
            DexFile dex = null;
            String name = file.getName();
            if (file.isDirectory()) {
                elements.add(new Element(file, true, null, null));
            } else if (file.isFile()) {
                if (name.endsWith(".dex")) {
                    try {
                        dex = DexPathList.loadDexFile(file, optimizedDirectory);
                    }
                    catch (IOException ex) {
                        InvokeDynamicSupport.bootstrapIntrinsic("logE", "java.lang.System", (String)("Unable to load dex file: " + file), (Throwable)ex);
                    }
                } else {
                    zip = file;
                    try {
                        dex = DexPathList.loadDexFile(file, optimizedDirectory);
                    }
                    catch (IOException suppressed) {
                        suppressedExceptions.add(suppressed);
                    }
                }
            } else {
                InvokeDynamicSupport.bootstrapIntrinsic("logW", "java.lang.System", (String)("ClassLoader referenced unknown path: " + file));
            }
            if (zip == null && dex == null) continue;
            elements.add(new Element(file, false, zip, dex));
        }
        return elements.toArray(new Element[elements.size()]);
    }

    private static final DexFile $$robo$$dalvik_system_DexPathList$loadDexFile(File file, File optimizedDirectory) throws IOException {
        if (optimizedDirectory == null) {
            return new DexFile(file);
        }
        String optimizedPath = DexPathList.optimizedPathFor(file, optimizedDirectory);
        return DexFile.loadDex(file.getPath(), optimizedPath, 0);
    }

    private static final String $$robo$$dalvik_system_DexPathList$optimizedPathFor(File path, File optimizedDirectory) {
        String fileName = path.getName();
        if (!fileName.endsWith(".dex")) {
            int lastDot = fileName.lastIndexOf(".");
            if (lastDot < 0) {
                fileName = fileName + ".dex";
            } else {
                StringBuilder sb = new StringBuilder(lastDot + 4);
                sb.append(fileName, 0, lastDot);
                sb.append(".dex");
                fileName = sb.toString();
            }
        }
        File result = new File(optimizedDirectory, fileName);
        return result.getPath();
    }

    private final Class $$robo$$dalvik_system_DexPathList$findClass(String name, List<Throwable> suppressed) {
        for (Element element : this.dexElements) {
            Class clazz;
            DexFile dex = element.dexFile;
            if (dex == null || (clazz = dex.loadClassBinaryName(name, this.definingContext, suppressed)) == null) continue;
            return clazz;
        }
        if (this.dexElementsSuppressedExceptions != null) {
            suppressed.addAll(Arrays.asList(this.dexElementsSuppressedExceptions));
        }
        return null;
    }

    private final URL $$robo$$dalvik_system_DexPathList$findResource(String name) {
        for (Element element : this.dexElements) {
            URL url = element.findResource(name);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    private final Enumeration<URL> $$robo$$dalvik_system_DexPathList$findResources(String name) {
        ArrayList<URL> result = new ArrayList<URL>();
        for (Element element : this.dexElements) {
            URL url = element.findResource(name);
            if (url == null) continue;
            result.add(url);
        }
        return Collections.enumeration(result);
    }

    private final String $$robo$$dalvik_system_DexPathList$findLibrary(String libraryName) {
        String fileName = System.mapLibraryName(libraryName);
        for (File directory : this.nativeLibraryDirectories) {
            String path = new File(directory, fileName).getPath();
            if (!IoUtils.canOpenReadOnly(path)) continue;
            return path;
        }
        return null;
    }

    private void __constructor__(ClassLoader classLoader, String string2, String string3, File file) {
        this.$$robo$$dalvik_system_DexPathList$__constructor__(classLoader, string2, string3, file);
    }

    public DexPathList(ClassLoader classLoader, String string2, String string3, File file) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$dalvik_system_DexPathList$__constructor__(java.lang.ClassLoader java.lang.String java.lang.String java.io.File ), 0, this, classLoader, string2, string3, file);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$dalvik_system_DexPathList$toString(), 0, this);
    }

    public File[] getNativeLibraryDirectories() {
        return InvokeDynamicSupport.bootstrap("getNativeLibraryDirectories", $$robo$$dalvik_system_DexPathList$getNativeLibraryDirectories(), 0, this);
    }

    private static ArrayList<File> splitDexPath(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("splitDexPath", $$robo$$dalvik_system_DexPathList$splitDexPath(java.lang.String ), 0, (String)string2);
    }

    private static File[] splitLibraryPath(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("splitLibraryPath", $$robo$$dalvik_system_DexPathList$splitLibraryPath(java.lang.String ), 0, (String)string2);
    }

    private static ArrayList<File> splitPaths(String string2, String string3, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("splitPaths", $$robo$$dalvik_system_DexPathList$splitPaths(java.lang.String java.lang.String boolean ), 0, (String)string2, (String)string3, (boolean)bl);
    }

    private static void splitAndAdd(String string2, boolean bl, ArrayList<File> arrayList) {
        InvokeDynamicSupport.bootstrapStatic("splitAndAdd", $$robo$$dalvik_system_DexPathList$splitAndAdd(java.lang.String boolean java.util.ArrayList<java.io.File> ), 0, (String)string2, (boolean)bl, arrayList);
    }

    private static Element[] makeDexElements(ArrayList<File> arrayList, File file, ArrayList<IOException> arrayList2) {
        return InvokeDynamicSupport.bootstrapStatic("makeDexElements", $$robo$$dalvik_system_DexPathList$makeDexElements(java.util.ArrayList<java.io.File> java.io.File java.util.ArrayList<java.io.IOException> ), 0, arrayList, (File)file, arrayList2);
    }

    private static DexFile loadDexFile(File file, File file2) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("loadDexFile", $$robo$$dalvik_system_DexPathList$loadDexFile(java.io.File java.io.File ), 0, (File)file, (File)file2);
    }

    private static String optimizedPathFor(File file, File file2) {
        return InvokeDynamicSupport.bootstrapStatic("optimizedPathFor", $$robo$$dalvik_system_DexPathList$optimizedPathFor(java.io.File java.io.File ), 0, (File)file, (File)file2);
    }

    public Class findClass(String string2, List<Throwable> list) {
        return InvokeDynamicSupport.bootstrap("findClass", $$robo$$dalvik_system_DexPathList$findClass(java.lang.String java.util.List<java.lang.Throwable> ), 0, this, string2, list);
    }

    public URL findResource(String string2) {
        return InvokeDynamicSupport.bootstrap("findResource", $$robo$$dalvik_system_DexPathList$findResource(java.lang.String ), 0, this, string2);
    }

    public Enumeration<URL> findResources(String string2) {
        return InvokeDynamicSupport.bootstrap("findResources", $$robo$$dalvik_system_DexPathList$findResources(java.lang.String ), 0, this, string2);
    }

    public String findLibrary(String string2) {
        return InvokeDynamicSupport.bootstrap("findLibrary", $$robo$$dalvik_system_DexPathList$findLibrary(java.lang.String ), 0, this, string2);
    }

    public /* synthetic */ DexPathList() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DexPathList)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class Element
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private File file;
        private boolean isDirectory;
        private File zip;
        private DexFile dexFile;
        private ZipFile zipFile;
        private boolean initialized;

        private void $$robo$$dalvik_system_DexPathList_Element$__constructor__(File file, boolean isDirectory, File zip, DexFile dexFile) {
            this.file = file;
            this.isDirectory = isDirectory;
            this.zip = zip;
            this.dexFile = dexFile;
        }

        private final String $$robo$$dalvik_system_DexPathList_Element$toString() {
            if (this.isDirectory) {
                return "directory \"" + this.file + "\"";
            }
            if (this.zip != null) {
                return "zip file \"" + this.zip + "\"";
            }
            return "dex file \"" + this.dexFile + "\"";
        }

        private final synchronized void $$robo$$dalvik_system_DexPathList_Element$maybeInit() {
            if (this.initialized) {
                return;
            }
            this.initialized = true;
            if (this.isDirectory || this.zip == null) {
                return;
            }
            try {
                this.zipFile = new ZipFile(this.zip);
            }
            catch (IOException ioe) {
                InvokeDynamicSupport.bootstrapIntrinsic("logE", "java.lang.System", (String)("Unable to open zip file: " + this.file), (Throwable)ioe);
                this.zipFile = null;
            }
        }

        private final URL $$robo$$dalvik_system_DexPathList_Element$findResource(String name) {
            File resourceFile;
            this.maybeInit();
            if (this.isDirectory && (resourceFile = new File(this.file, name)).exists()) {
                try {
                    return resourceFile.toURI().toURL();
                }
                catch (MalformedURLException ex) {
                    throw new RuntimeException(ex);
                }
            }
            if (this.zipFile == null || this.zipFile.getEntry(name) == null) {
                return null;
            }
            try {
                return new URL("jar:" + this.file.toURL() + "!/" + name);
            }
            catch (MalformedURLException ex) {
                throw new RuntimeException(ex);
            }
        }

        private void __constructor__(File file, boolean bl, File file2, DexFile dexFile) {
            this.$$robo$$dalvik_system_DexPathList_Element$__constructor__(file, bl, file2, dexFile);
        }

        public Element(File file, boolean bl, File file2, DexFile dexFile) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$dalvik_system_DexPathList_Element$__constructor__(java.io.File boolean java.io.File dalvik.system.DexFile ), 0, this, file, bl, file2, dexFile);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$dalvik_system_DexPathList_Element$toString(), 0, this);
        }

        public synchronized void maybeInit() {
            InvokeDynamicSupport.bootstrap("maybeInit", $$robo$$dalvik_system_DexPathList_Element$maybeInit(), 0, this);
        }

        public URL findResource(String string2) {
            return InvokeDynamicSupport.bootstrap("findResource", $$robo$$dalvik_system_DexPathList_Element$findResource(java.lang.String ), 0, this, string2);
        }

        public /* synthetic */ Element() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Element)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

