/*
 * Decompiled with CFR 0.152.
 */
package dalvik.system.profiler;

import com.google.errorprone.annotations.DoNotMock;
import dalvik.system.profiler.BinaryHprof;
import dalvik.system.profiler.HprofData;
import dalvik.system.profiler.MalformedHprofException;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class BinaryHprofReader
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static boolean TRACE = false;
    private DataInputStream in;
    private boolean strict;
    private String version;
    private Map<HprofData.StackTrace, int[]> stackTraces;
    private HprofData hprofData;
    private Map<Integer, String> idToString;
    private Map<Integer, String> idToClassName;
    private Map<Integer, StackTraceElement> idToStackFrame;
    private Map<Integer, HprofData.StackTrace> idToStackTrace;

    private void $$robo$$dalvik_system_profiler_BinaryHprofReader$__constructor__(InputStream inputStream) throws IOException {
        this.strict = true;
        this.stackTraces = new HashMap<HprofData.StackTrace, int[]>();
        this.hprofData = new HprofData(this.stackTraces);
        this.idToString = new HashMap<Integer, String>();
        this.idToClassName = new HashMap<Integer, String>();
        this.idToStackFrame = new HashMap<Integer, StackTraceElement>();
        this.idToStackTrace = new HashMap<Integer, HprofData.StackTrace>();
        this.in = new DataInputStream(inputStream);
    }

    private final boolean $$robo$$dalvik_system_profiler_BinaryHprofReader$getStrict() {
        return this.strict;
    }

    private final void $$robo$$dalvik_system_profiler_BinaryHprofReader$setStrict(boolean strict) {
        if (this.version != null) {
            throw new IllegalStateException("cannot set strict after read()");
        }
        this.strict = strict;
    }

    private final void $$robo$$dalvik_system_profiler_BinaryHprofReader$checkRead() {
        if (this.version == null) {
            throw new IllegalStateException("data access before read()");
        }
    }

    private final String $$robo$$dalvik_system_profiler_BinaryHprofReader$getVersion() {
        this.checkRead();
        return this.version;
    }

    private final HprofData $$robo$$dalvik_system_profiler_BinaryHprofReader$getHprofData() {
        this.checkRead();
        return this.hprofData;
    }

    private final void $$robo$$dalvik_system_profiler_BinaryHprofReader$read() throws IOException {
        this.parseHeader();
        this.parseRecords();
    }

    private final void $$robo$$dalvik_system_profiler_BinaryHprofReader$parseHeader() throws IOException {
        this.parseVersion();
        this.parseIdSize();
        this.parseTime();
    }

    private final void $$robo$$dalvik_system_profiler_BinaryHprofReader$parseVersion() throws IOException {
        String version = BinaryHprof.readMagic(this.in);
        if (version == null) {
            throw new MalformedHprofException("Could not find HPROF version");
        }
        this.version = version;
    }

    private final void $$robo$$dalvik_system_profiler_BinaryHprofReader$parseIdSize() throws IOException {
        int idSize = this.in.readInt();
        if (idSize != 4) {
            throw new MalformedHprofException("Unsupported identifier size: " + idSize);
        }
    }

    private final void $$robo$$dalvik_system_profiler_BinaryHprofReader$parseTime() throws IOException {
        long time = this.in.readLong();
        this.hprofData.setStartMillis(time);
    }

    private final void $$robo$$dalvik_system_profiler_BinaryHprofReader$parseRecords() throws IOException {
        while (this.parseRecord()) {
        }
    }

    private final boolean $$robo$$dalvik_system_profiler_BinaryHprofReader$parseRecord() throws IOException {
        int tagOrEOF = this.in.read();
        if (tagOrEOF == -1) {
            return false;
        }
        byte tag = (byte)tagOrEOF;
        int timeDeltaInMicroseconds = this.in.readInt();
        int recordLength = this.in.readInt();
        BinaryHprof.Tag hprofTag = BinaryHprof.Tag.get(tag);
        if (hprofTag == null) {
            this.skipRecord(hprofTag, recordLength);
            return true;
        }
        String error = hprofTag.checkSize(recordLength);
        if (error != null) {
            throw new MalformedHprofException(error);
        }
        switch (1.$SwitchMap$dalvik$system$profiler$BinaryHprof$Tag[hprofTag.ordinal()]) {
            case 1: {
                this.parseControlSettings();
                return true;
            }
            case 2: {
                this.parseStringInUtf8(recordLength);
                return true;
            }
            case 3: {
                this.parseStartThread();
                return true;
            }
            case 4: {
                this.parseEndThread();
                return true;
            }
            case 5: {
                this.parseLoadClass();
                return true;
            }
            case 6: {
                this.parseStackFrame();
                return true;
            }
            case 7: {
                this.parseStackTrace(recordLength);
                return true;
            }
            case 8: {
                this.parseCpuSamples(recordLength);
                return true;
            }
        }
        this.skipRecord(hprofTag, recordLength);
        return true;
    }

    private final void $$robo$$dalvik_system_profiler_BinaryHprofReader$skipRecord(BinaryHprof.Tag hprofTag, long recordLength) throws IOException {
        long skipped = this.in.skip(recordLength);
        if (skipped != recordLength) {
            throw new EOFException("Expected to skip " + recordLength + " bytes but only skipped " + skipped + " bytes");
        }
    }

    private final void $$robo$$dalvik_system_profiler_BinaryHprofReader$parseControlSettings() throws IOException {
        int flags = this.in.readInt();
        short depth = this.in.readShort();
        this.hprofData.setFlags(flags);
        this.hprofData.setDepth(depth);
    }

    private final void $$robo$$dalvik_system_profiler_BinaryHprofReader$parseStringInUtf8(int recordLength) throws IOException {
        int stringId = this.in.readInt();
        byte[] bytes = new byte[recordLength - 4];
        BinaryHprofReader.readFully(this.in, bytes);
        String string2 = new String(bytes, "UTF-8");
        String old = this.idToString.put(stringId, string2);
        if (old != null) {
            throw new MalformedHprofException("Duplicate string id: " + stringId);
        }
    }

    private static final void $$robo$$dalvik_system_profiler_BinaryHprofReader$readFully(InputStream in, byte[] dst) throws IOException {
        int bytesRead;
        int offset = 0;
        for (int byteCount = dst.length; byteCount > 0; byteCount -= bytesRead) {
            bytesRead = in.read(dst, offset, byteCount);
            if (bytesRead < 0) {
                throw new EOFException();
            }
            offset += bytesRead;
        }
    }

    private final void $$robo$$dalvik_system_profiler_BinaryHprofReader$parseLoadClass() throws IOException {
        int classId = this.in.readInt();
        int classObjectId = this.readId();
        int stackTraceSerialNumber = this.in.readInt();
        String className = this.readString();
        String old = this.idToClassName.put(classId, className);
        if (old != null) {
            throw new MalformedHprofException("Duplicate class id: " + classId);
        }
    }

    private final int $$robo$$dalvik_system_profiler_BinaryHprofReader$readId() throws IOException {
        return this.in.readInt();
    }

    private final String $$robo$$dalvik_system_profiler_BinaryHprofReader$readString() throws IOException {
        int id2 = this.readId();
        if (id2 == 0) {
            return null;
        }
        String string2 = this.idToString.get(id2);
        if (string2 == null) {
            throw new MalformedHprofException("Unknown string id " + id2);
        }
        return string2;
    }

    private final String $$robo$$dalvik_system_profiler_BinaryHprofReader$readClass() throws IOException {
        int id2 = this.readId();
        String string2 = this.idToClassName.get(id2);
        if (string2 == null) {
            throw new MalformedHprofException("Unknown class id " + id2);
        }
        return string2;
    }

    private final void $$robo$$dalvik_system_profiler_BinaryHprofReader$parseStartThread() throws IOException {
        int threadId = this.in.readInt();
        int objectId = this.readId();
        int stackTraceSerialNumber = this.in.readInt();
        String threadName = this.readString();
        String groupName = this.readString();
        String parentGroupName = this.readString();
        HprofData.ThreadEvent event = HprofData.ThreadEvent.start(objectId, threadId, threadName, groupName, parentGroupName);
        this.hprofData.addThreadEvent(event);
    }

    private final void $$robo$$dalvik_system_profiler_BinaryHprofReader$parseEndThread() throws IOException {
        int threadId = this.in.readInt();
        HprofData.ThreadEvent event = HprofData.ThreadEvent.end(threadId);
        this.hprofData.addThreadEvent(event);
    }

    private final void $$robo$$dalvik_system_profiler_BinaryHprofReader$parseStackFrame() throws IOException {
        int stackFrameId = this.readId();
        String methodName = this.readString();
        String methodSignature = this.readString();
        String file = this.readString();
        String className = this.readClass();
        int line = this.in.readInt();
        StackTraceElement stackFrame = new StackTraceElement(className, methodName, file, line);
        StackTraceElement old = this.idToStackFrame.put(stackFrameId, stackFrame);
        if (old != null) {
            throw new MalformedHprofException("Duplicate stack frame id: " + stackFrameId);
        }
    }

    private final void $$robo$$dalvik_system_profiler_BinaryHprofReader$parseStackTrace(int recordLength) throws IOException {
        int stackTraceId = this.in.readInt();
        int threadId = this.in.readInt();
        int frames = this.in.readInt();
        int expectedLength = 12 + frames * 4;
        if (recordLength != expectedLength) {
            throw new MalformedHprofException("Expected stack trace record of size " + expectedLength + " based on number of frames but header " + "specified a length of  " + recordLength);
        }
        StackTraceElement[] stackFrames = new StackTraceElement[frames];
        for (int i = 0; i < frames; ++i) {
            int stackFrameId = this.readId();
            StackTraceElement stackFrame = this.idToStackFrame.get(stackFrameId);
            if (stackFrame == null) {
                throw new MalformedHprofException("Unknown stack frame id " + stackFrameId);
            }
            stackFrames[i] = stackFrame;
        }
        HprofData.StackTrace stackTrace = new HprofData.StackTrace(stackTraceId, threadId, stackFrames);
        if (this.strict) {
            this.hprofData.addStackTrace(stackTrace, new int[1]);
        } else {
            int[] countCell = this.stackTraces.get(stackTrace);
            if (countCell == null) {
                this.hprofData.addStackTrace(stackTrace, new int[1]);
            }
        }
        HprofData.StackTrace old = this.idToStackTrace.put(stackTraceId, stackTrace);
        if (old != null) {
            throw new MalformedHprofException("Duplicate stack trace id: " + stackTraceId);
        }
    }

    private final void $$robo$$dalvik_system_profiler_BinaryHprofReader$parseCpuSamples(int recordLength) throws IOException {
        int totalSamples = this.in.readInt();
        int samplesCount = this.in.readInt();
        int expectedLength = 8 + samplesCount * 8;
        if (recordLength != expectedLength) {
            throw new MalformedHprofException("Expected CPU samples record of size " + expectedLength + " based on number of samples but header " + "specified a length of  " + recordLength);
        }
        int total = 0;
        for (int i = 0; i < samplesCount; ++i) {
            int count = this.in.readInt();
            int stackTraceId = this.in.readInt();
            HprofData.StackTrace stackTrace = this.idToStackTrace.get(stackTraceId);
            if (stackTrace == null) {
                throw new MalformedHprofException("Unknown stack trace id " + stackTraceId);
            }
            if (count == 0) {
                throw new MalformedHprofException("Zero sample count for stack trace " + stackTrace);
            }
            int[] countCell = this.stackTraces.get(stackTrace);
            if (this.strict) {
                if (countCell[0] != 0) {
                    throw new MalformedHprofException("Setting sample count of stack trace " + stackTrace + " to " + count + " found it was already initialized to " + countCell[0]);
                }
            } else {
                count += countCell[0];
            }
            countCell[0] = count;
            total += count;
        }
        if (this.strict && totalSamples != total) {
            throw new MalformedHprofException("Expected a total of " + totalSamples + " samples but saw " + total);
        }
    }

    private void __constructor__(InputStream inputStream) throws IOException {
        this.$$robo$$dalvik_system_profiler_BinaryHprofReader$__constructor__(inputStream);
    }

    public BinaryHprofReader(InputStream inputStream) throws IOException {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$dalvik_system_profiler_BinaryHprofReader$__constructor__(java.io.InputStream ), 0, this, inputStream);
    }

    public boolean getStrict() {
        return (boolean)InvokeDynamicSupport.bootstrap("getStrict", $$robo$$dalvik_system_profiler_BinaryHprofReader$getStrict(), 0, this);
    }

    public void setStrict(boolean bl) {
        InvokeDynamicSupport.bootstrap("setStrict", $$robo$$dalvik_system_profiler_BinaryHprofReader$setStrict(boolean ), 0, this, bl);
    }

    private void checkRead() {
        InvokeDynamicSupport.bootstrap("checkRead", $$robo$$dalvik_system_profiler_BinaryHprofReader$checkRead(), 0, this);
    }

    public String getVersion() {
        return InvokeDynamicSupport.bootstrap("getVersion", $$robo$$dalvik_system_profiler_BinaryHprofReader$getVersion(), 0, this);
    }

    public HprofData getHprofData() {
        return InvokeDynamicSupport.bootstrap("getHprofData", $$robo$$dalvik_system_profiler_BinaryHprofReader$getHprofData(), 0, this);
    }

    public void read() throws IOException {
        InvokeDynamicSupport.bootstrap("read", $$robo$$dalvik_system_profiler_BinaryHprofReader$read(), 0, this);
    }

    private void parseHeader() throws IOException {
        InvokeDynamicSupport.bootstrap("parseHeader", $$robo$$dalvik_system_profiler_BinaryHprofReader$parseHeader(), 0, this);
    }

    private void parseVersion() throws IOException {
        InvokeDynamicSupport.bootstrap("parseVersion", $$robo$$dalvik_system_profiler_BinaryHprofReader$parseVersion(), 0, this);
    }

    private void parseIdSize() throws IOException {
        InvokeDynamicSupport.bootstrap("parseIdSize", $$robo$$dalvik_system_profiler_BinaryHprofReader$parseIdSize(), 0, this);
    }

    private void parseTime() throws IOException {
        InvokeDynamicSupport.bootstrap("parseTime", $$robo$$dalvik_system_profiler_BinaryHprofReader$parseTime(), 0, this);
    }

    private void parseRecords() throws IOException {
        InvokeDynamicSupport.bootstrap("parseRecords", $$robo$$dalvik_system_profiler_BinaryHprofReader$parseRecords(), 0, this);
    }

    private boolean parseRecord() throws IOException {
        return (boolean)InvokeDynamicSupport.bootstrap("parseRecord", $$robo$$dalvik_system_profiler_BinaryHprofReader$parseRecord(), 0, this);
    }

    private void skipRecord(BinaryHprof.Tag tag, long l) throws IOException {
        InvokeDynamicSupport.bootstrap("skipRecord", $$robo$$dalvik_system_profiler_BinaryHprofReader$skipRecord(dalvik.system.profiler.BinaryHprof$Tag long ), 0, this, tag, l);
    }

    private void parseControlSettings() throws IOException {
        InvokeDynamicSupport.bootstrap("parseControlSettings", $$robo$$dalvik_system_profiler_BinaryHprofReader$parseControlSettings(), 0, this);
    }

    private void parseStringInUtf8(int n) throws IOException {
        InvokeDynamicSupport.bootstrap("parseStringInUtf8", $$robo$$dalvik_system_profiler_BinaryHprofReader$parseStringInUtf8(int ), 0, this, n);
    }

    private static void readFully(InputStream inputStream, byte[] byArray) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("readFully", $$robo$$dalvik_system_profiler_BinaryHprofReader$readFully(java.io.InputStream byte[] ), 0, (InputStream)inputStream, (byte[])byArray);
    }

    private void parseLoadClass() throws IOException {
        InvokeDynamicSupport.bootstrap("parseLoadClass", $$robo$$dalvik_system_profiler_BinaryHprofReader$parseLoadClass(), 0, this);
    }

    private int readId() throws IOException {
        return (int)InvokeDynamicSupport.bootstrap("readId", $$robo$$dalvik_system_profiler_BinaryHprofReader$readId(), 0, this);
    }

    private String readString() throws IOException {
        return InvokeDynamicSupport.bootstrap("readString", $$robo$$dalvik_system_profiler_BinaryHprofReader$readString(), 0, this);
    }

    private String readClass() throws IOException {
        return InvokeDynamicSupport.bootstrap("readClass", $$robo$$dalvik_system_profiler_BinaryHprofReader$readClass(), 0, this);
    }

    private void parseStartThread() throws IOException {
        InvokeDynamicSupport.bootstrap("parseStartThread", $$robo$$dalvik_system_profiler_BinaryHprofReader$parseStartThread(), 0, this);
    }

    private void parseEndThread() throws IOException {
        InvokeDynamicSupport.bootstrap("parseEndThread", $$robo$$dalvik_system_profiler_BinaryHprofReader$parseEndThread(), 0, this);
    }

    private void parseStackFrame() throws IOException {
        InvokeDynamicSupport.bootstrap("parseStackFrame", $$robo$$dalvik_system_profiler_BinaryHprofReader$parseStackFrame(), 0, this);
    }

    private void parseStackTrace(int n) throws IOException {
        InvokeDynamicSupport.bootstrap("parseStackTrace", $$robo$$dalvik_system_profiler_BinaryHprofReader$parseStackTrace(int ), 0, this, n);
    }

    private void parseCpuSamples(int n) throws IOException {
        InvokeDynamicSupport.bootstrap("parseCpuSamples", $$robo$$dalvik_system_profiler_BinaryHprofReader$parseCpuSamples(int ), 0, this, n);
    }

    public /* synthetic */ BinaryHprofReader() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BinaryHprofReader)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class 1
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        static /* synthetic */ int[] $SwitchMap$dalvik$system$profiler$BinaryHprof$Tag;

        static void __staticInitializer__() {
            $SwitchMap$dalvik$system$profiler$BinaryHprof$Tag = new int[BinaryHprof.Tag.values().length];
            try {
                1.$SwitchMap$dalvik$system$profiler$BinaryHprof$Tag[BinaryHprof.Tag.CONTROL_SETTINGS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$dalvik$system$profiler$BinaryHprof$Tag[BinaryHprof.Tag.STRING_IN_UTF8.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$dalvik$system$profiler$BinaryHprof$Tag[BinaryHprof.Tag.START_THREAD.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$dalvik$system$profiler$BinaryHprof$Tag[BinaryHprof.Tag.END_THREAD.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$dalvik$system$profiler$BinaryHprof$Tag[BinaryHprof.Tag.LOAD_CLASS.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$dalvik$system$profiler$BinaryHprof$Tag[BinaryHprof.Tag.STACK_FRAME.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$dalvik$system$profiler$BinaryHprof$Tag[BinaryHprof.Tag.STACK_TRACE.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$dalvik$system$profiler$BinaryHprof$Tag[BinaryHprof.Tag.CPU_SAMPLES.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$dalvik$system$profiler$BinaryHprof$Tag[BinaryHprof.Tag.UNLOAD_CLASS.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$dalvik$system$profiler$BinaryHprof$Tag[BinaryHprof.Tag.ALLOC_SITES.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$dalvik$system$profiler$BinaryHprof$Tag[BinaryHprof.Tag.HEAP_SUMMARY.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$dalvik$system$profiler$BinaryHprof$Tag[BinaryHprof.Tag.HEAP_DUMP.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$dalvik$system$profiler$BinaryHprof$Tag[BinaryHprof.Tag.HEAP_DUMP_SEGMENT.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$dalvik$system$profiler$BinaryHprof$Tag[BinaryHprof.Tag.HEAP_DUMP_END.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }

        static {
            RobolectricInternals.classInitializing(1.class);
        }

        public /* synthetic */ 1() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (1)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

