/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.InternalErrorHandler;
import gov.nist.javax.sip.header.CSeq;
import gov.nist.javax.sip.header.CallID;
import gov.nist.javax.sip.header.From;
import gov.nist.javax.sip.header.RequestLine;
import gov.nist.javax.sip.header.RetryAfter;
import gov.nist.javax.sip.header.StatusLine;
import gov.nist.javax.sip.header.To;
import gov.nist.javax.sip.header.Via;
import gov.nist.javax.sip.header.ViaList;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import gov.nist.javax.sip.parser.Pipeline;
import gov.nist.javax.sip.parser.PipelinedMsgParser;
import gov.nist.javax.sip.parser.SIPMessageListener;
import gov.nist.javax.sip.stack.HandshakeCompletedListenerImpl;
import gov.nist.javax.sip.stack.IOHandler;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.RawMessageChannel;
import gov.nist.javax.sip.stack.SIPClientTransaction;
import gov.nist.javax.sip.stack.SIPServerTransaction;
import gov.nist.javax.sip.stack.SIPTransaction;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import gov.nist.javax.sip.stack.ServerRequestInterface;
import gov.nist.javax.sip.stack.ServerResponseInterface;
import gov.nist.javax.sip.stack.TLSMessageProcessor;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.text.ParseException;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLSocket;
import javax.sip.address.Hop;

public final class TLSMessageChannel
extends MessageChannel
implements SIPMessageListener,
Runnable,
RawMessageChannel {
    private Socket mySock;
    private PipelinedMsgParser myParser;
    private InputStream myClientInputStream;
    private String key;
    protected boolean isCached;
    protected boolean isRunning;
    private Thread mythread;
    private String myAddress;
    private int myPort;
    private InetAddress peerAddress;
    private int peerPort;
    private String peerProtocol;
    private TLSMessageProcessor tlsMessageProcessor;
    private SIPTransactionStack sipStack;
    private HandshakeCompletedListener handshakeCompletedListener;

    protected TLSMessageChannel(Socket sock, SIPTransactionStack sipStack, TLSMessageProcessor msgProcessor) throws IOException {
        if (sipStack.isLoggingEnabled()) {
            sipStack.getStackLogger().logDebug("creating new TLSMessageChannel (incoming)");
            sipStack.getStackLogger().logStackTrace();
        }
        this.mySock = (SSLSocket)sock;
        if (sock instanceof SSLSocket) {
            SSLSocket sslSock = (SSLSocket)sock;
            sslSock.setNeedClientAuth(true);
            this.handshakeCompletedListener = new HandshakeCompletedListenerImpl(this);
            sslSock.addHandshakeCompletedListener(this.handshakeCompletedListener);
            sslSock.startHandshake();
        }
        this.peerAddress = this.mySock.getInetAddress();
        this.myAddress = msgProcessor.getIpAddress().getHostAddress();
        this.myClientInputStream = this.mySock.getInputStream();
        this.mythread = new Thread(this);
        this.mythread.setDaemon(true);
        this.mythread.setName("TLSMessageChannelThread");
        this.sipStack = sipStack;
        this.tlsMessageProcessor = msgProcessor;
        this.myPort = this.tlsMessageProcessor.getPort();
        this.peerPort = this.mySock.getPort();
        this.messageProcessor = msgProcessor;
        this.mythread.start();
    }

    protected TLSMessageChannel(InetAddress inetAddr, int port, SIPTransactionStack sipStack, TLSMessageProcessor messageProcessor) throws IOException {
        if (sipStack.isLoggingEnabled()) {
            sipStack.getStackLogger().logDebug("creating new TLSMessageChannel (outgoing)");
            sipStack.getStackLogger().logStackTrace();
        }
        this.peerAddress = inetAddr;
        this.peerPort = port;
        this.myPort = messageProcessor.getPort();
        this.peerProtocol = "TLS";
        this.sipStack = sipStack;
        this.tlsMessageProcessor = messageProcessor;
        this.myAddress = messageProcessor.getIpAddress().getHostAddress();
        this.key = MessageChannel.getKey(this.peerAddress, this.peerPort, "TLS");
        this.messageProcessor = messageProcessor;
    }

    @Override
    public boolean isReliable() {
        return true;
    }

    @Override
    public void close() {
        block4: {
            try {
                if (this.mySock != null) {
                    this.mySock.close();
                }
                if (this.sipStack.isLoggingEnabled()) {
                    this.sipStack.getStackLogger().logDebug("Closing message Channel " + this);
                }
            }
            catch (IOException ex) {
                if (!this.sipStack.isLoggingEnabled()) break block4;
                this.sipStack.getStackLogger().logDebug("Error closing socket " + ex);
            }
        }
    }

    @Override
    public SIPTransactionStack getSIPStack() {
        return this.sipStack;
    }

    @Override
    public String getTransport() {
        return "tls";
    }

    @Override
    public String getPeerAddress() {
        if (this.peerAddress != null) {
            return this.peerAddress.getHostAddress();
        }
        return this.getHost();
    }

    @Override
    protected InetAddress getPeerInetAddress() {
        return this.peerAddress;
    }

    @Override
    public String getPeerProtocol() {
        return this.peerProtocol;
    }

    private void sendMessage(byte[] msg, boolean retry) throws IOException {
        Socket sock = this.sipStack.ioHandler.sendBytes(this.getMessageProcessor().getIpAddress(), this.peerAddress, this.peerPort, this.peerProtocol, msg, retry, this);
        if (sock != this.mySock && sock != null) {
            try {
                if (this.mySock != null) {
                    this.mySock.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.mySock = sock;
            this.myClientInputStream = this.mySock.getInputStream();
            Thread thread = new Thread(this);
            thread.setDaemon(true);
            thread.setName("TLSMessageChannelThread");
            thread.start();
        }
    }

    @Override
    public void sendMessage(SIPMessage sipMessage) throws IOException {
        byte[] msg = sipMessage.encodeAsBytes(this.getTransport());
        long time = System.currentTimeMillis();
        this.sendMessage(msg, sipMessage instanceof SIPRequest);
        if (this.sipStack.getStackLogger().isLoggingEnabled(16)) {
            this.logMessage(sipMessage, this.peerAddress, this.peerPort, time);
        }
    }

    @Override
    public void sendMessage(byte[] message, InetAddress receiverAddress, int receiverPort, boolean retry) throws IOException {
        if (message == null || receiverAddress == null) {
            throw new IllegalArgumentException("Null argument");
        }
        Socket sock = this.sipStack.ioHandler.sendBytes(this.messageProcessor.getIpAddress(), receiverAddress, receiverPort, "TLS", message, retry, this);
        if (sock != this.mySock && sock != null) {
            try {
                if (this.mySock != null) {
                    this.mySock.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.mySock = sock;
            this.myClientInputStream = this.mySock.getInputStream();
            Thread mythread = new Thread(this);
            mythread.setDaemon(true);
            mythread.setName("TLSMessageChannelThread");
            mythread.start();
        }
    }

    @Override
    public void handleException(ParseException ex, SIPMessage sipMessage, Class hdrClass, String header, String message) throws ParseException {
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.getStackLogger().logException(ex);
        }
        if (hdrClass != null && (hdrClass.equals(From.class) || hdrClass.equals(To.class) || hdrClass.equals(CSeq.class) || hdrClass.equals(Via.class) || hdrClass.equals(CallID.class) || hdrClass.equals(RequestLine.class) || hdrClass.equals(StatusLine.class))) {
            String msgString;
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.getStackLogger().logDebug("Encountered bad message \n" + message);
            }
            if (!(msgString = sipMessage.toString()).startsWith("SIP/") && !msgString.startsWith("ACK ")) {
                String badReqRes = this.createBadReqRes(msgString, ex);
                if (badReqRes != null) {
                    if (this.sipStack.isLoggingEnabled()) {
                        this.sipStack.getStackLogger().logDebug("Sending automatic 400 Bad Request:");
                        this.sipStack.getStackLogger().logDebug(badReqRes);
                    }
                    try {
                        this.sendMessage(badReqRes.getBytes(), this.getPeerInetAddress(), this.getPeerPort(), false);
                    }
                    catch (IOException e) {
                        this.sipStack.getStackLogger().logException(e);
                    }
                } else if (this.sipStack.isLoggingEnabled()) {
                    this.sipStack.getStackLogger().logDebug("Could not formulate automatic 400 Bad Request");
                }
            }
            throw ex;
        }
        sipMessage.addUnparsed(header);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processMessage(SIPMessage sipMessage) throws Exception {
        block34: {
            if (sipMessage.getFrom() == null || sipMessage.getTo() == null || sipMessage.getCallId() == null || sipMessage.getCSeq() == null || sipMessage.getViaHeaders() == null) {
                String badmsg = sipMessage.encode();
                if (this.sipStack.isLoggingEnabled()) {
                    this.sipStack.getStackLogger().logError("bad message " + badmsg);
                    this.sipStack.getStackLogger().logError(">>> Dropped Bad Msg");
                }
                return;
            }
            ViaList viaList = sipMessage.getViaHeaders();
            if (sipMessage instanceof SIPRequest) {
                Via v = (Via)viaList.getFirst();
                Hop hop = this.sipStack.addressResolver.resolveAddress(v.getHop());
                this.peerProtocol = v.getTransport();
                try {
                    this.peerAddress = this.mySock.getInetAddress();
                    if (v.hasParameter("rport") || !hop.getHost().equals(this.peerAddress.getHostAddress())) {
                        v.setParameter("received", this.peerAddress.getHostAddress());
                    }
                    v.setParameter("rport", Integer.toString(this.peerPort));
                }
                catch (ParseException ex) {
                    InternalErrorHandler.handleException(ex);
                }
                if (!this.isCached) {
                    ((TLSMessageProcessor)this.messageProcessor).cacheMessageChannel(this);
                    this.isCached = true;
                    String key = IOHandler.makeKey(this.mySock.getInetAddress(), this.peerPort);
                    this.sipStack.ioHandler.putSocket(key, this.mySock);
                }
            }
            long receptionTime = System.currentTimeMillis();
            if (sipMessage instanceof SIPRequest) {
                SIPRequest sipRequest = (SIPRequest)sipMessage;
                if (this.sipStack.isLoggingEnabled()) {
                    this.sipStack.getStackLogger().logDebug("----Processing Message---");
                }
                if (this.sipStack.getStackLogger().isLoggingEnabled(16)) {
                    this.sipStack.serverLogger.logMessage(sipMessage, this.getPeerHostPort().toString(), this.messageProcessor.getIpAddress().getHostAddress() + ":" + this.messageProcessor.getPort(), false, receptionTime);
                }
                if (this.sipStack.getMaxMessageSize() > 0 && sipRequest.getSize() + (sipRequest.getContentLength() == null ? 0 : sipRequest.getContentLength().getContentLength()) > this.sipStack.getMaxMessageSize()) {
                    SIPResponse sipResponse = sipRequest.createResponse(513);
                    byte[] resp = sipResponse.encodeAsBytes(this.getTransport());
                    this.sendMessage(resp, false);
                    throw new Exception("Message size exceeded");
                }
                ServerRequestInterface sipServerRequest = this.sipStack.newSIPServerRequest(sipRequest, this);
                if (sipServerRequest != null) {
                    try {
                        sipServerRequest.processRequest(sipRequest, this);
                        break block34;
                    }
                    finally {
                        SIPServerTransaction sipServerTx;
                        if (sipServerRequest instanceof SIPTransaction && !(sipServerTx = (SIPServerTransaction)sipServerRequest).passToListener()) {
                            ((SIPTransaction)((Object)sipServerRequest)).releaseSem();
                        }
                    }
                }
                SIPResponse response = sipRequest.createResponse(503);
                RetryAfter retryAfter = new RetryAfter();
                try {
                    retryAfter.setRetryAfter((int)(10.0 * Math.random()));
                    response.setHeader(retryAfter);
                    this.sendMessage(response);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.sipStack.isLoggingEnabled()) {
                    this.sipStack.getStackLogger().logWarning("Dropping message -- could not acquire semaphore");
                }
                break block34;
            }
            SIPResponse sipResponse = (SIPResponse)sipMessage;
            try {
                sipResponse.checkHeaders();
            }
            catch (ParseException ex) {
                if (this.sipStack.isLoggingEnabled()) {
                    this.sipStack.getStackLogger().logError("Dropping Badly formatted response message >>> " + sipResponse);
                }
                return;
            }
            if (this.sipStack.getMaxMessageSize() > 0 && sipResponse.getSize() + (sipResponse.getContentLength() == null ? 0 : sipResponse.getContentLength().getContentLength()) > this.sipStack.getMaxMessageSize()) {
                if (this.sipStack.isLoggingEnabled()) {
                    this.sipStack.getStackLogger().logDebug("Message size exceeded");
                }
                return;
            }
            ServerResponseInterface sipServerResponse = this.sipStack.newSIPServerResponse(sipResponse, this);
            if (sipServerResponse != null) {
                try {
                    if (sipServerResponse instanceof SIPClientTransaction && !((SIPClientTransaction)sipServerResponse).checkFromTag(sipResponse)) {
                        if (this.sipStack.isLoggingEnabled()) {
                            this.sipStack.getStackLogger().logError("Dropping response message with invalid tag >>> " + sipResponse);
                        }
                        return;
                    }
                    sipServerResponse.processResponse(sipResponse, this);
                    break block34;
                }
                finally {
                    if (sipServerResponse instanceof SIPTransaction && !((SIPTransaction)((Object)sipServerResponse)).passToListener()) {
                        ((SIPTransaction)((Object)sipServerResponse)).releaseSem();
                    }
                }
            }
            this.sipStack.getStackLogger().logWarning("Could not get semaphore... dropping response");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        hispipe = null;
        hispipe = new Pipeline(this.myClientInputStream, this.sipStack.readTimeout, this.sipStack.getTimer());
        this.myParser = new PipelinedMsgParser(this, hispipe, this.sipStack.getMaxMessageSize());
        this.myParser.processInput();
        bufferSize = 4096;
        ++this.tlsMessageProcessor.useCount;
        this.isRunning = true;
        while (true) lbl-1000:
        // 3 sources

        {
            if ((nbytes = this.myClientInputStream.read(msg = new byte[bufferSize], 0, bufferSize)) == -1) {
                hispipe.write("\r\n\r\n".getBytes("UTF-8"));
                try {
                    if (this.sipStack.maxConnections != -1) {
                        var5_11 = this.tlsMessageProcessor;
                        synchronized (var5_11) {
                            --this.tlsMessageProcessor.nConnections;
                            this.tlsMessageProcessor.notify();
                        }
                    }
                    hispipe.close();
                    this.mySock.close();
                }
                catch (IOException var5_12) {
                    // empty catch block
                }
                return;
            }
            try {
                hispipe.write(msg, 0, nbytes);
            }
            catch (IOException ex) {
                try {
                    hispipe.write("\r\n\r\n".getBytes("UTF-8"));
                }
                catch (Exception var4_7) {
                    // empty catch block
                }
                try {
                    if (this.sipStack.isLoggingEnabled()) {
                        this.sipStack.getStackLogger().logDebug("IOException  closing sock " + ex);
                    }
                    try {
                        if (this.sipStack.maxConnections != -1) {
                            var4_8 = this.tlsMessageProcessor;
                            synchronized (var4_8) {
                                --this.tlsMessageProcessor.nConnections;
                                this.tlsMessageProcessor.notify();
                            }
                        }
                        this.mySock.close();
                        hispipe.close();
                    }
                    catch (IOException var4_9) {
                    }
                }
                catch (Exception var4_10) {
                    // empty catch block
                }
                return;
            }
            catch (Exception ex) {
                InternalErrorHandler.handleException(ex);
                continue;
            }
            break;
        }
        ** GOTO lbl-1000
        finally {
            this.isRunning = false;
            this.tlsMessageProcessor.remove(this);
            --this.tlsMessageProcessor.useCount;
            this.myParser.close();
        }
    }

    @Override
    protected void uncache() {
        if (this.isCached && !this.isRunning) {
            this.tlsMessageProcessor.remove(this);
        }
    }

    public boolean equals(Object other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        TLSMessageChannel that = (TLSMessageChannel)other;
        return this.mySock == that.mySock;
    }

    @Override
    public String getKey() {
        if (this.key != null) {
            return this.key;
        }
        this.key = MessageChannel.getKey(this.peerAddress, this.peerPort, "TLS");
        return this.key;
    }

    @Override
    public String getViaHost() {
        return this.myAddress;
    }

    @Override
    public int getViaPort() {
        return this.myPort;
    }

    @Override
    public int getPeerPort() {
        return this.peerPort;
    }

    @Override
    public int getPeerPacketSourcePort() {
        return this.peerPort;
    }

    @Override
    public InetAddress getPeerPacketSourceAddress() {
        return this.peerAddress;
    }

    @Override
    public boolean isSecure() {
        return true;
    }

    public void setHandshakeCompletedListener(HandshakeCompletedListener handshakeCompletedListenerImpl) {
        this.handshakeCompletedListener = handshakeCompletedListenerImpl;
    }

    public HandshakeCompletedListenerImpl getHandshakeCompletedListener() {
        return (HandshakeCompletedListenerImpl)this.handshakeCompletedListener;
    }
}

