/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import libcore.io.Streams;

public abstract class InputStream
implements Closeable {
    public int available() throws IOException {
        return 0;
    }

    @Override
    public void close() throws IOException {
    }

    public void mark(int readlimit) {
    }

    public boolean markSupported() {
        return false;
    }

    public abstract int read() throws IOException;

    public int read(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    public int read(byte[] buffer, int byteOffset, int byteCount) throws IOException {
        Arrays.checkOffsetAndCount(buffer.length, byteOffset, byteCount);
        for (int i = 0; i < byteCount; ++i) {
            int c;
            try {
                c = this.read();
                if (c == -1) {
                    return i == 0 ? -1 : i;
                }
            }
            catch (IOException e) {
                if (i != 0) {
                    return i;
                }
                throw e;
            }
            buffer[byteOffset + i] = (byte)c;
        }
        return byteCount;
    }

    public synchronized void reset() throws IOException {
        throw new IOException();
    }

    public long skip(long byteCount) throws IOException {
        return Streams.skipByReading(this, byteCount);
    }
}

