/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.Arrays;

public class OutputStreamWriter
extends Writer {
    private final OutputStream out;
    private CharsetEncoder encoder;
    private ByteBuffer bytes = ByteBuffer.allocate(8192);

    public OutputStreamWriter(OutputStream out) {
        this(out, Charset.defaultCharset());
    }

    public OutputStreamWriter(OutputStream out, String charsetName) throws UnsupportedEncodingException {
        super(out);
        if (charsetName == null) {
            throw new NullPointerException("charsetName == null");
        }
        this.out = out;
        try {
            this.encoder = Charset.forName(charsetName).newEncoder();
        }
        catch (Exception e) {
            throw new UnsupportedEncodingException(charsetName);
        }
        this.encoder.onMalformedInput(CodingErrorAction.REPLACE);
        this.encoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
    }

    public OutputStreamWriter(OutputStream out, Charset cs) {
        super(out);
        this.out = out;
        this.encoder = cs.newEncoder();
        this.encoder.onMalformedInput(CodingErrorAction.REPLACE);
        this.encoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
    }

    public OutputStreamWriter(OutputStream out, CharsetEncoder charsetEncoder) {
        super(out);
        charsetEncoder.charset();
        this.out = out;
        this.encoder = charsetEncoder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.encoder != null) {
                this.drainEncoder();
                this.flushBytes(false);
                this.out.close();
                this.encoder = null;
                this.bytes = null;
            }
        }
    }

    @Override
    public void flush() throws IOException {
        this.flushBytes(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushBytes(boolean flushUnderlyingStream) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.checkStatus();
            int position = this.bytes.position();
            if (position > 0) {
                this.bytes.flip();
                this.out.write(this.bytes.array(), this.bytes.arrayOffset(), position);
                this.bytes.clear();
            }
            if (flushUnderlyingStream) {
                this.out.flush();
            }
        }
    }

    private void convert(CharBuffer chars) throws IOException {
        block1: {
            CoderResult result;
            while ((result = this.encoder.encode(chars, this.bytes, false)).isOverflow()) {
                this.flushBytes(false);
            }
            if (!result.isError()) break block1;
            result.throwException();
        }
    }

    private void drainEncoder() throws IOException {
        CoderResult result;
        CharBuffer chars = CharBuffer.allocate(0);
        while (true) {
            if ((result = this.encoder.encode(chars, this.bytes, true)).isError()) {
                result.throwException();
                break;
            }
            if (!result.isOverflow()) break;
            this.flushBytes(false);
        }
        result = this.encoder.flush(this.bytes);
        while (!result.isUnderflow()) {
            if (result.isOverflow()) {
                this.flushBytes(false);
                result = this.encoder.flush(this.bytes);
                continue;
            }
            result.throwException();
        }
    }

    private void checkStatus() throws IOException {
        if (this.encoder == null) {
            throw new IOException("OutputStreamWriter is closed");
        }
    }

    public String getEncoding() {
        if (this.encoder == null) {
            return null;
        }
        return this.encoder.charset().name();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(char[] buffer, int offset, int count) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.checkStatus();
            Arrays.checkOffsetAndCount(buffer.length, offset, count);
            CharBuffer chars = CharBuffer.wrap(buffer, offset, count);
            this.convert(chars);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int oneChar) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.checkStatus();
            CharBuffer chars = CharBuffer.wrap(new char[]{(char)oneChar});
            this.convert(chars);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(String str, int offset, int count) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (count < 0) {
                throw new StringIndexOutOfBoundsException(str, offset, count);
            }
            if (str == null) {
                throw new NullPointerException("str == null");
            }
            if ((offset | count) < 0 || offset > str.length() - count) {
                throw new StringIndexOutOfBoundsException(str, offset, count);
            }
            this.checkStatus();
            CharBuffer chars = CharBuffer.wrap(str, offset, count + offset);
            this.convert(chars);
        }
    }

    @Override
    boolean checkError() {
        return this.out.checkError();
    }
}

