/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.PipedOutputStream;
import java.util.Arrays;
import libcore.io.IoUtils;

public class PipedInputStream
extends InputStream {
    private Thread lastReader;
    private Thread lastWriter;
    private boolean isClosed;
    protected byte[] buffer;
    protected int in = -1;
    protected int out;
    protected static final int PIPE_SIZE = 1024;
    boolean isConnected;

    public PipedInputStream() {
    }

    public PipedInputStream(PipedOutputStream out) throws IOException {
        this.connect(out);
    }

    public PipedInputStream(int pipeSize) {
        if (pipeSize <= 0) {
            throw new IllegalArgumentException("pipe size " + pipeSize + " too small");
        }
        this.buffer = new byte[pipeSize];
    }

    public PipedInputStream(PipedOutputStream out, int pipeSize) throws IOException {
        this(pipeSize);
        this.connect(out);
    }

    @Override
    public synchronized int available() throws IOException {
        if (this.buffer == null || this.in == -1) {
            return 0;
        }
        return this.in <= this.out ? this.buffer.length - this.out + this.in : this.in - this.out;
    }

    @Override
    public synchronized void close() throws IOException {
        this.buffer = null;
        this.notifyAll();
    }

    public void connect(PipedOutputStream src) throws IOException {
        src.connect(this);
    }

    synchronized void establishConnection() throws IOException {
        if (this.isConnected) {
            throw new IOException("Pipe already connected");
        }
        if (this.buffer == null) {
            this.buffer = new byte[1024];
        }
        this.isConnected = true;
    }

    @Override
    public synchronized int read() throws IOException {
        if (!this.isConnected) {
            throw new IOException("Not connected");
        }
        if (this.buffer == null) {
            throw new IOException("InputStream is closed");
        }
        this.lastReader = Thread.currentThread();
        try {
            int attempts = 3;
            while (this.in == -1) {
                if (this.isClosed) {
                    return -1;
                }
                if (attempts-- <= 0 && this.lastWriter != null && !this.lastWriter.isAlive()) {
                    throw new IOException("Pipe broken");
                }
                this.notifyAll();
                this.wait(1000L);
            }
        }
        catch (InterruptedException e) {
            IoUtils.throwInterruptedIoException();
        }
        int result = this.buffer[this.out++] & 0xFF;
        if (this.out == this.buffer.length) {
            this.out = 0;
        }
        if (this.out == this.in) {
            this.in = -1;
            this.out = 0;
        }
        this.notifyAll();
        return result;
    }

    @Override
    public synchronized int read(byte[] bytes, int byteOffset, int byteCount) throws IOException {
        int leftInBuffer;
        Arrays.checkOffsetAndCount(bytes.length, byteOffset, byteCount);
        if (byteCount == 0) {
            return 0;
        }
        if (!this.isConnected) {
            throw new IOException("Not connected");
        }
        if (this.buffer == null) {
            throw new IOException("InputStream is closed");
        }
        this.lastReader = Thread.currentThread();
        try {
            int attempts = 3;
            while (this.in == -1) {
                if (this.isClosed) {
                    return -1;
                }
                if (attempts-- <= 0 && this.lastWriter != null && !this.lastWriter.isAlive()) {
                    throw new IOException("Pipe broken");
                }
                this.notifyAll();
                this.wait(1000L);
            }
        }
        catch (InterruptedException e) {
            IoUtils.throwInterruptedIoException();
        }
        int totalCopied = 0;
        if (this.out >= this.in) {
            leftInBuffer = this.buffer.length - this.out;
            int length = leftInBuffer < byteCount ? leftInBuffer : byteCount;
            System.arraycopy((byte[])this.buffer, (int)this.out, (byte[])bytes, (int)byteOffset, (int)length);
            this.out += length;
            if (this.out == this.buffer.length) {
                this.out = 0;
            }
            if (this.out == this.in) {
                this.in = -1;
                this.out = 0;
            }
            totalCopied += length;
        }
        if (totalCopied < byteCount && this.in != -1) {
            int leftToCopy = byteCount - totalCopied;
            leftInBuffer = this.in - this.out;
            int length = leftToCopy < leftInBuffer ? leftToCopy : leftInBuffer;
            System.arraycopy((byte[])this.buffer, (int)this.out, (byte[])bytes, (int)(byteOffset + totalCopied), (int)length);
            this.out += length;
            if (this.out == this.in) {
                this.in = -1;
                this.out = 0;
            }
            totalCopied += length;
        }
        this.notifyAll();
        return totalCopied;
    }

    protected synchronized void receive(int oneByte) throws IOException {
        if (this.buffer == null || this.isClosed) {
            throw new IOException("Pipe is closed");
        }
        this.lastWriter = Thread.currentThread();
        try {
            while (this.buffer != null && this.out == this.in) {
                if (this.lastReader != null && !this.lastReader.isAlive()) {
                    throw new IOException("Pipe broken");
                }
                this.notifyAll();
                this.wait(1000L);
            }
        }
        catch (InterruptedException e) {
            IoUtils.throwInterruptedIoException();
        }
        if (this.buffer == null) {
            throw new IOException("Pipe is closed");
        }
        if (this.in == -1) {
            this.in = 0;
        }
        if (this.lastReader != null && !this.lastReader.isAlive()) {
            throw new IOException("Pipe broken");
        }
        this.buffer[this.in++] = (byte)oneByte;
        if (this.in == this.buffer.length) {
            this.in = 0;
        }
        this.notifyAll();
    }

    synchronized void done() {
        this.isClosed = true;
        this.notifyAll();
    }
}

