/*
 * Decompiled with CFR 0.152.
 */
package java.io;

final class SerializationHandleMap {
    private static final int LOAD_FACTOR = 7500;
    private Object[] keys;
    private int[] values;
    private int size = 0;
    private int threshold = 21;

    public SerializationHandleMap() {
        int arraySize = (int)((long)this.threshold * 10000L / 7500L);
        this.resizeArrays(arraySize);
    }

    private void resizeArrays(int newSize) {
        Object[] oldKeys = this.keys;
        int[] oldValues = this.values;
        this.keys = new Object[newSize];
        this.values = new int[newSize];
        if (oldKeys != null) {
            for (int i = 0; i < oldKeys.length; ++i) {
                Object key = oldKeys[i];
                int value = oldValues[i];
                int index = this.findIndex(key, this.keys);
                this.keys[index] = key;
                this.values[index] = value;
            }
        }
    }

    public int get(Object key) {
        int index = this.findIndex(key, this.keys);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        return -1;
    }

    private int findIndex(Object key, Object[] array2) {
        int length = array2.length;
        int index = this.getModuloHash(key, length);
        int last = (index + length - 1) % length;
        while (index != last && array2[index] != key && array2[index] != null) {
            index = (index + 1) % length;
        }
        return index;
    }

    private int getModuloHash(Object key, int length) {
        return (System.identityHashCode(key) & Integer.MAX_VALUE) % length;
    }

    public int put(Object key, int value) {
        Object _key = key;
        int _value = value;
        int index = this.findIndex(_key, this.keys);
        if (this.keys[index] != _key) {
            if (++this.size > this.threshold) {
                this.rehash();
                index = this.findIndex(_key, this.keys);
            }
            this.keys[index] = _key;
            this.values[index] = -1;
        }
        int result = this.values[index];
        this.values[index] = _value;
        return result;
    }

    private void rehash() {
        int newSize = this.keys.length * 2;
        this.resizeArrays(newSize);
        this.threshold = (int)((long)this.keys.length * 7500L / 10000L);
    }

    public int remove(Object key) {
        Object object;
        int next = this.findIndex(key, this.keys);
        int index = next;
        if (this.keys[index] != key) {
            return -1;
        }
        int result = this.values[index];
        int length = this.keys.length;
        while ((object = this.keys[next = (next + 2) % length]) != null) {
            boolean hashedOk;
            int hash = this.getModuloHash(object, length);
            boolean bl = hashedOk = hash > index;
            if (next < index) {
                hashedOk = hashedOk || hash <= next;
            } else {
                boolean bl2 = hashedOk = hashedOk && hash <= next;
            }
            if (hashedOk) continue;
            this.keys[index] = object;
            this.values[index] = this.values[next];
            index = next;
        }
        --this.size;
        this.keys[index] = null;
        this.values[index] = -1;
        return result;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }
}

