/*
 * Decompiled with CFR 0.152.
 */
package java.math;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigInt;
import java.math.BigInteger;
import java.math.Conversion;
import java.math.MathContext;
import java.math.Multiplication;
import java.math.RoundingMode;
import java.util.Arrays;
import libcore.math.MathUtils;

public class BigDecimal
extends Number
implements Comparable<BigDecimal>,
Serializable {
    public static final int ROUND_UP = 0;
    public static final int ROUND_DOWN = 1;
    public static final int ROUND_CEILING = 2;
    public static final int ROUND_FLOOR = 3;
    public static final int ROUND_HALF_UP = 4;
    public static final int ROUND_HALF_DOWN = 5;
    public static final int ROUND_HALF_EVEN = 6;
    public static final int ROUND_UNNECESSARY = 7;
    private static final long serialVersionUID = 6108874887143696463L;
    private static final double LOG10_2 = 0.3010299956639812;
    private transient String toStringImage = null;
    private transient int hashCode = 0;
    private static final BigInteger[] FIVE_POW;
    private static final BigInteger[] TEN_POW;
    private static final long[] LONG_FIVE_POW;
    private static final int[] LONG_FIVE_POW_BIT_LENGTH;
    private static final int[] LONG_POWERS_OF_TEN_BIT_LENGTH;
    private static final int BI_SCALED_BY_ZERO_LENGTH = 11;
    private static final BigDecimal[] BI_SCALED_BY_ZERO;
    private static final BigDecimal[] ZERO_SCALED_BY;
    private static final char[] CH_ZEROS;
    public static final BigDecimal ZERO;
    public static final BigDecimal ONE;
    public static final BigDecimal TEN;
    private BigInteger intVal;
    private transient int bitLength;
    private transient long smallValue;
    private int scale;
    private transient int precision = 0;

    private BigDecimal(long smallValue, int scale) {
        this.smallValue = smallValue;
        this.scale = scale;
        this.bitLength = BigDecimal.bitLength(smallValue);
    }

    private BigDecimal(int smallValue, int scale) {
        this.smallValue = smallValue;
        this.scale = scale;
        this.bitLength = BigDecimal.bitLength(smallValue);
    }

    public BigDecimal(char[] in, int offset, int len) {
        int begin = offset;
        int last = offset + (len - 1);
        if (in == null) {
            throw new NullPointerException("in == null");
        }
        if (last >= in.length || offset < 0 || len <= 0 || last < 0) {
            throw new NumberFormatException("Bad offset/length: offset=" + offset + " len=" + len + " in.length=" + in.length);
        }
        StringBuilder unscaledBuffer = new StringBuilder(len);
        int bufLength = 0;
        if (offset <= last && in[offset] == '+') {
            ++offset;
            ++begin;
        }
        int counter = 0;
        boolean wasNonZero = false;
        while (offset <= last && in[offset] != '.' && in[offset] != 'e' && in[offset] != 'E') {
            if (!wasNonZero) {
                if (in[offset] == '0') {
                    ++counter;
                } else {
                    wasNonZero = true;
                }
            }
            ++offset;
        }
        unscaledBuffer.append(in, begin, offset - begin);
        bufLength += offset - begin;
        if (offset <= last && in[offset] == '.') {
            begin = ++offset;
            while (offset <= last && in[offset] != 'e' && in[offset] != 'E') {
                if (!wasNonZero) {
                    if (in[offset] == '0') {
                        ++counter;
                    } else {
                        wasNonZero = true;
                    }
                }
                ++offset;
            }
            this.scale = offset - begin;
            bufLength += this.scale;
            unscaledBuffer.append(in, begin, this.scale);
        } else {
            this.scale = 0;
        }
        if (offset <= last && (in[offset] == 'e' || in[offset] == 'E')) {
            begin = ++offset;
            if (offset <= last && in[offset] == '+' && ++offset <= last && in[offset] != '-') {
                ++begin;
            }
            String scaleString = String.valueOf(in, begin, last + 1 - begin);
            long newScale = (long)this.scale - (long)Integer.parseInt(scaleString);
            this.scale = (int)newScale;
            if (newScale != (long)this.scale) {
                throw new NumberFormatException("Scale out of range");
            }
        }
        if (bufLength < 19) {
            this.smallValue = Long.parseLong(unscaledBuffer.toString());
            this.bitLength = BigDecimal.bitLength(this.smallValue);
        } else {
            this.setUnscaledValue(new BigInteger(unscaledBuffer.toString()));
        }
    }

    public BigDecimal(char[] in, int offset, int len, MathContext mc) {
        this(in, offset, len);
        this.inplaceRound(mc);
    }

    public BigDecimal(char[] in) {
        this(in, 0, in.length);
    }

    public BigDecimal(char[] in, MathContext mc) {
        this(in, 0, in.length);
        this.inplaceRound(mc);
    }

    public BigDecimal(String val) {
        this(val.toCharArray(), 0, val.length());
    }

    public BigDecimal(String val, MathContext mc) {
        this(val.toCharArray(), 0, val.length());
        this.inplaceRound(mc);
    }

    public BigDecimal(double val) {
        long mantissa;
        if (Double.isInfinite(val) || Double.isNaN(val)) {
            throw new NumberFormatException("Infinity or NaN: " + val);
        }
        long bits = Double.doubleToLongBits(val);
        this.scale = 1075 - (int)(bits >> 52 & 0x7FFL);
        long l = mantissa = this.scale == 1075 ? (bits & 0xFFFFFFFFFFFFFL) << 1 : bits & 0xFFFFFFFFFFFFFL | 0x10000000000000L;
        if (mantissa == 0L) {
            this.scale = 0;
            this.precision = 1;
        }
        if (this.scale > 0) {
            int trailingZeros = Math.min(this.scale, Long.numberOfTrailingZeros(mantissa));
            mantissa >>>= trailingZeros;
            this.scale -= trailingZeros;
        }
        if (bits >> 63 != 0L) {
            mantissa = -mantissa;
        }
        int mantissaBits = BigDecimal.bitLength(mantissa);
        if (this.scale < 0) {
            int n = this.bitLength = mantissaBits == 0 ? 0 : mantissaBits - this.scale;
            if (this.bitLength < 64) {
                this.smallValue = mantissa << -this.scale;
            } else {
                BigInt bi = new BigInt();
                bi.putLongInt(mantissa);
                bi.shift(-this.scale);
                this.intVal = new BigInteger(bi);
            }
            this.scale = 0;
        } else if (this.scale > 0) {
            if (this.scale < LONG_FIVE_POW.length && mantissaBits + LONG_FIVE_POW_BIT_LENGTH[this.scale] < 64) {
                this.smallValue = mantissa * LONG_FIVE_POW[this.scale];
                this.bitLength = BigDecimal.bitLength(this.smallValue);
            } else {
                this.setUnscaledValue(Multiplication.multiplyByFivePow(BigInteger.valueOf(mantissa), this.scale));
            }
        } else {
            this.smallValue = mantissa;
            this.bitLength = mantissaBits;
        }
    }

    public BigDecimal(double val, MathContext mc) {
        this(val);
        this.inplaceRound(mc);
    }

    public BigDecimal(BigInteger val) {
        this(val, 0);
    }

    public BigDecimal(BigInteger val, MathContext mc) {
        this(val);
        this.inplaceRound(mc);
    }

    public BigDecimal(BigInteger unscaledVal, int scale) {
        if (unscaledVal == null) {
            throw new NullPointerException("unscaledVal == null");
        }
        this.scale = scale;
        this.setUnscaledValue(unscaledVal);
    }

    public BigDecimal(BigInteger unscaledVal, int scale, MathContext mc) {
        this(unscaledVal, scale);
        this.inplaceRound(mc);
    }

    public BigDecimal(int val) {
        this(val, 0);
    }

    public BigDecimal(int val, MathContext mc) {
        this(val, 0);
        this.inplaceRound(mc);
    }

    public BigDecimal(long val) {
        this(val, 0);
    }

    public BigDecimal(long val, MathContext mc) {
        this(val);
        this.inplaceRound(mc);
    }

    public static BigDecimal valueOf(long unscaledVal, int scale) {
        if (scale == 0) {
            return BigDecimal.valueOf(unscaledVal);
        }
        if (unscaledVal == 0L && scale >= 0 && scale < ZERO_SCALED_BY.length) {
            return ZERO_SCALED_BY[scale];
        }
        return new BigDecimal(unscaledVal, scale);
    }

    public static BigDecimal valueOf(long unscaledVal) {
        if (unscaledVal >= 0L && unscaledVal < 11L) {
            return BI_SCALED_BY_ZERO[(int)unscaledVal];
        }
        return new BigDecimal(unscaledVal, 0);
    }

    public static BigDecimal valueOf(double val) {
        if (Double.isInfinite(val) || Double.isNaN(val)) {
            throw new NumberFormatException("Infinity or NaN: " + val);
        }
        return new BigDecimal(Double.toString(val));
    }

    public BigDecimal add(BigDecimal augend) {
        int diffScale = this.scale - augend.scale;
        if (this.isZero()) {
            if (diffScale <= 0) {
                return augend;
            }
            if (augend.isZero()) {
                return this;
            }
        } else if (augend.isZero() && diffScale >= 0) {
            return this;
        }
        if (diffScale == 0) {
            if (Math.max(this.bitLength, augend.bitLength) + 1 < 64) {
                return BigDecimal.valueOf(this.smallValue + augend.smallValue, this.scale);
            }
            return new BigDecimal(this.getUnscaledValue().add(augend.getUnscaledValue()), this.scale);
        }
        if (diffScale > 0) {
            return BigDecimal.addAndMult10(this, augend, diffScale);
        }
        return BigDecimal.addAndMult10(augend, this, -diffScale);
    }

    private static BigDecimal addAndMult10(BigDecimal thisValue, BigDecimal augend, int diffScale) {
        if (diffScale < MathUtils.LONG_POWERS_OF_TEN.length && Math.max(thisValue.bitLength, augend.bitLength + LONG_POWERS_OF_TEN_BIT_LENGTH[diffScale]) + 1 < 64) {
            return BigDecimal.valueOf(thisValue.smallValue + augend.smallValue * MathUtils.LONG_POWERS_OF_TEN[diffScale], thisValue.scale);
        }
        BigInt bi = Multiplication.multiplyByTenPow(augend.getUnscaledValue(), diffScale).getBigInt();
        bi.add(thisValue.getUnscaledValue().getBigInt());
        return new BigDecimal(new BigInteger(bi), thisValue.scale);
    }

    public BigDecimal add(BigDecimal augend, MathContext mc) {
        BigInteger tempBI;
        BigDecimal smaller;
        BigDecimal larger;
        long diffScale = (long)this.scale - (long)augend.scale;
        if (augend.isZero() || this.isZero() || mc.getPrecision() == 0) {
            return this.add(augend).round(mc);
        }
        if ((long)this.approxPrecision() < diffScale - 1L) {
            larger = augend;
            smaller = this;
        } else if ((long)augend.approxPrecision() < -diffScale - 1L) {
            larger = this;
            smaller = augend;
        } else {
            return this.add(augend).round(mc);
        }
        if (mc.getPrecision() >= larger.approxPrecision()) {
            return this.add(augend).round(mc);
        }
        int largerSignum = larger.signum();
        if (largerSignum == smaller.signum()) {
            tempBI = Multiplication.multiplyByPositiveInt(larger.getUnscaledValue(), 10).add(BigInteger.valueOf(largerSignum));
        } else {
            tempBI = larger.getUnscaledValue().subtract(BigInteger.valueOf(largerSignum));
            tempBI = Multiplication.multiplyByPositiveInt(tempBI, 10).add(BigInteger.valueOf(largerSignum * 9));
        }
        larger = new BigDecimal(tempBI, larger.scale + 1);
        return larger.round(mc);
    }

    public BigDecimal subtract(BigDecimal subtrahend) {
        int diffScale = this.scale - subtrahend.scale;
        if (this.isZero()) {
            if (diffScale <= 0) {
                return subtrahend.negate();
            }
            if (subtrahend.isZero()) {
                return this;
            }
        } else if (subtrahend.isZero() && diffScale >= 0) {
            return this;
        }
        if (diffScale == 0) {
            if (Math.max(this.bitLength, subtrahend.bitLength) + 1 < 64) {
                return BigDecimal.valueOf(this.smallValue - subtrahend.smallValue, this.scale);
            }
            return new BigDecimal(this.getUnscaledValue().subtract(subtrahend.getUnscaledValue()), this.scale);
        }
        if (diffScale > 0) {
            if (diffScale < MathUtils.LONG_POWERS_OF_TEN.length && Math.max(this.bitLength, subtrahend.bitLength + LONG_POWERS_OF_TEN_BIT_LENGTH[diffScale]) + 1 < 64) {
                return BigDecimal.valueOf(this.smallValue - subtrahend.smallValue * MathUtils.LONG_POWERS_OF_TEN[diffScale], this.scale);
            }
            return new BigDecimal(this.getUnscaledValue().subtract(Multiplication.multiplyByTenPow(subtrahend.getUnscaledValue(), diffScale)), this.scale);
        }
        if ((diffScale = -diffScale) < MathUtils.LONG_POWERS_OF_TEN.length && Math.max(this.bitLength + LONG_POWERS_OF_TEN_BIT_LENGTH[diffScale], subtrahend.bitLength) + 1 < 64) {
            return BigDecimal.valueOf(this.smallValue * MathUtils.LONG_POWERS_OF_TEN[diffScale] - subtrahend.smallValue, subtrahend.scale);
        }
        return new BigDecimal(Multiplication.multiplyByTenPow(this.getUnscaledValue(), diffScale).subtract(subtrahend.getUnscaledValue()), subtrahend.scale);
    }

    public BigDecimal subtract(BigDecimal subtrahend, MathContext mc) {
        long diffScale = (long)subtrahend.scale - (long)this.scale;
        if (subtrahend.isZero() || this.isZero() || mc.getPrecision() == 0) {
            return this.subtract(subtrahend).round(mc);
        }
        if ((long)subtrahend.approxPrecision() < diffScale - 1L && mc.getPrecision() < this.approxPrecision()) {
            BigInteger tempBI;
            int thisSignum = this.signum();
            if (thisSignum != subtrahend.signum()) {
                tempBI = Multiplication.multiplyByPositiveInt(this.getUnscaledValue(), 10).add(BigInteger.valueOf(thisSignum));
            } else {
                tempBI = this.getUnscaledValue().subtract(BigInteger.valueOf(thisSignum));
                tempBI = Multiplication.multiplyByPositiveInt(tempBI, 10).add(BigInteger.valueOf(thisSignum * 9));
            }
            BigDecimal leftOperand = new BigDecimal(tempBI, this.scale + 1);
            return leftOperand.round(mc);
        }
        return this.subtract(subtrahend).round(mc);
    }

    public BigDecimal multiply(BigDecimal multiplicand) {
        long newScale = (long)this.scale + (long)multiplicand.scale;
        if (this.isZero() || multiplicand.isZero()) {
            return BigDecimal.zeroScaledBy(newScale);
        }
        if (this.bitLength + multiplicand.bitLength < 64) {
            return BigDecimal.valueOf(this.smallValue * multiplicand.smallValue, BigDecimal.safeLongToInt(newScale));
        }
        return new BigDecimal(this.getUnscaledValue().multiply(multiplicand.getUnscaledValue()), BigDecimal.safeLongToInt(newScale));
    }

    public BigDecimal multiply(BigDecimal multiplicand, MathContext mc) {
        BigDecimal result = this.multiply(multiplicand);
        result.inplaceRound(mc);
        return result;
    }

    public BigDecimal divide(BigDecimal divisor, int scale, int roundingMode) {
        return this.divide(divisor, scale, RoundingMode.valueOf(roundingMode));
    }

    public BigDecimal divide(BigDecimal divisor, int scale, RoundingMode roundingMode) {
        if (roundingMode == null) {
            throw new NullPointerException("roundingMode == null");
        }
        if (divisor.isZero()) {
            throw new ArithmeticException("Division by zero");
        }
        long diffScale = (long)this.scale - (long)divisor.scale - (long)scale;
        if (BigDecimal.bitLength(diffScale) > 32) {
            throw new ArithmeticException("Unable to perform divisor / dividend scaling: the difference in scale is too big (" + diffScale + ")");
        }
        if (this.bitLength < 64 && divisor.bitLength < 64) {
            if (diffScale == 0L) {
                return BigDecimal.dividePrimitiveLongs(this.smallValue, divisor.smallValue, scale, roundingMode);
            }
            if (diffScale > 0L) {
                if (diffScale < (long)MathUtils.LONG_POWERS_OF_TEN.length && divisor.bitLength + LONG_POWERS_OF_TEN_BIT_LENGTH[(int)diffScale] < 64) {
                    return BigDecimal.dividePrimitiveLongs(this.smallValue, divisor.smallValue * MathUtils.LONG_POWERS_OF_TEN[(int)diffScale], scale, roundingMode);
                }
            } else if (-diffScale < (long)MathUtils.LONG_POWERS_OF_TEN.length && this.bitLength + LONG_POWERS_OF_TEN_BIT_LENGTH[(int)(-diffScale)] < 64) {
                return BigDecimal.dividePrimitiveLongs(this.smallValue * MathUtils.LONG_POWERS_OF_TEN[(int)(-diffScale)], divisor.smallValue, scale, roundingMode);
            }
        }
        BigInteger scaledDividend = this.getUnscaledValue();
        BigInteger scaledDivisor = divisor.getUnscaledValue();
        if (diffScale > 0L) {
            scaledDivisor = Multiplication.multiplyByTenPow(scaledDivisor, (int)diffScale);
        } else if (diffScale < 0L) {
            scaledDividend = Multiplication.multiplyByTenPow(scaledDividend, (int)(-diffScale));
        }
        return BigDecimal.divideBigIntegers(scaledDividend, scaledDivisor, scale, roundingMode);
    }

    private static BigDecimal divideBigIntegers(BigInteger scaledDividend, BigInteger scaledDivisor, int scale, RoundingMode roundingMode) {
        int compRem;
        BigInteger[] quotAndRem = scaledDividend.divideAndRemainder(scaledDivisor);
        BigInteger quotient = quotAndRem[0];
        BigInteger remainder = quotAndRem[1];
        if (remainder.signum() == 0) {
            return new BigDecimal(quotient, scale);
        }
        int sign = scaledDividend.signum() * scaledDivisor.signum();
        if (scaledDivisor.bitLength() < 63) {
            long rem = remainder.longValue();
            long divisor = scaledDivisor.longValue();
            compRem = BigDecimal.longCompareTo(Math.abs(rem) * 2L, Math.abs(divisor));
            compRem = BigDecimal.roundingBehavior(quotient.testBit(0) ? 1 : 0, sign * (5 + compRem), roundingMode);
        } else {
            compRem = remainder.abs().shiftLeftOneBit().compareTo(scaledDivisor.abs());
            compRem = BigDecimal.roundingBehavior(quotient.testBit(0) ? 1 : 0, sign * (5 + compRem), roundingMode);
        }
        if (compRem != 0) {
            if (quotient.bitLength() < 63) {
                return BigDecimal.valueOf(quotient.longValue() + (long)compRem, scale);
            }
            quotient = quotient.add(BigInteger.valueOf(compRem));
            return new BigDecimal(quotient, scale);
        }
        return new BigDecimal(quotient, scale);
    }

    private static BigDecimal dividePrimitiveLongs(long scaledDividend, long scaledDivisor, int scale, RoundingMode roundingMode) {
        long quotient = scaledDividend / scaledDivisor;
        long remainder = scaledDividend % scaledDivisor;
        int sign = Long.signum(scaledDividend) * Long.signum(scaledDivisor);
        if (remainder != 0L) {
            int compRem = BigDecimal.longCompareTo(Math.abs(remainder) * 2L, Math.abs(scaledDivisor));
            quotient += (long)BigDecimal.roundingBehavior((int)quotient & 1, sign * (5 + compRem), roundingMode);
        }
        return BigDecimal.valueOf(quotient, scale);
    }

    public BigDecimal divide(BigDecimal divisor, int roundingMode) {
        return this.divide(divisor, this.scale, RoundingMode.valueOf(roundingMode));
    }

    public BigDecimal divide(BigDecimal divisor, RoundingMode roundingMode) {
        return this.divide(divisor, this.scale, roundingMode);
    }

    public BigDecimal divide(BigDecimal divisor) {
        BigInteger p = this.getUnscaledValue();
        BigInteger q = divisor.getUnscaledValue();
        long diffScale = (long)this.scale - (long)divisor.scale;
        int l = 0;
        int i = 1;
        int lastPow = FIVE_POW.length - 1;
        if (divisor.isZero()) {
            throw new ArithmeticException("Division by zero");
        }
        if (p.signum() == 0) {
            return BigDecimal.zeroScaledBy(diffScale);
        }
        BigInteger gcd = p.gcd(q);
        p = p.divide(gcd);
        q = q.divide(gcd);
        int k = q.getLowestSetBit();
        q = q.shiftRight(k);
        while (true) {
            BigInteger[] quotAndRem;
            if ((quotAndRem = q.divideAndRemainder(FIVE_POW[i]))[1].signum() == 0) {
                l += i;
                if (i < lastPow) {
                    ++i;
                }
                q = quotAndRem[0];
                continue;
            }
            if (i == 1) break;
            i = 1;
        }
        if (!q.abs().equals(BigInteger.ONE)) {
            throw new ArithmeticException("Non-terminating decimal expansion; no exact representable decimal result");
        }
        if (q.signum() < 0) {
            p = p.negate();
        }
        int newScale = BigDecimal.safeLongToInt(diffScale + (long)Math.max(k, l));
        i = k - l;
        p = i > 0 ? Multiplication.multiplyByFivePow(p, i) : p.shiftLeft(-i);
        return new BigDecimal(p, newScale);
    }

    public BigDecimal divide(BigDecimal divisor, MathContext mc) {
        long diffScale;
        long trailingZeros = (long)mc.getPrecision() + 2L + (long)divisor.approxPrecision() - (long)this.approxPrecision();
        long newScale = diffScale = (long)this.scale - (long)divisor.scale;
        int i = 1;
        int lastPow = TEN_POW.length - 1;
        BigInteger[] quotAndRem = new BigInteger[]{this.getUnscaledValue()};
        if (mc.getPrecision() == 0 || this.isZero() || divisor.isZero()) {
            return this.divide(divisor);
        }
        if (trailingZeros > 0L) {
            quotAndRem[0] = this.getUnscaledValue().multiply(Multiplication.powerOf10(trailingZeros));
            newScale += trailingZeros;
        }
        quotAndRem = quotAndRem[0].divideAndRemainder(divisor.getUnscaledValue());
        BigInteger integerQuot = quotAndRem[0];
        if (quotAndRem[1].signum() != 0) {
            int compRem = quotAndRem[1].shiftLeftOneBit().compareTo(divisor.getUnscaledValue());
            integerQuot = integerQuot.multiply(BigInteger.TEN).add(BigInteger.valueOf(quotAndRem[0].signum() * (5 + compRem)));
            ++newScale;
        } else {
            while (!integerQuot.testBit(0)) {
                quotAndRem = integerQuot.divideAndRemainder(TEN_POW[i]);
                if (quotAndRem[1].signum() == 0 && newScale - (long)i >= diffScale) {
                    newScale -= (long)i;
                    if (i < lastPow) {
                        ++i;
                    }
                    integerQuot = quotAndRem[0];
                    continue;
                }
                if (i == 1) break;
                i = 1;
            }
        }
        return new BigDecimal(integerQuot, BigDecimal.safeLongToInt(newScale), mc);
    }

    public BigDecimal divideToIntegralValue(BigDecimal divisor) {
        BigInteger integralValue;
        BigInteger[] quotAndRem = new BigInteger[]{this.getUnscaledValue()};
        long newScale = (long)this.scale - (long)divisor.scale;
        long tempScale = 0L;
        int i = 1;
        int lastPow = TEN_POW.length - 1;
        if (divisor.isZero()) {
            throw new ArithmeticException("Division by zero");
        }
        if ((long)divisor.approxPrecision() + newScale > (long)this.approxPrecision() + 1L || this.isZero()) {
            integralValue = BigInteger.ZERO;
        } else if (newScale == 0L) {
            integralValue = this.getUnscaledValue().divide(divisor.getUnscaledValue());
        } else if (newScale > 0L) {
            BigInteger powerOfTen = Multiplication.powerOf10(newScale);
            integralValue = this.getUnscaledValue().divide(divisor.getUnscaledValue().multiply(powerOfTen));
            integralValue = integralValue.multiply(powerOfTen);
        } else {
            BigInteger powerOfTen = Multiplication.powerOf10(-newScale);
            integralValue = this.getUnscaledValue().multiply(powerOfTen).divide(divisor.getUnscaledValue());
            while (!integralValue.testBit(0)) {
                quotAndRem = integralValue.divideAndRemainder(TEN_POW[i]);
                if (quotAndRem[1].signum() == 0 && tempScale - (long)i >= newScale) {
                    tempScale -= (long)i;
                    if (i < lastPow) {
                        ++i;
                    }
                    integralValue = quotAndRem[0];
                    continue;
                }
                if (i == 1) break;
                i = 1;
            }
            newScale = tempScale;
        }
        return integralValue.signum() == 0 ? BigDecimal.zeroScaledBy(newScale) : new BigDecimal(integralValue, BigDecimal.safeLongToInt(newScale));
    }

    public BigDecimal divideToIntegralValue(BigDecimal divisor, MathContext mc) {
        long diffScale;
        int mcPrecision = mc.getPrecision();
        int diffPrecision = this.precision() - divisor.precision();
        int lastPow = TEN_POW.length - 1;
        long newScale = diffScale = (long)this.scale - (long)divisor.scale;
        long quotPrecision = (long)diffPrecision - diffScale + 1L;
        BigInteger[] quotAndRem = new BigInteger[2];
        if (mcPrecision == 0 || this.isZero() || divisor.isZero()) {
            return this.divideToIntegralValue(divisor);
        }
        if (quotPrecision <= 0L) {
            quotAndRem[0] = BigInteger.ZERO;
        } else if (diffScale == 0L) {
            quotAndRem[0] = this.getUnscaledValue().divide(divisor.getUnscaledValue());
        } else if (diffScale > 0L) {
            quotAndRem[0] = this.getUnscaledValue().divide(divisor.getUnscaledValue().multiply(Multiplication.powerOf10(diffScale)));
            newScale = Math.min(diffScale, Math.max((long)mcPrecision - quotPrecision + 1L, 0L));
            quotAndRem[0] = quotAndRem[0].multiply(Multiplication.powerOf10(newScale));
        } else {
            long exp = Math.min(-diffScale, Math.max((long)mcPrecision - (long)diffPrecision, 0L));
            quotAndRem = this.getUnscaledValue().multiply(Multiplication.powerOf10(exp)).divideAndRemainder(divisor.getUnscaledValue());
            newScale += exp;
            exp = -newScale;
            if (quotAndRem[1].signum() != 0 && exp > 0L) {
                long compRemDiv = (long)new BigDecimal(quotAndRem[1]).precision() + exp - (long)divisor.precision();
                if (compRemDiv == 0L) {
                    quotAndRem[1] = quotAndRem[1].multiply(Multiplication.powerOf10(exp)).divide(divisor.getUnscaledValue());
                    compRemDiv = Math.abs(quotAndRem[1].signum());
                }
                if (compRemDiv > 0L) {
                    throw new ArithmeticException("Division impossible");
                }
            }
        }
        if (quotAndRem[0].signum() == 0) {
            return BigDecimal.zeroScaledBy(diffScale);
        }
        BigInteger strippedBI = quotAndRem[0];
        BigDecimal integralValue = new BigDecimal(quotAndRem[0]);
        long resultPrecision = integralValue.precision();
        int i = 1;
        while (!strippedBI.testBit(0)) {
            quotAndRem = strippedBI.divideAndRemainder(TEN_POW[i]);
            if (quotAndRem[1].signum() == 0 && (resultPrecision - (long)i >= (long)mcPrecision || newScale - (long)i >= diffScale)) {
                resultPrecision -= (long)i;
                newScale -= (long)i;
                if (i < lastPow) {
                    ++i;
                }
                strippedBI = quotAndRem[0];
                continue;
            }
            if (i == 1) break;
            i = 1;
        }
        if (resultPrecision > (long)mcPrecision) {
            throw new ArithmeticException("Division impossible");
        }
        integralValue.scale = BigDecimal.safeLongToInt(newScale);
        integralValue.setUnscaledValue(strippedBI);
        return integralValue;
    }

    public BigDecimal remainder(BigDecimal divisor) {
        return this.divideAndRemainder(divisor)[1];
    }

    public BigDecimal remainder(BigDecimal divisor, MathContext mc) {
        return this.divideAndRemainder(divisor, mc)[1];
    }

    public BigDecimal[] divideAndRemainder(BigDecimal divisor) {
        BigDecimal[] quotAndRem;
        quotAndRem = new BigDecimal[]{this.divideToIntegralValue(divisor), this.subtract(quotAndRem[0].multiply(divisor))};
        return quotAndRem;
    }

    public BigDecimal[] divideAndRemainder(BigDecimal divisor, MathContext mc) {
        BigDecimal[] quotAndRem;
        quotAndRem = new BigDecimal[]{this.divideToIntegralValue(divisor, mc), this.subtract(quotAndRem[0].multiply(divisor))};
        return quotAndRem;
    }

    public BigDecimal pow(int n) {
        if (n == 0) {
            return ONE;
        }
        if (n < 0 || n > 999999999) {
            throw new ArithmeticException("Invalid operation");
        }
        long newScale = (long)this.scale * (long)n;
        return this.isZero() ? BigDecimal.zeroScaledBy(newScale) : new BigDecimal(this.getUnscaledValue().pow(n), BigDecimal.safeLongToInt(newScale));
    }

    public BigDecimal pow(int n, MathContext mc) {
        int m = Math.abs(n);
        int mcPrecision = mc.getPrecision();
        int elength = (int)Math.log10(m) + 1;
        MathContext newPrecision = mc;
        if (n == 0 || this.isZero() && n > 0) {
            return this.pow(n);
        }
        if (m > 999999999 || mcPrecision == 0 && n < 0 || mcPrecision > 0 && elength > mcPrecision) {
            throw new ArithmeticException("Invalid operation");
        }
        if (mcPrecision > 0) {
            newPrecision = new MathContext(mcPrecision + elength + 1, mc.getRoundingMode());
        }
        BigDecimal accum = this.round(newPrecision);
        for (int oneBitMask = Integer.highestOneBit(m) >> 1; oneBitMask > 0; oneBitMask >>= 1) {
            accum = accum.multiply(accum, newPrecision);
            if ((m & oneBitMask) != oneBitMask) continue;
            accum = accum.multiply(this, newPrecision);
        }
        if (n < 0) {
            accum = ONE.divide(accum, newPrecision);
        }
        accum.inplaceRound(mc);
        return accum;
    }

    public BigDecimal abs() {
        return this.signum() < 0 ? this.negate() : this;
    }

    public BigDecimal abs(MathContext mc) {
        BigDecimal result = this.signum() < 0 ? this.negate() : new BigDecimal(this.getUnscaledValue(), this.scale);
        result.inplaceRound(mc);
        return result;
    }

    public BigDecimal negate() {
        if (this.bitLength < 63 || this.bitLength == 63 && this.smallValue != Long.MIN_VALUE) {
            return BigDecimal.valueOf(-this.smallValue, this.scale);
        }
        return new BigDecimal(this.getUnscaledValue().negate(), this.scale);
    }

    public BigDecimal negate(MathContext mc) {
        BigDecimal result = this.negate();
        result.inplaceRound(mc);
        return result;
    }

    public BigDecimal plus() {
        return this;
    }

    public BigDecimal plus(MathContext mc) {
        return this.round(mc);
    }

    public int signum() {
        if (this.bitLength < 64) {
            return Long.signum(this.smallValue);
        }
        return this.getUnscaledValue().signum();
    }

    private boolean isZero() {
        return this.bitLength == 0 && this.smallValue != -1L;
    }

    public int scale() {
        return this.scale;
    }

    public int precision() {
        if (this.precision != 0) {
            return this.precision;
        }
        if (this.bitLength == 0) {
            this.precision = 1;
        } else if (this.bitLength < 64) {
            this.precision = this.decimalDigitsInLong(this.smallValue);
        } else {
            int decimalDigits = 1 + (int)((double)(this.bitLength - 1) * 0.3010299956639812);
            if (this.getUnscaledValue().divide(Multiplication.powerOf10(decimalDigits)).signum() != 0) {
                ++decimalDigits;
            }
            this.precision = decimalDigits;
        }
        return this.precision;
    }

    private int decimalDigitsInLong(long value) {
        if (value == Long.MIN_VALUE) {
            return 19;
        }
        int index = Arrays.binarySearch(MathUtils.LONG_POWERS_OF_TEN, Math.abs(value));
        return index < 0 ? -index - 1 : index + 1;
    }

    public BigInteger unscaledValue() {
        return this.getUnscaledValue();
    }

    public BigDecimal round(MathContext mc) {
        BigDecimal thisBD = new BigDecimal(this.getUnscaledValue(), this.scale);
        thisBD.inplaceRound(mc);
        return thisBD;
    }

    public BigDecimal setScale(int newScale, RoundingMode roundingMode) {
        if (roundingMode == null) {
            throw new NullPointerException("roundingMode == null");
        }
        long diffScale = (long)newScale - (long)this.scale;
        if (diffScale == 0L) {
            return this;
        }
        if (diffScale > 0L) {
            if (diffScale < (long)MathUtils.LONG_POWERS_OF_TEN.length && this.bitLength + LONG_POWERS_OF_TEN_BIT_LENGTH[(int)diffScale] < 64) {
                return BigDecimal.valueOf(this.smallValue * MathUtils.LONG_POWERS_OF_TEN[(int)diffScale], newScale);
            }
            return new BigDecimal(Multiplication.multiplyByTenPow(this.getUnscaledValue(), (int)diffScale), newScale);
        }
        if (this.bitLength < 64 && -diffScale < (long)MathUtils.LONG_POWERS_OF_TEN.length) {
            return BigDecimal.dividePrimitiveLongs(this.smallValue, MathUtils.LONG_POWERS_OF_TEN[(int)(-diffScale)], newScale, roundingMode);
        }
        return BigDecimal.divideBigIntegers(this.getUnscaledValue(), Multiplication.powerOf10(-diffScale), newScale, roundingMode);
    }

    public BigDecimal setScale(int newScale, int roundingMode) {
        return this.setScale(newScale, RoundingMode.valueOf(roundingMode));
    }

    public BigDecimal setScale(int newScale) {
        return this.setScale(newScale, RoundingMode.UNNECESSARY);
    }

    public BigDecimal movePointLeft(int n) {
        return this.movePoint((long)this.scale + (long)n);
    }

    private BigDecimal movePoint(long newScale) {
        if (this.isZero()) {
            return BigDecimal.zeroScaledBy(Math.max(newScale, 0L));
        }
        if (newScale >= 0L) {
            if (this.bitLength < 64) {
                return BigDecimal.valueOf(this.smallValue, BigDecimal.safeLongToInt(newScale));
            }
            return new BigDecimal(this.getUnscaledValue(), BigDecimal.safeLongToInt(newScale));
        }
        if (-newScale < (long)MathUtils.LONG_POWERS_OF_TEN.length && this.bitLength + LONG_POWERS_OF_TEN_BIT_LENGTH[(int)(-newScale)] < 64) {
            return BigDecimal.valueOf(this.smallValue * MathUtils.LONG_POWERS_OF_TEN[(int)(-newScale)], 0);
        }
        return new BigDecimal(Multiplication.multiplyByTenPow(this.getUnscaledValue(), BigDecimal.safeLongToInt(-newScale)), 0);
    }

    public BigDecimal movePointRight(int n) {
        return this.movePoint((long)this.scale - (long)n);
    }

    public BigDecimal scaleByPowerOfTen(int n) {
        long newScale = (long)this.scale - (long)n;
        if (this.bitLength < 64) {
            if (this.smallValue == 0L) {
                return BigDecimal.zeroScaledBy(newScale);
            }
            return BigDecimal.valueOf(this.smallValue, BigDecimal.safeLongToInt(newScale));
        }
        return new BigDecimal(this.getUnscaledValue(), BigDecimal.safeLongToInt(newScale));
    }

    public BigDecimal stripTrailingZeros() {
        int i = 1;
        int lastPow = TEN_POW.length - 1;
        long newScale = this.scale;
        if (this.isZero()) {
            return this;
        }
        BigInteger strippedBI = this.getUnscaledValue();
        while (!strippedBI.testBit(0)) {
            BigInteger[] quotAndRem = strippedBI.divideAndRemainder(TEN_POW[i]);
            if (quotAndRem[1].signum() == 0) {
                newScale -= (long)i;
                if (i < lastPow) {
                    ++i;
                }
                strippedBI = quotAndRem[0];
                continue;
            }
            if (i == 1) break;
            i = 1;
        }
        return new BigDecimal(strippedBI, BigDecimal.safeLongToInt(newScale));
    }

    @Override
    public int compareTo(BigDecimal val) {
        int valueSign;
        int thisSign = this.signum();
        if (thisSign == (valueSign = val.signum())) {
            if (this.scale == val.scale && this.bitLength < 64 && val.bitLength < 64) {
                return this.smallValue < val.smallValue ? -1 : (this.smallValue > val.smallValue ? 1 : 0);
            }
            long diffScale = (long)this.scale - (long)val.scale;
            int diffPrecision = this.approxPrecision() - val.approxPrecision();
            if ((long)diffPrecision > diffScale + 1L) {
                return thisSign;
            }
            if ((long)diffPrecision < diffScale - 1L) {
                return -thisSign;
            }
            BigInteger thisUnscaled = this.getUnscaledValue();
            BigInteger valUnscaled = val.getUnscaledValue();
            if (diffScale < 0L) {
                thisUnscaled = thisUnscaled.multiply(Multiplication.powerOf10(-diffScale));
            } else if (diffScale > 0L) {
                valUnscaled = valUnscaled.multiply(Multiplication.powerOf10(diffScale));
            }
            return thisUnscaled.compareTo(valUnscaled);
        }
        if (thisSign < valueSign) {
            return -1;
        }
        return 1;
    }

    public boolean equals(Object x) {
        if (this == x) {
            return true;
        }
        if (x instanceof BigDecimal) {
            BigDecimal x1 = (BigDecimal)x;
            return x1.scale == this.scale && (this.bitLength < 64 ? x1.smallValue == this.smallValue : this.intVal.equals(x1.intVal));
        }
        return false;
    }

    public BigDecimal min(BigDecimal val) {
        return this.compareTo(val) <= 0 ? this : val;
    }

    public BigDecimal max(BigDecimal val) {
        return this.compareTo(val) >= 0 ? this : val;
    }

    public int hashCode() {
        if (this.hashCode != 0) {
            return this.hashCode;
        }
        if (this.bitLength < 64) {
            this.hashCode = (int)(this.smallValue & 0xFFFFFFFFFFFFFFFFL);
            this.hashCode = 33 * this.hashCode + (int)(this.smallValue >> 32 & 0xFFFFFFFFFFFFFFFFL);
            this.hashCode = 17 * this.hashCode + this.scale;
            return this.hashCode;
        }
        this.hashCode = 17 * this.intVal.hashCode() + this.scale;
        return this.hashCode;
    }

    public String toString() {
        if (this.toStringImage != null) {
            return this.toStringImage;
        }
        if (this.bitLength < 32) {
            this.toStringImage = Conversion.toDecimalScaledString(this.smallValue, this.scale);
            return this.toStringImage;
        }
        String intString = this.getUnscaledValue().toString();
        if (this.scale == 0) {
            return intString;
        }
        int begin = this.getUnscaledValue().signum() < 0 ? 2 : 1;
        int end = intString.length();
        long exponent = -((long)this.scale) + (long)end - (long)begin;
        StringBuilder result = new StringBuilder();
        result.append(intString);
        if (this.scale > 0 && exponent >= -6L) {
            if (exponent >= 0L) {
                result.insert(end - this.scale, '.');
            } else {
                result.insert(begin - 1, "0.");
                result.insert(begin + 1, CH_ZEROS, 0, -((int)exponent) - 1);
            }
        } else {
            if (end - begin >= 1) {
                result.insert(begin, '.');
                ++end;
            }
            result.insert(end, 'E');
            if (exponent > 0L) {
                result.insert(++end, '+');
            }
            result.insert(++end, Long.toString(exponent));
        }
        this.toStringImage = result.toString();
        return this.toStringImage;
    }

    public String toEngineeringString() {
        String intString = this.getUnscaledValue().toString();
        if (this.scale == 0) {
            return intString;
        }
        int begin = this.getUnscaledValue().signum() < 0 ? 2 : 1;
        int end = intString.length();
        long exponent = -((long)this.scale) + (long)end - (long)begin;
        StringBuilder result = new StringBuilder(intString);
        if (this.scale > 0 && exponent >= -6L) {
            if (exponent >= 0L) {
                result.insert(end - this.scale, '.');
            } else {
                result.insert(begin - 1, "0.");
                result.insert(begin + 1, CH_ZEROS, 0, -((int)exponent) - 1);
            }
        } else {
            int delta = end - begin;
            int rem = (int)(exponent % 3L);
            if (rem != 0) {
                if (this.getUnscaledValue().signum() == 0) {
                    rem = rem < 0 ? -rem : 3 - rem;
                    exponent += (long)rem;
                } else {
                    rem = rem < 0 ? rem + 3 : rem;
                    exponent -= (long)rem;
                    begin += rem;
                }
                if (delta < 3) {
                    for (int i = rem - delta; i > 0; --i) {
                        result.insert(end++, '0');
                    }
                }
            }
            if (end - begin >= 1) {
                result.insert(begin, '.');
                ++end;
            }
            if (exponent != 0L) {
                result.insert(end, 'E');
                if (exponent > 0L) {
                    result.insert(++end, '+');
                }
                result.insert(++end, Long.toString(exponent));
            }
        }
        return result.toString();
    }

    public String toPlainString() {
        String intStr = this.getUnscaledValue().toString();
        if (this.scale == 0 || this.isZero() && this.scale < 0) {
            return intStr;
        }
        int begin = this.signum() < 0 ? 1 : 0;
        int delta = this.scale;
        StringBuilder result = new StringBuilder(intStr.length() + 1 + Math.abs(this.scale));
        if (begin == 1) {
            result.append('-');
        }
        if (this.scale > 0) {
            if ((delta -= intStr.length() - begin) >= 0) {
                result.append("0.");
                while (delta > CH_ZEROS.length) {
                    result.append(CH_ZEROS);
                    delta -= CH_ZEROS.length;
                }
                result.append(CH_ZEROS, 0, delta);
                result.append(intStr.substring(begin));
            } else {
                delta = begin - delta;
                result.append(intStr.substring(begin, delta));
                result.append('.');
                result.append(intStr.substring(delta));
            }
        } else {
            result.append(intStr.substring(begin));
            while (delta < -CH_ZEROS.length) {
                result.append(CH_ZEROS);
                delta += CH_ZEROS.length;
            }
            result.append(CH_ZEROS, 0, -delta);
        }
        return result.toString();
    }

    public BigInteger toBigInteger() {
        if (this.scale == 0 || this.isZero()) {
            return this.getUnscaledValue();
        }
        if (this.scale < 0) {
            return this.getUnscaledValue().multiply(Multiplication.powerOf10(-((long)this.scale)));
        }
        return this.getUnscaledValue().divide(Multiplication.powerOf10(this.scale));
    }

    public BigInteger toBigIntegerExact() {
        if (this.scale == 0 || this.isZero()) {
            return this.getUnscaledValue();
        }
        if (this.scale < 0) {
            return this.getUnscaledValue().multiply(Multiplication.powerOf10(-((long)this.scale)));
        }
        if (this.scale > this.approxPrecision() || this.scale > this.getUnscaledValue().getLowestSetBit()) {
            throw new ArithmeticException("Rounding necessary");
        }
        BigInteger[] integerAndFraction = this.getUnscaledValue().divideAndRemainder(Multiplication.powerOf10(this.scale));
        if (integerAndFraction[1].signum() != 0) {
            throw new ArithmeticException("Rounding necessary");
        }
        return integerAndFraction[0];
    }

    @Override
    public long longValue() {
        return this.scale <= -64 || this.scale > this.approxPrecision() ? 0L : this.toBigInteger().longValue();
    }

    public long longValueExact() {
        return this.valueExact(64);
    }

    @Override
    public int intValue() {
        return this.scale <= -32 || this.scale > this.approxPrecision() ? 0 : this.toBigInteger().intValue();
    }

    public int intValueExact() {
        return (int)this.valueExact(32);
    }

    public short shortValueExact() {
        return (short)this.valueExact(16);
    }

    public byte byteValueExact() {
        return (byte)this.valueExact(8);
    }

    @Override
    public float floatValue() {
        float floatResult = this.signum();
        long powerOfTwo = (long)this.bitLength - (long)((double)this.scale / 0.3010299956639812);
        floatResult = powerOfTwo < -149L || floatResult == 0.0f ? (floatResult *= 0.0f) : (powerOfTwo > 129L ? (floatResult *= Float.POSITIVE_INFINITY) : (float)this.doubleValue());
        return floatResult;
    }

    @Override
    public double doubleValue() {
        long tempBits;
        long bits;
        int sign = this.signum();
        int exponent = 1076;
        long powerOfTwo = (long)this.bitLength - (long)((double)this.scale / 0.3010299956639812);
        if (powerOfTwo < -1074L || sign == 0) {
            return (double)sign * 0.0;
        }
        if (powerOfTwo > 1025L) {
            return (double)sign * Double.POSITIVE_INFINITY;
        }
        BigInteger mantissa = this.getUnscaledValue().abs();
        if (this.scale <= 0) {
            mantissa = mantissa.multiply(Multiplication.powerOf10(-this.scale));
        } else {
            BigInteger powerOfTen = Multiplication.powerOf10(this.scale);
            int k = 100 - (int)powerOfTwo;
            if (k > 0) {
                mantissa = mantissa.shiftLeft(k);
                exponent -= k;
            }
            BigInteger[] quotAndRem = mantissa.divideAndRemainder(powerOfTen);
            int compRem = quotAndRem[1].shiftLeftOneBit().compareTo(powerOfTen);
            mantissa = quotAndRem[0].shiftLeft(2).add(BigInteger.valueOf(compRem * (compRem + 3) / 2 + 1));
            exponent -= 2;
        }
        int lowestSetBit = mantissa.getLowestSetBit();
        int discardedSize = mantissa.bitLength() - 54;
        if (discardedSize > 0) {
            tempBits = bits = mantissa.shiftRight(discardedSize).longValue();
            if ((bits & 1L) == 1L && lowestSetBit < discardedSize || (bits & 3L) == 3L) {
                bits += 2L;
            }
        } else {
            tempBits = bits = mantissa.longValue() << -discardedSize;
            if ((bits & 3L) == 3L) {
                bits += 2L;
            }
        }
        if ((bits & 0x40000000000000L) == 0L) {
            bits >>= 1;
            exponent += discardedSize;
        } else {
            bits >>= 2;
            exponent += discardedSize + 1;
        }
        if (exponent > 2046) {
            return (double)sign * Double.POSITIVE_INFINITY;
        }
        if (exponent <= 0) {
            if (exponent < -53) {
                return (double)sign * 0.0;
            }
            bits = tempBits >> 1;
            tempBits = bits & -1L >>> 63 + exponent;
            if (((bits >>= -exponent) & 3L) == 3L || (bits & 1L) == 1L && tempBits != 0L && lowestSetBit < discardedSize) {
                ++bits;
            }
            exponent = 0;
            bits >>= 1;
        }
        bits = (long)sign & Long.MIN_VALUE | (long)exponent << 52 | bits & 0xFFFFFFFFFFFFFL;
        return Double.longBitsToDouble(bits);
    }

    public BigDecimal ulp() {
        return BigDecimal.valueOf(1L, this.scale);
    }

    private void inplaceRound(MathContext mc) {
        int mcPrecision = mc.getPrecision();
        if (this.approxPrecision() < mcPrecision || mcPrecision == 0) {
            return;
        }
        int discardedPrecision = this.precision() - mcPrecision;
        if (discardedPrecision <= 0) {
            return;
        }
        if (this.bitLength < 64) {
            this.smallRound(mc, discardedPrecision);
            return;
        }
        BigInteger sizeOfFraction = Multiplication.powerOf10(discardedPrecision);
        BigInteger[] integerAndFraction = this.getUnscaledValue().divideAndRemainder(sizeOfFraction);
        long newScale = (long)this.scale - (long)discardedPrecision;
        if (integerAndFraction[1].signum() != 0) {
            BigDecimal tempBD;
            int compRem = integerAndFraction[1].abs().shiftLeftOneBit().compareTo(sizeOfFraction);
            compRem = BigDecimal.roundingBehavior(integerAndFraction[0].testBit(0) ? 1 : 0, integerAndFraction[1].signum() * (5 + compRem), mc.getRoundingMode());
            if (compRem != 0) {
                integerAndFraction[0] = integerAndFraction[0].add(BigInteger.valueOf(compRem));
            }
            if ((tempBD = new BigDecimal(integerAndFraction[0])).precision() > mcPrecision) {
                integerAndFraction[0] = integerAndFraction[0].divide(BigInteger.TEN);
                --newScale;
            }
        }
        this.scale = BigDecimal.safeLongToInt(newScale);
        this.precision = mcPrecision;
        this.setUnscaledValue(integerAndFraction[0]);
    }

    private static int longCompareTo(long value1, long value2) {
        return value1 > value2 ? 1 : (value1 < value2 ? -1 : 0);
    }

    private void smallRound(MathContext mc, int discardedPrecision) {
        long sizeOfFraction = MathUtils.LONG_POWERS_OF_TEN[discardedPrecision];
        long newScale = (long)this.scale - (long)discardedPrecision;
        long unscaledVal = this.smallValue;
        long integer2 = unscaledVal / sizeOfFraction;
        long fraction2 = unscaledVal % sizeOfFraction;
        if (fraction2 != 0L) {
            int compRem = BigDecimal.longCompareTo(Math.abs(fraction2) * 2L, sizeOfFraction);
            if (Math.log10(Math.abs(integer2 += (long)BigDecimal.roundingBehavior((int)integer2 & 1, Long.signum(fraction2) * (5 + compRem), mc.getRoundingMode()))) >= (double)mc.getPrecision()) {
                integer2 /= 10L;
                --newScale;
            }
        }
        this.scale = BigDecimal.safeLongToInt(newScale);
        this.precision = mc.getPrecision();
        this.smallValue = integer2;
        this.bitLength = BigDecimal.bitLength(integer2);
        this.intVal = null;
    }

    private static int roundingBehavior(int parityBit, int fraction2, RoundingMode roundingMode) {
        int increment = 0;
        switch (roundingMode) {
            case UNNECESSARY: {
                if (fraction2 == 0) break;
                throw new ArithmeticException("Rounding necessary");
            }
            case UP: {
                increment = Integer.signum(fraction2);
                break;
            }
            case DOWN: {
                break;
            }
            case CEILING: {
                increment = Math.max(Integer.signum(fraction2), 0);
                break;
            }
            case FLOOR: {
                increment = Math.min(Integer.signum(fraction2), 0);
                break;
            }
            case HALF_UP: {
                if (Math.abs(fraction2) < 5) break;
                increment = Integer.signum(fraction2);
                break;
            }
            case HALF_DOWN: {
                if (Math.abs(fraction2) <= 5) break;
                increment = Integer.signum(fraction2);
                break;
            }
            case HALF_EVEN: {
                if (Math.abs(fraction2) + parityBit <= 5) break;
                increment = Integer.signum(fraction2);
            }
        }
        return increment;
    }

    private long valueExact(int bitLengthOfType) {
        BigInteger bigInteger = this.toBigIntegerExact();
        if (bigInteger.bitLength() < bitLengthOfType) {
            return bigInteger.longValue();
        }
        throw new ArithmeticException("Rounding necessary");
    }

    private int approxPrecision() {
        return this.precision > 0 ? this.precision : (int)((double)(this.bitLength - 1) * 0.3010299956639812) + 1;
    }

    private static int safeLongToInt(long longValue) {
        if (longValue < Integer.MIN_VALUE || longValue > Integer.MAX_VALUE) {
            throw new ArithmeticException("Out of int range: " + longValue);
        }
        return (int)longValue;
    }

    private static BigDecimal zeroScaledBy(long longScale) {
        if (longScale == (long)((int)longScale)) {
            return BigDecimal.valueOf(0L, (int)longScale);
        }
        if (longScale >= 0L) {
            return new BigDecimal(0, Integer.MAX_VALUE);
        }
        return new BigDecimal(0, Integer.MIN_VALUE);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.bitLength = this.intVal.bitLength();
        if (this.bitLength < 64) {
            this.smallValue = this.intVal.longValue();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.getUnscaledValue();
        out.defaultWriteObject();
    }

    private BigInteger getUnscaledValue() {
        if (this.intVal == null) {
            this.intVal = BigInteger.valueOf(this.smallValue);
        }
        return this.intVal;
    }

    private void setUnscaledValue(BigInteger unscaledValue) {
        this.intVal = unscaledValue;
        this.bitLength = unscaledValue.bitLength();
        if (this.bitLength < 64) {
            this.smallValue = unscaledValue.longValue();
        }
    }

    private static int bitLength(long smallValue) {
        if (smallValue < 0L) {
            smallValue ^= 0xFFFFFFFFFFFFFFFFL;
        }
        return 64 - Long.numberOfLeadingZeros(smallValue);
    }

    private static int bitLength(int smallValue) {
        if (smallValue < 0) {
            smallValue ^= 0xFFFFFFFF;
        }
        return 32 - Integer.numberOfLeadingZeros(smallValue);
    }

    static {
        int i;
        LONG_FIVE_POW = new long[]{1L, 5L, 25L, 125L, 625L, 3125L, 15625L, 78125L, 390625L, 1953125L, 9765625L, 48828125L, 244140625L, 1220703125L, 6103515625L, 30517578125L, 152587890625L, 762939453125L, 3814697265625L, 19073486328125L, 95367431640625L, 476837158203125L, 2384185791015625L, 11920928955078125L, 59604644775390625L, 298023223876953125L, 1490116119384765625L, 7450580596923828125L};
        LONG_FIVE_POW_BIT_LENGTH = new int[LONG_FIVE_POW.length];
        LONG_POWERS_OF_TEN_BIT_LENGTH = new int[MathUtils.LONG_POWERS_OF_TEN.length];
        BI_SCALED_BY_ZERO = new BigDecimal[11];
        ZERO_SCALED_BY = new BigDecimal[11];
        CH_ZEROS = new char[100];
        Arrays.fill(CH_ZEROS, '0');
        for (i = 0; i < ZERO_SCALED_BY.length; ++i) {
            BigDecimal.BI_SCALED_BY_ZERO[i] = new BigDecimal(i, 0);
            BigDecimal.ZERO_SCALED_BY[i] = new BigDecimal(0, i);
        }
        for (i = 0; i < LONG_FIVE_POW_BIT_LENGTH.length; ++i) {
            BigDecimal.LONG_FIVE_POW_BIT_LENGTH[i] = BigDecimal.bitLength(LONG_FIVE_POW[i]);
        }
        for (i = 0; i < LONG_POWERS_OF_TEN_BIT_LENGTH.length; ++i) {
            BigDecimal.LONG_POWERS_OF_TEN_BIT_LENGTH[i] = BigDecimal.bitLength(MathUtils.LONG_POWERS_OF_TEN[i]);
        }
        TEN_POW = Multiplication.bigTenPows;
        FIVE_POW = Multiplication.bigFivePows;
        ZERO = new BigDecimal(0, 0);
        ONE = new BigDecimal(1, 0);
        TEN = new BigDecimal(10, 0);
    }
}

