/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import android.system.ErrnoException;
import android.system.OsConstants;
import java.io.Closeable;
import java.io.FileDescriptor;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocketImpl;
import java.net.DatagramSocketImplFactory;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.PlainDatagramSocketImpl;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.DatagramChannel;
import libcore.io.IoBridge;
import libcore.io.Libcore;

public class DatagramSocket
implements Closeable {
    DatagramSocketImpl impl;
    InetAddress address;
    int port = -1;
    static DatagramSocketImplFactory factory;
    boolean isBound = false;
    private boolean isConnected = false;
    private SocketException pendingConnectException;
    private boolean isClosed = false;
    private Object lock = new Object();

    public DatagramSocket() throws SocketException {
        this(0);
    }

    public DatagramSocket(int aPort) throws SocketException {
        this.checkPort(aPort);
        this.createSocket(aPort, Inet4Address.ANY);
    }

    public DatagramSocket(int aPort, InetAddress addr) throws SocketException {
        this.checkPort(aPort);
        this.createSocket(aPort, addr == null ? Inet4Address.ANY : addr);
    }

    private void checkPort(int aPort) {
        if (aPort < 0 || aPort > 65535) {
            throw new IllegalArgumentException("Port out of range: " + aPort);
        }
    }

    @Override
    public void close() {
        this.isClosed = true;
        this.impl.close();
    }

    public void onClose() {
        this.isClosed = true;
        this.impl.onClose();
    }

    public void disconnect() {
        if (this.isClosed() || !this.isConnected()) {
            return;
        }
        this.impl.disconnect();
        this.address = null;
        this.port = -1;
        this.isConnected = false;
    }

    public void onDisconnect() {
        this.address = null;
        this.port = -1;
        this.isConnected = false;
        this.impl.onDisconnect();
    }

    synchronized void createSocket(int aPort, InetAddress addr) throws SocketException {
        this.impl = factory != null ? factory.createDatagramSocketImpl() : new PlainDatagramSocketImpl();
        this.impl.create();
        try {
            this.impl.bind(aPort, addr);
            this.isBound = true;
        }
        catch (SocketException e) {
            this.close();
            throw e;
        }
    }

    public InetAddress getInetAddress() {
        return this.address;
    }

    public InetAddress getLocalAddress() {
        try {
            return IoBridge.getSocketLocalAddress(this.impl.fd);
        }
        catch (SocketException ex) {
            return null;
        }
    }

    public int getLocalPort() {
        if (this.isClosed()) {
            return -1;
        }
        if (!this.isBound()) {
            return 0;
        }
        return this.impl.getLocalPort();
    }

    public int getPort() {
        return this.port;
    }

    boolean isMulticastSocket() {
        return false;
    }

    public synchronized int getReceiveBufferSize() throws SocketException {
        this.checkOpen();
        return (Integer)this.impl.getOption(4098);
    }

    public synchronized int getSendBufferSize() throws SocketException {
        this.checkOpen();
        return (Integer)this.impl.getOption(4097);
    }

    public synchronized int getSoTimeout() throws SocketException {
        this.checkOpen();
        return (Integer)this.impl.getOption(4102);
    }

    public synchronized void receive(DatagramPacket pack) throws IOException {
        this.checkOpen();
        this.ensureBound();
        if (pack == null) {
            throw new NullPointerException("pack == null");
        }
        if (this.pendingConnectException != null) {
            throw new SocketException("Pending connect failure", this.pendingConnectException);
        }
        pack.resetLengthForReceive();
        this.impl.receive(pack);
    }

    public void send(DatagramPacket pack) throws IOException {
        this.checkOpen();
        this.ensureBound();
        InetAddress packAddr = pack.getAddress();
        if (this.address != null) {
            if (packAddr != null) {
                if (!this.address.equals(packAddr) || this.port != pack.getPort()) {
                    throw new IllegalArgumentException("Packet address mismatch with connected address");
                }
            } else {
                pack.setAddress(this.address);
                pack.setPort(this.port);
            }
        } else if (packAddr == null) {
            throw new NullPointerException("Destination address is null");
        }
        this.impl.send(pack);
    }

    public void setNetworkInterface(NetworkInterface netInterface) throws SocketException {
        if (netInterface == null) {
            throw new NullPointerException("netInterface == null");
        }
        try {
            Libcore.os.setsockoptIfreq(this.impl.fd, OsConstants.SOL_SOCKET, OsConstants.SO_BINDTODEVICE, netInterface.getName());
        }
        catch (ErrnoException errnoException) {
            throw errnoException.rethrowAsSocketException();
        }
    }

    public synchronized void setSendBufferSize(int size) throws SocketException {
        if (size < 1) {
            throw new IllegalArgumentException("size < 1");
        }
        this.checkOpen();
        this.impl.setOption(4097, size);
    }

    public synchronized void setReceiveBufferSize(int size) throws SocketException {
        if (size < 1) {
            throw new IllegalArgumentException("size < 1");
        }
        this.checkOpen();
        this.impl.setOption(4098, size);
    }

    public synchronized void setSoTimeout(int timeout) throws SocketException {
        if (timeout < 0) {
            throw new IllegalArgumentException("timeout < 0");
        }
        this.checkOpen();
        this.impl.setOption(4102, timeout);
    }

    public static synchronized void setDatagramSocketImplFactory(DatagramSocketImplFactory fac) throws IOException {
        if (factory != null) {
            throw new SocketException("Factory already set");
        }
        factory = fac;
    }

    protected DatagramSocket(DatagramSocketImpl socketImpl) {
        if (socketImpl == null) {
            throw new NullPointerException("socketImpl == null");
        }
        this.impl = socketImpl;
    }

    public DatagramSocket(SocketAddress localAddr) throws SocketException {
        if (localAddr != null) {
            if (!(localAddr instanceof InetSocketAddress)) {
                throw new IllegalArgumentException("Local address not an InetSocketAddress: " + localAddr.getClass());
            }
            this.checkPort(((InetSocketAddress)localAddr).getPort());
        }
        this.impl = factory != null ? factory.createDatagramSocketImpl() : new PlainDatagramSocketImpl();
        this.impl.create();
        if (localAddr != null) {
            try {
                this.bind(localAddr);
            }
            catch (SocketException e) {
                this.close();
                throw e;
            }
        }
        this.setBroadcast(true);
    }

    void checkOpen() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
    }

    private void ensureBound() throws SocketException {
        if (!this.isBound()) {
            this.impl.bind(0, Inet4Address.ANY);
            this.isBound = true;
        }
    }

    public void bind(SocketAddress localAddr) throws SocketException {
        InetAddress addr;
        int localPort;
        this.checkOpen();
        if (localAddr == null) {
            localPort = 0;
            addr = Inet4Address.ANY;
        } else {
            if (!(localAddr instanceof InetSocketAddress)) {
                throw new IllegalArgumentException("Local address not an InetSocketAddress: " + localAddr.getClass());
            }
            InetSocketAddress inetAddr = (InetSocketAddress)localAddr;
            addr = inetAddr.getAddress();
            if (addr == null) {
                throw new SocketException("Host is unresolved: " + inetAddr.getHostName());
            }
            localPort = inetAddr.getPort();
            this.checkPort(localPort);
        }
        this.impl.bind(localPort, addr);
        this.isBound = true;
    }

    public void onBind(InetAddress localAddress, int localPort) {
        this.isBound = true;
        this.impl.onBind(localAddress, localPort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(SocketAddress peer) throws SocketException {
        if (peer == null) {
            throw new IllegalArgumentException("peer == null");
        }
        if (!(peer instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("peer not an InetSocketAddress: " + peer.getClass());
        }
        InetSocketAddress isa = (InetSocketAddress)peer;
        if (isa.getAddress() == null) {
            throw new SocketException("Host is unresolved: " + isa.getHostName());
        }
        Object object = this.lock;
        synchronized (object) {
            this.checkOpen();
            this.ensureBound();
            this.address = isa.getAddress();
            this.port = isa.getPort();
            this.isConnected = true;
            this.impl.connect(this.address, this.port);
        }
    }

    public void onConnect(InetAddress remoteAddress, int remotePort) {
        this.isConnected = true;
        this.address = remoteAddress;
        this.port = remotePort;
        this.impl.onConnect(remoteAddress, remotePort);
    }

    public void connect(InetAddress address, int port) {
        if (address == null) {
            throw new IllegalArgumentException("address == null");
        }
        try {
            this.connect(new InetSocketAddress(address, port));
        }
        catch (SocketException connectException) {
            this.pendingConnectException = connectException;
        }
    }

    public boolean isBound() {
        return this.isBound;
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public SocketAddress getRemoteSocketAddress() {
        if (!this.isConnected()) {
            return null;
        }
        return new InetSocketAddress(this.getInetAddress(), this.getPort());
    }

    public SocketAddress getLocalSocketAddress() {
        if (this.isClosed() || !this.isBound()) {
            return null;
        }
        return new InetSocketAddress(this.getLocalAddress(), this.getLocalPort());
    }

    public void setReuseAddress(boolean reuse) throws SocketException {
        this.checkOpen();
        this.impl.setOption(4, reuse);
    }

    public boolean getReuseAddress() throws SocketException {
        this.checkOpen();
        return (Boolean)this.impl.getOption(4);
    }

    public void setBroadcast(boolean broadcast) throws SocketException {
        this.checkOpen();
        this.impl.setOption(32, broadcast);
    }

    public boolean getBroadcast() throws SocketException {
        this.checkOpen();
        return (Boolean)this.impl.getOption(32);
    }

    public void setTrafficClass(int value) throws SocketException {
        this.checkOpen();
        if (value < 0 || value > 255) {
            throw new IllegalArgumentException("Value doesn't fit in an unsigned byte: " + value);
        }
        this.impl.setOption(3, value);
    }

    public int getTrafficClass() throws SocketException {
        this.checkOpen();
        return (Integer)this.impl.getOption(3);
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public DatagramChannel getChannel() {
        return null;
    }

    public final FileDescriptor getFileDescriptor$() {
        return this.impl.fd;
    }
}

