/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Locale;
import libcore.net.UriCodec;
import libcore.net.url.UrlUtils;

public final class URI
implements Comparable<URI>,
Serializable {
    private static final long serialVersionUID = -6052424284110960213L;
    static final String UNRESERVED = "_-!.~'()*";
    static final String PUNCTUATION = ",;:$&+=";
    static final UriCodec USER_INFO_ENCODER = new PartEncoder("");
    static final UriCodec PATH_ENCODER = new PartEncoder("/@");
    static final UriCodec AUTHORITY_ENCODER = new PartEncoder("@[]");
    static final UriCodec FILE_AND_QUERY_ENCODER = new PartEncoder("/@?");
    static final UriCodec ALL_LEGAL_ENCODER = new PartEncoder("?/[]@");
    private static final UriCodec ASCII_ONLY = new UriCodec(){

        @Override
        protected boolean isRetained(char c) {
            return c <= '\u007f';
        }
    };
    private String string;
    private transient String scheme;
    private transient String schemeSpecificPart;
    private transient String authority;
    private transient String userInfo;
    private transient String host;
    private transient int port = -1;
    private transient String path;
    private transient String query;
    private transient String fragment;
    private transient boolean opaque;
    private transient boolean absolute;
    private transient boolean serverAuthority = false;
    private transient int hash = -1;

    private URI() {
    }

    public URI(String spec) throws URISyntaxException {
        this.parseURI(spec, false);
    }

    public URI(String scheme, String schemeSpecificPart, String fragment) throws URISyntaxException {
        StringBuilder uri = new StringBuilder();
        if (scheme != null) {
            uri.append(scheme);
            uri.append(':');
        }
        if (schemeSpecificPart != null) {
            ALL_LEGAL_ENCODER.appendEncoded(uri, schemeSpecificPart);
        }
        if (fragment != null) {
            uri.append('#');
            ALL_LEGAL_ENCODER.appendEncoded(uri, fragment);
        }
        this.parseURI(uri.toString(), false);
    }

    public URI(String scheme, String userInfo, String host, int port, String path, String query, String fragment) throws URISyntaxException {
        if (scheme == null && userInfo == null && host == null && path == null && query == null && fragment == null) {
            this.path = "";
            return;
        }
        if (scheme != null && path != null && !path.isEmpty() && path.charAt(0) != '/') {
            throw new URISyntaxException(path, "Relative path");
        }
        StringBuilder uri = new StringBuilder();
        if (scheme != null) {
            uri.append(scheme);
            uri.append(':');
        }
        if (userInfo != null || host != null || port != -1) {
            uri.append("//");
        }
        if (userInfo != null) {
            USER_INFO_ENCODER.appendEncoded(uri, userInfo);
            uri.append('@');
        }
        if (host != null) {
            if (host.indexOf(58) != -1 && host.indexOf(93) == -1 && host.indexOf(91) == -1) {
                host = "[" + host + "]";
            }
            uri.append(host);
        }
        if (port != -1) {
            uri.append(':');
            uri.append(port);
        }
        if (path != null) {
            PATH_ENCODER.appendEncoded(uri, path);
        }
        if (query != null) {
            uri.append('?');
            ALL_LEGAL_ENCODER.appendEncoded(uri, query);
        }
        if (fragment != null) {
            uri.append('#');
            ALL_LEGAL_ENCODER.appendEncoded(uri, fragment);
        }
        this.parseURI(uri.toString(), true);
    }

    public URI(String scheme, String host, String path, String fragment) throws URISyntaxException {
        this(scheme, null, host, -1, path, null, fragment);
    }

    public URI(String scheme, String authority, String path, String query, String fragment) throws URISyntaxException {
        if (scheme != null && path != null && !path.isEmpty() && path.charAt(0) != '/') {
            throw new URISyntaxException(path, "Relative path");
        }
        StringBuilder uri = new StringBuilder();
        if (scheme != null) {
            uri.append(scheme);
            uri.append(':');
        }
        if (authority != null) {
            uri.append("//");
            AUTHORITY_ENCODER.appendEncoded(uri, authority);
        }
        if (path != null) {
            PATH_ENCODER.appendEncoded(uri, path);
        }
        if (query != null) {
            uri.append('?');
            ALL_LEGAL_ENCODER.appendEncoded(uri, query);
        }
        if (fragment != null) {
            uri.append('#');
            ALL_LEGAL_ENCODER.appendEncoded(uri, fragment);
        }
        this.parseURI(uri.toString(), false);
    }

    private void parseURI(String uri, boolean forceServer) throws URISyntaxException {
        int fileStart;
        int start;
        int colon;
        this.string = uri;
        int fragmentStart = UrlUtils.findFirstOf(uri, "#", 0, uri.length());
        if (fragmentStart < uri.length()) {
            this.fragment = ALL_LEGAL_ENCODER.validate(uri, fragmentStart + 1, uri.length(), "fragment");
        }
        if ((colon = UrlUtils.findFirstOf(uri, ":", 0, fragmentStart)) < UrlUtils.findFirstOf(uri, "/?#", 0, fragmentStart)) {
            this.absolute = true;
            this.scheme = this.validateScheme(uri, colon);
            start = colon + 1;
            if (start == fragmentStart) {
                throw new URISyntaxException(uri, "Scheme-specific part expected", start);
            }
            if (!uri.regionMatches(start, "/", 0, 1)) {
                this.opaque = true;
                this.schemeSpecificPart = ALL_LEGAL_ENCODER.validate(uri, start, fragmentStart, "scheme specific part");
                return;
            }
        } else {
            this.absolute = false;
            start = 0;
        }
        this.opaque = false;
        this.schemeSpecificPart = uri.substring(start, fragmentStart);
        if (uri.regionMatches(start, "//", 0, 2)) {
            int authorityStart = start + 2;
            fileStart = UrlUtils.findFirstOf(uri, "/?", authorityStart, fragmentStart);
            if (authorityStart == uri.length()) {
                throw new URISyntaxException(uri, "Authority expected", uri.length());
            }
            if (authorityStart < fileStart) {
                this.authority = AUTHORITY_ENCODER.validate(uri, authorityStart, fileStart, "authority");
            }
        } else {
            fileStart = start;
        }
        int queryStart = UrlUtils.findFirstOf(uri, "?", fileStart, fragmentStart);
        this.path = PATH_ENCODER.validate(uri, fileStart, queryStart, "path");
        if (queryStart < fragmentStart) {
            this.query = ALL_LEGAL_ENCODER.validate(uri, queryStart + 1, fragmentStart, "query");
        }
        this.parseAuthority(forceServer);
    }

    private String validateScheme(String uri, int end) throws URISyntaxException {
        if (end == 0) {
            throw new URISyntaxException(uri, "Scheme expected", 0);
        }
        for (int i = 0; i < end; ++i) {
            if (UrlUtils.isValidSchemeChar(i, uri.charAt(i))) continue;
            throw new URISyntaxException(uri, "Illegal character in scheme", 0);
        }
        return uri.substring(0, end);
    }

    private void parseAuthority(boolean forceServer) throws URISyntaxException {
        String tempHost;
        if (this.authority == null) {
            return;
        }
        String tempUserInfo = null;
        String temp = this.authority;
        int index = temp.indexOf(64);
        int hostIndex = 0;
        if (index != -1) {
            tempUserInfo = temp.substring(0, index);
            this.validateUserInfo(this.authority, tempUserInfo, 0);
            temp = temp.substring(index + 1);
            hostIndex = index + 1;
        }
        index = temp.lastIndexOf(58);
        int endIndex = temp.indexOf(93);
        int tempPort = -1;
        if (index != -1 && endIndex < index) {
            tempHost = temp.substring(0, index);
            if (index < temp.length() - 1) {
                try {
                    char firstPortChar = temp.charAt(index + 1);
                    if (firstPortChar < '0' || firstPortChar > '9') {
                        if (forceServer) {
                            throw new URISyntaxException(this.authority, "Invalid port number", hostIndex + index + 1);
                        }
                        return;
                    }
                    tempPort = Integer.parseInt(temp.substring(index + 1));
                }
                catch (NumberFormatException e) {
                    if (forceServer) {
                        throw new URISyntaxException(this.authority, "Invalid port number", hostIndex + index + 1);
                    }
                    return;
                }
            }
        } else {
            tempHost = temp;
        }
        if (tempHost.isEmpty()) {
            if (forceServer) {
                throw new URISyntaxException(this.authority, "Expected host", hostIndex);
            }
            return;
        }
        if (!this.isValidHost(forceServer, tempHost)) {
            return;
        }
        this.userInfo = tempUserInfo;
        this.host = tempHost;
        this.port = tempPort;
        this.serverAuthority = true;
    }

    private void validateUserInfo(String uri, String userInfo, int index) throws URISyntaxException {
        for (int i = 0; i < userInfo.length(); ++i) {
            char ch = userInfo.charAt(i);
            if (ch != ']' && ch != '[') continue;
            throw new URISyntaxException(uri, "Illegal character in userInfo", index + i);
        }
    }

    private boolean isValidHost(boolean forceServer, String host) throws URISyntaxException {
        if (host.startsWith("[")) {
            if (!host.endsWith("]")) {
                throw new URISyntaxException(host, "Expected a closing square bracket for IPv6 address", 0);
            }
            if (InetAddress.isNumeric(host)) {
                return true;
            }
            throw new URISyntaxException(host, "Malformed IPv6 address");
        }
        if (host.indexOf(91) != -1 || host.indexOf(93) != -1) {
            throw new URISyntaxException(host, "Illegal character in host name", 0);
        }
        int index = host.lastIndexOf(46);
        if (index < 0 || index == host.length() - 1 || !Character.isDigit(host.charAt(index + 1))) {
            if (this.isValidDomainName(host)) {
                return true;
            }
            if (forceServer) {
                throw new URISyntaxException(host, "Illegal character in host name", 0);
            }
            return false;
        }
        try {
            InetAddress ia = InetAddress.parseNumericAddress(host);
            if (ia instanceof Inet4Address) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (forceServer) {
            throw new URISyntaxException(host, "Malformed IPv4 address", 0);
        }
        return false;
    }

    private boolean isValidDomainName(String host) {
        char ch;
        try {
            UriCodec.validateSimple(host, "-.");
        }
        catch (URISyntaxException e) {
            return false;
        }
        String lastLabel = null;
        for (String token : host.split("\\.")) {
            lastLabel = token;
            if (!lastLabel.startsWith("-") && !lastLabel.endsWith("-")) continue;
            return false;
        }
        if (lastLabel == null) {
            return false;
        }
        return lastLabel.equals(host) || (ch = lastLabel.charAt(0)) < '0' || ch > '9';
    }

    @Override
    public int compareTo(URI uri) {
        int ret;
        if (this.scheme == null && uri.scheme != null) {
            return -1;
        }
        if (this.scheme != null && uri.scheme == null) {
            return 1;
        }
        if (this.scheme != null && uri.scheme != null && (ret = this.scheme.compareToIgnoreCase(uri.scheme)) != 0) {
            return ret;
        }
        if (!this.opaque && uri.opaque) {
            return -1;
        }
        if (this.opaque && !uri.opaque) {
            return 1;
        }
        if (this.opaque && uri.opaque) {
            ret = this.schemeSpecificPart.compareTo(uri.schemeSpecificPart);
            if (ret != 0) {
                return ret;
            }
        } else {
            if (this.authority != null && uri.authority == null) {
                return 1;
            }
            if (this.authority == null && uri.authority != null) {
                return -1;
            }
            if (this.authority != null && uri.authority != null) {
                if (this.host != null && uri.host != null) {
                    if (this.userInfo != null && uri.userInfo == null) {
                        return 1;
                    }
                    if (this.userInfo == null && uri.userInfo != null) {
                        return -1;
                    }
                    if (this.userInfo != null && uri.userInfo != null && (ret = this.userInfo.compareTo(uri.userInfo)) != 0) {
                        return ret;
                    }
                    ret = this.host.compareToIgnoreCase(uri.host);
                    if (ret != 0) {
                        return ret;
                    }
                    if (this.port != uri.port) {
                        return this.port - uri.port;
                    }
                } else {
                    ret = this.authority.compareTo(uri.authority);
                    if (ret != 0) {
                        return ret;
                    }
                }
            }
            if ((ret = this.path.compareTo(uri.path)) != 0) {
                return ret;
            }
            if (this.query != null && uri.query == null) {
                return 1;
            }
            if (this.query == null && uri.query != null) {
                return -1;
            }
            if (this.query != null && uri.query != null && (ret = this.query.compareTo(uri.query)) != 0) {
                return ret;
            }
        }
        if (this.fragment != null && uri.fragment == null) {
            return 1;
        }
        if (this.fragment == null && uri.fragment != null) {
            return -1;
        }
        if (this.fragment != null && uri.fragment != null && (ret = this.fragment.compareTo(uri.fragment)) != 0) {
            return ret;
        }
        return 0;
    }

    public static URI create(String uri) {
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    private URI duplicate() {
        URI clone = new URI();
        clone.absolute = this.absolute;
        clone.authority = this.authority;
        clone.fragment = this.fragment;
        clone.host = this.host;
        clone.opaque = this.opaque;
        clone.path = this.path;
        clone.port = this.port;
        clone.query = this.query;
        clone.scheme = this.scheme;
        clone.schemeSpecificPart = this.schemeSpecificPart;
        clone.userInfo = this.userInfo;
        clone.serverAuthority = this.serverAuthority;
        return clone;
    }

    private String convertHexToLowerCase(String s) {
        int index;
        StringBuilder result = new StringBuilder("");
        if (s.indexOf(37) == -1) {
            return s;
        }
        int prevIndex = 0;
        while ((index = s.indexOf(37, prevIndex)) != -1) {
            result.append(s.substring(prevIndex, index + 1));
            result.append(s.substring(index + 1, index + 3).toLowerCase(Locale.US));
            prevIndex = index += 3;
        }
        return result.toString();
    }

    private boolean escapedEquals(String first, String second) {
        if (first.length() != second.length()) {
            return false;
        }
        int prevIndex = 0;
        int index1;
        int index;
        while ((index = first.indexOf(37, prevIndex)) == (index1 = second.indexOf(37, prevIndex))) {
            if (index == -1) {
                return first.regionMatches(prevIndex, second, prevIndex, second.length() - prevIndex);
            }
            if (!first.regionMatches(prevIndex, second, prevIndex, index - prevIndex)) {
                return false;
            }
            if (!first.regionMatches(true, index + 1, second, index + 1, 2)) {
                return false;
            }
            prevIndex = index += 3;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (!(o instanceof URI)) {
            return false;
        }
        URI uri = (URI)o;
        if (uri.fragment == null && this.fragment != null || uri.fragment != null && this.fragment == null) {
            return false;
        }
        if (uri.fragment != null && this.fragment != null && !this.escapedEquals(uri.fragment, this.fragment)) {
            return false;
        }
        if (uri.scheme == null && this.scheme != null || uri.scheme != null && this.scheme == null) {
            return false;
        }
        if (uri.scheme != null && this.scheme != null && !uri.scheme.equalsIgnoreCase(this.scheme)) {
            return false;
        }
        if (uri.opaque && this.opaque) {
            return this.escapedEquals(uri.schemeSpecificPart, this.schemeSpecificPart);
        }
        if (!uri.opaque && !this.opaque) {
            if (!this.escapedEquals(this.path, uri.path)) {
                return false;
            }
            if (uri.query != null && this.query == null || uri.query == null && this.query != null) {
                return false;
            }
            if (uri.query != null && this.query != null && !this.escapedEquals(uri.query, this.query)) {
                return false;
            }
            if (uri.authority != null && this.authority == null || uri.authority == null && this.authority != null) {
                return false;
            }
            if (uri.authority != null && this.authority != null) {
                if (uri.host != null && this.host == null || uri.host == null && this.host != null) {
                    return false;
                }
                if (uri.host == null && this.host == null) {
                    return this.escapedEquals(uri.authority, this.authority);
                }
                if (!this.host.equalsIgnoreCase(uri.host)) {
                    return false;
                }
                if (this.port != uri.port) {
                    return false;
                }
                if (uri.userInfo != null && this.userInfo == null || uri.userInfo == null && this.userInfo != null) {
                    return false;
                }
                if (uri.userInfo != null && this.userInfo != null) {
                    return this.escapedEquals(this.userInfo, uri.userInfo);
                }
                return true;
            }
            return true;
        }
        return false;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getSchemeSpecificPart() {
        return this.decode(this.schemeSpecificPart);
    }

    public String getRawSchemeSpecificPart() {
        return this.schemeSpecificPart;
    }

    public String getAuthority() {
        return this.decode(this.authority);
    }

    public String getRawAuthority() {
        return this.authority;
    }

    public String getUserInfo() {
        return this.decode(this.userInfo);
    }

    public String getRawUserInfo() {
        return this.userInfo;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public int getEffectivePort() {
        return URI.getEffectivePort(this.scheme, this.port);
    }

    public static int getEffectivePort(String scheme, int specifiedPort) {
        if (specifiedPort != -1) {
            return specifiedPort;
        }
        if ("http".equalsIgnoreCase(scheme)) {
            return 80;
        }
        if ("https".equalsIgnoreCase(scheme)) {
            return 443;
        }
        return -1;
    }

    public String getPath() {
        return this.decode(this.path);
    }

    public String getRawPath() {
        return this.path;
    }

    public String getQuery() {
        return this.decode(this.query);
    }

    public String getRawQuery() {
        return this.query;
    }

    public String getFragment() {
        return this.decode(this.fragment);
    }

    public String getRawFragment() {
        return this.fragment;
    }

    public int hashCode() {
        if (this.hash == -1) {
            this.hash = this.getHashString().hashCode();
        }
        return this.hash;
    }

    public boolean isAbsolute() {
        return this.absolute;
    }

    public boolean isOpaque() {
        return this.opaque;
    }

    private String normalize(String path, boolean discardRelativePrefix) {
        int slash;
        int colon = (path = UrlUtils.canonicalizePath(path, discardRelativePrefix)).indexOf(58);
        if (colon != -1 && ((slash = path.indexOf(47)) == -1 || colon < slash)) {
            path = "./" + path;
        }
        return path;
    }

    public URI normalize() {
        if (this.opaque) {
            return this;
        }
        String normalizedPath = this.normalize(this.path, false);
        if (this.path.equals(normalizedPath)) {
            return this;
        }
        URI result = this.duplicate();
        result.path = normalizedPath;
        result.setSchemeSpecificPart();
        return result;
    }

    public URI parseServerAuthority() throws URISyntaxException {
        if (!this.serverAuthority) {
            this.parseAuthority(true);
        }
        return this;
    }

    public URI relativize(URI relative) {
        String relativePath;
        if (relative.opaque || this.opaque) {
            return relative;
        }
        if (this.scheme == null ? relative.scheme != null : !this.scheme.equals(relative.scheme)) {
            return relative;
        }
        if (this.authority == null ? relative.authority != null : !this.authority.equals(relative.authority)) {
            return relative;
        }
        String thisPath = this.normalize(this.path, false);
        if (!thisPath.equals(relativePath = this.normalize(relative.path, false)) && !relativePath.startsWith(thisPath = thisPath.substring(0, thisPath.lastIndexOf(47) + 1))) {
            return relative;
        }
        URI result = new URI();
        result.fragment = relative.fragment;
        result.query = relative.query;
        result.path = relativePath.substring(thisPath.length());
        result.setSchemeSpecificPart();
        return result;
    }

    public URI resolve(URI relative) {
        String resolvedPath;
        if (relative.absolute || this.opaque) {
            return relative;
        }
        if (relative.authority != null) {
            URI result = relative.duplicate();
            result.scheme = this.scheme;
            result.absolute = this.absolute;
            return result;
        }
        if (relative.path.isEmpty() && relative.scheme == null && relative.query == null) {
            URI result = this.duplicate();
            result.fragment = relative.fragment;
            return result;
        }
        URI result = this.duplicate();
        result.fragment = relative.fragment;
        result.query = relative.query;
        if (relative.path.startsWith("/")) {
            resolvedPath = relative.path;
        } else if (relative.path.isEmpty()) {
            resolvedPath = this.path;
        } else {
            int endIndex = this.path.lastIndexOf(47) + 1;
            resolvedPath = this.path.substring(0, endIndex) + relative.path;
        }
        result.path = UrlUtils.authoritySafePath(result.authority, this.normalize(resolvedPath, true));
        result.setSchemeSpecificPart();
        return result;
    }

    private void setSchemeSpecificPart() {
        StringBuilder ssp = new StringBuilder();
        if (this.authority != null) {
            ssp.append("//" + this.authority);
        }
        if (this.path != null) {
            ssp.append(this.path);
        }
        if (this.query != null) {
            ssp.append("?" + this.query);
        }
        this.schemeSpecificPart = ssp.toString();
        this.string = null;
    }

    public URI resolve(String relative) {
        return this.resolve(URI.create(relative));
    }

    private String decode(String s) {
        return s != null ? UriCodec.decode(s) : null;
    }

    public String toASCIIString() {
        StringBuilder result = new StringBuilder();
        ASCII_ONLY.appendEncoded(result, this.toString());
        return result.toString();
    }

    public String toString() {
        if (this.string != null) {
            return this.string;
        }
        StringBuilder result = new StringBuilder();
        if (this.scheme != null) {
            result.append(this.scheme);
            result.append(':');
        }
        if (this.opaque) {
            result.append(this.schemeSpecificPart);
        } else {
            if (this.authority != null) {
                result.append("//");
                result.append(this.authority);
            }
            if (this.path != null) {
                result.append(this.path);
            }
            if (this.query != null) {
                result.append('?');
                result.append(this.query);
            }
        }
        if (this.fragment != null) {
            result.append('#');
            result.append(this.fragment);
        }
        this.string = result.toString();
        return this.string;
    }

    private String getHashString() {
        StringBuilder result = new StringBuilder();
        if (this.scheme != null) {
            result.append(this.scheme.toLowerCase(Locale.US));
            result.append(':');
        }
        if (this.opaque) {
            result.append(this.schemeSpecificPart);
        } else {
            if (this.authority != null) {
                result.append("//");
                if (this.host == null) {
                    result.append(this.authority);
                } else {
                    if (this.userInfo != null) {
                        result.append(this.userInfo + "@");
                    }
                    result.append(this.host.toLowerCase(Locale.US));
                    if (this.port != -1) {
                        result.append(":" + this.port);
                    }
                }
            }
            if (this.path != null) {
                result.append(this.path);
            }
            if (this.query != null) {
                result.append('?');
                result.append(this.query);
            }
        }
        if (this.fragment != null) {
            result.append('#');
            result.append(this.fragment);
        }
        return this.convertHexToLowerCase(result.toString());
    }

    public URL toURL() throws MalformedURLException {
        if (!this.absolute) {
            throw new IllegalArgumentException("URI is not absolute: " + this.toString());
        }
        return new URL(this.toString());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        try {
            this.parseURI(this.string, false);
        }
        catch (URISyntaxException e) {
            throw new IOException(e.toString());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException, ClassNotFoundException {
        this.toString();
        out.defaultWriteObject();
    }

    private static class PartEncoder
    extends UriCodec {
        private final String extraLegalCharacters;

        PartEncoder(String extraLegalCharacters) {
            this.extraLegalCharacters = extraLegalCharacters;
        }

        @Override
        protected boolean isRetained(char c) {
            return URI.UNRESERVED.indexOf(c) != -1 || URI.PUNCTUATION.indexOf(c) != -1 || this.extraLegalCharacters.indexOf(c) != -1 || c > '\u007f' && !Character.isSpaceChar(c) && !Character.isISOControl(c);
        }
    }
}

