/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.ReadOnlyBufferException;

final class CharArrayBuffer
extends CharBuffer {
    private final char[] backingArray;
    private final int arrayOffset;
    private final boolean isReadOnly;

    CharArrayBuffer(char[] array2) {
        this(array2.length, array2, 0, false);
    }

    private CharArrayBuffer(int capacity, char[] backingArray, int arrayOffset, boolean isReadOnly) {
        super(capacity, 0L);
        this.backingArray = backingArray;
        this.arrayOffset = arrayOffset;
        this.isReadOnly = isReadOnly;
    }

    private static CharArrayBuffer copy(CharArrayBuffer other, int markOfOther, boolean isReadOnly) {
        CharArrayBuffer buf = new CharArrayBuffer(other.capacity(), other.backingArray, other.arrayOffset, isReadOnly);
        buf.limit = other.limit;
        buf.position = other.position();
        buf.mark = markOfOther;
        return buf;
    }

    @Override
    public CharBuffer asReadOnlyBuffer() {
        return CharArrayBuffer.copy(this, this.mark, true);
    }

    @Override
    public CharBuffer compact() {
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        System.arraycopy((char[])this.backingArray, (int)(this.position + this.arrayOffset), (char[])this.backingArray, (int)this.arrayOffset, (int)this.remaining());
        this.position = this.limit - this.position;
        this.limit = this.capacity;
        this.mark = -1;
        return this;
    }

    @Override
    public CharBuffer duplicate() {
        return CharArrayBuffer.copy(this, this.mark, this.isReadOnly);
    }

    @Override
    public CharBuffer slice() {
        return new CharArrayBuffer(this.remaining(), this.backingArray, this.arrayOffset + this.position, this.isReadOnly);
    }

    @Override
    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    @Override
    char[] protectedArray() {
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        return this.backingArray;
    }

    @Override
    int protectedArrayOffset() {
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        return this.arrayOffset;
    }

    @Override
    boolean protectedHasArray() {
        return !this.isReadOnly;
    }

    @Override
    public final char get() {
        if (this.position == this.limit) {
            throw new BufferUnderflowException();
        }
        return this.backingArray[this.arrayOffset + this.position++];
    }

    @Override
    public final char get(int index) {
        this.checkIndex(index);
        return this.backingArray[this.arrayOffset + index];
    }

    @Override
    public final CharBuffer get(char[] dst, int srcOffset, int charCount) {
        if (charCount > this.remaining()) {
            throw new BufferUnderflowException();
        }
        System.arraycopy((char[])this.backingArray, (int)(this.arrayOffset + this.position), (char[])dst, (int)srcOffset, (int)charCount);
        this.position += charCount;
        return this;
    }

    @Override
    public final boolean isDirect() {
        return false;
    }

    @Override
    public final ByteOrder order() {
        return ByteOrder.nativeOrder();
    }

    @Override
    public final CharBuffer subSequence(int start, int end) {
        this.checkStartEndRemaining(start, end);
        CharBuffer result = this.duplicate();
        result.limit(this.position + end);
        result.position(this.position + start);
        return result;
    }

    @Override
    public CharBuffer put(char c) {
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        if (this.position == this.limit) {
            throw new BufferOverflowException();
        }
        this.backingArray[this.arrayOffset + this.position++] = c;
        return this;
    }

    @Override
    public CharBuffer put(int index, char c) {
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        this.checkIndex(index);
        this.backingArray[this.arrayOffset + index] = c;
        return this;
    }

    @Override
    public CharBuffer put(char[] src, int srcOffset, int charCount) {
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        if (charCount > this.remaining()) {
            throw new BufferOverflowException();
        }
        System.arraycopy((char[])src, (int)srcOffset, (char[])this.backingArray, (int)(this.arrayOffset + this.position), (int)charCount);
        this.position += charCount;
        return this;
    }

    @Override
    public final String toString() {
        return String.copyValueOf(this.backingArray, this.arrayOffset + this.position, this.remaining());
    }
}

