/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.DoubleArrayBuffer;
import java.nio.ReadOnlyBufferException;
import java.util.Arrays;

public abstract class DoubleBuffer
extends Buffer
implements Comparable<DoubleBuffer> {
    public static DoubleBuffer allocate(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("capacity < 0: " + capacity);
        }
        return new DoubleArrayBuffer(new double[capacity]);
    }

    public static DoubleBuffer wrap(double[] array2) {
        return DoubleBuffer.wrap(array2, 0, array2.length);
    }

    public static DoubleBuffer wrap(double[] array2, int start, int doubleCount) {
        Arrays.checkOffsetAndCount(array2.length, start, doubleCount);
        DoubleArrayBuffer buf = new DoubleArrayBuffer(array2);
        buf.position = start;
        buf.limit = start + doubleCount;
        return buf;
    }

    DoubleBuffer(int capacity, long effectiveDirectAddress) {
        super(3, capacity, effectiveDirectAddress);
    }

    public final double[] array() {
        return this.protectedArray();
    }

    @Override
    public final int arrayOffset() {
        return this.protectedArrayOffset();
    }

    public abstract DoubleBuffer asReadOnlyBuffer();

    public abstract DoubleBuffer compact();

    @Override
    public int compareTo(DoubleBuffer otherBuffer) {
        int thisPos = this.position;
        int otherPos = otherBuffer.position;
        for (int compareRemaining = this.remaining() < otherBuffer.remaining() ? this.remaining() : otherBuffer.remaining(); compareRemaining > 0; --compareRemaining) {
            double otherDouble;
            double thisDouble = this.get(thisPos);
            if (thisDouble != (otherDouble = otherBuffer.get(otherPos)) && (thisDouble == thisDouble || otherDouble == otherDouble)) {
                return thisDouble < otherDouble ? -1 : 1;
            }
            ++thisPos;
            ++otherPos;
        }
        return this.remaining() - otherBuffer.remaining();
    }

    public abstract DoubleBuffer duplicate();

    public boolean equals(Object other) {
        if (!(other instanceof DoubleBuffer)) {
            return false;
        }
        DoubleBuffer otherBuffer = (DoubleBuffer)other;
        if (this.remaining() != otherBuffer.remaining()) {
            return false;
        }
        int myPosition = this.position;
        int otherPosition = otherBuffer.position;
        boolean equalSoFar = true;
        while (equalSoFar && myPosition < this.limit) {
            double b;
            double a;
            equalSoFar = (a = this.get(myPosition++)) == (b = otherBuffer.get(otherPosition++)) || a != a && b != b;
        }
        return equalSoFar;
    }

    public abstract double get();

    public DoubleBuffer get(double[] dst) {
        return this.get(dst, 0, dst.length);
    }

    public DoubleBuffer get(double[] dst, int dstOffset, int doubleCount) {
        Arrays.checkOffsetAndCount(dst.length, dstOffset, doubleCount);
        if (doubleCount > this.remaining()) {
            throw new BufferUnderflowException();
        }
        for (int i = dstOffset; i < dstOffset + doubleCount; ++i) {
            dst[i] = this.get();
        }
        return this;
    }

    public abstract double get(int var1);

    @Override
    public final boolean hasArray() {
        return this.protectedHasArray();
    }

    public int hashCode() {
        int myPosition = this.position;
        int hash = 0;
        while (myPosition < this.limit) {
            long l = Double.doubleToLongBits(this.get(myPosition++));
            hash = hash + (int)l ^ (int)(l >> 32);
        }
        return hash;
    }

    @Override
    public abstract boolean isDirect();

    public abstract ByteOrder order();

    abstract double[] protectedArray();

    abstract int protectedArrayOffset();

    abstract boolean protectedHasArray();

    public abstract DoubleBuffer put(double var1);

    public final DoubleBuffer put(double[] src) {
        return this.put(src, 0, src.length);
    }

    public DoubleBuffer put(double[] src, int srcOffset, int doubleCount) {
        Arrays.checkOffsetAndCount(src.length, srcOffset, doubleCount);
        if (doubleCount > this.remaining()) {
            throw new BufferOverflowException();
        }
        for (int i = srcOffset; i < srcOffset + doubleCount; ++i) {
            this.put(src[i]);
        }
        return this;
    }

    public DoubleBuffer put(DoubleBuffer src) {
        if (this.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        if (src == this) {
            throw new IllegalArgumentException("src == this");
        }
        if (src.remaining() > this.remaining()) {
            throw new BufferOverflowException();
        }
        double[] doubles = new double[src.remaining()];
        src.get(doubles);
        this.put(doubles);
        return this;
    }

    public abstract DoubleBuffer put(int var1, double var2);

    public abstract DoubleBuffer slice();
}

