/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.nio.ByteBuffer;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.ProtectionDomain;
import java.util.HashMap;

public class SecureClassLoader
extends ClassLoader {
    private HashMap<CodeSource, ProtectionDomain> pds = new HashMap();

    protected SecureClassLoader() {
    }

    protected SecureClassLoader(ClassLoader parent) {
        super(parent);
    }

    protected PermissionCollection getPermissions(CodeSource codesource) {
        return new Permissions();
    }

    protected final Class<?> defineClass(String name, byte[] b, int off, int len, CodeSource cs) {
        return cs == null ? this.defineClass(name, b, off, len) : this.defineClass(name, b, off, len, this.getPD(cs));
    }

    protected final Class<?> defineClass(String name, ByteBuffer b, CodeSource cs) {
        byte[] data = b.array();
        return cs == null ? this.defineClass(name, data, 0, data.length) : this.defineClass(name, data, 0, data.length, this.getPD(cs));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProtectionDomain getPD(CodeSource cs) {
        ProtectionDomain pd;
        if (cs == null) {
            return null;
        }
        HashMap<CodeSource, ProtectionDomain> hashMap = this.pds;
        synchronized (hashMap) {
            pd = this.pds.get(cs);
            if (pd != null) {
                return pd;
            }
            PermissionCollection perms = this.getPermissions(cs);
            pd = new ProtectionDomain(cs, perms, this, null);
            this.pds.put(cs, pd);
        }
        return pd;
    }
}

