/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.nio.ByteOrder;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandomSpi;
import java.security.Security;
import java.util.Random;
import libcore.io.Memory;
import org.apache.harmony.security.fortress.Engine;
import org.apache.harmony.security.fortress.Services;
import org.apache.harmony.security.provider.crypto.SHA1PRNG_SecureRandomImpl;

public class SecureRandom
extends Random {
    private static final long serialVersionUID = 4940670005562187L;
    private static final String SERVICE = "SecureRandom";
    private static final Engine ENGINE = new Engine("SecureRandom");
    private final Provider provider;
    private final SecureRandomSpi secureRandomSpi;
    private final String algorithm;
    private static volatile SecureRandom internalSecureRandom;

    public SecureRandom() {
        super(0L);
        Provider.Service service = Services.getSecureRandomService();
        if (service == null) {
            this.provider = null;
            this.secureRandomSpi = new SHA1PRNG_SecureRandomImpl();
            this.algorithm = "SHA1PRNG";
        } else {
            try {
                this.provider = service.getProvider();
                this.secureRandomSpi = (SecureRandomSpi)service.newInstance(null);
                this.algorithm = service.getAlgorithm();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public SecureRandom(byte[] seed) {
        this();
        this.setSeed(seed);
    }

    protected SecureRandom(SecureRandomSpi secureRandomSpi, Provider provider) {
        this(secureRandomSpi, provider, "unknown");
    }

    private SecureRandom(SecureRandomSpi secureRandomSpi, Provider provider, String algorithm) {
        super(0L);
        this.provider = provider;
        this.algorithm = algorithm;
        this.secureRandomSpi = secureRandomSpi;
    }

    public static SecureRandom getInstance(String algorithm) throws NoSuchAlgorithmException {
        if (algorithm == null) {
            throw new NullPointerException("algorithm == null");
        }
        Engine.SpiAndProvider sap = ENGINE.getInstance(algorithm, null);
        return new SecureRandom((SecureRandomSpi)sap.spi, sap.provider, algorithm);
    }

    public static SecureRandom getInstance(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (provider == null || provider.isEmpty()) {
            throw new IllegalArgumentException();
        }
        Provider p = Security.getProvider(provider);
        if (p == null) {
            throw new NoSuchProviderException(provider);
        }
        return SecureRandom.getInstance(algorithm, p);
    }

    public static SecureRandom getInstance(String algorithm, Provider provider) throws NoSuchAlgorithmException {
        if (provider == null) {
            throw new IllegalArgumentException("provider == null");
        }
        if (algorithm == null) {
            throw new NullPointerException("algorithm == null");
        }
        Object spi = ENGINE.getInstance(algorithm, provider, null);
        return new SecureRandom((SecureRandomSpi)spi, provider, algorithm);
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public synchronized void setSeed(byte[] seed) {
        this.secureRandomSpi.engineSetSeed(seed);
    }

    @Override
    public void setSeed(long seed) {
        if (seed == 0L) {
            return;
        }
        byte[] byteSeed = new byte[8];
        Memory.pokeLong(byteSeed, 0, seed, ByteOrder.BIG_ENDIAN);
        this.setSeed(byteSeed);
    }

    @Override
    public synchronized void nextBytes(byte[] bytes) {
        this.secureRandomSpi.engineNextBytes(bytes);
    }

    @Override
    protected final int next(int numBits) {
        if (numBits < 0) {
            numBits = 0;
        } else if (numBits > 32) {
            numBits = 32;
        }
        int bytes = (numBits + 7) / 8;
        byte[] next = new byte[bytes];
        int ret = 0;
        this.nextBytes(next);
        for (int i = 0; i < bytes; ++i) {
            ret = next[i] & 0xFF | ret << 8;
        }
        return ret >>>= bytes * 8 - numBits;
    }

    public static byte[] getSeed(int numBytes) {
        SecureRandom result = internalSecureRandom;
        if (result == null) {
            internalSecureRandom = result = new SecureRandom();
        }
        return result.generateSeed(numBytes);
    }

    public byte[] generateSeed(int numBytes) {
        return this.secureRandomSpi.engineGenerateSeed(numBytes);
    }
}

