/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;

public final class SignedObject
implements Serializable {
    private static final long serialVersionUID = 720502720485447167L;
    private byte[] content;
    private byte[] signature;
    private String thealgorithm;

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        byte[] tmp = new byte[this.content.length];
        System.arraycopy((byte[])this.content, (int)0, (byte[])tmp, (int)0, (int)this.content.length);
        this.content = tmp;
        tmp = new byte[this.signature.length];
        System.arraycopy((byte[])this.signature, (int)0, (byte[])tmp, (int)0, (int)this.signature.length);
        this.signature = tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SignedObject(Serializable object, PrivateKey signingKey, Signature signingEngine) throws IOException, InvalidKeyException, SignatureException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
            oos.writeObject(object);
            oos.flush();
        }
        this.content = baos.toByteArray();
        signingEngine.initSign(signingKey);
        this.thealgorithm = signingEngine.getAlgorithm();
        signingEngine.update(this.content);
        this.signature = signingEngine.sign();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject() throws IOException, ClassNotFoundException {
        try (ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(this.content));){
            Object object = ois.readObject();
            return object;
        }
    }

    public byte[] getSignature() {
        byte[] sig = new byte[this.signature.length];
        System.arraycopy((byte[])this.signature, (int)0, (byte[])sig, (int)0, (int)this.signature.length);
        return sig;
    }

    public String getAlgorithm() {
        return this.thealgorithm;
    }

    public boolean verify(PublicKey verificationKey, Signature verificationEngine) throws InvalidKeyException, SignatureException {
        verificationEngine.initVerify(verificationKey);
        verificationEngine.update(this.content);
        return verificationEngine.verify(this.signature);
    }
}

