/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class Hashtable<K, V>
extends Dictionary<K, V>
implements Map<K, V>,
Cloneable,
Serializable {
    private static final int MINIMUM_CAPACITY = 4;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final Map.Entry[] EMPTY_TABLE = new HashtableEntry[2];
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private transient HashtableEntry<K, V>[] table;
    private transient int size;
    private transient int modCount;
    private transient int threshold;
    private transient Set<K> keySet;
    private transient Set<Map.Entry<K, V>> entrySet;
    private transient Collection<V> values;
    private static final int CHARS_PER_ENTRY = 15;
    private static final long serialVersionUID = 1421746759512286392L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("threshold", Integer.TYPE), new ObjectStreamField("loadFactor", Float.TYPE)};

    public Hashtable() {
        this.table = (HashtableEntry[])EMPTY_TABLE;
        this.threshold = -1;
    }

    public Hashtable(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Capacity: " + capacity);
        }
        if (capacity == 0) {
            HashtableEntry[] tab = (HashtableEntry[])EMPTY_TABLE;
            this.table = tab;
            this.threshold = -1;
            return;
        }
        capacity = capacity < 4 ? 4 : (capacity > 0x40000000 ? 0x40000000 : Collections.roundUpToPowerOfTwo(capacity));
        this.makeTable(capacity);
    }

    public Hashtable(int capacity, float loadFactor) {
        this(capacity);
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Load factor: " + loadFactor);
        }
    }

    public Hashtable(Map<? extends K, ? extends V> map) {
        this(Hashtable.capacityForInitSize(map.size()));
        super.constructorPutAll(map);
    }

    private void constructorPutAll(Map<? extends K, ? extends V> map) {
        if (this.table == EMPTY_TABLE) {
            this.doubleCapacity();
        }
        for (Map.Entry<K, V> e : map.entrySet()) {
            this.constructorPut(e.getKey(), e.getValue());
        }
    }

    private static int capacityForInitSize(int size) {
        int result = (size >> 1) + size;
        return (result & 0xC0000000) == 0 ? result : 0x40000000;
    }

    public synchronized Object clone() {
        Hashtable result;
        try {
            result = (Hashtable)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
        result.makeTable(this.table.length);
        result.size = 0;
        result.keySet = null;
        result.entrySet = null;
        result.values = null;
        result.constructorPutAll(this);
        return result;
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public synchronized int size() {
        return this.size;
    }

    @Override
    public synchronized V get(Object key) {
        int hash = Collections.secondaryHash(key);
        HashtableEntry<K, V>[] tab = this.table;
        HashtableEntry<K, V> e = tab[hash & tab.length - 1];
        while (e != null) {
            Object eKey = e.key;
            if (eKey == key || e.hash == hash && key.equals(eKey)) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    @Override
    public synchronized boolean containsKey(Object key) {
        int hash = Collections.secondaryHash(key);
        HashtableEntry<K, V>[] tab = this.table;
        HashtableEntry<K, V> e = tab[hash & tab.length - 1];
        while (e != null) {
            Object eKey = e.key;
            if (eKey == key || e.hash == hash && key.equals(eKey)) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    @Override
    public synchronized boolean containsValue(Object value) {
        if (value == null) {
            throw new NullPointerException("value == null");
        }
        for (HashtableEntry<K, V> e : this.table) {
            while (e != null) {
                if (value.equals(e.value)) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    public boolean contains(Object value) {
        return this.containsValue(value);
    }

    @Override
    public synchronized V put(K key, V value) {
        HashtableEntry<K, V> first;
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        if (value == null) {
            throw new NullPointerException("value == null");
        }
        int hash = Collections.secondaryHash(key);
        HashtableEntry<K, V>[] tab = this.table;
        int index = hash & tab.length - 1;
        HashtableEntry<K, V> e = first = tab[index];
        while (e != null) {
            if (e.hash == hash && key.equals(e.key)) {
                Object oldValue = e.value;
                e.value = value;
                return oldValue;
            }
            e = e.next;
        }
        ++this.modCount;
        if (this.size++ > this.threshold) {
            this.rehash();
            tab = this.doubleCapacity();
            index = hash & tab.length - 1;
            first = tab[index];
        }
        tab[index] = new HashtableEntry<K, V>(key, value, hash, first);
        return null;
    }

    private void constructorPut(K key, V value) {
        HashtableEntry<K, V> first;
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        if (value == null) {
            throw new NullPointerException("value == null");
        }
        int hash = Collections.secondaryHash(key);
        HashtableEntry<K, V>[] tab = this.table;
        int index = hash & tab.length - 1;
        HashtableEntry<K, V> e = first = tab[index];
        while (e != null) {
            if (e.hash == hash && key.equals(e.key)) {
                e.value = value;
                return;
            }
            e = e.next;
        }
        tab[index] = new HashtableEntry<K, V>(key, value, hash, first);
        ++this.size;
    }

    @Override
    public synchronized void putAll(Map<? extends K, ? extends V> map) {
        this.ensureCapacity(map.size());
        for (Map.Entry<K, V> e : map.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    private void ensureCapacity(int numMappings) {
        HashtableEntry<K, V>[] oldTable;
        int oldCapacity;
        int newCapacity = Collections.roundUpToPowerOfTwo(Hashtable.capacityForInitSize(numMappings));
        if (newCapacity <= (oldCapacity = (oldTable = this.table).length)) {
            return;
        }
        this.rehash();
        if (newCapacity == oldCapacity * 2) {
            this.doubleCapacity();
            return;
        }
        HashtableEntry<K, V>[] newTable = this.makeTable(newCapacity);
        if (this.size != 0) {
            int newMask = newCapacity - 1;
            for (int i = 0; i < oldCapacity; ++i) {
                HashtableEntry<K, V> e = oldTable[i];
                while (e != null) {
                    HashtableEntry oldNext = e.next;
                    int newIndex = e.hash & newMask;
                    HashtableEntry<K, V> newNext = newTable[newIndex];
                    newTable[newIndex] = e;
                    e.next = newNext;
                    e = oldNext;
                }
            }
        }
    }

    protected void rehash() {
    }

    private HashtableEntry<K, V>[] makeTable(int newCapacity) {
        HashtableEntry[] newTable = new HashtableEntry[newCapacity];
        this.table = newTable;
        this.threshold = (newCapacity >> 1) + (newCapacity >> 2);
        return newTable;
    }

    private HashtableEntry<K, V>[] doubleCapacity() {
        HashtableEntry<K, V>[] oldTable = this.table;
        int oldCapacity = oldTable.length;
        if (oldCapacity == 0x40000000) {
            return oldTable;
        }
        int newCapacity = oldCapacity * 2;
        HashtableEntry<K, V>[] newTable = this.makeTable(newCapacity);
        if (this.size == 0) {
            return newTable;
        }
        for (int j = 0; j < oldCapacity; ++j) {
            HashtableEntry<K, V> e = oldTable[j];
            if (e == null) continue;
            int highBit = e.hash & oldCapacity;
            HashtableEntry<K, V> broken = null;
            newTable[j | highBit] = e;
            HashtableEntry n = e.next;
            while (n != null) {
                int nextHighBit = n.hash & oldCapacity;
                if (nextHighBit != highBit) {
                    if (broken == null) {
                        newTable[j | nextHighBit] = n;
                    } else {
                        broken.next = n;
                    }
                    broken = e;
                    highBit = nextHighBit;
                }
                e = n;
                n = n.next;
            }
            if (broken == null) continue;
            broken.next = null;
        }
        return newTable;
    }

    @Override
    public synchronized V remove(Object key) {
        int hash = Collections.secondaryHash(key);
        HashtableEntry<K, V>[] tab = this.table;
        int index = hash & tab.length - 1;
        HashtableEntry<K, V> e = tab[index];
        HashtableEntry<K, V> prev = null;
        while (e != null) {
            if (e.hash == hash && key.equals(e.key)) {
                if (prev == null) {
                    tab[index] = e.next;
                } else {
                    prev.next = e.next;
                }
                ++this.modCount;
                --this.size;
                return e.value;
            }
            prev = e;
            e = e.next;
        }
        return null;
    }

    @Override
    public synchronized void clear() {
        if (this.size != 0) {
            Arrays.fill(this.table, null);
            ++this.modCount;
            this.size = 0;
        }
    }

    @Override
    public synchronized Set<K> keySet() {
        KeySet ks = this.keySet;
        return ks != null ? ks : (this.keySet = new KeySet());
    }

    @Override
    public synchronized Collection<V> values() {
        Values vs = this.values;
        return vs != null ? vs : (this.values = new Values());
    }

    @Override
    public synchronized Set<Map.Entry<K, V>> entrySet() {
        EntrySet es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySet());
    }

    @Override
    public synchronized Enumeration<K> keys() {
        return new KeyEnumeration();
    }

    @Override
    public synchronized Enumeration<V> elements() {
        return new ValueEnumeration();
    }

    private synchronized boolean containsMapping(Object key, Object value) {
        int hash = Collections.secondaryHash(key);
        HashtableEntry<K, V>[] tab = this.table;
        int index = hash & tab.length - 1;
        HashtableEntry<K, V> e = tab[index];
        while (e != null) {
            if (e.hash == hash && e.key.equals(key)) {
                return e.value.equals(value);
            }
            e = e.next;
        }
        return false;
    }

    private synchronized boolean removeMapping(Object key, Object value) {
        int hash = Collections.secondaryHash(key);
        HashtableEntry<K, V>[] tab = this.table;
        int index = hash & tab.length - 1;
        HashtableEntry<K, V> e = tab[index];
        HashtableEntry<K, V> prev = null;
        while (e != null) {
            if (e.hash == hash && e.key.equals(key)) {
                if (!e.value.equals(value)) {
                    return false;
                }
                if (prev == null) {
                    tab[index] = e.next;
                } else {
                    prev.next = e.next;
                }
                ++this.modCount;
                --this.size;
                return true;
            }
            prev = e;
            e = e.next;
        }
        return false;
    }

    @Override
    public synchronized boolean equals(Object object) {
        return object instanceof Map && this.entrySet().equals(((Map)object).entrySet());
    }

    @Override
    public synchronized int hashCode() {
        int result = 0;
        for (Map.Entry<K, V> e : this.entrySet()) {
            K key = e.getKey();
            V value = e.getValue();
            if (key == this || value == this) continue;
            result += (key != null ? key.hashCode() : 0) ^ (value != null ? value.hashCode() : 0);
        }
        return result;
    }

    public synchronized String toString() {
        StringBuilder result = new StringBuilder(15 * this.size);
        result.append('{');
        Iterator<Map.Entry<K, V>> i = this.entrySet().iterator();
        boolean hasMore = i.hasNext();
        while (hasMore) {
            Map.Entry<K, V> entry = i.next();
            K key = entry.getKey();
            result.append(key == this ? "(this Map)" : key.toString());
            result.append('=');
            V value = entry.getValue();
            result.append(value == this ? "(this Map)" : value.toString());
            hasMore = i.hasNext();
            if (!hasMore) continue;
            result.append(", ");
        }
        result.append('}');
        return result.toString();
    }

    private synchronized void writeObject(ObjectOutputStream stream) throws IOException {
        ObjectOutputStream.PutField fields = stream.putFields();
        fields.put("threshold", (int)(0.75f * (float)this.table.length));
        fields.put("loadFactor", 0.75f);
        stream.writeFields();
        stream.writeInt(this.table.length);
        stream.writeInt(this.size);
        for (Map.Entry<K, V> e : this.entrySet()) {
            stream.writeObject(e.getKey());
            stream.writeObject(e.getValue());
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int capacity = stream.readInt();
        if (capacity < 0) {
            throw new InvalidObjectException("Capacity: " + capacity);
        }
        capacity = capacity < 4 ? 4 : (capacity > 0x40000000 ? 0x40000000 : Collections.roundUpToPowerOfTwo(capacity));
        this.makeTable(capacity);
        int size = stream.readInt();
        if (size < 0) {
            throw new InvalidObjectException("Size: " + size);
        }
        for (int i = 0; i < size; ++i) {
            Object key = stream.readObject();
            Object val = stream.readObject();
            this.constructorPut(key, val);
        }
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return Hashtable.this.containsMapping(e.getKey(), e.getValue());
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return Hashtable.this.removeMapping(e.getKey(), e.getValue());
        }

        @Override
        public int size() {
            return Hashtable.this.size();
        }

        @Override
        public void clear() {
            Hashtable.this.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean removeAll(Collection<?> collection) {
            Hashtable hashtable = Hashtable.this;
            synchronized (hashtable) {
                return super.removeAll(collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean retainAll(Collection<?> collection) {
            Hashtable hashtable = Hashtable.this;
            synchronized (hashtable) {
                return super.retainAll(collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsAll(Collection<?> collection) {
            Hashtable hashtable = Hashtable.this;
            synchronized (hashtable) {
                return super.containsAll(collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean equals(Object object) {
            Hashtable hashtable = Hashtable.this;
            synchronized (hashtable) {
                return super.equals(object);
            }
        }

        @Override
        public int hashCode() {
            return Hashtable.this.hashCode();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String toString() {
            Hashtable hashtable = Hashtable.this;
            synchronized (hashtable) {
                return super.toString();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object[] toArray() {
            Hashtable hashtable = Hashtable.this;
            synchronized (hashtable) {
                return super.toArray();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T[] toArray(T[] a) {
            Hashtable hashtable = Hashtable.this;
            synchronized (hashtable) {
                return super.toArray(a);
            }
        }
    }

    private final class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return Hashtable.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return Hashtable.this.containsValue(o);
        }

        @Override
        public void clear() {
            Hashtable.this.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsAll(Collection<?> collection) {
            Hashtable hashtable = Hashtable.this;
            synchronized (hashtable) {
                return super.containsAll(collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String toString() {
            Hashtable hashtable = Hashtable.this;
            synchronized (hashtable) {
                return super.toString();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object[] toArray() {
            Hashtable hashtable = Hashtable.this;
            synchronized (hashtable) {
                return super.toArray();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T[] toArray(T[] a) {
            Hashtable hashtable = Hashtable.this;
            synchronized (hashtable) {
                return super.toArray(a);
            }
        }
    }

    private final class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return Hashtable.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return Hashtable.this.containsKey(o);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Object o) {
            Hashtable hashtable = Hashtable.this;
            synchronized (hashtable) {
                int oldSize = Hashtable.this.size;
                Hashtable.this.remove(o);
                return Hashtable.this.size != oldSize;
            }
        }

        @Override
        public void clear() {
            Hashtable.this.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean removeAll(Collection<?> collection) {
            Hashtable hashtable = Hashtable.this;
            synchronized (hashtable) {
                return super.removeAll(collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean retainAll(Collection<?> collection) {
            Hashtable hashtable = Hashtable.this;
            synchronized (hashtable) {
                return super.retainAll(collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsAll(Collection<?> collection) {
            Hashtable hashtable = Hashtable.this;
            synchronized (hashtable) {
                return super.containsAll(collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean equals(Object object) {
            Hashtable hashtable = Hashtable.this;
            synchronized (hashtable) {
                return super.equals(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int hashCode() {
            Hashtable hashtable = Hashtable.this;
            synchronized (hashtable) {
                return super.hashCode();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String toString() {
            Hashtable hashtable = Hashtable.this;
            synchronized (hashtable) {
                return super.toString();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object[] toArray() {
            Hashtable hashtable = Hashtable.this;
            synchronized (hashtable) {
                return super.toArray();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T[] toArray(T[] a) {
            Hashtable hashtable = Hashtable.this;
            synchronized (hashtable) {
                return super.toArray(a);
            }
        }
    }

    private final class ValueEnumeration
    extends HashIterator
    implements Enumeration<V> {
        private ValueEnumeration() {
        }

        @Override
        public boolean hasMoreElements() {
            return this.hasNext();
        }

        @Override
        public V nextElement() {
            return this.nextEntryNotFailFast().value;
        }
    }

    private final class KeyEnumeration
    extends HashIterator
    implements Enumeration<K> {
        private KeyEnumeration() {
        }

        @Override
        public boolean hasMoreElements() {
            return this.hasNext();
        }

        @Override
        public K nextElement() {
            return this.nextEntryNotFailFast().key;
        }
    }

    private final class EntryIterator
    extends HashIterator
    implements Iterator<Map.Entry<K, V>> {
        private EntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            return this.nextEntry();
        }
    }

    private final class ValueIterator
    extends HashIterator
    implements Iterator<V> {
        private ValueIterator() {
        }

        @Override
        public V next() {
            return this.nextEntry().value;
        }
    }

    private final class KeyIterator
    extends HashIterator
    implements Iterator<K> {
        private KeyIterator() {
        }

        @Override
        public K next() {
            return this.nextEntry().key;
        }
    }

    private abstract class HashIterator {
        int nextIndex;
        HashtableEntry<K, V> nextEntry;
        HashtableEntry<K, V> lastEntryReturned;
        int expectedModCount;

        HashIterator() {
            this.expectedModCount = Hashtable.this.modCount;
            HashtableEntry[] tab = Hashtable.this.table;
            HashtableEntry next = null;
            while (next == null && this.nextIndex < tab.length) {
                next = tab[this.nextIndex++];
            }
            this.nextEntry = next;
        }

        public boolean hasNext() {
            return this.nextEntry != null;
        }

        HashtableEntry<K, V> nextEntry() {
            if (Hashtable.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.nextEntry == null) {
                throw new NoSuchElementException();
            }
            HashtableEntry entryToReturn = this.nextEntry;
            HashtableEntry[] tab = Hashtable.this.table;
            HashtableEntry next = entryToReturn.next;
            while (next == null && this.nextIndex < tab.length) {
                next = tab[this.nextIndex++];
            }
            this.nextEntry = next;
            this.lastEntryReturned = entryToReturn;
            return this.lastEntryReturned;
        }

        HashtableEntry<K, V> nextEntryNotFailFast() {
            if (this.nextEntry == null) {
                throw new NoSuchElementException();
            }
            HashtableEntry entryToReturn = this.nextEntry;
            HashtableEntry[] tab = Hashtable.this.table;
            HashtableEntry next = entryToReturn.next;
            while (next == null && this.nextIndex < tab.length) {
                next = tab[this.nextIndex++];
            }
            this.nextEntry = next;
            this.lastEntryReturned = entryToReturn;
            return this.lastEntryReturned;
        }

        public void remove() {
            if (this.lastEntryReturned == null) {
                throw new IllegalStateException();
            }
            if (Hashtable.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Hashtable.this.remove(this.lastEntryReturned.key);
            this.lastEntryReturned = null;
            this.expectedModCount = Hashtable.this.modCount;
        }
    }

    private static class HashtableEntry<K, V>
    implements Map.Entry<K, V> {
        final K key;
        V value;
        final int hash;
        HashtableEntry<K, V> next;

        HashtableEntry(K key, V value, int hash, HashtableEntry<K, V> next) {
            this.key = key;
            this.value = value;
            this.hash = hash;
            this.next = next;
        }

        @Override
        public final K getKey() {
            return this.key;
        }

        @Override
        public final V getValue() {
            return this.value;
        }

        @Override
        public final V setValue(V value) {
            if (value == null) {
                throw new NullPointerException("value == null");
            }
            V oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        @Override
        public final boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return this.key.equals(e.getKey()) && this.value.equals(e.getValue());
        }

        @Override
        public final int hashCode() {
            return this.key.hashCode() ^ this.value.hashCode();
        }

        public final String toString() {
            return this.key + "=" + this.value;
        }
    }
}

