/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.NoSuchElementException;

final class MiniEnumSet<E extends Enum<E>>
extends EnumSet<E> {
    private static final int MAX_ELEMENTS = 64;
    private int size;
    private final E[] enums;
    private long bits;

    MiniEnumSet(Class<E> elementType, E[] enums) {
        super(elementType);
        this.enums = enums;
    }

    @Override
    public Iterator<E> iterator() {
        return new MiniEnumSetIterator();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        this.bits = 0L;
        this.size = 0;
    }

    @Override
    public boolean add(E element) {
        this.elementClass.cast(element);
        long oldBits = this.bits;
        long newBits = oldBits | 1L << ((Enum)element).ordinal();
        if (oldBits != newBits) {
            this.bits = newBits;
            ++this.size;
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        if (collection.isEmpty()) {
            return false;
        }
        if (collection instanceof EnumSet) {
            long newBits;
            EnumSet set = (EnumSet)collection;
            set.elementClass.asSubclass(this.elementClass);
            MiniEnumSet miniSet = (MiniEnumSet)set;
            long oldBits = this.bits;
            this.bits = newBits = oldBits | miniSet.bits;
            this.size = Long.bitCount(newBits);
            return oldBits != newBits;
        }
        return super.addAll(collection);
    }

    @Override
    public boolean contains(Object object) {
        if (object == null || !this.isValidType(object.getClass())) {
            return false;
        }
        Enum element = (Enum)object;
        int ordinal = element.ordinal();
        return (this.bits & 1L << ordinal) != 0L;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        if (collection.isEmpty()) {
            return true;
        }
        if (collection instanceof MiniEnumSet) {
            MiniEnumSet set = (MiniEnumSet)collection;
            long setBits = set.bits;
            return this.isValidType(set.elementClass) && (this.bits & setBits) == setBits;
        }
        return !(collection instanceof EnumSet) && super.containsAll(collection);
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        if (collection.isEmpty()) {
            return false;
        }
        if (collection instanceof EnumSet) {
            EnumSet set = (EnumSet)collection;
            if (!this.isValidType(set.elementClass)) {
                return false;
            }
            MiniEnumSet miniSet = (MiniEnumSet)set;
            long oldBits = this.bits;
            long newBits = oldBits & (miniSet.bits ^ 0xFFFFFFFFFFFFFFFFL);
            if (oldBits != newBits) {
                this.bits = newBits;
                this.size = Long.bitCount(newBits);
                return true;
            }
            return false;
        }
        return super.removeAll(collection);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        if (collection instanceof EnumSet) {
            EnumSet set = (EnumSet)collection;
            if (!this.isValidType(set.elementClass)) {
                if (this.size > 0) {
                    this.clear();
                    return true;
                }
                return false;
            }
            MiniEnumSet miniSet = (MiniEnumSet)set;
            long oldBits = this.bits;
            long newBits = oldBits & miniSet.bits;
            if (oldBits != newBits) {
                this.bits = newBits;
                this.size = Long.bitCount(newBits);
                return true;
            }
            return false;
        }
        return super.retainAll(collection);
    }

    @Override
    public boolean remove(Object object) {
        if (object == null || !this.isValidType(object.getClass())) {
            return false;
        }
        long oldBits = this.bits;
        Enum element = (Enum)object;
        int ordinal = element.ordinal();
        long newBits = oldBits & (1L << ordinal ^ 0xFFFFFFFFFFFFFFFFL);
        if (oldBits != newBits) {
            this.bits = newBits;
            --this.size;
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof EnumSet)) {
            return super.equals(object);
        }
        EnumSet set = (EnumSet)object;
        if (!this.isValidType(set.elementClass)) {
            return this.size == 0 && set.isEmpty();
        }
        return this.bits == ((MiniEnumSet)set).bits;
    }

    @Override
    void complement() {
        if (this.enums.length != 0) {
            this.bits ^= 0xFFFFFFFFFFFFFFFFL;
            this.bits &= -1L >>> 64 - this.enums.length;
            this.size = this.enums.length - this.size;
        }
    }

    @Override
    void setRange(E start, E end) {
        int length = ((Enum)end).ordinal() - ((Enum)start).ordinal() + 1;
        long range = -1L >>> 64 - length << ((Enum)start).ordinal();
        this.bits |= range;
        this.size = Long.bitCount(this.bits);
    }

    private class MiniEnumSetIterator
    implements Iterator<E> {
        private long currentBits;
        private long mask;
        private E last;

        private MiniEnumSetIterator() {
            this.currentBits = MiniEnumSet.this.bits;
            this.mask = this.currentBits & -this.currentBits;
        }

        @Override
        public boolean hasNext() {
            return this.mask != 0L;
        }

        @Override
        public E next() {
            if (this.mask == 0L) {
                throw new NoSuchElementException();
            }
            int ordinal = Long.numberOfTrailingZeros(this.mask);
            this.last = MiniEnumSet.this.enums[ordinal];
            this.currentBits &= this.mask ^ 0xFFFFFFFFFFFFFFFFL;
            this.mask = this.currentBits & -this.currentBits;
            return this.last;
        }

        @Override
        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException();
            }
            MiniEnumSet.this.remove(this.last);
            this.last = null;
        }
    }
}

