/*
 * Decompiled with CFR 0.152.
 */
package java.util.jar;

import java.io.IOException;
import java.security.CodeSigner;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.JarVerifier;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;

public class JarEntry
extends ZipEntry {
    private Attributes attributes;
    final JarFile parentJar;
    CodeSigner[] signers;
    private CertificateFactory factory;
    private boolean isFactoryChecked = false;

    public JarEntry(String name) {
        super(name);
        this.parentJar = null;
    }

    public JarEntry(ZipEntry entry) {
        this(entry, null);
    }

    JarEntry(ZipEntry entry, JarFile parentJar) {
        super(entry);
        this.parentJar = parentJar;
    }

    public JarEntry(JarEntry je) {
        super(je);
        this.parentJar = je.parentJar;
        this.attributes = je.attributes;
        this.signers = je.signers;
    }

    public Attributes getAttributes() throws IOException {
        if (this.attributes != null || this.parentJar == null) {
            return this.attributes;
        }
        Manifest manifest = this.parentJar.getManifest();
        if (manifest == null) {
            return null;
        }
        this.attributes = manifest.getAttributes(this.getName());
        return this.attributes;
    }

    public Certificate[] getCertificates() {
        if (this.parentJar == null) {
            return null;
        }
        JarVerifier jarVerifier = this.parentJar.verifier;
        if (jarVerifier == null) {
            return null;
        }
        Certificate[][] certChains = jarVerifier.getCertificateChains(this.getName());
        if (certChains == null) {
            return null;
        }
        int count = 0;
        for (Certificate[] chain : certChains) {
            count += chain.length;
        }
        Certificate[] certs = new Certificate[count];
        int i = 0;
        for (Certificate[] chain : certChains) {
            System.arraycopy(chain, 0, certs, i, chain.length);
            i += chain.length;
        }
        return certs;
    }

    void setAttributes(Attributes attrib) {
        this.attributes = attrib;
    }

    public CodeSigner[] getCodeSigners() {
        if (this.parentJar == null) {
            return null;
        }
        JarVerifier jarVerifier = this.parentJar.verifier;
        if (jarVerifier == null) {
            return null;
        }
        if (this.signers == null) {
            this.signers = this.getCodeSigners(jarVerifier.getCertificateChains(this.getName()));
        }
        if (this.signers == null) {
            return null;
        }
        return (CodeSigner[])this.signers.clone();
    }

    private CodeSigner[] getCodeSigners(Certificate[][] certChains) {
        if (certChains == null) {
            return null;
        }
        ArrayList<CodeSigner> asigners = new ArrayList<CodeSigner>(certChains.length);
        for (Certificate[] chain : certChains) {
            this.addCodeSigner(asigners, chain);
        }
        CodeSigner[] tmp = new CodeSigner[asigners.size()];
        asigners.toArray(tmp);
        return tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCodeSigner(ArrayList<CodeSigner> asigners, Certificate[] certs) {
        for (Certificate cert : certs) {
            if (cert instanceof X509Certificate) continue;
            return;
        }
        CertPath certPath = null;
        if (!this.isFactoryChecked) {
            try {
                this.factory = CertificateFactory.getInstance("X.509");
            }
            catch (CertificateException certificateException) {
            }
            finally {
                this.isFactoryChecked = true;
            }
        }
        if (this.factory == null) {
            return;
        }
        try {
            certPath = this.factory.generateCertPath(Arrays.asList(certs));
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
        if (certPath != null) {
            asigners.add(new CodeSigner(certPath, null));
        }
    }
}

