/*
 * Decompiled with CFR 0.152.
 */
package java.util.regex;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.PatternSyntaxException;
import java.util.regex.Splitter;

public final class Pattern
implements Serializable {
    private static final long serialVersionUID = 5073258162644648461L;
    public static final int UNIX_LINES = 1;
    public static final int CASE_INSENSITIVE = 2;
    public static final int COMMENTS = 4;
    public static final int MULTILINE = 8;
    public static final int LITERAL = 16;
    public static final int DOTALL = 32;
    public static final int UNICODE_CASE = 64;
    public static final int CANON_EQ = 128;
    private final String pattern;
    private final int flags;
    transient long address;

    public Matcher matcher(CharSequence input) {
        return new Matcher(this, input);
    }

    public String[] split(CharSequence input, int limit) {
        return Splitter.split(this, this.pattern, input.toString(), limit);
    }

    public String[] split(CharSequence input) {
        return this.split(input, 0);
    }

    public String pattern() {
        return this.pattern;
    }

    public String toString() {
        return this.pattern;
    }

    public int flags() {
        return this.flags;
    }

    public static Pattern compile(String regularExpression, int flags) throws PatternSyntaxException {
        return new Pattern(regularExpression, flags);
    }

    public static Pattern compile(String pattern) {
        return new Pattern(pattern, 0);
    }

    private Pattern(String pattern, int flags) throws PatternSyntaxException {
        if ((flags & 0x80) != 0) {
            throw new UnsupportedOperationException("CANON_EQ flag not supported");
        }
        int supportedFlags = 127;
        if ((flags & ~supportedFlags) != 0) {
            throw new IllegalArgumentException("Unsupported flags: " + (flags & ~supportedFlags));
        }
        this.pattern = pattern;
        this.flags = flags;
        this.compile();
    }

    private void compile() throws PatternSyntaxException {
        if (this.pattern == null) {
            throw new NullPointerException("pattern == null");
        }
        String icuPattern = this.pattern;
        if ((this.flags & 0x10) != 0) {
            icuPattern = Pattern.quote(this.pattern);
        }
        int icuFlags = this.flags & 0x2F;
        this.address = Pattern.compileImpl(icuPattern, icuFlags);
    }

    public static boolean matches(String regularExpression, CharSequence input) {
        return new Matcher(new Pattern(regularExpression, 0), input).matches();
    }

    public static String quote(String string2) {
        int k;
        StringBuilder sb = new StringBuilder();
        sb.append("\\Q");
        int apos = 0;
        while ((k = string2.indexOf("\\E", apos)) >= 0) {
            sb.append(string2.substring(apos, k + 2)).append("\\\\E\\Q");
            apos = k + 2;
        }
        return sb.append(string2.substring(apos)).append("\\E").toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            Pattern.closeImpl(this.address);
        }
        finally {
            super.finalize();
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.compile();
    }

    private static native void closeImpl(long var0);

    private static native long compileImpl(String var0, int var1);
}

