/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import javax.crypto.Cipher;
import javax.crypto.NullCipher;
import javax.crypto.ShortBufferException;
import libcore.io.Streams;

public class CipherInputStream
extends FilterInputStream {
    private final Cipher cipher;
    private final byte[] inputBuffer;
    private byte[] outputBuffer;
    private int outputIndex;
    private int outputLength;
    private boolean finished;

    public CipherInputStream(InputStream is, Cipher c) {
        super(is);
        this.cipher = c;
        int blockSize = Math.max(c.getBlockSize(), 1);
        int bufferSize = Math.max(blockSize, 8192 / blockSize * blockSize);
        this.inputBuffer = new byte[bufferSize];
        this.outputBuffer = new byte[bufferSize + (blockSize > 1 ? 2 * blockSize : 0)];
    }

    protected CipherInputStream(InputStream is) {
        this(is, new NullCipher());
    }

    private boolean fillBuffer() throws IOException {
        if (this.finished) {
            return false;
        }
        this.outputIndex = 0;
        this.outputLength = 0;
        while (this.outputLength == 0) {
            int byteCount;
            int outputSize = this.cipher.getOutputSize(this.inputBuffer.length);
            if (this.outputBuffer == null || this.outputBuffer.length < outputSize) {
                this.outputBuffer = new byte[outputSize];
            }
            if ((byteCount = this.in.read(this.inputBuffer)) == -1) {
                try {
                    this.outputLength = this.cipher.doFinal(this.outputBuffer, 0);
                }
                catch (Exception e) {
                    throw new IOException("Error while finalizing cipher", e);
                }
                this.finished = true;
                return this.outputLength != 0;
            }
            try {
                this.outputLength = this.cipher.update(this.inputBuffer, 0, byteCount, this.outputBuffer, 0);
            }
            catch (ShortBufferException e) {
                throw new AssertionError((Object)e);
            }
        }
        return true;
    }

    @Override
    public int read() throws IOException {
        if (this.in == null) {
            throw new NullPointerException("in == null");
        }
        if (this.outputIndex == this.outputLength && !this.fillBuffer()) {
            return -1;
        }
        return this.outputBuffer[this.outputIndex++] & 0xFF;
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        if (this.in == null) {
            throw new NullPointerException("in == null");
        }
        if (this.outputIndex == this.outputLength && !this.fillBuffer()) {
            return -1;
        }
        int available = this.outputLength - this.outputIndex;
        if (available < len) {
            len = available;
        }
        if (buf != null) {
            System.arraycopy((byte[])this.outputBuffer, (int)this.outputIndex, (byte[])buf, (int)off, (int)len);
        }
        this.outputIndex += len;
        return len;
    }

    @Override
    public long skip(long byteCount) throws IOException {
        return Streams.skipByReading(this, byteCount);
    }

    @Override
    public int available() throws IOException {
        return this.outputLength - this.outputIndex;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
        try {
            this.cipher.doFinal();
        }
        catch (GeneralSecurityException generalSecurityException) {
            // empty catch block
        }
    }

    @Override
    public boolean markSupported() {
        return false;
    }
}

