/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto.spec;

import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;

public class GCMParameterSpec
implements AlgorithmParameterSpec {
    private final int tagLen;
    private final byte[] iv;

    public GCMParameterSpec(int tagLen, byte[] iv) {
        if (tagLen < 0) {
            throw new IllegalArgumentException("tag should be a non-negative integer");
        }
        if (iv == null) {
            throw new IllegalArgumentException("iv == null");
        }
        this.tagLen = tagLen;
        this.iv = (byte[])iv.clone();
    }

    public GCMParameterSpec(int tagLen, byte[] iv, int offset, int byteCount) {
        if (tagLen < 0) {
            throw new IllegalArgumentException("tag should be a non-negative integer");
        }
        if (iv == null) {
            throw new IllegalArgumentException("iv == null");
        }
        try {
            Arrays.checkOffsetAndCount(iv.length, offset, byteCount);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException(e);
        }
        this.tagLen = tagLen;
        this.iv = Arrays.copyOfRange(iv, offset, offset + byteCount);
    }

    public int getTLen() {
        return this.tagLen;
    }

    public byte[] getIV() {
        return (byte[])this.iv.clone();
    }
}

