/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.x500;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.Principal;
import java.util.Map;
import org.apache.harmony.security.x501.Name;

public final class X500Principal
implements Serializable,
Principal {
    private static final long serialVersionUID = -500463348111345721L;
    public static final String CANONICAL = "CANONICAL";
    public static final String RFC1779 = "RFC1779";
    public static final String RFC2253 = "RFC2253";
    private transient Name dn;
    private transient String canonicalName;

    public X500Principal(byte[] name) {
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        try {
            this.dn = (Name)Name.ASN1.decode(name);
        }
        catch (IOException e) {
            throw this.incorrectInputEncoding(e);
        }
    }

    public X500Principal(InputStream in) {
        if (in == null) {
            throw new NullPointerException("in == null");
        }
        try {
            this.dn = (Name)Name.ASN1.decode(in);
        }
        catch (IOException e) {
            throw this.incorrectInputEncoding(e);
        }
    }

    private IllegalArgumentException incorrectInputEncoding(IOException e) {
        IllegalArgumentException iae = new IllegalArgumentException("Incorrect input encoding");
        iae.initCause(e);
        throw iae;
    }

    public X500Principal(String name) {
        if (name == null) {
            throw new NullPointerException("name == null");
        }
        try {
            this.dn = new Name(name);
        }
        catch (IOException e) {
            throw this.incorrectInputName(e, name);
        }
    }

    public X500Principal(String name, Map<String, String> keywordMap) {
        if (name == null) {
            throw new NullPointerException("name == null");
        }
        try {
            this.dn = new Name(this.substituteNameFromMap(name, keywordMap));
        }
        catch (IOException e) {
            throw this.incorrectInputName(e, name);
        }
    }

    private IllegalArgumentException incorrectInputName(IOException e, String name) {
        IllegalArgumentException iae = new IllegalArgumentException("Incorrect input name:" + name);
        iae.initCause(e);
        throw iae;
    }

    private synchronized String getCanonicalName() {
        if (this.canonicalName == null) {
            this.canonicalName = this.dn.getName(CANONICAL);
        }
        return this.canonicalName;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        X500Principal principal = (X500Principal)o;
        return this.getCanonicalName().equals(principal.getCanonicalName());
    }

    public byte[] getEncoded() {
        byte[] src = this.dn.getEncoded();
        byte[] dst = new byte[src.length];
        System.arraycopy((byte[])src, (int)0, (byte[])dst, (int)0, (int)dst.length);
        return dst;
    }

    @Override
    public String getName() {
        return this.dn.getName(RFC2253);
    }

    public String getName(String format) {
        if (CANONICAL.equals(format)) {
            return this.getCanonicalName();
        }
        return this.dn.getName(format);
    }

    public String getName(String format, Map<String, String> oidMap) {
        String rfc1779Name = this.dn.getName(RFC1779);
        String rfc2253Name = this.dn.getName(RFC2253);
        if (format.equalsIgnoreCase(RFC1779)) {
            StringBuilder resultName = new StringBuilder(rfc1779Name);
            int fromIndex = resultName.length();
            int equalIndex = -1;
            while (-1 != (equalIndex = resultName.lastIndexOf("=", fromIndex))) {
                String subSubName;
                int commaIndex = resultName.lastIndexOf(",", equalIndex);
                String subName = resultName.substring(commaIndex + 1, equalIndex).trim();
                if (subName.length() > 4 && subName.substring(0, 4).equals("OID.") && oidMap.containsKey(subSubName = subName.substring(4))) {
                    String replaceName = oidMap.get(subSubName);
                    if (commaIndex > 0) {
                        replaceName = " " + replaceName;
                    }
                    resultName.replace(commaIndex + 1, equalIndex, replaceName);
                }
                fromIndex = commaIndex;
            }
            return resultName.toString();
        }
        if (format.equalsIgnoreCase(RFC2253)) {
            StringBuilder resultName = new StringBuilder(rfc2253Name);
            StringBuilder subsidyName = new StringBuilder(rfc1779Name);
            int fromIndex = resultName.length();
            int subsidyFromIndex = subsidyName.length();
            int equalIndex = -1;
            int subsidyEqualIndex = -1;
            while (-1 != (equalIndex = resultName.lastIndexOf("=", fromIndex))) {
                subsidyEqualIndex = subsidyName.lastIndexOf("=", subsidyFromIndex);
                int commaIndex = resultName.lastIndexOf(",", equalIndex);
                String subName = resultName.substring(commaIndex + 1, equalIndex).trim();
                if (oidMap.containsKey(subName)) {
                    int subGoalEndIndex;
                    int subOrignalEndIndex = resultName.indexOf(",", equalIndex);
                    if (subOrignalEndIndex == -1) {
                        subOrignalEndIndex = resultName.length();
                    }
                    if ((subGoalEndIndex = subsidyName.indexOf(",", subsidyEqualIndex)) == -1) {
                        subGoalEndIndex = subsidyName.length();
                    }
                    resultName.replace(equalIndex + 1, subOrignalEndIndex, subsidyName.substring(subsidyEqualIndex + 1, subGoalEndIndex));
                    resultName.replace(commaIndex + 1, equalIndex, oidMap.get(subName));
                }
                fromIndex = commaIndex;
                subsidyFromIndex = subsidyEqualIndex - 1;
            }
            return resultName.toString();
        }
        throw new IllegalArgumentException("invalid format specified: " + format);
    }

    @Override
    public int hashCode() {
        return this.getCanonicalName().hashCode();
    }

    @Override
    public String toString() {
        return this.dn.getName(RFC1779);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.dn.getEncoded());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.dn = (Name)Name.ASN1.decode((byte[])in.readObject());
    }

    private String substituteNameFromMap(String name, Map<String, String> keywordMap) {
        int equalIndex;
        StringBuilder sbName = new StringBuilder(name);
        int fromIndex = sbName.length();
        while (-1 != (equalIndex = sbName.lastIndexOf("=", fromIndex))) {
            int commaIndex = sbName.lastIndexOf(",", equalIndex);
            String subName = sbName.substring(commaIndex + 1, equalIndex).trim();
            if (keywordMap.containsKey(subName)) {
                sbName.replace(commaIndex + 1, equalIndex, keywordMap.get(subName));
            }
            fromIndex = commaIndex;
        }
        return sbName.toString();
    }
}

