/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.datatype;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Properties;
import libcore.io.IoUtils;

final class FactoryFinder {
    private static final String CLASS_NAME = "javax.xml.datatype.FactoryFinder";
    private static boolean debug = false;
    private static Properties cacheProps = new Properties();
    private static boolean firstTime = true;
    private static final int DEFAULT_LINE_LENGTH = 80;

    private FactoryFinder() {
    }

    private static void debugPrintln(String msg) {
        if (debug) {
            System.err.println("javax.xml.datatype.FactoryFinder:" + msg);
        }
    }

    private static ClassLoader findClassLoader() throws ConfigurationError {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (debug) {
            FactoryFinder.debugPrintln("Using context class loader: " + classLoader);
        }
        if (classLoader == null) {
            classLoader = FactoryFinder.class.getClassLoader();
            if (debug) {
                FactoryFinder.debugPrintln("Using the class loader of FactoryFinder: " + classLoader);
            }
        }
        return classLoader;
    }

    static Object newInstance(String className, ClassLoader classLoader) throws ConfigurationError {
        try {
            Class<?> spiClass = classLoader == null ? Class.forName(className) : classLoader.loadClass(className);
            if (debug) {
                FactoryFinder.debugPrintln("Loaded " + className + " from " + FactoryFinder.which(spiClass));
            }
            return spiClass.newInstance();
        }
        catch (ClassNotFoundException x) {
            throw new ConfigurationError("Provider " + className + " not found", x);
        }
        catch (Exception x) {
            throw new ConfigurationError("Provider " + className + " could not be instantiated: " + x, x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object find(String factoryId, String fallbackClassName) throws ConfigurationError {
        Object provider;
        ClassLoader classLoader;
        block16: {
            classLoader = FactoryFinder.findClassLoader();
            String systemProp = System.getProperty(factoryId);
            if (systemProp != null && systemProp.length() > 0) {
                if (debug) {
                    FactoryFinder.debugPrintln("found " + systemProp + " in the system property " + factoryId);
                }
                return FactoryFinder.newInstance(systemProp, classLoader);
            }
            try {
                String javah = System.getProperty("java.home");
                String configFile = javah + File.separator + "lib" + File.separator + "jaxp.properties";
                String factoryClassName = null;
                if (firstTime) {
                    Properties properties = cacheProps;
                    synchronized (properties) {
                        if (firstTime) {
                            File f = new File(configFile);
                            firstTime = false;
                            if (f.exists()) {
                                if (debug) {
                                    FactoryFinder.debugPrintln("Read properties file " + f);
                                }
                                cacheProps.load(new FileInputStream(f));
                            }
                        }
                    }
                }
                factoryClassName = cacheProps.getProperty(factoryId);
                if (debug) {
                    FactoryFinder.debugPrintln("found " + factoryClassName + " in $java.home/jaxp.properties");
                }
                if (factoryClassName != null) {
                    return FactoryFinder.newInstance(factoryClassName, classLoader);
                }
            }
            catch (Exception ex) {
                if (!debug) break block16;
                ex.printStackTrace();
            }
        }
        if ((provider = FactoryFinder.findJarServiceProvider(factoryId)) != null) {
            return provider;
        }
        if (fallbackClassName == null) {
            throw new ConfigurationError("Provider for " + factoryId + " cannot be found", null);
        }
        if (debug) {
            FactoryFinder.debugPrintln("loaded from fallback value: " + fallbackClassName);
        }
        return FactoryFinder.newInstance(fallbackClassName, classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object findJarServiceProvider(String factoryId) throws ConfigurationError {
        BufferedReader rd;
        String serviceId = "META-INF/services/" + factoryId;
        InputStream is = null;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl != null) {
            is = cl.getResourceAsStream(serviceId);
        }
        if (is == null) {
            cl = FactoryFinder.class.getClassLoader();
            is = cl.getResourceAsStream(serviceId);
        }
        if (is == null) {
            return null;
        }
        if (debug) {
            FactoryFinder.debugPrintln("found jar resource=" + serviceId + " using ClassLoader: " + cl);
        }
        try {
            rd = new BufferedReader(new InputStreamReader(is, "UTF-8"), 80);
        }
        catch (UnsupportedEncodingException e) {
            rd = new BufferedReader(new InputStreamReader(is), 80);
        }
        String factoryClassName = null;
        try {
            factoryClassName = rd.readLine();
        }
        catch (IOException x) {
            Object var7_8 = null;
            return var7_8;
        }
        finally {
            IoUtils.closeQuietly(rd);
        }
        if (factoryClassName != null && !"".equals(factoryClassName)) {
            if (debug) {
                FactoryFinder.debugPrintln("found in resource, value=" + factoryClassName);
            }
            return FactoryFinder.newInstance(factoryClassName, cl);
        }
        return null;
    }

    private static String which(Class clazz) {
        block5: {
            try {
                String classnameAsResource = clazz.getName().replace('.', '/') + ".class";
                ClassLoader loader = clazz.getClassLoader();
                URL it = loader != null ? loader.getResource(classnameAsResource) : ClassLoader.getSystemResource(classnameAsResource);
                if (it != null) {
                    return it.toString();
                }
            }
            catch (VirtualMachineError vme) {
                throw vme;
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                if (!debug) break block5;
                t.printStackTrace();
            }
        }
        return "unknown location";
    }

    static {
        String val = System.getProperty("jaxp.debug");
        debug = val != null && !"false".equals(val);
    }

    static class ConfigurationError
    extends Error {
        private static final long serialVersionUID = -3644413026244211347L;
        private Exception exception;

        ConfigurationError(String msg, Exception x) {
            super(msg);
            this.exception = x;
        }

        Exception getException() {
            return this.exception;
        }
    }
}

