/*
 * Decompiled with CFR 0.152.
 */
package libcore.icu;

import com.google.errorprone.annotations.DoNotMock;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import libcore.util.BasicLruCache;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class DateIntervalFormat
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int FORMAT_SHOW_TIME = 1;
    public static int FORMAT_SHOW_WEEKDAY = 2;
    public static int FORMAT_SHOW_YEAR = 4;
    public static int FORMAT_NO_YEAR = 8;
    public static int FORMAT_SHOW_DATE = 16;
    public static int FORMAT_NO_MONTH_DAY = 32;
    public static int FORMAT_12HOUR = 64;
    public static int FORMAT_24HOUR = 128;
    public static int FORMAT_UTC = 8192;
    public static int FORMAT_ABBREV_TIME = 16384;
    public static int FORMAT_ABBREV_WEEKDAY = 32768;
    public static int FORMAT_ABBREV_MONTH = 65536;
    public static int FORMAT_NUMERIC_DATE = 131072;
    public static int FORMAT_ABBREV_ALL = 524288;
    private static int DAY_IN_MS = 86400000;
    private static int EPOCH_JULIAN_DAY = 2440588;
    private static FormatterCache CACHED_FORMATTERS;

    private void $$robo$$libcore_icu_DateIntervalFormat$__constructor__() {
    }

    private static final String $$robo$$libcore_icu_DateIntervalFormat$formatDateRange(long startMs, long endMs, int flags, String olsonId) {
        if ((flags & 0x2000) != 0) {
            olsonId = "UTC";
        }
        TimeZone tz = olsonId != null ? TimeZone.getTimeZone(olsonId) : TimeZone.getDefault();
        return DateIntervalFormat.formatDateRange(Locale.getDefault(), tz, startMs, endMs, flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String $$robo$$libcore_icu_DateIntervalFormat$formatDateRange(Locale locale, TimeZone tz, long startMs, long endMs, int flags) {
        Calendar endCalendar;
        Calendar startCalendar = Calendar.getInstance(tz);
        startCalendar.setTimeInMillis(startMs);
        if (startMs == endMs) {
            endCalendar = startCalendar;
        } else {
            endCalendar = Calendar.getInstance(tz);
            endCalendar.setTimeInMillis(endMs);
        }
        boolean endsAtMidnight = DateIntervalFormat.isMidnight(endCalendar);
        if (startMs != endMs && endsAtMidnight && ((flags & 1) == 0 || DateIntervalFormat.dayDistance(startCalendar, endCalendar) <= 1)) {
            endCalendar.roll(5, false);
            endMs -= 86400000L;
        }
        String skeleton = DateIntervalFormat.toSkeleton(startCalendar, endCalendar, flags);
        FormatterCache formatterCache = CACHED_FORMATTERS;
        synchronized (formatterCache) {
            return DateIntervalFormat.formatDateInterval(DateIntervalFormat.getFormatter(skeleton, locale.toString(), tz.getID()), startMs, endMs);
        }
    }

    private static final long $$robo$$libcore_icu_DateIntervalFormat$getFormatter(String skeleton, String localeName, String tzName) {
        String key = skeleton + "\t" + localeName + "\t" + tzName;
        Long formatter = (Long)CACHED_FORMATTERS.get(key);
        if (formatter != null) {
            return formatter;
        }
        long address = DateIntervalFormat.createDateIntervalFormat(skeleton, localeName, tzName);
        CACHED_FORMATTERS.put(key, address);
        return address;
    }

    private static final String $$robo$$libcore_icu_DateIntervalFormat$toSkeleton(Calendar startCalendar, Calendar endCalendar, int flags) {
        if ((flags & 0x80000) != 0) {
            flags |= 0x1C000;
        }
        String monthPart = "MMMM";
        if ((flags & 0x20000) != 0) {
            monthPart = "M";
        } else if ((flags & 0x10000) != 0) {
            monthPart = "MMM";
        }
        String weekPart = "EEEE";
        if ((flags & 0x8000) != 0) {
            weekPart = "EEE";
        }
        String timePart = "j";
        if ((flags & 0x80) != 0) {
            timePart = "H";
        } else if ((flags & 0x40) != 0) {
            timePart = "h";
        }
        if ((flags & 0x4000) == 0 || (flags & 0x80) != 0) {
            timePart = timePart + "m";
        } else if (!DateIntervalFormat.onTheHour(startCalendar) || !DateIntervalFormat.onTheHour(endCalendar)) {
            timePart = timePart + "m";
        }
        if (DateIntervalFormat.fallOnDifferentDates(startCalendar, endCalendar)) {
            flags |= 0x10;
        }
        if (DateIntervalFormat.fallInSameMonth(startCalendar, endCalendar) && (flags & 0x20) != 0) {
            flags &= 0xFFFFFFFD;
            flags &= 0xFFFFFFFE;
        }
        if ((flags & 0x13) == 0) {
            flags |= 0x10;
        }
        if (!((flags & 0x10) == 0 || (flags & 4) != 0 || (flags & 8) != 0 || DateIntervalFormat.fallInSameYear(startCalendar, endCalendar) && DateIntervalFormat.isThisYear(startCalendar))) {
            flags |= 4;
        }
        StringBuilder builder = new StringBuilder();
        if ((flags & 0x30) != 0) {
            if ((flags & 4) != 0) {
                builder.append("y");
            }
            builder.append(monthPart);
            if ((flags & 0x20) == 0) {
                builder.append("d");
            }
        }
        if ((flags & 2) != 0) {
            builder.append(weekPart);
        }
        if ((flags & 1) != 0) {
            builder.append(timePart);
        }
        return builder.toString();
    }

    private static final boolean $$robo$$libcore_icu_DateIntervalFormat$isMidnight(Calendar c) {
        return c.get(11) == 0 && c.get(12) == 0 && c.get(13) == 0 && c.get(14) == 0;
    }

    private static final boolean $$robo$$libcore_icu_DateIntervalFormat$onTheHour(Calendar c) {
        return c.get(12) == 0 && c.get(13) == 0;
    }

    private static final boolean $$robo$$libcore_icu_DateIntervalFormat$fallOnDifferentDates(Calendar c1, Calendar c2) {
        return c1.get(1) != c2.get(1) || c1.get(2) != c2.get(2) || c1.get(5) != c2.get(5);
    }

    private static final boolean $$robo$$libcore_icu_DateIntervalFormat$fallInSameMonth(Calendar c1, Calendar c2) {
        return c1.get(2) == c2.get(2);
    }

    private static final boolean $$robo$$libcore_icu_DateIntervalFormat$fallInSameYear(Calendar c1, Calendar c2) {
        return c1.get(1) == c2.get(1);
    }

    private static final boolean $$robo$$libcore_icu_DateIntervalFormat$isThisYear(Calendar c) {
        Calendar now = Calendar.getInstance(c.getTimeZone());
        return c.get(1) == now.get(1);
    }

    private static final int $$robo$$libcore_icu_DateIntervalFormat$dayDistance(Calendar c1, Calendar c2) {
        return DateIntervalFormat.julianDay(c2) - DateIntervalFormat.julianDay(c1);
    }

    private static final int $$robo$$libcore_icu_DateIntervalFormat$julianDay(Calendar c) {
        long utcMs = c.getTimeInMillis() + (long)c.get(15) + (long)c.get(16);
        return (int)(utcMs / 86400000L) + 2440588;
    }

    private static final long $$robo$$libcore_icu_DateIntervalFormat$createDateIntervalFormat(String string2, String string3, String string4) {
        return 0L;
    }

    private static final void $$robo$$libcore_icu_DateIntervalFormat$destroyDateIntervalFormat(long l) {
    }

    private static final String $$robo$$libcore_icu_DateIntervalFormat$formatDateInterval(long l, long l2, long l3) {
        return null;
    }

    static void __staticInitializer__() {
        CACHED_FORMATTERS = new FormatterCache();
    }

    private void __constructor__() {
        this.$$robo$$libcore_icu_DateIntervalFormat$__constructor__();
    }

    private DateIntervalFormat() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$libcore_icu_DateIntervalFormat$__constructor__(), 0, this);
    }

    public static String formatDateRange(long l, long l2, int n, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("formatDateRange", $$robo$$libcore_icu_DateIntervalFormat$formatDateRange(long long int java.lang.String ), 0, (long)l, (long)l2, (int)n, (String)string2);
    }

    public static String formatDateRange(Locale locale, TimeZone timeZone, long l, long l2, int n) {
        return InvokeDynamicSupport.bootstrapStatic("formatDateRange", $$robo$$libcore_icu_DateIntervalFormat$formatDateRange(java.util.Locale java.util.TimeZone long long int ), 0, (Locale)locale, (TimeZone)timeZone, (long)l, (long)l2, (int)n);
    }

    private static long getFormatter(String string2, String string3, String string4) {
        return (long)InvokeDynamicSupport.bootstrapStatic("getFormatter", $$robo$$libcore_icu_DateIntervalFormat$getFormatter(java.lang.String java.lang.String java.lang.String ), 0, (String)string2, (String)string3, (String)string4);
    }

    private static String toSkeleton(Calendar calendar, Calendar calendar2, int n) {
        return InvokeDynamicSupport.bootstrapStatic("toSkeleton", $$robo$$libcore_icu_DateIntervalFormat$toSkeleton(java.util.Calendar java.util.Calendar int ), 0, (Calendar)calendar, (Calendar)calendar2, (int)n);
    }

    private static boolean isMidnight(Calendar calendar) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isMidnight", $$robo$$libcore_icu_DateIntervalFormat$isMidnight(java.util.Calendar ), 0, (Calendar)calendar);
    }

    private static boolean onTheHour(Calendar calendar) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("onTheHour", $$robo$$libcore_icu_DateIntervalFormat$onTheHour(java.util.Calendar ), 0, (Calendar)calendar);
    }

    private static boolean fallOnDifferentDates(Calendar calendar, Calendar calendar2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("fallOnDifferentDates", $$robo$$libcore_icu_DateIntervalFormat$fallOnDifferentDates(java.util.Calendar java.util.Calendar ), 0, (Calendar)calendar, (Calendar)calendar2);
    }

    private static boolean fallInSameMonth(Calendar calendar, Calendar calendar2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("fallInSameMonth", $$robo$$libcore_icu_DateIntervalFormat$fallInSameMonth(java.util.Calendar java.util.Calendar ), 0, (Calendar)calendar, (Calendar)calendar2);
    }

    private static boolean fallInSameYear(Calendar calendar, Calendar calendar2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("fallInSameYear", $$robo$$libcore_icu_DateIntervalFormat$fallInSameYear(java.util.Calendar java.util.Calendar ), 0, (Calendar)calendar, (Calendar)calendar2);
    }

    private static boolean isThisYear(Calendar calendar) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isThisYear", $$robo$$libcore_icu_DateIntervalFormat$isThisYear(java.util.Calendar ), 0, (Calendar)calendar);
    }

    private static int dayDistance(Calendar calendar, Calendar calendar2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("dayDistance", $$robo$$libcore_icu_DateIntervalFormat$dayDistance(java.util.Calendar java.util.Calendar ), 0, (Calendar)calendar, (Calendar)calendar2);
    }

    private static int julianDay(Calendar calendar) {
        return (int)InvokeDynamicSupport.bootstrapStatic("julianDay", $$robo$$libcore_icu_DateIntervalFormat$julianDay(java.util.Calendar ), 0, (Calendar)calendar);
    }

    private static final native /* synthetic */ long $$robo$$createDateIntervalFormat$nativeBinding(String var0, String var1, String var2);

    private static long createDateIntervalFormat(String string2, String string3, String string4) {
        return (long)InvokeDynamicSupport.bootstrapStatic("createDateIntervalFormat", $$robo$$libcore_icu_DateIntervalFormat$createDateIntervalFormat(java.lang.String java.lang.String java.lang.String ), 1, (String)string2, (String)string3, (String)string4);
    }

    private static final native /* synthetic */ void $$robo$$destroyDateIntervalFormat$nativeBinding(long var0);

    private static void destroyDateIntervalFormat(long l) {
        InvokeDynamicSupport.bootstrapStatic("destroyDateIntervalFormat", $$robo$$libcore_icu_DateIntervalFormat$destroyDateIntervalFormat(long ), 1, (long)l);
    }

    private static final native /* synthetic */ String $$robo$$formatDateInterval$nativeBinding(long var0, long var2, long var4);

    private static String formatDateInterval(long l, long l2, long l3) {
        return InvokeDynamicSupport.bootstrapStatic("formatDateInterval", $$robo$$libcore_icu_DateIntervalFormat$formatDateInterval(long long long ), 1, (long)l, (long)l2, (long)l3);
    }

    static {
        RobolectricInternals.classInitializing(DateIntervalFormat.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DateIntervalFormat)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class FormatterCache
    extends BasicLruCache<String, Long> {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$libcore_icu_DateIntervalFormat_FormatterCache$__constructor__() {
        }

        private final void $$robo$$libcore_icu_DateIntervalFormat_FormatterCache$entryEvicted(String key, Long value) {
            DateIntervalFormat.destroyDateIntervalFormat(value);
        }

        private void __constructor__() {
            this.$$robo$$libcore_icu_DateIntervalFormat_FormatterCache$__constructor__();
        }

        FormatterCache() {
            super(8);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$libcore_icu_DateIntervalFormat_FormatterCache$__constructor__(), 0, this);
        }

        @Override
        protected void entryEvicted(String string2, Long l) {
            InvokeDynamicSupport.bootstrap("entryEvicted", $$robo$$libcore_icu_DateIntervalFormat_FormatterCache$entryEvicted(java.lang.String java.lang.Long ), 0, this, string2, l);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FormatterCache)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

