/*
 * Decompiled with CFR 0.152.
 */
package libcore.icu;

import com.google.errorprone.annotations.DoNotMock;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParsePosition;
import libcore.icu.LocaleData;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class NativeDecimalFormat
implements Cloneable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static int UNUM_DECIMAL_SEPARATOR_SYMBOL = 0;
    private static int UNUM_GROUPING_SEPARATOR_SYMBOL = 1;
    private static int UNUM_PATTERN_SEPARATOR_SYMBOL = 2;
    private static int UNUM_PERCENT_SYMBOL = 3;
    private static int UNUM_ZERO_DIGIT_SYMBOL = 4;
    private static int UNUM_DIGIT_SYMBOL = 5;
    private static int UNUM_MINUS_SIGN_SYMBOL = 6;
    private static int UNUM_PLUS_SIGN_SYMBOL = 7;
    private static int UNUM_CURRENCY_SYMBOL = 8;
    private static int UNUM_INTL_CURRENCY_SYMBOL = 9;
    private static int UNUM_MONETARY_SEPARATOR_SYMBOL = 10;
    private static int UNUM_EXPONENTIAL_SYMBOL = 11;
    private static int UNUM_PERMILL_SYMBOL = 12;
    private static int UNUM_PAD_ESCAPE_SYMBOL = 13;
    private static int UNUM_INFINITY_SYMBOL = 14;
    private static int UNUM_NAN_SYMBOL = 15;
    private static int UNUM_SIGNIFICANT_DIGIT_SYMBOL = 16;
    private static int UNUM_MONETARY_GROUPING_SEPARATOR_SYMBOL = 17;
    private static int UNUM_FORMAT_SYMBOL_COUNT = 18;
    private static int UNUM_PARSE_INT_ONLY = 0;
    private static int UNUM_GROUPING_USED = 1;
    private static int UNUM_DECIMAL_ALWAYS_SHOWN = 2;
    private static int UNUM_MAX_INTEGER_DIGITS = 3;
    private static int UNUM_MIN_INTEGER_DIGITS = 4;
    private static int UNUM_INTEGER_DIGITS = 5;
    private static int UNUM_MAX_FRACTION_DIGITS = 6;
    private static int UNUM_MIN_FRACTION_DIGITS = 7;
    private static int UNUM_FRACTION_DIGITS = 8;
    private static int UNUM_MULTIPLIER = 9;
    private static int UNUM_GROUPING_SIZE = 10;
    private static int UNUM_ROUNDING_MODE = 11;
    private static int UNUM_ROUNDING_INCREMENT = 12;
    private static int UNUM_FORMAT_WIDTH = 13;
    private static int UNUM_PADDING_POSITION = 14;
    private static int UNUM_SECONDARY_GROUPING_SIZE = 15;
    private static int UNUM_SIGNIFICANT_DIGITS_USED = 16;
    private static int UNUM_MIN_SIGNIFICANT_DIGITS = 17;
    private static int UNUM_MAX_SIGNIFICANT_DIGITS = 18;
    private static int UNUM_LENIENT_PARSE = 19;
    private static int UNUM_POSITIVE_PREFIX = 0;
    private static int UNUM_POSITIVE_SUFFIX = 1;
    private static int UNUM_NEGATIVE_PREFIX = 2;
    private static int UNUM_NEGATIVE_SUFFIX = 3;
    private static int UNUM_PADDING_CHARACTER = 4;
    private static int UNUM_CURRENCY_CODE = 5;
    private static int UNUM_DEFAULT_RULESET = 6;
    private static int UNUM_PUBLIC_RULESETS = 7;
    private static Format.Field[] ICU4C_FIELD_IDS;
    private long address;
    private String lastPattern;
    private boolean negPrefNull;
    private boolean negSuffNull;
    private boolean posPrefNull;
    private boolean posSuffNull;
    private transient boolean parseBigDecimal;

    private static final int $$robo$$libcore_icu_NativeDecimalFormat$translateFieldId(FieldPosition fp) {
        Format.Field attr2;
        int id2 = fp.getField();
        if (id2 < -1 || id2 > 1) {
            id2 = -1;
        }
        if (id2 == -1 && (attr2 = fp.getFieldAttribute()) != null) {
            for (int i = 0; i < ICU4C_FIELD_IDS.length; ++i) {
                if (!ICU4C_FIELD_IDS[i].equals(attr2)) continue;
                id2 = i;
                break;
            }
        }
        return id2;
    }

    private void $$robo$$libcore_icu_NativeDecimalFormat$__constructor__(String pattern, DecimalFormatSymbols dfs) {
        try {
            this.address = NativeDecimalFormat.open(pattern, dfs.getCurrencySymbol(), dfs.getDecimalSeparator(), dfs.getDigit(), dfs.getExponentSeparator(), dfs.getGroupingSeparator(), dfs.getInfinity(), dfs.getInternationalCurrencySymbol(), dfs.getMinusSignString(), dfs.getMonetaryDecimalSeparator(), dfs.getNaN(), dfs.getPatternSeparator(), dfs.getPercent(), dfs.getPerMill(), dfs.getZeroDigit());
            this.lastPattern = pattern;
        }
        catch (NullPointerException npe) {
            throw npe;
        }
        catch (RuntimeException re) {
            throw new IllegalArgumentException("syntax error: " + re.getMessage() + ": " + pattern);
        }
    }

    private void $$robo$$libcore_icu_NativeDecimalFormat$__constructor__(String pattern, LocaleData data) {
        this.address = NativeDecimalFormat.open(pattern, data.currencySymbol, data.decimalSeparator, '#', data.exponentSeparator, data.groupingSeparator, data.infinity, data.internationalCurrencySymbol, data.minusSign, data.monetarySeparator, data.NaN, data.patternSeparator, data.percent, data.perMill, data.zeroDigit);
        this.lastPattern = pattern;
    }

    private final synchronized void $$robo$$libcore_icu_NativeDecimalFormat$close() {
        if (this.address != 0L) {
            NativeDecimalFormat.close(this.address);
            this.address = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$libcore_icu_NativeDecimalFormat$finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    private final Object $$robo$$libcore_icu_NativeDecimalFormat$clone() {
        try {
            NativeDecimalFormat clone = (NativeDecimalFormat)super.clone();
            clone.address = NativeDecimalFormat.cloneImpl(this.address);
            clone.lastPattern = this.lastPattern;
            clone.negPrefNull = this.negPrefNull;
            clone.negSuffNull = this.negSuffNull;
            clone.posPrefNull = this.posPrefNull;
            clone.posSuffNull = this.posSuffNull;
            return clone;
        }
        catch (CloneNotSupportedException unexpected) {
            throw new AssertionError((Object)unexpected);
        }
    }

    private final boolean $$robo$$libcore_icu_NativeDecimalFormat$equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof NativeDecimalFormat)) {
            return false;
        }
        NativeDecimalFormat obj = (NativeDecimalFormat)object;
        if (obj.address == this.address) {
            return true;
        }
        return obj.toPattern().equals(this.toPattern()) && obj.isDecimalSeparatorAlwaysShown() == this.isDecimalSeparatorAlwaysShown() && obj.getGroupingSize() == this.getGroupingSize() && obj.getMultiplier() == this.getMultiplier() && obj.getNegativePrefix().equals(this.getNegativePrefix()) && obj.getNegativeSuffix().equals(this.getNegativeSuffix()) && obj.getPositivePrefix().equals(this.getPositivePrefix()) && obj.getPositiveSuffix().equals(this.getPositiveSuffix()) && obj.getMaximumIntegerDigits() == this.getMaximumIntegerDigits() && obj.getMaximumFractionDigits() == this.getMaximumFractionDigits() && obj.getMinimumIntegerDigits() == this.getMinimumIntegerDigits() && obj.getMinimumFractionDigits() == this.getMinimumFractionDigits() && obj.isGroupingUsed() == this.isGroupingUsed();
    }

    private final String $$robo$$libcore_icu_NativeDecimalFormat$toString() {
        return this.getClass().getName() + "[\"" + this.toPattern() + "\"" + ",isDecimalSeparatorAlwaysShown=" + this.isDecimalSeparatorAlwaysShown() + ",groupingSize=" + this.getGroupingSize() + ",multiplier=" + this.getMultiplier() + ",negativePrefix=" + this.getNegativePrefix() + ",negativeSuffix=" + this.getNegativeSuffix() + ",positivePrefix=" + this.getPositivePrefix() + ",positiveSuffix=" + this.getPositiveSuffix() + ",maxIntegerDigits=" + this.getMaximumIntegerDigits() + ",maxFractionDigits=" + this.getMaximumFractionDigits() + ",minIntegerDigits=" + this.getMinimumIntegerDigits() + ",minFractionDigits=" + this.getMinimumFractionDigits() + ",grouping=" + this.isGroupingUsed() + "]";
    }

    private final void $$robo$$libcore_icu_NativeDecimalFormat$setDecimalFormatSymbols(DecimalFormatSymbols dfs) {
        NativeDecimalFormat.setDecimalFormatSymbols(this.address, dfs.getCurrencySymbol(), dfs.getDecimalSeparator(), dfs.getDigit(), dfs.getExponentSeparator(), dfs.getGroupingSeparator(), dfs.getInfinity(), dfs.getInternationalCurrencySymbol(), dfs.getMinusSignString(), dfs.getMonetaryDecimalSeparator(), dfs.getNaN(), dfs.getPatternSeparator(), dfs.getPercent(), dfs.getPerMill(), dfs.getZeroDigit());
    }

    private final void $$robo$$libcore_icu_NativeDecimalFormat$setDecimalFormatSymbols(LocaleData localeData) {
        NativeDecimalFormat.setDecimalFormatSymbols(this.address, localeData.currencySymbol, localeData.decimalSeparator, '#', localeData.exponentSeparator, localeData.groupingSeparator, localeData.infinity, localeData.internationalCurrencySymbol, localeData.minusSign, localeData.monetarySeparator, localeData.NaN, localeData.patternSeparator, localeData.percent, localeData.perMill, localeData.zeroDigit);
    }

    private final char[] $$robo$$libcore_icu_NativeDecimalFormat$formatBigDecimal(BigDecimal value, FieldPosition field) {
        FieldPositionIterator fpi = FieldPositionIterator.forFieldPosition(field);
        char[] result = NativeDecimalFormat.formatDigitList(this.address, value.toString(), fpi);
        if (fpi != null && field != null) {
            NativeDecimalFormat.updateFieldPosition(field, fpi);
        }
        return result;
    }

    private final char[] $$robo$$libcore_icu_NativeDecimalFormat$formatBigInteger(BigInteger value, FieldPosition field) {
        FieldPositionIterator fpi = FieldPositionIterator.forFieldPosition(field);
        char[] result = NativeDecimalFormat.formatDigitList(this.address, value.toString(10), fpi);
        if (fpi != null && field != null) {
            NativeDecimalFormat.updateFieldPosition(field, fpi);
        }
        return result;
    }

    private final char[] $$robo$$libcore_icu_NativeDecimalFormat$formatLong(long value, FieldPosition field) {
        FieldPositionIterator fpi = FieldPositionIterator.forFieldPosition(field);
        char[] result = NativeDecimalFormat.formatLong(this.address, value, fpi);
        if (fpi != null && field != null) {
            NativeDecimalFormat.updateFieldPosition(field, fpi);
        }
        return result;
    }

    private final char[] $$robo$$libcore_icu_NativeDecimalFormat$formatDouble(double value, FieldPosition field) {
        FieldPositionIterator fpi = FieldPositionIterator.forFieldPosition(field);
        char[] result = NativeDecimalFormat.formatDouble(this.address, value, fpi);
        if (fpi != null && field != null) {
            NativeDecimalFormat.updateFieldPosition(field, fpi);
        }
        return result;
    }

    private static final void $$robo$$libcore_icu_NativeDecimalFormat$updateFieldPosition(FieldPosition fp, FieldPositionIterator fpi) {
        int field = NativeDecimalFormat.translateFieldId(fp);
        if (field != -1) {
            while (fpi.next()) {
                if (fpi.fieldId() != field) continue;
                fp.setBeginIndex(fpi.start());
                fp.setEndIndex(fpi.limit());
                return;
            }
        }
    }

    private final void $$robo$$libcore_icu_NativeDecimalFormat$applyLocalizedPattern(String pattern) {
        NativeDecimalFormat.applyPattern(this.address, true, pattern);
        this.lastPattern = null;
    }

    private final void $$robo$$libcore_icu_NativeDecimalFormat$applyPattern(String pattern) {
        if (this.lastPattern != null && pattern.equals(this.lastPattern)) {
            return;
        }
        NativeDecimalFormat.applyPattern(this.address, false, pattern);
        this.lastPattern = pattern;
    }

    private final AttributedCharacterIterator $$robo$$libcore_icu_NativeDecimalFormat$formatToCharacterIterator(Object object) {
        String text;
        if (object == null) {
            throw new NullPointerException("object == null");
        }
        if (!(object instanceof Number)) {
            throw new IllegalArgumentException("object not a Number: " + object.getClass());
        }
        Number number = (Number)object;
        FieldPositionIterator fpIter = new FieldPositionIterator();
        if (number instanceof BigInteger || number instanceof BigDecimal) {
            text = new String(NativeDecimalFormat.formatDigitList(this.address, number.toString(), fpIter));
        } else if (number instanceof Double || number instanceof Float) {
            double dv = number.doubleValue();
            text = new String(NativeDecimalFormat.formatDouble(this.address, dv, fpIter));
        } else {
            long lv = number.longValue();
            text = new String(NativeDecimalFormat.formatLong(this.address, lv, fpIter));
        }
        AttributedString as = new AttributedString(text);
        while (fpIter.next()) {
            Format.Field field = fpIter.field();
            as.addAttribute(field, field, fpIter.start(), fpIter.limit());
        }
        return as.getIterator();
    }

    private final int $$robo$$libcore_icu_NativeDecimalFormat$makeScalePositive(int scale, StringBuilder val) {
        if (scale < 0) {
            for (int i = scale = -scale; i > 0; --i) {
                val.append('0');
            }
            scale = 0;
        }
        return scale;
    }

    private final String $$robo$$libcore_icu_NativeDecimalFormat$toLocalizedPattern() {
        return NativeDecimalFormat.toPatternImpl(this.address, true);
    }

    private final String $$robo$$libcore_icu_NativeDecimalFormat$toPattern() {
        return NativeDecimalFormat.toPatternImpl(this.address, false);
    }

    private final Number $$robo$$libcore_icu_NativeDecimalFormat$parse(String string2, ParsePosition position) {
        return NativeDecimalFormat.parse(this.address, string2, position, this.parseBigDecimal);
    }

    private final int $$robo$$libcore_icu_NativeDecimalFormat$getMaximumFractionDigits() {
        return NativeDecimalFormat.getAttribute(this.address, 6);
    }

    private final int $$robo$$libcore_icu_NativeDecimalFormat$getMaximumIntegerDigits() {
        return NativeDecimalFormat.getAttribute(this.address, 3);
    }

    private final int $$robo$$libcore_icu_NativeDecimalFormat$getMinimumFractionDigits() {
        return NativeDecimalFormat.getAttribute(this.address, 7);
    }

    private final int $$robo$$libcore_icu_NativeDecimalFormat$getMinimumIntegerDigits() {
        return NativeDecimalFormat.getAttribute(this.address, 4);
    }

    private final int $$robo$$libcore_icu_NativeDecimalFormat$getGroupingSize() {
        if (!this.isGroupingUsed()) {
            return 0;
        }
        return NativeDecimalFormat.getAttribute(this.address, 10);
    }

    private final int $$robo$$libcore_icu_NativeDecimalFormat$getMultiplier() {
        return NativeDecimalFormat.getAttribute(this.address, 9);
    }

    private final String $$robo$$libcore_icu_NativeDecimalFormat$getNegativePrefix() {
        if (this.negPrefNull) {
            return null;
        }
        return NativeDecimalFormat.getTextAttribute(this.address, 2);
    }

    private final String $$robo$$libcore_icu_NativeDecimalFormat$getNegativeSuffix() {
        if (this.negSuffNull) {
            return null;
        }
        return NativeDecimalFormat.getTextAttribute(this.address, 3);
    }

    private final String $$robo$$libcore_icu_NativeDecimalFormat$getPositivePrefix() {
        if (this.posPrefNull) {
            return null;
        }
        return NativeDecimalFormat.getTextAttribute(this.address, 0);
    }

    private final String $$robo$$libcore_icu_NativeDecimalFormat$getPositiveSuffix() {
        if (this.posSuffNull) {
            return null;
        }
        return NativeDecimalFormat.getTextAttribute(this.address, 1);
    }

    private final boolean $$robo$$libcore_icu_NativeDecimalFormat$isDecimalSeparatorAlwaysShown() {
        return NativeDecimalFormat.getAttribute(this.address, 2) != 0;
    }

    private final boolean $$robo$$libcore_icu_NativeDecimalFormat$isParseBigDecimal() {
        return this.parseBigDecimal;
    }

    private final boolean $$robo$$libcore_icu_NativeDecimalFormat$isParseIntegerOnly() {
        return NativeDecimalFormat.getAttribute(this.address, 0) != 0;
    }

    private final boolean $$robo$$libcore_icu_NativeDecimalFormat$isGroupingUsed() {
        return NativeDecimalFormat.getAttribute(this.address, 1) != 0;
    }

    private final void $$robo$$libcore_icu_NativeDecimalFormat$setDecimalSeparatorAlwaysShown(boolean value) {
        int i = value ? -1 : 0;
        NativeDecimalFormat.setAttribute(this.address, 2, i);
    }

    private final void $$robo$$libcore_icu_NativeDecimalFormat$setCurrency(String currencySymbol, String currencyCode) {
        NativeDecimalFormat.setSymbol(this.address, 8, currencySymbol);
        NativeDecimalFormat.setSymbol(this.address, 9, currencyCode);
    }

    private final void $$robo$$libcore_icu_NativeDecimalFormat$setGroupingSize(int value) {
        NativeDecimalFormat.setAttribute(this.address, 10, value);
    }

    private final void $$robo$$libcore_icu_NativeDecimalFormat$setGroupingUsed(boolean value) {
        int i = value ? -1 : 0;
        NativeDecimalFormat.setAttribute(this.address, 1, i);
    }

    private final void $$robo$$libcore_icu_NativeDecimalFormat$setMaximumFractionDigits(int value) {
        NativeDecimalFormat.setAttribute(this.address, 6, value);
    }

    private final void $$robo$$libcore_icu_NativeDecimalFormat$setMaximumIntegerDigits(int value) {
        NativeDecimalFormat.setAttribute(this.address, 3, value);
    }

    private final void $$robo$$libcore_icu_NativeDecimalFormat$setMinimumFractionDigits(int value) {
        NativeDecimalFormat.setAttribute(this.address, 7, value);
    }

    private final void $$robo$$libcore_icu_NativeDecimalFormat$setMinimumIntegerDigits(int value) {
        NativeDecimalFormat.setAttribute(this.address, 4, value);
    }

    private final void $$robo$$libcore_icu_NativeDecimalFormat$setMultiplier(int value) {
        NativeDecimalFormat.setAttribute(this.address, 9, value);
    }

    private final void $$robo$$libcore_icu_NativeDecimalFormat$setNegativePrefix(String value) {
        boolean bl = this.negPrefNull = value == null;
        if (!this.negPrefNull) {
            NativeDecimalFormat.setTextAttribute(this.address, 2, value);
        }
    }

    private final void $$robo$$libcore_icu_NativeDecimalFormat$setNegativeSuffix(String value) {
        boolean bl = this.negSuffNull = value == null;
        if (!this.negSuffNull) {
            NativeDecimalFormat.setTextAttribute(this.address, 3, value);
        }
    }

    private final void $$robo$$libcore_icu_NativeDecimalFormat$setPositivePrefix(String value) {
        boolean bl = this.posPrefNull = value == null;
        if (!this.posPrefNull) {
            NativeDecimalFormat.setTextAttribute(this.address, 0, value);
        }
    }

    private final void $$robo$$libcore_icu_NativeDecimalFormat$setPositiveSuffix(String value) {
        boolean bl = this.posSuffNull = value == null;
        if (!this.posSuffNull) {
            NativeDecimalFormat.setTextAttribute(this.address, 1, value);
        }
    }

    private final void $$robo$$libcore_icu_NativeDecimalFormat$setParseBigDecimal(boolean value) {
        this.parseBigDecimal = value;
    }

    private final void $$robo$$libcore_icu_NativeDecimalFormat$setParseIntegerOnly(boolean value) {
        int i = value ? -1 : 0;
        NativeDecimalFormat.setAttribute(this.address, 0, i);
    }

    private static final void $$robo$$libcore_icu_NativeDecimalFormat$applyPattern(long addr, boolean localized, String pattern) {
        try {
            NativeDecimalFormat.applyPatternImpl(addr, localized, pattern);
        }
        catch (NullPointerException npe) {
            throw npe;
        }
        catch (RuntimeException re) {
            throw new IllegalArgumentException("syntax error: " + re.getMessage() + ": " + pattern);
        }
    }

    private final void $$robo$$libcore_icu_NativeDecimalFormat$setRoundingMode(RoundingMode roundingMode, double roundingIncrement) {
        int nativeRoundingMode;
        switch (1.$SwitchMap$java$math$RoundingMode[roundingMode.ordinal()]) {
            case 1: {
                nativeRoundingMode = 0;
                break;
            }
            case 2: {
                nativeRoundingMode = 1;
                break;
            }
            case 3: {
                nativeRoundingMode = 2;
                break;
            }
            case 4: {
                nativeRoundingMode = 3;
                break;
            }
            case 5: {
                nativeRoundingMode = 4;
                break;
            }
            case 6: {
                nativeRoundingMode = 5;
                break;
            }
            case 7: {
                nativeRoundingMode = 6;
                break;
            }
            case 8: {
                nativeRoundingMode = 7;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        NativeDecimalFormat.setRoundingMode(this.address, nativeRoundingMode, roundingIncrement);
    }

    private static final void $$robo$$libcore_icu_NativeDecimalFormat$applyPatternImpl(long l, boolean bl, String string2) {
    }

    private static final long $$robo$$libcore_icu_NativeDecimalFormat$cloneImpl(long l) {
        return 0L;
    }

    private static final void $$robo$$libcore_icu_NativeDecimalFormat$close(long l) {
    }

    private static final char[] $$robo$$libcore_icu_NativeDecimalFormat$formatLong(long l, long l2, FieldPositionIterator fieldPositionIterator) {
        return null;
    }

    private static final char[] $$robo$$libcore_icu_NativeDecimalFormat$formatDouble(long l, double d, FieldPositionIterator fieldPositionIterator) {
        return null;
    }

    private static final char[] $$robo$$libcore_icu_NativeDecimalFormat$formatDigitList(long l, String string2, FieldPositionIterator fieldPositionIterator) {
        return null;
    }

    private static final int $$robo$$libcore_icu_NativeDecimalFormat$getAttribute(long l, int n) {
        return 0;
    }

    private static final String $$robo$$libcore_icu_NativeDecimalFormat$getTextAttribute(long l, int n) {
        return null;
    }

    private static final long $$robo$$libcore_icu_NativeDecimalFormat$open(String string2, String string3, char c, char c2, String string4, char c3, String string5, String string6, String string7, char c4, String string8, char c5, char c6, char c7, char c8) {
        return 0L;
    }

    private static final Number $$robo$$libcore_icu_NativeDecimalFormat$parse(long l, String string2, ParsePosition parsePosition, boolean bl) {
        return null;
    }

    private static final void $$robo$$libcore_icu_NativeDecimalFormat$setDecimalFormatSymbols(long l, String string2, char c, char c2, String string3, char c3, String string4, String string5, String string6, char c4, String string7, char c5, char c6, char c7, char c8) {
    }

    private static final void $$robo$$libcore_icu_NativeDecimalFormat$setSymbol(long l, int n, String string2) {
    }

    private static final void $$robo$$libcore_icu_NativeDecimalFormat$setAttribute(long l, int n, int n2) {
    }

    private static final void $$robo$$libcore_icu_NativeDecimalFormat$setRoundingMode(long l, int n, double d) {
    }

    private static final void $$robo$$libcore_icu_NativeDecimalFormat$setTextAttribute(long l, int n, String string2) {
    }

    private static final String $$robo$$libcore_icu_NativeDecimalFormat$toPatternImpl(long l, boolean bl) {
        return null;
    }

    static void __staticInitializer__() {
        ICU4C_FIELD_IDS = new Format.Field[]{NumberFormat.Field.INTEGER, NumberFormat.Field.FRACTION, NumberFormat.Field.DECIMAL_SEPARATOR, NumberFormat.Field.EXPONENT_SYMBOL, NumberFormat.Field.EXPONENT_SIGN, NumberFormat.Field.EXPONENT, NumberFormat.Field.GROUPING_SEPARATOR, NumberFormat.Field.CURRENCY, NumberFormat.Field.PERCENT, NumberFormat.Field.PERMILLE, NumberFormat.Field.SIGN};
    }

    private static int translateFieldId(FieldPosition fieldPosition) {
        return (int)InvokeDynamicSupport.bootstrapStatic("translateFieldId", $$robo$$libcore_icu_NativeDecimalFormat$translateFieldId(java.text.FieldPosition ), 0, (FieldPosition)fieldPosition);
    }

    private void __constructor__(String string2, DecimalFormatSymbols decimalFormatSymbols) {
        this.$$robo$$libcore_icu_NativeDecimalFormat$__constructor__(string2, decimalFormatSymbols);
    }

    public NativeDecimalFormat(String string2, DecimalFormatSymbols decimalFormatSymbols) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$libcore_icu_NativeDecimalFormat$__constructor__(java.lang.String java.text.DecimalFormatSymbols ), 0, this, string2, decimalFormatSymbols);
    }

    private void __constructor__(String string2, LocaleData localeData) {
        this.$$robo$$libcore_icu_NativeDecimalFormat$__constructor__(string2, localeData);
    }

    public NativeDecimalFormat(String string2, LocaleData localeData) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$libcore_icu_NativeDecimalFormat$__constructor__(java.lang.String libcore.icu.LocaleData ), 0, this, string2, localeData);
    }

    public synchronized void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$libcore_icu_NativeDecimalFormat$close(), 0, this);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$libcore_icu_NativeDecimalFormat$finalize(), 0, this);
    }

    public Object clone() {
        return InvokeDynamicSupport.bootstrap("clone", $$robo$$libcore_icu_NativeDecimalFormat$clone(), 0, this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$libcore_icu_NativeDecimalFormat$equals(java.lang.Object ), 0, this, object);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$libcore_icu_NativeDecimalFormat$toString(), 0, this);
    }

    public void setDecimalFormatSymbols(DecimalFormatSymbols decimalFormatSymbols) {
        InvokeDynamicSupport.bootstrap("setDecimalFormatSymbols", $$robo$$libcore_icu_NativeDecimalFormat$setDecimalFormatSymbols(java.text.DecimalFormatSymbols ), 0, this, decimalFormatSymbols);
    }

    public void setDecimalFormatSymbols(LocaleData localeData) {
        InvokeDynamicSupport.bootstrap("setDecimalFormatSymbols", $$robo$$libcore_icu_NativeDecimalFormat$setDecimalFormatSymbols(libcore.icu.LocaleData ), 0, this, localeData);
    }

    public char[] formatBigDecimal(BigDecimal bigDecimal, FieldPosition fieldPosition) {
        return InvokeDynamicSupport.bootstrap("formatBigDecimal", $$robo$$libcore_icu_NativeDecimalFormat$formatBigDecimal(java.math.BigDecimal java.text.FieldPosition ), 0, this, bigDecimal, fieldPosition);
    }

    public char[] formatBigInteger(BigInteger bigInteger, FieldPosition fieldPosition) {
        return InvokeDynamicSupport.bootstrap("formatBigInteger", $$robo$$libcore_icu_NativeDecimalFormat$formatBigInteger(java.math.BigInteger java.text.FieldPosition ), 0, this, bigInteger, fieldPosition);
    }

    public char[] formatLong(long l, FieldPosition fieldPosition) {
        return InvokeDynamicSupport.bootstrap("formatLong", $$robo$$libcore_icu_NativeDecimalFormat$formatLong(long java.text.FieldPosition ), 0, this, l, fieldPosition);
    }

    public char[] formatDouble(double d, FieldPosition fieldPosition) {
        return InvokeDynamicSupport.bootstrap("formatDouble", $$robo$$libcore_icu_NativeDecimalFormat$formatDouble(double java.text.FieldPosition ), 0, this, d, fieldPosition);
    }

    private static void updateFieldPosition(FieldPosition fieldPosition, FieldPositionIterator fieldPositionIterator) {
        InvokeDynamicSupport.bootstrapStatic("updateFieldPosition", $$robo$$libcore_icu_NativeDecimalFormat$updateFieldPosition(java.text.FieldPosition libcore.icu.NativeDecimalFormat$FieldPositionIterator ), 0, (FieldPosition)fieldPosition, (FieldPositionIterator)fieldPositionIterator);
    }

    public void applyLocalizedPattern(String string2) {
        InvokeDynamicSupport.bootstrap("applyLocalizedPattern", $$robo$$libcore_icu_NativeDecimalFormat$applyLocalizedPattern(java.lang.String ), 0, this, string2);
    }

    public void applyPattern(String string2) {
        InvokeDynamicSupport.bootstrap("applyPattern", $$robo$$libcore_icu_NativeDecimalFormat$applyPattern(java.lang.String ), 0, this, string2);
    }

    public AttributedCharacterIterator formatToCharacterIterator(Object object) {
        return InvokeDynamicSupport.bootstrap("formatToCharacterIterator", $$robo$$libcore_icu_NativeDecimalFormat$formatToCharacterIterator(java.lang.Object ), 0, this, object);
    }

    private int makeScalePositive(int n, StringBuilder stringBuilder) {
        return (int)InvokeDynamicSupport.bootstrap("makeScalePositive", $$robo$$libcore_icu_NativeDecimalFormat$makeScalePositive(int java.lang.StringBuilder ), 0, this, n, stringBuilder);
    }

    public String toLocalizedPattern() {
        return InvokeDynamicSupport.bootstrap("toLocalizedPattern", $$robo$$libcore_icu_NativeDecimalFormat$toLocalizedPattern(), 0, this);
    }

    public String toPattern() {
        return InvokeDynamicSupport.bootstrap("toPattern", $$robo$$libcore_icu_NativeDecimalFormat$toPattern(), 0, this);
    }

    public Number parse(String string2, ParsePosition parsePosition) {
        return InvokeDynamicSupport.bootstrap("parse", $$robo$$libcore_icu_NativeDecimalFormat$parse(java.lang.String java.text.ParsePosition ), 0, this, string2, parsePosition);
    }

    public int getMaximumFractionDigits() {
        return (int)InvokeDynamicSupport.bootstrap("getMaximumFractionDigits", $$robo$$libcore_icu_NativeDecimalFormat$getMaximumFractionDigits(), 0, this);
    }

    public int getMaximumIntegerDigits() {
        return (int)InvokeDynamicSupport.bootstrap("getMaximumIntegerDigits", $$robo$$libcore_icu_NativeDecimalFormat$getMaximumIntegerDigits(), 0, this);
    }

    public int getMinimumFractionDigits() {
        return (int)InvokeDynamicSupport.bootstrap("getMinimumFractionDigits", $$robo$$libcore_icu_NativeDecimalFormat$getMinimumFractionDigits(), 0, this);
    }

    public int getMinimumIntegerDigits() {
        return (int)InvokeDynamicSupport.bootstrap("getMinimumIntegerDigits", $$robo$$libcore_icu_NativeDecimalFormat$getMinimumIntegerDigits(), 0, this);
    }

    public int getGroupingSize() {
        return (int)InvokeDynamicSupport.bootstrap("getGroupingSize", $$robo$$libcore_icu_NativeDecimalFormat$getGroupingSize(), 0, this);
    }

    public int getMultiplier() {
        return (int)InvokeDynamicSupport.bootstrap("getMultiplier", $$robo$$libcore_icu_NativeDecimalFormat$getMultiplier(), 0, this);
    }

    public String getNegativePrefix() {
        return InvokeDynamicSupport.bootstrap("getNegativePrefix", $$robo$$libcore_icu_NativeDecimalFormat$getNegativePrefix(), 0, this);
    }

    public String getNegativeSuffix() {
        return InvokeDynamicSupport.bootstrap("getNegativeSuffix", $$robo$$libcore_icu_NativeDecimalFormat$getNegativeSuffix(), 0, this);
    }

    public String getPositivePrefix() {
        return InvokeDynamicSupport.bootstrap("getPositivePrefix", $$robo$$libcore_icu_NativeDecimalFormat$getPositivePrefix(), 0, this);
    }

    public String getPositiveSuffix() {
        return InvokeDynamicSupport.bootstrap("getPositiveSuffix", $$robo$$libcore_icu_NativeDecimalFormat$getPositiveSuffix(), 0, this);
    }

    public boolean isDecimalSeparatorAlwaysShown() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDecimalSeparatorAlwaysShown", $$robo$$libcore_icu_NativeDecimalFormat$isDecimalSeparatorAlwaysShown(), 0, this);
    }

    public boolean isParseBigDecimal() {
        return (boolean)InvokeDynamicSupport.bootstrap("isParseBigDecimal", $$robo$$libcore_icu_NativeDecimalFormat$isParseBigDecimal(), 0, this);
    }

    public boolean isParseIntegerOnly() {
        return (boolean)InvokeDynamicSupport.bootstrap("isParseIntegerOnly", $$robo$$libcore_icu_NativeDecimalFormat$isParseIntegerOnly(), 0, this);
    }

    public boolean isGroupingUsed() {
        return (boolean)InvokeDynamicSupport.bootstrap("isGroupingUsed", $$robo$$libcore_icu_NativeDecimalFormat$isGroupingUsed(), 0, this);
    }

    public void setDecimalSeparatorAlwaysShown(boolean bl) {
        InvokeDynamicSupport.bootstrap("setDecimalSeparatorAlwaysShown", $$robo$$libcore_icu_NativeDecimalFormat$setDecimalSeparatorAlwaysShown(boolean ), 0, this, bl);
    }

    public void setCurrency(String string2, String string3) {
        InvokeDynamicSupport.bootstrap("setCurrency", $$robo$$libcore_icu_NativeDecimalFormat$setCurrency(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    public void setGroupingSize(int n) {
        InvokeDynamicSupport.bootstrap("setGroupingSize", $$robo$$libcore_icu_NativeDecimalFormat$setGroupingSize(int ), 0, this, n);
    }

    public void setGroupingUsed(boolean bl) {
        InvokeDynamicSupport.bootstrap("setGroupingUsed", $$robo$$libcore_icu_NativeDecimalFormat$setGroupingUsed(boolean ), 0, this, bl);
    }

    public void setMaximumFractionDigits(int n) {
        InvokeDynamicSupport.bootstrap("setMaximumFractionDigits", $$robo$$libcore_icu_NativeDecimalFormat$setMaximumFractionDigits(int ), 0, this, n);
    }

    public void setMaximumIntegerDigits(int n) {
        InvokeDynamicSupport.bootstrap("setMaximumIntegerDigits", $$robo$$libcore_icu_NativeDecimalFormat$setMaximumIntegerDigits(int ), 0, this, n);
    }

    public void setMinimumFractionDigits(int n) {
        InvokeDynamicSupport.bootstrap("setMinimumFractionDigits", $$robo$$libcore_icu_NativeDecimalFormat$setMinimumFractionDigits(int ), 0, this, n);
    }

    public void setMinimumIntegerDigits(int n) {
        InvokeDynamicSupport.bootstrap("setMinimumIntegerDigits", $$robo$$libcore_icu_NativeDecimalFormat$setMinimumIntegerDigits(int ), 0, this, n);
    }

    public void setMultiplier(int n) {
        InvokeDynamicSupport.bootstrap("setMultiplier", $$robo$$libcore_icu_NativeDecimalFormat$setMultiplier(int ), 0, this, n);
    }

    public void setNegativePrefix(String string2) {
        InvokeDynamicSupport.bootstrap("setNegativePrefix", $$robo$$libcore_icu_NativeDecimalFormat$setNegativePrefix(java.lang.String ), 0, this, string2);
    }

    public void setNegativeSuffix(String string2) {
        InvokeDynamicSupport.bootstrap("setNegativeSuffix", $$robo$$libcore_icu_NativeDecimalFormat$setNegativeSuffix(java.lang.String ), 0, this, string2);
    }

    public void setPositivePrefix(String string2) {
        InvokeDynamicSupport.bootstrap("setPositivePrefix", $$robo$$libcore_icu_NativeDecimalFormat$setPositivePrefix(java.lang.String ), 0, this, string2);
    }

    public void setPositiveSuffix(String string2) {
        InvokeDynamicSupport.bootstrap("setPositiveSuffix", $$robo$$libcore_icu_NativeDecimalFormat$setPositiveSuffix(java.lang.String ), 0, this, string2);
    }

    public void setParseBigDecimal(boolean bl) {
        InvokeDynamicSupport.bootstrap("setParseBigDecimal", $$robo$$libcore_icu_NativeDecimalFormat$setParseBigDecimal(boolean ), 0, this, bl);
    }

    public void setParseIntegerOnly(boolean bl) {
        InvokeDynamicSupport.bootstrap("setParseIntegerOnly", $$robo$$libcore_icu_NativeDecimalFormat$setParseIntegerOnly(boolean ), 0, this, bl);
    }

    private static void applyPattern(long l, boolean bl, String string2) {
        InvokeDynamicSupport.bootstrapStatic("applyPattern", $$robo$$libcore_icu_NativeDecimalFormat$applyPattern(long boolean java.lang.String ), 0, (long)l, (boolean)bl, (String)string2);
    }

    public void setRoundingMode(RoundingMode roundingMode, double d) {
        InvokeDynamicSupport.bootstrap("setRoundingMode", $$robo$$libcore_icu_NativeDecimalFormat$setRoundingMode(java.math.RoundingMode double ), 0, this, roundingMode, d);
    }

    private static final native /* synthetic */ void $$robo$$applyPatternImpl$nativeBinding(long var0, boolean var2, String var3);

    private static void applyPatternImpl(long l, boolean bl, String string2) {
        InvokeDynamicSupport.bootstrapStatic("applyPatternImpl", $$robo$$libcore_icu_NativeDecimalFormat$applyPatternImpl(long boolean java.lang.String ), 1, (long)l, (boolean)bl, (String)string2);
    }

    private static final native /* synthetic */ long $$robo$$cloneImpl$nativeBinding(long var0);

    private static long cloneImpl(long l) {
        return (long)InvokeDynamicSupport.bootstrapStatic("cloneImpl", $$robo$$libcore_icu_NativeDecimalFormat$cloneImpl(long ), 1, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$close$nativeBinding(long var0);

    private static void close(long l) {
        InvokeDynamicSupport.bootstrapStatic("close", $$robo$$libcore_icu_NativeDecimalFormat$close(long ), 1, (long)l);
    }

    private static final native /* synthetic */ char[] $$robo$$formatLong$nativeBinding(long var0, long var2, FieldPositionIterator var4);

    private static char[] formatLong(long l, long l2, FieldPositionIterator fieldPositionIterator) {
        return InvokeDynamicSupport.bootstrapStatic("formatLong", $$robo$$libcore_icu_NativeDecimalFormat$formatLong(long long libcore.icu.NativeDecimalFormat$FieldPositionIterator ), 1, (long)l, (long)l2, (FieldPositionIterator)fieldPositionIterator);
    }

    private static final native /* synthetic */ char[] $$robo$$formatDouble$nativeBinding(long var0, double var2, FieldPositionIterator var4);

    private static char[] formatDouble(long l, double d, FieldPositionIterator fieldPositionIterator) {
        return InvokeDynamicSupport.bootstrapStatic("formatDouble", $$robo$$libcore_icu_NativeDecimalFormat$formatDouble(long double libcore.icu.NativeDecimalFormat$FieldPositionIterator ), 1, (long)l, (double)d, (FieldPositionIterator)fieldPositionIterator);
    }

    private static final native /* synthetic */ char[] $$robo$$formatDigitList$nativeBinding(long var0, String var2, FieldPositionIterator var3);

    private static char[] formatDigitList(long l, String string2, FieldPositionIterator fieldPositionIterator) {
        return InvokeDynamicSupport.bootstrapStatic("formatDigitList", $$robo$$libcore_icu_NativeDecimalFormat$formatDigitList(long java.lang.String libcore.icu.NativeDecimalFormat$FieldPositionIterator ), 1, (long)l, (String)string2, (FieldPositionIterator)fieldPositionIterator);
    }

    private static final native /* synthetic */ int $$robo$$getAttribute$nativeBinding(long var0, int var2);

    private static int getAttribute(long l, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getAttribute", $$robo$$libcore_icu_NativeDecimalFormat$getAttribute(long int ), 1, (long)l, (int)n);
    }

    private static final native /* synthetic */ String $$robo$$getTextAttribute$nativeBinding(long var0, int var2);

    private static String getTextAttribute(long l, int n) {
        return InvokeDynamicSupport.bootstrapStatic("getTextAttribute", $$robo$$libcore_icu_NativeDecimalFormat$getTextAttribute(long int ), 1, (long)l, (int)n);
    }

    private static final native /* synthetic */ long $$robo$$open$nativeBinding(String var0, String var1, char var2, char var3, String var4, char var5, String var6, String var7, String var8, char var9, String var10, char var11, char var12, char var13, char var14);

    private static long open(String string2, String string3, char c, char c2, String string4, char c3, String string5, String string6, String string7, char c4, String string8, char c5, char c6, char c7, char c8) {
        return (long)InvokeDynamicSupport.bootstrapStatic("open", $$robo$$libcore_icu_NativeDecimalFormat$open(java.lang.String java.lang.String char char java.lang.String char java.lang.String java.lang.String java.lang.String char java.lang.String char char char char ), 1, (String)string2, (String)string3, (char)c, (char)c2, (String)string4, (char)c3, (String)string5, (String)string6, (String)string7, (char)c4, (String)string8, (char)c5, (char)c6, (char)c7, (char)c8);
    }

    private static final native /* synthetic */ Number $$robo$$parse$nativeBinding(long var0, String var2, ParsePosition var3, boolean var4);

    private static Number parse(long l, String string2, ParsePosition parsePosition, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("parse", $$robo$$libcore_icu_NativeDecimalFormat$parse(long java.lang.String java.text.ParsePosition boolean ), 1, (long)l, (String)string2, (ParsePosition)parsePosition, (boolean)bl);
    }

    private static final native /* synthetic */ void $$robo$$setDecimalFormatSymbols$nativeBinding(long var0, String var2, char var3, char var4, String var5, char var6, String var7, String var8, String var9, char var10, String var11, char var12, char var13, char var14, char var15);

    private static void setDecimalFormatSymbols(long l, String string2, char c, char c2, String string3, char c3, String string4, String string5, String string6, char c4, String string7, char c5, char c6, char c7, char c8) {
        InvokeDynamicSupport.bootstrapStatic("setDecimalFormatSymbols", $$robo$$libcore_icu_NativeDecimalFormat$setDecimalFormatSymbols(long java.lang.String char char java.lang.String char java.lang.String java.lang.String java.lang.String char java.lang.String char char char char ), 1, (long)l, (String)string2, (char)c, (char)c2, (String)string3, (char)c3, (String)string4, (String)string5, (String)string6, (char)c4, (String)string7, (char)c5, (char)c6, (char)c7, (char)c8);
    }

    private static final native /* synthetic */ void $$robo$$setSymbol$nativeBinding(long var0, int var2, String var3);

    private static void setSymbol(long l, int n, String string2) {
        InvokeDynamicSupport.bootstrapStatic("setSymbol", $$robo$$libcore_icu_NativeDecimalFormat$setSymbol(long int java.lang.String ), 1, (long)l, (int)n, (String)string2);
    }

    private static final native /* synthetic */ void $$robo$$setAttribute$nativeBinding(long var0, int var2, int var3);

    private static void setAttribute(long l, int n, int n2) {
        InvokeDynamicSupport.bootstrapStatic("setAttribute", $$robo$$libcore_icu_NativeDecimalFormat$setAttribute(long int int ), 1, (long)l, (int)n, (int)n2);
    }

    private static final native /* synthetic */ void $$robo$$setRoundingMode$nativeBinding(long var0, int var2, double var3);

    private static void setRoundingMode(long l, int n, double d) {
        InvokeDynamicSupport.bootstrapStatic("setRoundingMode", $$robo$$libcore_icu_NativeDecimalFormat$setRoundingMode(long int double ), 1, (long)l, (int)n, (double)d);
    }

    private static final native /* synthetic */ void $$robo$$setTextAttribute$nativeBinding(long var0, int var2, String var3);

    private static void setTextAttribute(long l, int n, String string2) {
        InvokeDynamicSupport.bootstrapStatic("setTextAttribute", $$robo$$libcore_icu_NativeDecimalFormat$setTextAttribute(long int java.lang.String ), 1, (long)l, (int)n, (String)string2);
    }

    private static final native /* synthetic */ String $$robo$$toPatternImpl$nativeBinding(long var0, boolean var2);

    private static String toPatternImpl(long l, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("toPatternImpl", $$robo$$libcore_icu_NativeDecimalFormat$toPatternImpl(long boolean ), 1, (long)l, (boolean)bl);
    }

    static {
        RobolectricInternals.classInitializing(NativeDecimalFormat.class);
    }

    public /* synthetic */ NativeDecimalFormat() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NativeDecimalFormat)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class FieldPositionIterator
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int[] data;
        private int pos;

        private void $$robo$$libcore_icu_NativeDecimalFormat_FieldPositionIterator$__constructor__() {
            this.pos = -3;
        }

        private static final FieldPositionIterator $$robo$$libcore_icu_NativeDecimalFormat_FieldPositionIterator$forFieldPosition(FieldPosition fp) {
            return fp != null ? new FieldPositionIterator() : null;
        }

        private final boolean $$robo$$libcore_icu_NativeDecimalFormat_FieldPositionIterator$next() {
            if (this.data == null) {
                return false;
            }
            this.pos += 3;
            return this.pos < this.data.length;
        }

        private final int $$robo$$libcore_icu_NativeDecimalFormat_FieldPositionIterator$fieldId() {
            return this.data[this.pos];
        }

        private final Format.Field $$robo$$libcore_icu_NativeDecimalFormat_FieldPositionIterator$field() {
            return ICU4C_FIELD_IDS[this.data[this.pos]];
        }

        private final int $$robo$$libcore_icu_NativeDecimalFormat_FieldPositionIterator$start() {
            return this.data[this.pos + 1];
        }

        private final int $$robo$$libcore_icu_NativeDecimalFormat_FieldPositionIterator$limit() {
            return this.data[this.pos + 2];
        }

        private final void $$robo$$libcore_icu_NativeDecimalFormat_FieldPositionIterator$setData(int[] data) {
            this.data = data;
            this.pos = -3;
        }

        private /* synthetic */ void $$robo$$libcore_icu_NativeDecimalFormat_FieldPositionIterator$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$libcore_icu_NativeDecimalFormat_FieldPositionIterator$__constructor__();
        }

        private FieldPositionIterator() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$libcore_icu_NativeDecimalFormat_FieldPositionIterator$__constructor__(), 0, this);
        }

        public static FieldPositionIterator forFieldPosition(FieldPosition fieldPosition) {
            return InvokeDynamicSupport.bootstrapStatic("forFieldPosition", $$robo$$libcore_icu_NativeDecimalFormat_FieldPositionIterator$forFieldPosition(java.text.FieldPosition ), 0, (FieldPosition)fieldPosition);
        }

        public boolean next() {
            return (boolean)InvokeDynamicSupport.bootstrap("next", $$robo$$libcore_icu_NativeDecimalFormat_FieldPositionIterator$next(), 0, this);
        }

        public int fieldId() {
            return (int)InvokeDynamicSupport.bootstrap("fieldId", $$robo$$libcore_icu_NativeDecimalFormat_FieldPositionIterator$fieldId(), 0, this);
        }

        public Format.Field field() {
            return InvokeDynamicSupport.bootstrap("field", $$robo$$libcore_icu_NativeDecimalFormat_FieldPositionIterator$field(), 0, this);
        }

        public int start() {
            return (int)InvokeDynamicSupport.bootstrap("start", $$robo$$libcore_icu_NativeDecimalFormat_FieldPositionIterator$start(), 0, this);
        }

        public int limit() {
            return (int)InvokeDynamicSupport.bootstrap("limit", $$robo$$libcore_icu_NativeDecimalFormat_FieldPositionIterator$limit(), 0, this);
        }

        private void setData(int[] nArray) {
            InvokeDynamicSupport.bootstrap("setData", $$robo$$libcore_icu_NativeDecimalFormat_FieldPositionIterator$setData(int[] ), 0, this, nArray);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$libcore_icu_NativeDecimalFormat_FieldPositionIterator$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FieldPositionIterator)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

