/*
 * Decompiled with CFR 0.152.
 */
package libcore.icu;

import com.google.errorprone.annotations.DoNotMock;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;
import libcore.util.BasicLruCache;
import libcore.util.ZoneInfoDB;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class TimeZoneNames
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String[] availableTimeZoneIds;
    public static int OLSON_NAME = 0;
    public static int LONG_NAME = 1;
    public static int SHORT_NAME = 2;
    public static int LONG_NAME_DST = 3;
    public static int SHORT_NAME_DST = 4;
    public static int NAME_COUNT = 5;
    private static ZoneStringsCache cachedZoneStrings;
    private static Comparator<String[]> ZONE_STRINGS_COMPARATOR;

    private void $$robo$$libcore_icu_TimeZoneNames$__constructor__() {
    }

    private static final String $$robo$$libcore_icu_TimeZoneNames$getDisplayName(String[][] zoneStrings, String id2, boolean daylight, int style2) {
        String[] needle = new String[]{id2};
        int index = Arrays.binarySearch(zoneStrings, needle, ZONE_STRINGS_COMPARATOR);
        if (index >= 0) {
            String[] row = zoneStrings[index];
            if (daylight) {
                return style2 == 1 ? row[3] : row[4];
            }
            return style2 == 1 ? row[1] : row[2];
        }
        return null;
    }

    private static final String[][] $$robo$$libcore_icu_TimeZoneNames$getZoneStrings(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return (String[][])cachedZoneStrings.get(locale);
    }

    private static final String[] $$robo$$libcore_icu_TimeZoneNames$forLocale(Locale locale) {
        String countryCode = locale.getCountry();
        ArrayList<String> ids = new ArrayList<String>();
        for (String line : ZoneInfoDB.getInstance().getZoneTab().split("\n")) {
            if (!line.startsWith(countryCode)) continue;
            int olsonIdStart = line.indexOf(9, 4) + 1;
            int olsonIdEnd = line.indexOf(9, olsonIdStart);
            if (olsonIdEnd == -1) {
                olsonIdEnd = line.length();
            }
            ids.add(line.substring(olsonIdStart, olsonIdEnd));
        }
        return ids.toArray(new String[ids.size()]);
    }

    private static final String $$robo$$libcore_icu_TimeZoneNames$getExemplarLocation(String string2, String string3) {
        return null;
    }

    private static final void $$robo$$libcore_icu_TimeZoneNames$fillZoneStrings(String string2, String[][] stringArray) {
    }

    static void __staticInitializer__() {
        availableTimeZoneIds = TimeZone.getAvailableIDs();
        cachedZoneStrings = new ZoneStringsCache();
        cachedZoneStrings.get(Locale.ROOT);
        cachedZoneStrings.get(Locale.US);
        cachedZoneStrings.get(Locale.getDefault());
        ZONE_STRINGS_COMPARATOR = new Comparator<String[]>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$libcore_icu_TimeZoneNames_1$__constructor__() {
            }

            private final int $$robo$$libcore_icu_TimeZoneNames_1$compare(String[] lhs, String[] rhs) {
                return lhs[0].compareTo(rhs[0]);
            }

            private void __constructor__() {
                this.$$robo$$libcore_icu_TimeZoneNames_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$libcore_icu_TimeZoneNames_1$__constructor__(), 0, this);
            }

            @Override
            public int compare(String[] stringArray, String[] stringArray2) {
                return (int)InvokeDynamicSupport.bootstrap("compare", $$robo$$libcore_icu_TimeZoneNames_1$compare(java.lang.String[] java.lang.String[] ), 0, this, stringArray, stringArray2);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__() {
        this.$$robo$$libcore_icu_TimeZoneNames$__constructor__();
    }

    private TimeZoneNames() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$libcore_icu_TimeZoneNames$__constructor__(), 0, this);
    }

    public static String getDisplayName(String[][] stringArray, String string2, boolean bl, int n) {
        return InvokeDynamicSupport.bootstrapStatic("getDisplayName", $$robo$$libcore_icu_TimeZoneNames$getDisplayName(java.lang.String[][] java.lang.String boolean int ), 0, (String[][])stringArray, (String)string2, (boolean)bl, (int)n);
    }

    public static String[][] getZoneStrings(Locale locale) {
        return InvokeDynamicSupport.bootstrapStatic("getZoneStrings", $$robo$$libcore_icu_TimeZoneNames$getZoneStrings(java.util.Locale ), 0, (Locale)locale);
    }

    public static String[] forLocale(Locale locale) {
        return InvokeDynamicSupport.bootstrapStatic("forLocale", $$robo$$libcore_icu_TimeZoneNames$forLocale(java.util.Locale ), 0, (Locale)locale);
    }

    private static final native /* synthetic */ String $$robo$$getExemplarLocation$nativeBinding(String var0, String var1);

    public static String getExemplarLocation(String string2, String string3) {
        return InvokeDynamicSupport.bootstrapStatic("getExemplarLocation", $$robo$$libcore_icu_TimeZoneNames$getExemplarLocation(java.lang.String java.lang.String ), 1, (String)string2, (String)string3);
    }

    private static final native /* synthetic */ void $$robo$$fillZoneStrings$nativeBinding(String var0, String[][] var1);

    private static void fillZoneStrings(String string2, String[][] stringArray) {
        InvokeDynamicSupport.bootstrapStatic("fillZoneStrings", $$robo$$libcore_icu_TimeZoneNames$fillZoneStrings(java.lang.String java.lang.String[][] ), 1, (String)string2, (String[][])stringArray);
    }

    static {
        RobolectricInternals.classInitializing(TimeZoneNames.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TimeZoneNames)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class ZoneStringsCache
    extends BasicLruCache<Locale, String[][]> {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$libcore_icu_TimeZoneNames_ZoneStringsCache$__constructor__() {
        }

        private final String[][] $$robo$$libcore_icu_TimeZoneNames_ZoneStringsCache$create(Locale locale) {
            CallSite start = InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
            String[][] result = new String[availableTimeZoneIds.length][5];
            for (int i = 0; i < availableTimeZoneIds.length; ++i) {
                result[i][0] = availableTimeZoneIds[i];
            }
            CallSite nativeStart = InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
            TimeZoneNames.fillZoneStrings(locale.toString(), result);
            CallSite nativeEnd = InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
            this.internStrings(result);
            CallSite end = InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
            reference var11_8 = nativeEnd - nativeStart;
            reference var13_9 = end - start;
            System.logI((String)("Loaded time zone names for \"" + locale + "\" in " + (long)var13_9 + "ms" + " (" + (long)var11_8 + "ms in ICU)"));
            return result;
        }

        private final synchronized void $$robo$$libcore_icu_TimeZoneNames_ZoneStringsCache$internStrings(String[][] result) {
            HashMap<String, String> internTable = new HashMap<String, String>();
            for (int i = 0; i < result.length; ++i) {
                for (int j = 1; j < 5; ++j) {
                    String original = result[i][j];
                    String nonDuplicate = (String)internTable.get(original);
                    if (nonDuplicate == null) {
                        internTable.put(original, original);
                        continue;
                    }
                    result[i][j] = nonDuplicate;
                }
            }
        }

        private void __constructor__() {
            this.$$robo$$libcore_icu_TimeZoneNames_ZoneStringsCache$__constructor__();
        }

        public ZoneStringsCache() {
            super(5);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$libcore_icu_TimeZoneNames_ZoneStringsCache$__constructor__(), 0, this);
        }

        @Override
        protected String[][] create(Locale locale) {
            return InvokeDynamicSupport.bootstrap("create", $$robo$$libcore_icu_TimeZoneNames_ZoneStringsCache$create(java.util.Locale ), 0, this, locale);
        }

        private synchronized void internStrings(String[][] stringArray) {
            InvokeDynamicSupport.bootstrap("internStrings", $$robo$$libcore_icu_TimeZoneNames_ZoneStringsCache$internStrings(java.lang.String[][] ), 0, this, stringArray);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ZoneStringsCache)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

