/*
 * Decompiled with CFR 0.152.
 */
package libcore.io;

import com.google.errorprone.annotations.DoNotMock;
import java.nio.ByteOrder;
import libcore.io.BufferIterator;
import libcore.io.Memory;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class HeapBufferIterator
extends BufferIterator
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private byte[] buffer;
    private int offset;
    private int byteCount;
    private ByteOrder order;
    private int position;

    private void $$robo$$libcore_io_HeapBufferIterator$__constructor__(byte[] buffer, int offset, int byteCount, ByteOrder order) {
        this.buffer = buffer;
        this.offset = offset;
        this.byteCount = byteCount;
        this.order = order;
    }

    private final void $$robo$$libcore_io_HeapBufferIterator$seek(int offset) {
        this.position = offset;
    }

    private final void $$robo$$libcore_io_HeapBufferIterator$skip(int byteCount) {
        this.position += byteCount;
    }

    private final void $$robo$$libcore_io_HeapBufferIterator$readByteArray(byte[] dst, int dstOffset, int byteCount) {
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])this.buffer, (int)(this.offset + this.position), (byte[])dst, (int)dstOffset, (int)byteCount);
        this.position += byteCount;
    }

    private final byte $$robo$$libcore_io_HeapBufferIterator$readByte() {
        byte result = this.buffer[this.offset + this.position];
        ++this.position;
        return result;
    }

    private final int $$robo$$libcore_io_HeapBufferIterator$readInt() {
        int result = Memory.peekInt(this.buffer, this.offset + this.position, this.order);
        this.position += 4;
        return result;
    }

    private final void $$robo$$libcore_io_HeapBufferIterator$readIntArray(int[] dst, int dstOffset, int intCount) {
        int byteCount = intCount * 4;
        Memory.unsafeBulkGet(dst, dstOffset, byteCount, this.buffer, this.offset + this.position, 4, this.order.needsSwap);
        this.position += byteCount;
    }

    private final short $$robo$$libcore_io_HeapBufferIterator$readShort() {
        short result = Memory.peekShort(this.buffer, this.offset + this.position, this.order);
        this.position += 2;
        return result;
    }

    private static final BufferIterator $$robo$$libcore_io_HeapBufferIterator$iterator(byte[] buffer, int offset, int byteCount, ByteOrder order) {
        return new HeapBufferIterator(buffer, offset, byteCount, order);
    }

    private void __constructor__(byte[] byArray, int n, int n2, ByteOrder byteOrder) {
        this.$$robo$$libcore_io_HeapBufferIterator$__constructor__(byArray, n, n2, byteOrder);
    }

    HeapBufferIterator(byte[] byArray, int n, int n2, ByteOrder byteOrder) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$libcore_io_HeapBufferIterator$__constructor__(byte[] int int java.nio.ByteOrder ), 0, this, byArray, n, n2, byteOrder);
    }

    @Override
    public void seek(int n) {
        InvokeDynamicSupport.bootstrap("seek", $$robo$$libcore_io_HeapBufferIterator$seek(int ), 0, this, n);
    }

    @Override
    public void skip(int n) {
        InvokeDynamicSupport.bootstrap("skip", $$robo$$libcore_io_HeapBufferIterator$skip(int ), 0, this, n);
    }

    @Override
    public void readByteArray(byte[] byArray, int n, int n2) {
        InvokeDynamicSupport.bootstrap("readByteArray", $$robo$$libcore_io_HeapBufferIterator$readByteArray(byte[] int int ), 0, this, byArray, n, n2);
    }

    @Override
    public byte readByte() {
        return (byte)InvokeDynamicSupport.bootstrap("readByte", $$robo$$libcore_io_HeapBufferIterator$readByte(), 0, this);
    }

    @Override
    public int readInt() {
        return (int)InvokeDynamicSupport.bootstrap("readInt", $$robo$$libcore_io_HeapBufferIterator$readInt(), 0, this);
    }

    @Override
    public void readIntArray(int[] nArray, int n, int n2) {
        InvokeDynamicSupport.bootstrap("readIntArray", $$robo$$libcore_io_HeapBufferIterator$readIntArray(int[] int int ), 0, this, nArray, n, n2);
    }

    @Override
    public short readShort() {
        return (short)InvokeDynamicSupport.bootstrap("readShort", $$robo$$libcore_io_HeapBufferIterator$readShort(), 0, this);
    }

    public static BufferIterator iterator(byte[] byArray, int n, int n2, ByteOrder byteOrder) {
        return InvokeDynamicSupport.bootstrapStatic("iterator", $$robo$$libcore_io_HeapBufferIterator$iterator(byte[] int int java.nio.ByteOrder ), 0, (byte[])byArray, (int)n, (int)n2, (ByteOrder)byteOrder);
    }

    public /* synthetic */ HeapBufferIterator() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (HeapBufferIterator)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

