/*
 * Decompiled with CFR 0.152.
 */
package libcore.io;

import android.system.ErrnoException;
import android.system.OsConstants;
import android.system.StructStat;
import com.google.errorprone.annotations.DoNotMock;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Random;
import libcore.io.IoBridge;
import libcore.io.Libcore;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class IoUtils
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static Random TEMPORARY_DIRECTORY_PRNG;

    private void $$robo$$libcore_io_IoUtils$__constructor__() {
    }

    private static final void $$robo$$libcore_io_IoUtils$close(FileDescriptor fd) throws IOException {
        try {
            if (fd != null && fd.valid()) {
                Libcore.os.close(fd);
            }
        }
        catch (ErrnoException errnoException) {
            throw errnoException.rethrowAsIOException();
        }
    }

    private static final void $$robo$$libcore_io_IoUtils$closeQuietly(AutoCloseable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (RuntimeException rethrown) {
                throw rethrown;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static final void $$robo$$libcore_io_IoUtils$closeQuietly(FileDescriptor fd) {
        try {
            IoUtils.close(fd);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static final void $$robo$$libcore_io_IoUtils$closeQuietly(Socket socket) {
        if (socket != null) {
            try {
                socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static final void $$robo$$libcore_io_IoUtils$setBlocking(FileDescriptor fd, boolean blocking) throws IOException {
        try {
            int flags = Libcore.os.fcntlVoid(fd, OsConstants.F_GETFL);
            flags = !blocking ? (flags |= OsConstants.O_NONBLOCK) : (flags &= ~OsConstants.O_NONBLOCK);
            Libcore.os.fcntlLong(fd, OsConstants.F_SETFL, flags);
        }
        catch (ErrnoException errnoException) {
            throw errnoException.rethrowAsIOException();
        }
    }

    private static final byte[] $$robo$$libcore_io_IoUtils$readFileAsByteArray(String absolutePath) throws IOException {
        return new FileReader(absolutePath).readFully().toByteArray();
    }

    private static final String $$robo$$libcore_io_IoUtils$readFileAsString(String absolutePath) throws IOException {
        return new FileReader(absolutePath).readFully().toString(StandardCharsets.UTF_8);
    }

    private static final void $$robo$$libcore_io_IoUtils$deleteContents(File dir) throws IOException {
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    IoUtils.deleteContents(file);
                }
                file.delete();
            }
        }
    }

    private static final File $$robo$$libcore_io_IoUtils$createTemporaryDirectory(String prefix) {
        String candidateName;
        File result;
        do {
            candidateName = prefix + TEMPORARY_DIRECTORY_PRNG.nextInt();
        } while (!(result = new File(System.getProperty("java.io.tmpdir"), candidateName)).mkdir());
        return result;
    }

    private static final boolean $$robo$$libcore_io_IoUtils$canOpenReadOnly(String path) {
        try {
            FileDescriptor fd = Libcore.os.open(path, OsConstants.O_RDONLY, 0);
            Libcore.os.close(fd);
            return true;
        }
        catch (ErrnoException errnoException) {
            return false;
        }
    }

    private static final void $$robo$$libcore_io_IoUtils$throwInterruptedIoException() throws InterruptedIOException {
        Thread.currentThread().interrupt();
        throw new InterruptedIOException();
    }

    static void __staticInitializer__() {
        TEMPORARY_DIRECTORY_PRNG = new Random();
    }

    private void __constructor__() {
        this.$$robo$$libcore_io_IoUtils$__constructor__();
    }

    private IoUtils() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$libcore_io_IoUtils$__constructor__(), 0, this);
    }

    public static void close(FileDescriptor fileDescriptor) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("close", $$robo$$libcore_io_IoUtils$close(java.io.FileDescriptor ), 0, (FileDescriptor)fileDescriptor);
    }

    public static void closeQuietly(AutoCloseable autoCloseable) {
        InvokeDynamicSupport.bootstrapStatic("closeQuietly", $$robo$$libcore_io_IoUtils$closeQuietly(java.lang.AutoCloseable ), 0, (AutoCloseable)autoCloseable);
    }

    public static void closeQuietly(FileDescriptor fileDescriptor) {
        InvokeDynamicSupport.bootstrapStatic("closeQuietly", $$robo$$libcore_io_IoUtils$closeQuietly(java.io.FileDescriptor ), 0, (FileDescriptor)fileDescriptor);
    }

    public static void closeQuietly(Socket socket) {
        InvokeDynamicSupport.bootstrapStatic("closeQuietly", $$robo$$libcore_io_IoUtils$closeQuietly(java.net.Socket ), 0, (Socket)socket);
    }

    public static void setBlocking(FileDescriptor fileDescriptor, boolean bl) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("setBlocking", $$robo$$libcore_io_IoUtils$setBlocking(java.io.FileDescriptor boolean ), 0, (FileDescriptor)fileDescriptor, (boolean)bl);
    }

    public static byte[] readFileAsByteArray(String string2) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("readFileAsByteArray", $$robo$$libcore_io_IoUtils$readFileAsByteArray(java.lang.String ), 0, (String)string2);
    }

    public static String readFileAsString(String string2) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("readFileAsString", $$robo$$libcore_io_IoUtils$readFileAsString(java.lang.String ), 0, (String)string2);
    }

    public static void deleteContents(File file) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("deleteContents", $$robo$$libcore_io_IoUtils$deleteContents(java.io.File ), 0, (File)file);
    }

    public static File createTemporaryDirectory(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("createTemporaryDirectory", $$robo$$libcore_io_IoUtils$createTemporaryDirectory(java.lang.String ), 0, (String)string2);
    }

    public static boolean canOpenReadOnly(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("canOpenReadOnly", $$robo$$libcore_io_IoUtils$canOpenReadOnly(java.lang.String ), 0, (String)string2);
    }

    public static void throwInterruptedIoException() throws InterruptedIOException {
        InvokeDynamicSupport.bootstrapStatic("throwInterruptedIoException", $$robo$$libcore_io_IoUtils$throwInterruptedIoException(), 0);
    }

    static {
        RobolectricInternals.classInitializing(IoUtils.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (IoUtils)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class FileReader
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private FileDescriptor fd;
        private boolean unknownLength;
        private byte[] bytes;
        private int count;

        private void $$robo$$libcore_io_IoUtils_FileReader$__constructor__(String absolutePath) throws IOException {
            int capacity;
            this.fd = IoBridge.open(absolutePath, OsConstants.O_RDONLY);
            try {
                StructStat stat = Libcore.os.fstat(this.fd);
                capacity = (int)stat.st_size;
                if (capacity == 0) {
                    this.unknownLength = true;
                    capacity = 8192;
                }
            }
            catch (ErrnoException exception) {
                IoUtils.closeQuietly(this.fd);
                throw exception.rethrowAsIOException();
            }
            this.bytes = new byte[capacity];
        }

        private final FileReader $$robo$$libcore_io_IoUtils_FileReader$readFully() throws IOException {
            int capacity = this.bytes.length;
            try {
                int read;
                while ((read = Libcore.os.read(this.fd, this.bytes, this.count, capacity - this.count)) != 0) {
                    this.count += read;
                    if (this.count != capacity) continue;
                    if (!this.unknownLength) break;
                    int newCapacity = capacity * 2;
                    byte[] newBytes = new byte[newCapacity];
                    InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])this.bytes, (int)0, (byte[])newBytes, (int)0, (int)capacity);
                    this.bytes = newBytes;
                    capacity = newCapacity;
                }
                FileReader newCapacity = this;
                return newCapacity;
            }
            catch (ErrnoException e) {
                throw e.rethrowAsIOException();
            }
            finally {
                IoUtils.closeQuietly(this.fd);
            }
        }

        @FindBugsSuppressWarnings(value={"EI_EXPOSE_REP"})
        private final byte[] $$robo$$libcore_io_IoUtils_FileReader$toByteArray() {
            if (this.count == this.bytes.length) {
                return this.bytes;
            }
            byte[] result = new byte[this.count];
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])this.bytes, (int)0, (byte[])result, (int)0, (int)this.count);
            return result;
        }

        private final String $$robo$$libcore_io_IoUtils_FileReader$toString(Charset cs) {
            return new String(this.bytes, 0, this.count, cs);
        }

        private void __constructor__(String string2) throws IOException {
            this.$$robo$$libcore_io_IoUtils_FileReader$__constructor__(string2);
        }

        public FileReader(String string2) throws IOException {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$libcore_io_IoUtils_FileReader$__constructor__(java.lang.String ), 0, this, string2);
        }

        public FileReader readFully() throws IOException {
            return InvokeDynamicSupport.bootstrap("readFully", $$robo$$libcore_io_IoUtils_FileReader$readFully(), 0, this);
        }

        public byte[] toByteArray() {
            return InvokeDynamicSupport.bootstrap("toByteArray", $$robo$$libcore_io_IoUtils_FileReader$toByteArray(), 0, this);
        }

        public String toString(Charset charset) {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$libcore_io_IoUtils_FileReader$toString(java.nio.charset.Charset ), 0, this, charset);
        }

        public /* synthetic */ FileReader() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FileReader)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

