/*
 * Decompiled with CFR 0.152.
 */
package libcore.io;

import android.system.ErrnoException;
import android.system.OsConstants;
import com.google.errorprone.annotations.DoNotMock;
import java.io.FileDescriptor;
import java.nio.ByteOrder;
import libcore.io.BufferIterator;
import libcore.io.Libcore;
import libcore.io.NioBufferIterator;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class MemoryMappedFile
implements AutoCloseable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private long address;
    private long size;

    private void $$robo$$libcore_io_MemoryMappedFile$__constructor__(long address, long size) {
        this.address = address;
        this.size = size;
    }

    private static final MemoryMappedFile $$robo$$libcore_io_MemoryMappedFile$mmapRO(String path) throws ErrnoException {
        FileDescriptor fd = Libcore.os.open(path, OsConstants.O_RDONLY, 0);
        long size = Libcore.os.fstat((FileDescriptor)fd).st_size;
        long address = Libcore.os.mmap(0L, size, OsConstants.PROT_READ, OsConstants.MAP_SHARED, fd, 0L);
        Libcore.os.close(fd);
        return new MemoryMappedFile(address, size);
    }

    private final synchronized void $$robo$$libcore_io_MemoryMappedFile$close() throws ErrnoException {
        if (this.address != 0L) {
            Libcore.os.munmap(this.address, this.size);
            this.address = 0L;
        }
    }

    private final BufferIterator $$robo$$libcore_io_MemoryMappedFile$bigEndianIterator() {
        return new NioBufferIterator(this.address, (int)this.size, ByteOrder.nativeOrder() != ByteOrder.BIG_ENDIAN);
    }

    private final BufferIterator $$robo$$libcore_io_MemoryMappedFile$littleEndianIterator() {
        return new NioBufferIterator(this.address, (int)this.size, ByteOrder.nativeOrder() != ByteOrder.LITTLE_ENDIAN);
    }

    private final long $$robo$$libcore_io_MemoryMappedFile$size() {
        return this.size;
    }

    private void __constructor__(long l, long l2) {
        this.$$robo$$libcore_io_MemoryMappedFile$__constructor__(l, l2);
    }

    public MemoryMappedFile(long l, long l2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$libcore_io_MemoryMappedFile$__constructor__(long long ), 0, this, l, l2);
    }

    public static MemoryMappedFile mmapRO(String string2) throws ErrnoException {
        return InvokeDynamicSupport.bootstrapStatic("mmapRO", $$robo$$libcore_io_MemoryMappedFile$mmapRO(java.lang.String ), 0, (String)string2);
    }

    @Override
    public synchronized void close() throws ErrnoException {
        InvokeDynamicSupport.bootstrap("close", $$robo$$libcore_io_MemoryMappedFile$close(), 0, this);
    }

    public BufferIterator bigEndianIterator() {
        return InvokeDynamicSupport.bootstrap("bigEndianIterator", $$robo$$libcore_io_MemoryMappedFile$bigEndianIterator(), 0, this);
    }

    public BufferIterator littleEndianIterator() {
        return InvokeDynamicSupport.bootstrap("littleEndianIterator", $$robo$$libcore_io_MemoryMappedFile$littleEndianIterator(), 0, this);
    }

    public long size() {
        return (long)InvokeDynamicSupport.bootstrap("size", $$robo$$libcore_io_MemoryMappedFile$size(), 0, this);
    }

    public /* synthetic */ MemoryMappedFile() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MemoryMappedFile)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

