/*
 * Decompiled with CFR 0.152.
 */
package libcore.io;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class StrictLineReader
implements Closeable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static byte CR = 13;
    private static byte LF = 10;
    private InputStream in;
    private Charset charset;
    private byte[] buf;
    private int pos;
    private int end;

    private void $$robo$$libcore_io_StrictLineReader$__constructor__(InputStream in) {
    }

    private void $$robo$$libcore_io_StrictLineReader$__constructor__(InputStream in, int capacity) {
    }

    private void $$robo$$libcore_io_StrictLineReader$__constructor__(InputStream in, Charset charset) {
    }

    private void $$robo$$libcore_io_StrictLineReader$__constructor__(InputStream in, int capacity, Charset charset) {
        if (in == null) {
            throw new NullPointerException("in == null");
        }
        if (charset == null) {
            throw new NullPointerException("charset == null");
        }
        if (capacity < 0) {
            throw new IllegalArgumentException("capacity <= 0");
        }
        if (!(charset.equals(StandardCharsets.US_ASCII) || charset.equals(StandardCharsets.UTF_8) || charset.equals(StandardCharsets.ISO_8859_1))) {
            throw new IllegalArgumentException("Unsupported encoding");
        }
        this.in = in;
        this.charset = charset;
        this.buf = new byte[capacity];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$libcore_io_StrictLineReader$close() throws IOException {
        InputStream inputStream = this.in;
        synchronized (inputStream) {
            if (this.buf != null) {
                this.buf = null;
                this.in.close();
            }
        }
    }

    private final String $$robo$$libcore_io_StrictLineReader$readLine() throws IOException {
        InputStream inputStream = this.in;
        synchronized (inputStream) {
            if (this.buf == null) {
                throw new IOException("LineReader is closed");
            }
            if (this.pos >= this.end) {
                this.fillBuf();
            }
            for (int i = this.pos; i != this.end; ++i) {
                if (this.buf[i] != 10) continue;
                int lineEnd = i != this.pos && this.buf[i - 1] == 13 ? i - 1 : i;
                String res = new String(this.buf, this.pos, lineEnd - this.pos, this.charset);
                this.pos = i + 1;
                return res;
            }
            ShadowedObject out = new ShadowedObject(this, this.end - this.pos + 80){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ StrictLineReader this$0;

                private void $$robo$$libcore_io_StrictLineReader_1$__constructor__(StrictLineReader strictLineReader, int x0) {
                }

                private final String $$robo$$libcore_io_StrictLineReader_1$toString() {
                    int length = this.count > 0 && this.buf[this.count - 1] == 13 ? this.count - 1 : this.count;
                    return new String(this.buf, 0, length, this.this$0.charset);
                }

                private void __constructor__(StrictLineReader strictLineReader, int n) {
                    this.$$robo$$libcore_io_StrictLineReader_1$__constructor__(strictLineReader, n);
                }
                {
                    this.this$0 = strictLineReader;
                    super(n);
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$libcore_io_StrictLineReader_1$__constructor__(libcore.io.StrictLineReader int ), 0, this, strictLineReader, n);
                }

                @Override
                public String toString() {
                    return InvokeDynamicSupport.bootstrap("toString", $$robo$$libcore_io_StrictLineReader_1$toString(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            block4: while (true) {
                out.write(this.buf, this.pos, this.end - this.pos);
                this.end = -1;
                this.fillBuf();
                int i = this.pos;
                while (true) {
                    if (i == this.end) continue block4;
                    if (this.buf[i] == 10) {
                        if (i != this.pos) {
                            out.write(this.buf, this.pos, i - this.pos);
                        }
                        this.pos = i + 1;
                        return out.toString();
                    }
                    ++i;
                }
                break;
            }
        }
    }

    private final int $$robo$$libcore_io_StrictLineReader$readInt() throws IOException {
        String intString = this.readLine();
        try {
            return Integer.parseInt(intString);
        }
        catch (NumberFormatException e) {
            throw new IOException("expected an int but was \"" + intString + "\"");
        }
    }

    private final boolean $$robo$$libcore_io_StrictLineReader$hasUnterminatedLine() {
        return this.end == -1;
    }

    private final void $$robo$$libcore_io_StrictLineReader$fillBuf() throws IOException {
        int result = this.in.read(this.buf, 0, this.buf.length);
        if (result == -1) {
            throw new EOFException();
        }
        this.pos = 0;
        this.end = result;
    }

    private void __constructor__(InputStream inputStream) {
        this.$$robo$$libcore_io_StrictLineReader$__constructor__(inputStream);
    }

    public StrictLineReader(InputStream inputStream) {
        this(inputStream, 8192);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$libcore_io_StrictLineReader$__constructor__(java.io.InputStream ), 0, this, inputStream);
    }

    private void __constructor__(InputStream inputStream, int n) {
        this.$$robo$$libcore_io_StrictLineReader$__constructor__(inputStream, n);
    }

    public StrictLineReader(InputStream inputStream, int n) {
        this(inputStream, n, StandardCharsets.US_ASCII);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$libcore_io_StrictLineReader$__constructor__(java.io.InputStream int ), 0, this, inputStream, n);
    }

    private void __constructor__(InputStream inputStream, Charset charset) {
        this.$$robo$$libcore_io_StrictLineReader$__constructor__(inputStream, charset);
    }

    public StrictLineReader(InputStream inputStream, Charset charset) {
        this(inputStream, 8192, charset);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$libcore_io_StrictLineReader$__constructor__(java.io.InputStream java.nio.charset.Charset ), 0, this, inputStream, charset);
    }

    private void __constructor__(InputStream inputStream, int n, Charset charset) {
        this.$$robo$$libcore_io_StrictLineReader$__constructor__(inputStream, n, charset);
    }

    public StrictLineReader(InputStream inputStream, int n, Charset charset) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$libcore_io_StrictLineReader$__constructor__(java.io.InputStream int java.nio.charset.Charset ), 0, this, inputStream, n, charset);
    }

    @Override
    public void close() throws IOException {
        InvokeDynamicSupport.bootstrap("close", $$robo$$libcore_io_StrictLineReader$close(), 0, this);
    }

    public String readLine() throws IOException {
        return InvokeDynamicSupport.bootstrap("readLine", $$robo$$libcore_io_StrictLineReader$readLine(), 0, this);
    }

    public int readInt() throws IOException {
        return (int)InvokeDynamicSupport.bootstrap("readInt", $$robo$$libcore_io_StrictLineReader$readInt(), 0, this);
    }

    public boolean hasUnterminatedLine() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasUnterminatedLine", $$robo$$libcore_io_StrictLineReader$hasUnterminatedLine(), 0, this);
    }

    private void fillBuf() throws IOException {
        InvokeDynamicSupport.bootstrap("fillBuf", $$robo$$libcore_io_StrictLineReader$fillBuf(), 0, this);
    }

    public /* synthetic */ StrictLineReader() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (StrictLineReader)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

