/*
 * Decompiled with CFR 0.152.
 */
package libcore.net;

import java.io.ByteArrayOutputStream;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class UriCodec
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;

    private void $$robo$$libcore_net_UriCodec$__constructor__() {
    }

    protected abstract boolean isRetained(char var1);

    private final String $$robo$$libcore_net_UriCodec$validate(String uri, int start, int end, String name) throws URISyntaxException {
        int i = start;
        while (i < end) {
            char ch = uri.charAt(i);
            if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || this.isRetained(ch)) {
                ++i;
                continue;
            }
            if (ch == '%') {
                if (i + 2 >= end) {
                    throw new URISyntaxException(uri, "Incomplete % sequence in " + name, i);
                }
                int d1 = UriCodec.hexToInt(uri.charAt(i + 1));
                int d2 = UriCodec.hexToInt(uri.charAt(i + 2));
                if (d1 == -1 || d2 == -1) {
                    throw new URISyntaxException(uri, "Invalid % sequence: " + uri.substring(i, i + 3) + " in " + name, i);
                }
                i += 3;
                continue;
            }
            throw new URISyntaxException(uri, "Illegal character in " + name, i);
        }
        return uri.substring(start, end);
    }

    private static final void $$robo$$libcore_net_UriCodec$validateSimple(String s, String legal) throws URISyntaxException {
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || legal.indexOf(ch) > -1) continue;
            throw new URISyntaxException(s, "Illegal character", i);
        }
    }

    private final void $$robo$$libcore_net_UriCodec$appendEncoded(StringBuilder builder, String s, Charset charset, boolean isPartiallyEncoded) {
        if (s == null) {
            throw new NullPointerException("s == null");
        }
        int escapeStart = -1;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || this.isRetained(c) || c == '%' && isPartiallyEncoded) {
                if (escapeStart != -1) {
                    UriCodec.appendHex(builder, s.substring(escapeStart, i), charset);
                    escapeStart = -1;
                }
                if (c == '%' && isPartiallyEncoded) {
                    builder.append(s, i, Math.min(i + 3, s.length()));
                    i += 2;
                    continue;
                }
                if (c == ' ') {
                    builder.append('+');
                    continue;
                }
                builder.append(c);
                continue;
            }
            if (escapeStart != -1) continue;
            escapeStart = i;
        }
        if (escapeStart != -1) {
            UriCodec.appendHex(builder, s.substring(escapeStart, s.length()), charset);
        }
    }

    private final String $$robo$$libcore_net_UriCodec$encode(String s, Charset charset) {
        StringBuilder builder = new StringBuilder(s.length() + 16);
        this.appendEncoded(builder, s, charset, false);
        return builder.toString();
    }

    private final void $$robo$$libcore_net_UriCodec$appendEncoded(StringBuilder builder, String s) {
        this.appendEncoded(builder, s, StandardCharsets.UTF_8, false);
    }

    private final void $$robo$$libcore_net_UriCodec$appendPartiallyEncoded(StringBuilder builder, String s) {
        this.appendEncoded(builder, s, StandardCharsets.UTF_8, true);
    }

    private static final String $$robo$$libcore_net_UriCodec$decode(String s, boolean convertPlus, Charset charset, boolean throwOnFailure) {
        if (!(s.indexOf(37) != -1 || convertPlus && s.indexOf(43) != -1)) {
            return s;
        }
        StringBuilder result = new StringBuilder(s.length());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int i = 0;
        while (i < s.length()) {
            int c = s.charAt(i);
            if (c == 37) {
                do {
                    int d2;
                    int d1;
                    if (i + 2 < s.length() && (d1 = UriCodec.hexToInt(s.charAt(i + 1))) != -1 && (d2 = UriCodec.hexToInt(s.charAt(i + 2))) != -1) {
                        out.write((byte)((d1 << 4) + d2));
                        continue;
                    }
                    if (throwOnFailure) {
                        throw new IllegalArgumentException("Invalid % sequence at " + i + ": " + s);
                    }
                    byte[] replacement = "\ufffd".getBytes(charset);
                    out.write(replacement, 0, replacement.length);
                } while ((i += 3) < s.length() && s.charAt(i) == '%');
                result.append(new String(out.toByteArray(), charset));
                out.reset();
                continue;
            }
            if (convertPlus && c == 43) {
                c = 32;
            }
            result.append((char)c);
            ++i;
        }
        return result.toString();
    }

    private static final int $$robo$$libcore_net_UriCodec$hexToInt(char c) {
        if ('0' <= c && c <= '9') {
            return c - 48;
        }
        if ('a' <= c && c <= 'f') {
            return 10 + (c - 97);
        }
        if ('A' <= c && c <= 'F') {
            return 10 + (c - 65);
        }
        return -1;
    }

    private static final String $$robo$$libcore_net_UriCodec$decode(String s) {
        return UriCodec.decode(s, false, StandardCharsets.UTF_8, true);
    }

    private static final void $$robo$$libcore_net_UriCodec$appendHex(StringBuilder builder, String s, Charset charset) {
        for (byte b : s.getBytes(charset)) {
            UriCodec.appendHex(builder, b);
        }
    }

    private static final void $$robo$$libcore_net_UriCodec$appendHex(StringBuilder sb, byte b) {
        sb.append('%');
        sb.append(Byte.toHexString((byte)b, (boolean)true));
    }

    private void __constructor__() {
        this.$$robo$$libcore_net_UriCodec$__constructor__();
    }

    public UriCodec() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$libcore_net_UriCodec$__constructor__(), 0, this);
    }

    public String validate(String string2, int n, int n2, String string3) throws URISyntaxException {
        return InvokeDynamicSupport.bootstrap("validate", $$robo$$libcore_net_UriCodec$validate(java.lang.String int int java.lang.String ), 0, this, string2, n, n2, string3);
    }

    public static void validateSimple(String string2, String string3) throws URISyntaxException {
        InvokeDynamicSupport.bootstrapStatic("validateSimple", $$robo$$libcore_net_UriCodec$validateSimple(java.lang.String java.lang.String ), 0, (String)string2, (String)string3);
    }

    private void appendEncoded(StringBuilder stringBuilder, String string2, Charset charset, boolean bl) {
        InvokeDynamicSupport.bootstrap("appendEncoded", $$robo$$libcore_net_UriCodec$appendEncoded(java.lang.StringBuilder java.lang.String java.nio.charset.Charset boolean ), 0, this, stringBuilder, string2, charset, bl);
    }

    public String encode(String string2, Charset charset) {
        return InvokeDynamicSupport.bootstrap("encode", $$robo$$libcore_net_UriCodec$encode(java.lang.String java.nio.charset.Charset ), 0, this, string2, charset);
    }

    public void appendEncoded(StringBuilder stringBuilder, String string2) {
        InvokeDynamicSupport.bootstrap("appendEncoded", $$robo$$libcore_net_UriCodec$appendEncoded(java.lang.StringBuilder java.lang.String ), 0, this, stringBuilder, string2);
    }

    public void appendPartiallyEncoded(StringBuilder stringBuilder, String string2) {
        InvokeDynamicSupport.bootstrap("appendPartiallyEncoded", $$robo$$libcore_net_UriCodec$appendPartiallyEncoded(java.lang.StringBuilder java.lang.String ), 0, this, stringBuilder, string2);
    }

    public static String decode(String string2, boolean bl, Charset charset, boolean bl2) {
        return InvokeDynamicSupport.bootstrapStatic("decode", $$robo$$libcore_net_UriCodec$decode(java.lang.String boolean java.nio.charset.Charset boolean ), 0, (String)string2, (boolean)bl, (Charset)charset, (boolean)bl2);
    }

    private static int hexToInt(char c) {
        return (int)InvokeDynamicSupport.bootstrapStatic("hexToInt", $$robo$$libcore_net_UriCodec$hexToInt(char ), 0, (char)c);
    }

    public static String decode(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("decode", $$robo$$libcore_net_UriCodec$decode(java.lang.String ), 0, (String)string2);
    }

    private static void appendHex(StringBuilder stringBuilder, String string2, Charset charset) {
        InvokeDynamicSupport.bootstrapStatic("appendHex", $$robo$$libcore_net_UriCodec$appendHex(java.lang.StringBuilder java.lang.String java.nio.charset.Charset ), 0, (StringBuilder)stringBuilder, (String)string2, (Charset)charset);
    }

    private static void appendHex(StringBuilder stringBuilder, byte by) {
        InvokeDynamicSupport.bootstrapStatic("appendHex", $$robo$$libcore_net_UriCodec$appendHex(java.lang.StringBuilder byte ), 0, (StringBuilder)stringBuilder, (byte)by);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (UriCodec)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

