/*
 * Decompiled with CFR 0.152.
 */
package libcore.net.url;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import libcore.net.UriCodec;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class FileURLConnection
extends URLConnection
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static Comparator<String> HEADER_COMPARATOR;
    private String filename;
    private InputStream is;
    private long length;
    private long lastModified;
    private boolean isDir;
    private FilePermission permission;
    private String[] headerKeysAndValues;
    private static int CONTENT_TYPE_VALUE_IDX = 1;
    private static int CONTENT_LENGTH_VALUE_IDX = 3;
    private static int LAST_MODIFIED_VALUE_IDX = 5;
    private Map<String, List<String>> headerFields;

    private void $$robo$$libcore_net_url_FileURLConnection$__constructor__(URL url) {
        this.length = -1L;
        this.lastModified = -1L;
        this.filename = url.getFile();
        if (this.filename == null) {
            this.filename = "";
        }
        this.filename = UriCodec.decode(this.filename);
        this.headerKeysAndValues = new String[]{"content-type", null, "content-length", null, "last-modified", null};
    }

    private final void $$robo$$libcore_net_url_FileURLConnection$connect() throws IOException {
        File f = new File(this.filename);
        IOException error = null;
        if (f.isDirectory()) {
            this.isDir = true;
            this.is = this.getDirectoryListing(f);
            this.lastModified = f.lastModified();
            this.headerKeysAndValues[1] = "text/html";
        } else {
            try {
                this.is = new BufferedInputStream(new FileInputStream(f));
            }
            catch (IOException ioe) {
                error = ioe;
            }
            if (error == null) {
                this.length = f.length();
                this.lastModified = f.lastModified();
                this.headerKeysAndValues[1] = this.getContentTypeForPlainFiles();
            } else {
                this.headerKeysAndValues[1] = "content/unknown";
            }
        }
        this.headerKeysAndValues[3] = String.valueOf(this.length);
        this.headerKeysAndValues[5] = String.valueOf(this.lastModified);
        this.connected = true;
        if (error != null) {
            throw error;
        }
    }

    private final String $$robo$$libcore_net_url_FileURLConnection$getHeaderField(String key) {
        if (!this.connected) {
            try {
                this.connect();
            }
            catch (IOException ioe) {
                return null;
            }
        }
        for (int i = 0; i < this.headerKeysAndValues.length; i += 2) {
            if (!this.headerKeysAndValues[i].equalsIgnoreCase(key)) continue;
            return this.headerKeysAndValues[i + 1];
        }
        return null;
    }

    private final String $$robo$$libcore_net_url_FileURLConnection$getHeaderFieldKey(int position) {
        if (!this.connected) {
            try {
                this.connect();
            }
            catch (IOException ioe) {
                return null;
            }
        }
        if (position < 0 || position > this.headerKeysAndValues.length / 2) {
            return null;
        }
        return this.headerKeysAndValues[position * 2];
    }

    private final String $$robo$$libcore_net_url_FileURLConnection$getHeaderField(int position) {
        if (!this.connected) {
            try {
                this.connect();
            }
            catch (IOException ioe) {
                return null;
            }
        }
        if (position < 0 || position > this.headerKeysAndValues.length / 2) {
            return null;
        }
        return this.headerKeysAndValues[position * 2 + 1];
    }

    private final Map<String, List<String>> $$robo$$libcore_net_url_FileURLConnection$getHeaderFields() {
        if (this.headerFields == null) {
            TreeMap<String, List<String>> headerFieldsMap = new TreeMap<String, List<String>>(HEADER_COMPARATOR);
            for (int i = 0; i < this.headerKeysAndValues.length; i += 2) {
                headerFieldsMap.put(this.headerKeysAndValues[i], Collections.singletonList(this.headerKeysAndValues[i + 1]));
            }
            this.headerFields = Collections.unmodifiableMap(headerFieldsMap);
        }
        return this.headerFields;
    }

    private final int $$robo$$libcore_net_url_FileURLConnection$getContentLength() {
        long length = this.getContentLengthLong();
        return length <= Integer.MAX_VALUE ? (int)length : -1;
    }

    private final long $$robo$$libcore_net_url_FileURLConnection$getContentLengthLong() {
        try {
            if (!this.connected) {
                this.connect();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.length;
    }

    private final String $$robo$$libcore_net_url_FileURLConnection$getContentType() {
        return this.getHeaderField(0);
    }

    private final String $$robo$$libcore_net_url_FileURLConnection$getContentTypeForPlainFiles() {
        String result = FileURLConnection.guessContentTypeFromName(this.url.getFile());
        if (result != null) {
            return result;
        }
        try {
            result = FileURLConnection.guessContentTypeFromStream(this.is);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (result != null) {
            return result;
        }
        return "content/unknown";
    }

    private final InputStream $$robo$$libcore_net_url_FileURLConnection$getDirectoryListing(File f) {
        String[] fileList = f.list();
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(bytes);
        out.print("<title>Directory Listing</title>\n");
        out.print("<base href=\"file:");
        out.print(f.getPath().replace('\\', '/') + "/\"><h1>" + f.getPath() + "</h1>\n<hr>\n");
        for (int i = 0; i < fileList.length; ++i) {
            out.print(fileList[i] + "<br>\n");
        }
        out.close();
        return new ByteArrayInputStream(bytes.toByteArray());
    }

    private final InputStream $$robo$$libcore_net_url_FileURLConnection$getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        return this.is;
    }

    private final Permission $$robo$$libcore_net_url_FileURLConnection$getPermission() throws IOException {
        if (this.permission == null) {
            String path = this.filename;
            if (File.separatorChar != '/') {
                path = path.replace('/', File.separatorChar);
            }
            this.permission = new FilePermission(path, "read");
        }
        return this.permission;
    }

    static void __staticInitializer__() {
        HEADER_COMPARATOR = new Comparator<String>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$libcore_net_url_FileURLConnection_1$__constructor__() {
            }

            private final int $$robo$$libcore_net_url_FileURLConnection_1$compare(String a, String b) {
                if (a == b) {
                    return 0;
                }
                if (a == null) {
                    return -1;
                }
                if (b == null) {
                    return 1;
                }
                return String.CASE_INSENSITIVE_ORDER.compare(a, b);
            }

            private void __constructor__() {
                this.$$robo$$libcore_net_url_FileURLConnection_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$libcore_net_url_FileURLConnection_1$__constructor__(), 0, this);
            }

            @Override
            public int compare(String string2, String string3) {
                return (int)InvokeDynamicSupport.bootstrap("compare", $$robo$$libcore_net_url_FileURLConnection_1$compare(java.lang.String java.lang.String ), 0, this, string2, string3);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(URL uRL) {
        this.$$robo$$libcore_net_url_FileURLConnection$__constructor__(uRL);
    }

    public FileURLConnection(URL uRL) {
        super(uRL);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$libcore_net_url_FileURLConnection$__constructor__(java.net.URL ), 0, this, uRL);
    }

    @Override
    public void connect() throws IOException {
        InvokeDynamicSupport.bootstrap("connect", $$robo$$libcore_net_url_FileURLConnection$connect(), 0, this);
    }

    @Override
    public String getHeaderField(String string2) {
        return InvokeDynamicSupport.bootstrap("getHeaderField", $$robo$$libcore_net_url_FileURLConnection$getHeaderField(java.lang.String ), 0, this, string2);
    }

    @Override
    public String getHeaderFieldKey(int n) {
        return InvokeDynamicSupport.bootstrap("getHeaderFieldKey", $$robo$$libcore_net_url_FileURLConnection$getHeaderFieldKey(int ), 0, this, n);
    }

    @Override
    public String getHeaderField(int n) {
        return InvokeDynamicSupport.bootstrap("getHeaderField", $$robo$$libcore_net_url_FileURLConnection$getHeaderField(int ), 0, this, n);
    }

    @Override
    public Map<String, List<String>> getHeaderFields() {
        return InvokeDynamicSupport.bootstrap("getHeaderFields", $$robo$$libcore_net_url_FileURLConnection$getHeaderFields(), 0, this);
    }

    @Override
    public int getContentLength() {
        return (int)InvokeDynamicSupport.bootstrap("getContentLength", $$robo$$libcore_net_url_FileURLConnection$getContentLength(), 0, this);
    }

    private long getContentLengthLong() {
        return (long)InvokeDynamicSupport.bootstrap("getContentLengthLong", $$robo$$libcore_net_url_FileURLConnection$getContentLengthLong(), 0, this);
    }

    @Override
    public String getContentType() {
        return InvokeDynamicSupport.bootstrap("getContentType", $$robo$$libcore_net_url_FileURLConnection$getContentType(), 0, this);
    }

    private String getContentTypeForPlainFiles() {
        return InvokeDynamicSupport.bootstrap("getContentTypeForPlainFiles", $$robo$$libcore_net_url_FileURLConnection$getContentTypeForPlainFiles(), 0, this);
    }

    private InputStream getDirectoryListing(File file) {
        return InvokeDynamicSupport.bootstrap("getDirectoryListing", $$robo$$libcore_net_url_FileURLConnection$getDirectoryListing(java.io.File ), 0, this, file);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return InvokeDynamicSupport.bootstrap("getInputStream", $$robo$$libcore_net_url_FileURLConnection$getInputStream(), 0, this);
    }

    @Override
    public Permission getPermission() throws IOException {
        return InvokeDynamicSupport.bootstrap("getPermission", $$robo$$libcore_net_url_FileURLConnection$getPermission(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(FileURLConnection.class);
    }

    public /* synthetic */ FileURLConnection() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FileURLConnection)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

