/*
 * Decompiled with CFR 0.152.
 */
package libcore.net.url;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketPermission;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import libcore.net.url.FtpURLInputStream;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class FtpURLConnection
extends URLConnection
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static int FTP_PORT = 21;
    private static int FTP_DATAOPEN = 125;
    private static int FTP_OPENDATA = 150;
    private static int FTP_OK = 200;
    private static int FTP_USERREADY = 220;
    private static int FTP_TRANSFEROK = 226;
    private static int FTP_LOGGEDIN = 230;
    private static int FTP_FILEOK = 250;
    private static int FTP_PASWD = 331;
    private static int FTP_NOTFOUND = 550;
    private Socket controlSocket;
    private Socket dataSocket;
    private ServerSocket acceptSocket;
    private InputStream ctrlInput;
    private InputStream inputStream;
    private OutputStream ctrlOutput;
    private int dataPort;
    private String username;
    private String password;
    private String replyCode;
    private String hostName;
    private Proxy proxy;
    private Proxy currentProxy;
    private URI uri;

    private void $$robo$$libcore_net_url_FtpURLConnection$__constructor__(URL url) {
        this.username = "anonymous";
        this.password = "";
        this.hostName = url.getHost();
        String parse = url.getUserInfo();
        if (parse != null) {
            int split = parse.indexOf(58);
            if (split >= 0) {
                this.username = parse.substring(0, split);
                this.password = parse.substring(split + 1);
            } else {
                this.username = parse;
            }
        }
        this.uri = null;
        try {
            this.uri = url.toURI();
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }

    private void $$robo$$libcore_net_url_FtpURLConnection$__constructor__(URL url, Proxy proxy) {
        this.proxy = proxy;
    }

    private final void $$robo$$libcore_net_url_FtpURLConnection$cd() throws IOException {
        int idx = this.url.getFile().lastIndexOf(47);
        if (idx > 0) {
            String dir = this.url.getFile().substring(0, idx);
            this.write("CWD " + dir + "\r\n");
            int reply = this.getReply();
            if (reply != 250 && dir.length() > 0 && dir.charAt(0) == '/') {
                this.write("CWD " + dir.substring(1) + "\r\n");
                reply = this.getReply();
            }
            if (reply != 250) {
                throw new IOException("Unable to change directories");
            }
        }
    }

    private final void $$robo$$libcore_net_url_FtpURLConnection$connect() throws IOException {
        ProxySelector selector;
        List<Object> proxyList = null;
        if (this.proxy != null) {
            proxyList = new ArrayList<Proxy>(1);
            proxyList.add(this.proxy);
        } else {
            selector = ProxySelector.getDefault();
            if (selector != null) {
                proxyList = selector.select(this.uri);
            }
        }
        if (proxyList == null) {
            this.currentProxy = null;
            this.connectInternal();
        } else {
            selector = ProxySelector.getDefault();
            Iterator<Object> iter = proxyList.iterator();
            boolean connectOK = false;
            String failureReason = "";
            while (iter.hasNext() && !connectOK) {
                this.currentProxy = (Proxy)iter.next();
                try {
                    this.connectInternal();
                    connectOK = true;
                }
                catch (IOException ioe) {
                    failureReason = ioe.getLocalizedMessage();
                    if (selector == null || Proxy.NO_PROXY == this.currentProxy) continue;
                    selector.connectFailed(this.uri, this.currentProxy.address(), ioe);
                }
            }
            if (!connectOK) {
                throw new IOException("Unable to connect to server: " + failureReason);
            }
        }
    }

    private final void $$robo$$libcore_net_url_FtpURLConnection$connectInternal() throws IOException {
        int port = this.url.getPort();
        int connectTimeout = this.getConnectTimeout();
        if (port <= 0) {
            port = 21;
        }
        this.controlSocket = this.currentProxy == null || Proxy.Type.HTTP == this.currentProxy.type() ? new Socket() : new Socket(this.currentProxy);
        InetSocketAddress addr = new InetSocketAddress(this.hostName, port);
        this.controlSocket.connect(addr, connectTimeout);
        this.connected = true;
        this.ctrlOutput = this.controlSocket.getOutputStream();
        this.ctrlInput = this.controlSocket.getInputStream();
        this.login();
        this.setType();
        if (!this.getDoInput()) {
            this.cd();
        }
        try {
            this.acceptSocket = new ServerSocket(0);
            this.dataPort = this.acceptSocket.getLocalPort();
            this.port();
            if (connectTimeout == 0) {
                connectTimeout = 3000;
            }
            this.acceptSocket.setSoTimeout(this.getConnectTimeout());
            if (this.getDoInput()) {
                this.getFile();
            } else {
                this.sendFile();
            }
            this.dataSocket = this.acceptSocket.accept();
            this.dataSocket.setSoTimeout(this.getReadTimeout());
            this.acceptSocket.close();
        }
        catch (InterruptedIOException e) {
            throw new IOException("Could not establish data connection");
        }
        if (this.getDoInput()) {
            this.inputStream = new FtpURLInputStream(new BufferedInputStream(this.dataSocket.getInputStream()), this.controlSocket);
        }
    }

    private final String $$robo$$libcore_net_url_FtpURLConnection$getContentType() {
        String result = FtpURLConnection.guessContentTypeFromName(this.url.getFile());
        if (result == null) {
            return "content/unknown";
        }
        return result;
    }

    private final void $$robo$$libcore_net_url_FtpURLConnection$getFile() throws IOException {
        String file = this.url.getFile();
        this.write("RETR " + file + "\r\n");
        int reply = this.getReply();
        if (reply == 550 && file.length() > 0 && file.charAt(0) == '/') {
            this.write("RETR " + file.substring(1) + "\r\n");
            reply = this.getReply();
        }
        if (reply != 150 && reply != 226) {
            throw new FileNotFoundException("Unable to retrieve file: " + reply);
        }
    }

    private final InputStream $$robo$$libcore_net_url_FtpURLConnection$getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        return this.inputStream;
    }

    private final Permission $$robo$$libcore_net_url_FtpURLConnection$getPermission() throws IOException {
        int port = this.url.getPort();
        if (port <= 0) {
            port = 21;
        }
        return new SocketPermission(this.hostName + ":" + port, "connect, resolve");
    }

    private final OutputStream $$robo$$libcore_net_url_FtpURLConnection$getOutputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        return this.dataSocket.getOutputStream();
    }

    private final int $$robo$$libcore_net_url_FtpURLConnection$getReply() throws IOException {
        byte[] code = new byte[3];
        for (int i = 0; i < code.length; ++i) {
            int tmp = this.ctrlInput.read();
            if (tmp == -1) {
                throw new EOFException();
            }
            code[i] = (byte)tmp;
        }
        this.replyCode = new String(code, 0, code.length, StandardCharsets.ISO_8859_1);
        boolean multiline = false;
        if (this.ctrlInput.read() == 45) {
            multiline = true;
        }
        this.readLine();
        if (multiline) {
            while (this.readMultiLine()) {
            }
        }
        try {
            return Integer.parseInt(this.replyCode);
        }
        catch (NumberFormatException e) {
            throw (IOException)new IOException("reply code is invalid").initCause(e);
        }
    }

    private final void $$robo$$libcore_net_url_FtpURLConnection$login() throws IOException {
        int reply = this.getReply();
        if (reply != 220) {
            throw new IOException("Unable to connect to server: " + this.url.getHost());
        }
        this.write("USER " + this.username + "\r\n");
        reply = this.getReply();
        if (reply != 331 && reply != 230) {
            throw new IOException("Unable to log in to server (USER): " + this.url.getHost());
        }
        if (reply == 331) {
            this.write("PASS " + this.password + "\r\n");
            reply = this.getReply();
            if (reply != 200 && reply != 220 && reply != 230) {
                throw new IOException("Unable to log in to server (PASS): " + this.url.getHost());
            }
        }
    }

    private final void $$robo$$libcore_net_url_FtpURLConnection$port() throws IOException {
        this.write("PORT " + this.controlSocket.getLocalAddress().getHostAddress().replace('.', ',') + ',' + (this.dataPort >> 8) + ',' + (this.dataPort & 0xFF) + "\r\n");
        if (this.getReply() != 200) {
            throw new IOException("Unable to configure data port");
        }
    }

    private final String $$robo$$libcore_net_url_FtpURLConnection$readLine() throws IOException {
        int c;
        StringBuilder sb = new StringBuilder();
        while ((c = this.ctrlInput.read()) != 10) {
            sb.append((char)c);
        }
        return sb.toString();
    }

    private final boolean $$robo$$libcore_net_url_FtpURLConnection$readMultiLine() throws IOException {
        String line = this.readLine();
        if (line.length() < 4) {
            return true;
        }
        return !line.substring(0, 3).equals(this.replyCode) || line.charAt(3) != ' ';
    }

    private final void $$robo$$libcore_net_url_FtpURLConnection$sendFile() throws IOException {
        this.write("STOR " + this.url.getFile().substring(this.url.getFile().lastIndexOf(47) + 1, this.url.getFile().length()) + "\r\n");
        int reply = this.getReply();
        if (reply != 150 && reply != 200 && reply != 125) {
            throw new IOException("Unable to store file");
        }
    }

    private final void $$robo$$libcore_net_url_FtpURLConnection$setDoInput(boolean newValue) {
        if (this.connected) {
            throw new IllegalAccessError();
        }
        this.doInput = newValue;
        this.doOutput = !newValue;
    }

    private final void $$robo$$libcore_net_url_FtpURLConnection$setDoOutput(boolean newValue) {
        if (this.connected) {
            throw new IllegalAccessError();
        }
        this.doOutput = newValue;
        this.doInput = !newValue;
    }

    private final void $$robo$$libcore_net_url_FtpURLConnection$setType() throws IOException {
        this.write("TYPE I\r\n");
        if (this.getReply() != 200) {
            throw new IOException("Unable to set transfer type");
        }
    }

    private final void $$robo$$libcore_net_url_FtpURLConnection$write(String command) throws IOException {
        this.ctrlOutput.write(command.getBytes(StandardCharsets.ISO_8859_1));
    }

    private void __constructor__(URL uRL) {
        this.$$robo$$libcore_net_url_FtpURLConnection$__constructor__(uRL);
    }

    protected FtpURLConnection(URL uRL) {
        super(uRL);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$libcore_net_url_FtpURLConnection$__constructor__(java.net.URL ), 0, this, uRL);
    }

    private void __constructor__(URL uRL, Proxy proxy) {
        this.$$robo$$libcore_net_url_FtpURLConnection$__constructor__(uRL, proxy);
    }

    protected FtpURLConnection(URL uRL, Proxy proxy) {
        this(uRL);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$libcore_net_url_FtpURLConnection$__constructor__(java.net.URL java.net.Proxy ), 0, this, uRL, proxy);
    }

    private void cd() throws IOException {
        InvokeDynamicSupport.bootstrap("cd", $$robo$$libcore_net_url_FtpURLConnection$cd(), 0, this);
    }

    @Override
    public void connect() throws IOException {
        InvokeDynamicSupport.bootstrap("connect", $$robo$$libcore_net_url_FtpURLConnection$connect(), 0, this);
    }

    private void connectInternal() throws IOException {
        InvokeDynamicSupport.bootstrap("connectInternal", $$robo$$libcore_net_url_FtpURLConnection$connectInternal(), 0, this);
    }

    @Override
    public String getContentType() {
        return InvokeDynamicSupport.bootstrap("getContentType", $$robo$$libcore_net_url_FtpURLConnection$getContentType(), 0, this);
    }

    private void getFile() throws IOException {
        InvokeDynamicSupport.bootstrap("getFile", $$robo$$libcore_net_url_FtpURLConnection$getFile(), 0, this);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return InvokeDynamicSupport.bootstrap("getInputStream", $$robo$$libcore_net_url_FtpURLConnection$getInputStream(), 0, this);
    }

    @Override
    public Permission getPermission() throws IOException {
        return InvokeDynamicSupport.bootstrap("getPermission", $$robo$$libcore_net_url_FtpURLConnection$getPermission(), 0, this);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return InvokeDynamicSupport.bootstrap("getOutputStream", $$robo$$libcore_net_url_FtpURLConnection$getOutputStream(), 0, this);
    }

    private int getReply() throws IOException {
        return (int)InvokeDynamicSupport.bootstrap("getReply", $$robo$$libcore_net_url_FtpURLConnection$getReply(), 0, this);
    }

    private void login() throws IOException {
        InvokeDynamicSupport.bootstrap("login", $$robo$$libcore_net_url_FtpURLConnection$login(), 0, this);
    }

    private void port() throws IOException {
        InvokeDynamicSupport.bootstrap("port", $$robo$$libcore_net_url_FtpURLConnection$port(), 0, this);
    }

    private String readLine() throws IOException {
        return InvokeDynamicSupport.bootstrap("readLine", $$robo$$libcore_net_url_FtpURLConnection$readLine(), 0, this);
    }

    private boolean readMultiLine() throws IOException {
        return (boolean)InvokeDynamicSupport.bootstrap("readMultiLine", $$robo$$libcore_net_url_FtpURLConnection$readMultiLine(), 0, this);
    }

    private void sendFile() throws IOException {
        InvokeDynamicSupport.bootstrap("sendFile", $$robo$$libcore_net_url_FtpURLConnection$sendFile(), 0, this);
    }

    @Override
    public void setDoInput(boolean bl) {
        InvokeDynamicSupport.bootstrap("setDoInput", $$robo$$libcore_net_url_FtpURLConnection$setDoInput(boolean ), 0, this, bl);
    }

    @Override
    public void setDoOutput(boolean bl) {
        InvokeDynamicSupport.bootstrap("setDoOutput", $$robo$$libcore_net_url_FtpURLConnection$setDoOutput(boolean ), 0, this, bl);
    }

    private void setType() throws IOException {
        InvokeDynamicSupport.bootstrap("setType", $$robo$$libcore_net_url_FtpURLConnection$setType(), 0, this);
    }

    private void write(String string2) throws IOException {
        InvokeDynamicSupport.bootstrap("write", $$robo$$libcore_net_url_FtpURLConnection$write(java.lang.String ), 0, this, string2);
    }

    public /* synthetic */ FtpURLConnection() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FtpURLConnection)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

