/*
 * Decompiled with CFR 0.152.
 */
package libcore.net.url;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Permission;
import java.util.HashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import libcore.net.UriCodec;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class JarURLConnectionImpl
extends JarURLConnection
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static HashMap<URL, JarFile> jarCache;
    private URL jarFileURL;
    private InputStream jarInput;
    private JarFile jarFile;
    private JarEntry jarEntry;
    private boolean closed;

    private void $$robo$$libcore_net_url_JarURLConnectionImpl$__constructor__(URL url) throws MalformedURLException, IOException {
        this.jarFileURL = this.getJarFileURL();
        this.jarFileURLConnection = this.jarFileURL.openConnection();
    }

    private final void $$robo$$libcore_net_url_JarURLConnectionImpl$connect() throws IOException {
        if (!this.connected) {
            this.findJarFile();
            this.findJarEntry();
            this.connected = true;
        }
    }

    private final JarFile $$robo$$libcore_net_url_JarURLConnectionImpl$getJarFile() throws IOException {
        this.connect();
        return this.jarFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$libcore_net_url_JarURLConnectionImpl$findJarFile() throws IOException {
        if (this.getUseCaches()) {
            HashMap<URL, JarFile> hashMap = jarCache;
            synchronized (hashMap) {
                this.jarFile = jarCache.get(this.jarFileURL);
            }
            if (this.jarFile == null) {
                JarFile jar = this.openJarFile();
                HashMap<URL, JarFile> hashMap2 = jarCache;
                synchronized (hashMap2) {
                    this.jarFile = jarCache.get(this.jarFileURL);
                    if (this.jarFile == null) {
                        jarCache.put(this.jarFileURL, jar);
                        this.jarFile = jar;
                    } else {
                        jar.close();
                    }
                }
            }
        } else {
            this.jarFile = this.openJarFile();
        }
        if (this.jarFile == null) {
            throw new IOException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final JarFile $$robo$$libcore_net_url_JarURLConnectionImpl$openJarFile() throws IOException {
        if (this.jarFileURL.getProtocol().equals("file")) {
            String decodedFile = UriCodec.decode(this.jarFileURL.getFile());
            return new JarFile(new File(decodedFile), true, 1);
        }
        try (InputStream is = this.jarFileURL.openConnection().getInputStream();){
            JarFile jarFile;
            FileOutputStream fos;
            block22: {
                fos = null;
                Object result = null;
                File tempJar = File.createTempFile("hyjar_", ".tmp", null);
                tempJar.deleteOnExit();
                fos = new FileOutputStream(tempJar);
                byte[] buf = new byte[4096];
                int nbytes = 0;
                while ((nbytes = is.read(buf)) > -1) {
                    fos.write(buf, 0, nbytes);
                }
                fos.close();
                jarFile = new JarFile(tempJar, true, 5);
                if (fos == null) break block22;
                try {
                    fos.close();
                }
                catch (IOException ex) {
                    JarFile jarFile2 = null;
                    if (is != null) {
                        is.close();
                    }
                    return jarFile2;
                }
            }
            return jarFile;
            catch (IOException e) {
                JarFile jarFile3;
                block24: {
                    block23: {
                        jarFile3 = null;
                        if (fos == null) break block23;
                        try {
                            fos.close();
                        }
                        catch (IOException ex) {
                            JarFile jarFile4 = null;
                            if (is != null) {
                                is.close();
                            }
                            return jarFile4;
                        }
                    }
                    if (is == null) break block24;
                    is.close();
                }
                return jarFile3;
                {
                    catch (Throwable throwable) {
                        block25: {
                            if (fos == null) break block25;
                            try {
                                fos.close();
                            }
                            catch (IOException ex) {
                                JarFile jarFile5 = null;
                                if (is != null) {
                                    is.close();
                                }
                                return jarFile5;
                            }
                        }
                        throw throwable;
                    }
                }
            }
        }
    }

    private final JarEntry $$robo$$libcore_net_url_JarURLConnectionImpl$getJarEntry() throws IOException {
        this.connect();
        return this.jarEntry;
    }

    private final void $$robo$$libcore_net_url_JarURLConnectionImpl$findJarEntry() throws IOException {
        if (this.getEntryName() == null) {
            return;
        }
        this.jarEntry = this.jarFile.getJarEntry(this.getEntryName());
        if (this.jarEntry == null) {
            throw new FileNotFoundException(this.getEntryName());
        }
    }

    private final InputStream $$robo$$libcore_net_url_JarURLConnectionImpl$getInputStream() throws IOException {
        if (this.closed) {
            throw new IllegalStateException("JarURLConnection InputStream has been closed");
        }
        this.connect();
        if (this.jarInput != null) {
            return this.jarInput;
        }
        if (this.jarEntry == null) {
            throw new IOException("Jar entry not specified");
        }
        this.jarInput = new JarURLConnectionInputStream(this, this.jarFile.getInputStream(this.jarEntry), this.jarFile);
        return this.jarInput;
    }

    private final String $$robo$$libcore_net_url_JarURLConnectionImpl$getContentType() {
        if (this.url.getFile().endsWith("!/")) {
            return "x-java/jar";
        }
        String cType = null;
        String entryName = this.getEntryName();
        if (entryName != null) {
            cType = JarURLConnectionImpl.guessContentTypeFromName(entryName);
        } else {
            try {
                this.connect();
                cType = this.jarFileURLConnection.getContentType();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (cType == null) {
            cType = "content/unknown";
        }
        return cType;
    }

    private final int $$robo$$libcore_net_url_JarURLConnectionImpl$getContentLength() {
        try {
            this.connect();
            if (this.jarEntry == null) {
                return this.jarFileURLConnection.getContentLength();
            }
            return (int)this.getJarEntry().getSize();
        }
        catch (IOException iOException) {
            return -1;
        }
    }

    private final Object $$robo$$libcore_net_url_JarURLConnectionImpl$getContent() throws IOException {
        this.connect();
        if (this.jarEntry == null) {
            return this.jarFile;
        }
        return super.getContent();
    }

    private final Permission $$robo$$libcore_net_url_JarURLConnectionImpl$getPermission() throws IOException {
        return this.jarFileURLConnection.getPermission();
    }

    private final boolean $$robo$$libcore_net_url_JarURLConnectionImpl$getUseCaches() {
        return this.jarFileURLConnection.getUseCaches();
    }

    private final void $$robo$$libcore_net_url_JarURLConnectionImpl$setUseCaches(boolean usecaches) {
        this.jarFileURLConnection.setUseCaches(usecaches);
    }

    private final boolean $$robo$$libcore_net_url_JarURLConnectionImpl$getDefaultUseCaches() {
        return this.jarFileURLConnection.getDefaultUseCaches();
    }

    private final void $$robo$$libcore_net_url_JarURLConnectionImpl$setDefaultUseCaches(boolean defaultusecaches) {
        this.jarFileURLConnection.setDefaultUseCaches(defaultusecaches);
    }

    static void __staticInitializer__() {
        jarCache = new HashMap();
    }

    private void __constructor__(URL uRL) throws MalformedURLException, IOException {
        this.$$robo$$libcore_net_url_JarURLConnectionImpl$__constructor__(uRL);
    }

    public JarURLConnectionImpl(URL uRL) throws MalformedURLException, IOException {
        super(uRL);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$libcore_net_url_JarURLConnectionImpl$__constructor__(java.net.URL ), 0, this, uRL);
    }

    @Override
    public void connect() throws IOException {
        InvokeDynamicSupport.bootstrap("connect", $$robo$$libcore_net_url_JarURLConnectionImpl$connect(), 0, this);
    }

    @Override
    public JarFile getJarFile() throws IOException {
        return InvokeDynamicSupport.bootstrap("getJarFile", $$robo$$libcore_net_url_JarURLConnectionImpl$getJarFile(), 0, this);
    }

    private void findJarFile() throws IOException {
        InvokeDynamicSupport.bootstrap("findJarFile", $$robo$$libcore_net_url_JarURLConnectionImpl$findJarFile(), 0, this);
    }

    private JarFile openJarFile() throws IOException {
        return InvokeDynamicSupport.bootstrap("openJarFile", $$robo$$libcore_net_url_JarURLConnectionImpl$openJarFile(), 0, this);
    }

    @Override
    public JarEntry getJarEntry() throws IOException {
        return InvokeDynamicSupport.bootstrap("getJarEntry", $$robo$$libcore_net_url_JarURLConnectionImpl$getJarEntry(), 0, this);
    }

    private void findJarEntry() throws IOException {
        InvokeDynamicSupport.bootstrap("findJarEntry", $$robo$$libcore_net_url_JarURLConnectionImpl$findJarEntry(), 0, this);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return InvokeDynamicSupport.bootstrap("getInputStream", $$robo$$libcore_net_url_JarURLConnectionImpl$getInputStream(), 0, this);
    }

    @Override
    public String getContentType() {
        return InvokeDynamicSupport.bootstrap("getContentType", $$robo$$libcore_net_url_JarURLConnectionImpl$getContentType(), 0, this);
    }

    @Override
    public int getContentLength() {
        return (int)InvokeDynamicSupport.bootstrap("getContentLength", $$robo$$libcore_net_url_JarURLConnectionImpl$getContentLength(), 0, this);
    }

    @Override
    public Object getContent() throws IOException {
        return InvokeDynamicSupport.bootstrap("getContent", $$robo$$libcore_net_url_JarURLConnectionImpl$getContent(), 0, this);
    }

    @Override
    public Permission getPermission() throws IOException {
        return InvokeDynamicSupport.bootstrap("getPermission", $$robo$$libcore_net_url_JarURLConnectionImpl$getPermission(), 0, this);
    }

    @Override
    public boolean getUseCaches() {
        return (boolean)InvokeDynamicSupport.bootstrap("getUseCaches", $$robo$$libcore_net_url_JarURLConnectionImpl$getUseCaches(), 0, this);
    }

    @Override
    public void setUseCaches(boolean bl) {
        InvokeDynamicSupport.bootstrap("setUseCaches", $$robo$$libcore_net_url_JarURLConnectionImpl$setUseCaches(boolean ), 0, this, bl);
    }

    @Override
    public boolean getDefaultUseCaches() {
        return (boolean)InvokeDynamicSupport.bootstrap("getDefaultUseCaches", $$robo$$libcore_net_url_JarURLConnectionImpl$getDefaultUseCaches(), 0, this);
    }

    @Override
    public void setDefaultUseCaches(boolean bl) {
        InvokeDynamicSupport.bootstrap("setDefaultUseCaches", $$robo$$libcore_net_url_JarURLConnectionImpl$setDefaultUseCaches(boolean ), 0, this, bl);
    }

    static {
        RobolectricInternals.classInitializing(JarURLConnectionImpl.class);
    }

    public /* synthetic */ JarURLConnectionImpl() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (JarURLConnectionImpl)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class JarURLConnectionInputStream
    extends FilterInputStream
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        JarFile jarFile;
        /* synthetic */ JarURLConnectionImpl this$0;

        private void $$robo$$libcore_net_url_JarURLConnectionImpl_JarURLConnectionInputStream$__constructor__(JarURLConnectionImpl jarURLConnectionImpl, InputStream in, JarFile file) {
            this.jarFile = file;
        }

        private final void $$robo$$libcore_net_url_JarURLConnectionImpl_JarURLConnectionInputStream$close() throws IOException {
            super.close();
            if (!this.this$0.getUseCaches()) {
                this.this$0.closed = true;
                this.jarFile.close();
            }
        }

        private void __constructor__(JarURLConnectionImpl jarURLConnectionImpl, InputStream inputStream, JarFile jarFile) {
            this.$$robo$$libcore_net_url_JarURLConnectionImpl_JarURLConnectionInputStream$__constructor__(jarURLConnectionImpl, inputStream, jarFile);
        }

        protected JarURLConnectionInputStream(JarURLConnectionImpl jarURLConnectionImpl, InputStream inputStream, JarFile jarFile) {
            this.this$0 = jarURLConnectionImpl;
            super(inputStream);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$libcore_net_url_JarURLConnectionImpl_JarURLConnectionInputStream$__constructor__(libcore.net.url.JarURLConnectionImpl java.io.InputStream java.util.jar.JarFile ), 0, this, jarURLConnectionImpl, inputStream, jarFile);
        }

        @Override
        public void close() throws IOException {
            InvokeDynamicSupport.bootstrap("close", $$robo$$libcore_net_url_JarURLConnectionImpl_JarURLConnectionInputStream$close(), 0, this);
        }

        public /* synthetic */ JarURLConnectionInputStream() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (JarURLConnectionInputStream)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

