/*
 * Decompiled with CFR 0.152.
 */
package libcore.net.url;

import com.google.errorprone.annotations.DoNotMock;
import java.util.Locale;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class UrlUtils
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;

    private void $$robo$$libcore_net_url_UrlUtils$__constructor__() {
    }

    private static final String $$robo$$libcore_net_url_UrlUtils$canonicalizePath(String path, boolean discardRelativePrefix) {
        int segmentStart = 0;
        int deletableSegments = 0;
        int i = 0;
        while (i <= path.length()) {
            int nextSegmentStart;
            if (i == path.length()) {
                nextSegmentStart = i;
            } else if (path.charAt(i) == '/') {
                nextSegmentStart = i + 1;
            } else {
                ++i;
                continue;
            }
            if (i == segmentStart + 1 && path.regionMatches(segmentStart, ".", 0, 1)) {
                path = path.substring(0, segmentStart) + path.substring(nextSegmentStart);
                i = segmentStart;
                continue;
            }
            if (i == segmentStart + 2 && path.regionMatches(segmentStart, "..", 0, 2)) {
                if (deletableSegments > 0 || discardRelativePrefix) {
                    --deletableSegments;
                    int prevSegmentStart = path.lastIndexOf(47, segmentStart - 2) + 1;
                    path = path.substring(0, prevSegmentStart) + path.substring(nextSegmentStart);
                    i = segmentStart = prevSegmentStart;
                    continue;
                }
                segmentStart = ++i;
                continue;
            }
            if (i > 0) {
                ++deletableSegments;
            }
            segmentStart = ++i;
        }
        return path;
    }

    private static final String $$robo$$libcore_net_url_UrlUtils$authoritySafePath(String authority, String path) {
        if (!(authority == null || authority.isEmpty() || path.isEmpty() || path.startsWith("/"))) {
            return "/" + path;
        }
        return path;
    }

    private static final String $$robo$$libcore_net_url_UrlUtils$getSchemePrefix(String spec) {
        int colon = spec.indexOf(58);
        if (colon < 1) {
            return null;
        }
        for (int i = 0; i < colon; ++i) {
            char c = spec.charAt(i);
            if (UrlUtils.isValidSchemeChar(i, c)) continue;
            return null;
        }
        return spec.substring(0, colon).toLowerCase(Locale.US);
    }

    private static final boolean $$robo$$libcore_net_url_UrlUtils$isValidSchemeChar(int index, char c) {
        if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
            return true;
        }
        return index > 0 && (c >= '0' && c <= '9' || c == '+' || c == '-' || c == '.');
    }

    private static final int $$robo$$libcore_net_url_UrlUtils$findFirstOf(String string2, String chars, int start, int end) {
        for (int i = start; i < end; ++i) {
            char c = string2.charAt(i);
            if (chars.indexOf(c) == -1) continue;
            return i;
        }
        return end;
    }

    private void __constructor__() {
        this.$$robo$$libcore_net_url_UrlUtils$__constructor__();
    }

    private UrlUtils() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$libcore_net_url_UrlUtils$__constructor__(), 0, this);
    }

    public static String canonicalizePath(String string2, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("canonicalizePath", $$robo$$libcore_net_url_UrlUtils$canonicalizePath(java.lang.String boolean ), 0, (String)string2, (boolean)bl);
    }

    public static String authoritySafePath(String string2, String string3) {
        return InvokeDynamicSupport.bootstrapStatic("authoritySafePath", $$robo$$libcore_net_url_UrlUtils$authoritySafePath(java.lang.String java.lang.String ), 0, (String)string2, (String)string3);
    }

    public static String getSchemePrefix(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getSchemePrefix", $$robo$$libcore_net_url_UrlUtils$getSchemePrefix(java.lang.String ), 0, (String)string2);
    }

    public static boolean isValidSchemeChar(int n, char c) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isValidSchemeChar", $$robo$$libcore_net_url_UrlUtils$isValidSchemeChar(int char ), 0, (int)n, (char)c);
    }

    public static int findFirstOf(String string2, String string3, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("findFirstOf", $$robo$$libcore_net_url_UrlUtils$findFirstOf(java.lang.String java.lang.String int int ), 0, (String)string2, (String)string3, (int)n, (int)n2);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (UrlUtils)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

