/*
 * Decompiled with CFR 0.152.
 */
package libcore.reflect;

import com.android.dex.Annotation;
import com.android.dex.Dex;
import com.android.dex.EncodedValueReader;
import com.android.dex.FieldId;
import com.android.dex.ProtoId;
import com.android.dex.TypeList;
import com.google.errorprone.annotations.DoNotMock;
import java.lang.annotation.Inherited;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import libcore.reflect.AnnotationFactory;
import libcore.reflect.AnnotationMember;
import libcore.reflect.InternalNames;
import libcore.util.EmptyArray;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class AnnotationAccess
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static Class<?>[] NO_ARGUMENTS;
    private static byte VISIBILITY_BUILD = 0;
    private static byte VISIBILITY_RUNTIME = 1;
    private static byte VISIBILITY_SYSTEM = 2;

    private void $$robo$$libcore_reflect_AnnotationAccess$__constructor__() {
    }

    private static final <A extends java.lang.annotation.Annotation> A $$robo$$libcore_reflect_AnnotationAccess$getAnnotation(Class<?> c, Class<A> annotationType) {
        if (annotationType == null) {
            throw new NullPointerException("annotationType == null");
        }
        A annotation = AnnotationAccess.getDeclaredAnnotation(c, annotationType);
        if (annotation != null) {
            return annotation;
        }
        if (AnnotationAccess.isInherited(annotationType)) {
            for (Class<?> sup = c.getSuperclass(); sup != null; sup = sup.getSuperclass()) {
                annotation = AnnotationAccess.getDeclaredAnnotation(sup, annotationType);
                if (annotation == null) continue;
                return annotation;
            }
        }
        return null;
    }

    private static final boolean $$robo$$libcore_reflect_AnnotationAccess$isInherited(Class<? extends java.lang.annotation.Annotation> annotationType) {
        return AnnotationAccess.isDeclaredAnnotationPresent(annotationType, Inherited.class);
    }

    private static final java.lang.annotation.Annotation[] $$robo$$libcore_reflect_AnnotationAccess$getAnnotations(Class<?> c) {
        HashMap<Class<? extends java.lang.annotation.Annotation>, java.lang.annotation.Annotation> map = new HashMap<Class<? extends java.lang.annotation.Annotation>, java.lang.annotation.Annotation>();
        for (java.lang.annotation.Annotation declaredAnnotation : AnnotationAccess.getDeclaredAnnotations(c)) {
            map.put(declaredAnnotation.annotationType(), declaredAnnotation);
        }
        for (Class<?> sup = c.getSuperclass(); sup != null; sup = sup.getSuperclass()) {
            for (java.lang.annotation.Annotation declaredAnnotation : AnnotationAccess.getDeclaredAnnotations(sup)) {
                Class<? extends java.lang.annotation.Annotation> clazz = declaredAnnotation.annotationType();
                if (map.containsKey(clazz) || !AnnotationAccess.isInherited(clazz)) continue;
                map.put(clazz, declaredAnnotation);
            }
        }
        Collection coll = map.values();
        return coll.toArray(new java.lang.annotation.Annotation[coll.size()]);
    }

    private static final boolean $$robo$$libcore_reflect_AnnotationAccess$isAnnotationPresent(Class<?> c, Class<? extends java.lang.annotation.Annotation> annotationType) {
        if (annotationType == null) {
            throw new NullPointerException("annotationType == null");
        }
        if (AnnotationAccess.isDeclaredAnnotationPresent(c, annotationType)) {
            return true;
        }
        if (AnnotationAccess.isInherited(annotationType)) {
            for (Class<?> sup = c.getSuperclass(); sup != null; sup = sup.getSuperclass()) {
                if (!AnnotationAccess.isDeclaredAnnotationPresent(sup, annotationType)) continue;
                return true;
            }
        }
        return false;
    }

    private static final List<java.lang.annotation.Annotation> $$robo$$libcore_reflect_AnnotationAccess$getDeclaredAnnotations(AnnotatedElement element) {
        int offset = AnnotationAccess.getAnnotationSetOffset(element);
        return AnnotationAccess.annotationSetToAnnotations(AnnotationAccess.getDexClass(element), offset);
    }

    private static final <A extends java.lang.annotation.Annotation> A $$robo$$libcore_reflect_AnnotationAccess$getDeclaredAnnotation(AnnotatedElement element, Class<A> annotationClass) {
        Annotation a = AnnotationAccess.getAnnotation(element, annotationClass);
        return a != null ? (A)AnnotationAccess.toAnnotationInstance(AnnotationAccess.getDexClass(element), annotationClass, a) : null;
    }

    private static final boolean $$robo$$libcore_reflect_AnnotationAccess$isDeclaredAnnotationPresent(AnnotatedElement element, Class<? extends java.lang.annotation.Annotation> annotationClass) {
        return AnnotationAccess.getAnnotation(element, annotationClass) != null;
    }

    private static final Annotation $$robo$$libcore_reflect_AnnotationAccess$getAnnotation(AnnotatedElement element, Class<? extends java.lang.annotation.Annotation> annotationClass) {
        int annotationSetOffset = AnnotationAccess.getAnnotationSetOffset(element);
        if (annotationSetOffset == 0) {
            return null;
        }
        Class<?> dexClass = AnnotationAccess.getDexClass(element);
        Dex dex = dexClass.getDex();
        Dex.Section setIn = dex.open(annotationSetOffset);
        String annotationInternalName = InternalNames.getInternalName(annotationClass);
        int size = setIn.readInt();
        for (int i = 0; i < size; ++i) {
            int annotationOffset = setIn.readInt();
            Dex.Section annotationIn = dex.open(annotationOffset);
            Annotation candidate = annotationIn.readAnnotation();
            String candidateInternalName = dex.typeNames().get(candidate.getTypeIndex());
            if (!candidateInternalName.equals(annotationInternalName)) continue;
            return candidate;
        }
        return null;
    }

    private static final int $$robo$$libcore_reflect_AnnotationAccess$getAnnotationSetOffset(AnnotatedElement element) {
        Class<?> dexClass = AnnotationAccess.getDexClass(element);
        int directoryOffset = dexClass.getDexAnnotationDirectoryOffset();
        if (directoryOffset == 0) {
            return 0;
        }
        Dex.Section directoryIn = dexClass.getDex().open(directoryOffset);
        int classSetOffset = directoryIn.readInt();
        if (element instanceof Class) {
            return classSetOffset;
        }
        int fieldsSize = directoryIn.readInt();
        int methodsSize = directoryIn.readInt();
        directoryIn.readInt();
        if (element instanceof Field) {
            int fieldIndex = ((Field)element).getDexFieldIndex();
            for (int i = 0; i < fieldsSize; ++i) {
                int candidateFieldIndex = directoryIn.readInt();
                int annotationSetOffset = directoryIn.readInt();
                if (candidateFieldIndex != fieldIndex) continue;
                return annotationSetOffset;
            }
            return 0;
        }
        directoryIn.skip(8 * fieldsSize);
        int methodIndex = element instanceof Method ? ((Method)element).getDexMethodIndex() : ((Constructor)element).getDexMethodIndex();
        for (int i = 0; i < methodsSize; ++i) {
            int candidateMethodIndex = directoryIn.readInt();
            int annotationSetOffset = directoryIn.readInt();
            if (candidateMethodIndex != methodIndex) continue;
            return annotationSetOffset;
        }
        return 0;
    }

    private static final Class<?> $$robo$$libcore_reflect_AnnotationAccess$getDexClass(AnnotatedElement element) {
        return element instanceof Class ? (Class<?>)element : ((Member)((Object)element)).getDeclaringClass();
    }

    private static final java.lang.annotation.Annotation[][] $$robo$$libcore_reflect_AnnotationAccess$getParameterAnnotations(Class<?> declaringClass, int methodDexIndex) {
        int i;
        Dex dex = declaringClass.getDex();
        int protoIndex = dex.methodIds().get(methodDexIndex).getProtoIndex();
        ProtoId proto = dex.protoIds().get(protoIndex);
        TypeList parametersList = dex.readTypeList(proto.getParametersOffset());
        short[] types = parametersList.getTypes();
        int typesCount = types.length;
        int directoryOffset = declaringClass.getDexAnnotationDirectoryOffset();
        if (directoryOffset == 0) {
            return new java.lang.annotation.Annotation[typesCount][0];
        }
        Dex.Section directoryIn = dex.open(directoryOffset);
        directoryIn.readInt();
        int fieldsSize = directoryIn.readInt();
        int methodsSize = directoryIn.readInt();
        int parametersSize = directoryIn.readInt();
        for (i = 0; i < fieldsSize; ++i) {
            directoryIn.readInt();
            directoryIn.readInt();
        }
        for (i = 0; i < methodsSize; ++i) {
            directoryIn.readInt();
            directoryIn.readInt();
        }
        for (i = 0; i < parametersSize; ++i) {
            int candidateMethodDexIndex = directoryIn.readInt();
            int annotationSetRefListOffset = directoryIn.readInt();
            if (candidateMethodDexIndex != methodDexIndex) continue;
            Dex.Section refList = dex.open(annotationSetRefListOffset);
            int parameterCount = refList.readInt();
            java.lang.annotation.Annotation[][] result = new java.lang.annotation.Annotation[parameterCount][];
            for (int p = 0; p < parameterCount; ++p) {
                int annotationSetOffset = refList.readInt();
                List<java.lang.annotation.Annotation> annotations = AnnotationAccess.annotationSetToAnnotations(declaringClass, annotationSetOffset);
                result[p] = annotations.toArray(new java.lang.annotation.Annotation[annotations.size()]);
            }
            return result;
        }
        return new java.lang.annotation.Annotation[typesCount][0];
    }

    private static final Object $$robo$$libcore_reflect_AnnotationAccess$getDefaultValue(Method method) {
        Class<?> annotationClass = method.getDeclaringClass();
        Dex dex = annotationClass.getDex();
        EncodedValueReader reader = AnnotationAccess.getOnlyAnnotationValue(dex, annotationClass, "Ldalvik/annotation/AnnotationDefault;");
        if (reader == null) {
            return null;
        }
        int fieldCount = reader.readAnnotation();
        if (reader.getAnnotationType() != annotationClass.getDexTypeIndex()) {
            throw new AssertionError((Object)"annotation value type != annotation class");
        }
        int methodNameIndex = dex.findStringIndex(method.getName());
        for (int i = 0; i < fieldCount; ++i) {
            int candidateNameIndex = reader.readAnnotationName();
            if (candidateNameIndex == methodNameIndex) {
                Class<?> returnType = method.getReturnType();
                return AnnotationAccess.decodeValue(annotationClass, returnType, dex, reader);
            }
            reader.skipValue();
        }
        return null;
    }

    private static final Class<?> $$robo$$libcore_reflect_AnnotationAccess$getEnclosingClass(Class<?> c) {
        Dex dex = c.getDex();
        EncodedValueReader reader = AnnotationAccess.getOnlyAnnotationValue(dex, c, "Ldalvik/annotation/EnclosingClass;");
        if (reader == null) {
            return null;
        }
        return c.getDexCacheType(dex, reader.readType());
    }

    private static final AccessibleObject $$robo$$libcore_reflect_AnnotationAccess$getEnclosingMethodOrConstructor(Class<?> c) {
        Dex dex = c.getDex();
        EncodedValueReader reader = AnnotationAccess.getOnlyAnnotationValue(dex, c, "Ldalvik/annotation/EnclosingMethod;");
        if (reader == null) {
            return null;
        }
        return AnnotationAccess.indexToMethod(c, dex, reader.readMethod());
    }

    private static final Class<?>[] $$robo$$libcore_reflect_AnnotationAccess$getMemberClasses(Class<?> c) {
        Dex dex = c.getDex();
        EncodedValueReader reader = AnnotationAccess.getOnlyAnnotationValue(dex, c, "Ldalvik/annotation/MemberClasses;");
        if (reader == null) {
            return EmptyArray.CLASS;
        }
        return (Class[])AnnotationAccess.decodeValue(c, Class[].class, dex, reader);
    }

    private static final String $$robo$$libcore_reflect_AnnotationAccess$getSignature(AnnotatedElement element) {
        Class<?> dexClass = AnnotationAccess.getDexClass(element);
        Dex dex = dexClass.getDex();
        EncodedValueReader reader = AnnotationAccess.getOnlyAnnotationValue(dex, element, "Ldalvik/annotation/Signature;");
        if (reader == null) {
            return null;
        }
        String[] array2 = (String[])AnnotationAccess.decodeValue(dexClass, String[].class, dex, reader);
        StringBuilder result = new StringBuilder();
        for (String s : array2) {
            result.append(s);
        }
        return result.toString();
    }

    private static final Class<?>[] $$robo$$libcore_reflect_AnnotationAccess$getExceptions(AnnotatedElement element) {
        Class<?> dexClass = AnnotationAccess.getDexClass(element);
        Dex dex = dexClass.getDex();
        EncodedValueReader reader = AnnotationAccess.getOnlyAnnotationValue(dex, element, "Ldalvik/annotation/Throws;");
        if (reader == null) {
            return EmptyArray.CLASS;
        }
        return (Class[])AnnotationAccess.decodeValue(dexClass, Class[].class, dex, reader);
    }

    private static final int $$robo$$libcore_reflect_AnnotationAccess$getInnerClassFlags(Class<?> c, int defaultValue) {
        Dex dex = c.getDex();
        EncodedValueReader reader = AnnotationAccess.getAnnotationReader(dex, c, "Ldalvik/annotation/InnerClass;", 2);
        if (reader == null) {
            return defaultValue;
        }
        reader.readAnnotationName();
        return reader.readInt();
    }

    private static final String $$robo$$libcore_reflect_AnnotationAccess$getInnerClassName(Class<?> c) {
        Dex dex = c.getDex();
        EncodedValueReader reader = AnnotationAccess.getAnnotationReader(dex, c, "Ldalvik/annotation/InnerClass;", 2);
        if (reader == null) {
            return null;
        }
        reader.readAnnotationName();
        reader.readInt();
        reader.readAnnotationName();
        return reader.peek() == 30 ? null : (String)AnnotationAccess.decodeValue(c, String.class, dex, reader);
    }

    private static final boolean $$robo$$libcore_reflect_AnnotationAccess$isAnonymousClass(Class<?> c) {
        Dex dex = c.getDex();
        EncodedValueReader reader = AnnotationAccess.getAnnotationReader(dex, c, "Ldalvik/annotation/InnerClass;", 2);
        if (reader == null) {
            return false;
        }
        reader.readAnnotationName();
        reader.readInt();
        reader.readAnnotationName();
        return reader.peek() == 30;
    }

    private static final EncodedValueReader $$robo$$libcore_reflect_AnnotationAccess$getAnnotationReader(Dex dex, AnnotatedElement element, String annotationName, int expectedFieldCount) {
        int annotationSetOffset = AnnotationAccess.getAnnotationSetOffset(element);
        if (annotationSetOffset == 0) {
            return null;
        }
        Dex.Section setIn = dex.open(annotationSetOffset);
        Annotation annotation = null;
        int size = setIn.readInt();
        for (int i = 0; i < size; ++i) {
            int annotationOffset = setIn.readInt();
            Dex.Section annotationIn = dex.open(annotationOffset);
            Annotation candidate = annotationIn.readAnnotation();
            String candidateAnnotationName = dex.typeNames().get(candidate.getTypeIndex());
            if (!annotationName.equals(candidateAnnotationName)) continue;
            annotation = candidate;
            break;
        }
        if (annotation == null) {
            return null;
        }
        EncodedValueReader reader = annotation.getReader();
        int fieldCount = reader.readAnnotation();
        String readerAnnotationName = dex.typeNames().get(reader.getAnnotationType());
        if (!readerAnnotationName.equals(annotationName)) {
            throw new AssertionError();
        }
        if (fieldCount != expectedFieldCount) {
            return null;
        }
        return reader;
    }

    private static final EncodedValueReader $$robo$$libcore_reflect_AnnotationAccess$getOnlyAnnotationValue(Dex dex, AnnotatedElement element, String annotationName) {
        EncodedValueReader reader = AnnotationAccess.getAnnotationReader(dex, element, annotationName, 1);
        if (reader == null) {
            return null;
        }
        reader.readAnnotationName();
        return reader;
    }

    private static final Class<? extends java.lang.annotation.Annotation> $$robo$$libcore_reflect_AnnotationAccess$getAnnotationClass(Class<?> context, Dex dex, int typeIndex) {
        try {
            Class result = context.getDexCacheType(dex, typeIndex);
            if (!result.isAnnotation()) {
                throw new IncompatibleClassChangeError("Expected annotation: " + result.getName());
            }
            return result;
        }
        catch (NoClassDefFoundError ncdfe) {
            return null;
        }
    }

    private static final AccessibleObject $$robo$$libcore_reflect_AnnotationAccess$indexToMethod(Class<?> context, Dex dex, int methodIndex) {
        Class declaringClass = context.getDexCacheType(dex, dex.declaringClassIndexFromMethodIndex(methodIndex));
        String name = context.getDexCacheString(dex, dex.nameIndexFromMethodIndex(methodIndex));
        short[] types = dex.parameterTypeIndicesFromMethodIndex(methodIndex);
        Object[] parametersArray = new Class[types.length];
        for (int i = 0; i < types.length; ++i) {
            parametersArray[i] = context.getDexCacheType(dex, types[i]);
        }
        try {
            return name.equals("<init>") ? declaringClass.getDeclaredConstructor((Class<?>[])parametersArray) : declaringClass.getDeclaredMethod(name, (Class<?>[])parametersArray);
        }
        catch (NoSuchMethodException e) {
            throw new IncompatibleClassChangeError("Couldn't find " + declaringClass.getName() + "." + name + Arrays.toString(parametersArray));
        }
    }

    private static final List<java.lang.annotation.Annotation> $$robo$$libcore_reflect_AnnotationAccess$annotationSetToAnnotations(Class<?> context, int offset) {
        if (offset == 0) {
            return Collections.emptyList();
        }
        Dex dex = context.getDex();
        Dex.Section setIn = dex.open(offset);
        int size = setIn.readInt();
        ArrayList<java.lang.annotation.Annotation> result = new ArrayList<java.lang.annotation.Annotation>(size);
        for (int i = 0; i < size; ++i) {
            Class<? extends java.lang.annotation.Annotation> annotationClass;
            int annotationOffset = setIn.readInt();
            Dex.Section annotationIn = dex.open(annotationOffset);
            Annotation annotation = annotationIn.readAnnotation();
            if (annotation.getVisibility() != 1 || (annotationClass = AnnotationAccess.getAnnotationClass(context, dex, annotation.getTypeIndex())) == null) continue;
            result.add(AnnotationAccess.toAnnotationInstance(context, dex, annotationClass, annotation.getReader()));
        }
        return result;
    }

    private static final <A extends java.lang.annotation.Annotation> A $$robo$$libcore_reflect_AnnotationAccess$toAnnotationInstance(Class<?> context, Class<A> annotationClass, Annotation annotation) {
        return AnnotationAccess.toAnnotationInstance(context, context.getDex(), annotationClass, annotation.getReader());
    }

    private static final <A extends java.lang.annotation.Annotation> A $$robo$$libcore_reflect_AnnotationAccess$toAnnotationInstance(Class<?> context, Dex dex, Class<A> annotationClass, EncodedValueReader reader) {
        int fieldCount = reader.readAnnotation();
        if (annotationClass != context.getDexCacheType(dex, reader.getAnnotationType())) {
            throw new AssertionError((Object)"annotation value type != return type");
        }
        AnnotationMember[] members = new AnnotationMember[fieldCount];
        for (int i = 0; i < fieldCount; ++i) {
            Method method;
            int name = reader.readAnnotationName();
            String nameString = dex.strings().get(name);
            try {
                method = annotationClass.getMethod(nameString, NO_ARGUMENTS);
            }
            catch (NoSuchMethodException e) {
                throw new IncompatibleClassChangeError("Couldn't find " + annotationClass.getName() + "." + nameString);
            }
            Class<?> returnType = method.getReturnType();
            Object value = AnnotationAccess.decodeValue(context, returnType, dex, reader);
            members[i] = new AnnotationMember(nameString, value, returnType, method);
        }
        return AnnotationFactory.createAnnotation(annotationClass, members);
    }

    private static final Object $$robo$$libcore_reflect_AnnotationAccess$decodeValue(Class<?> context, Class<?> type, Dex dex, EncodedValueReader reader) {
        if (type.isArray()) {
            int size = reader.readArray();
            Class<?> componentType = type.getComponentType();
            Object array2 = Array.newInstance(componentType, size);
            for (int i = 0; i < size; ++i) {
                Array.set(array2, i, AnnotationAccess.decodeValue(context, componentType, dex, reader));
            }
            return array2;
        }
        if (type.isEnum()) {
            int fieldIndex = reader.readEnum();
            FieldId fieldId = dex.fieldIds().get(fieldIndex);
            String fieldName = dex.strings().get(fieldId.getNameIndex());
            try {
                Field field = type.getDeclaredField(fieldName);
                return field.get(null);
            }
            catch (NoSuchFieldException e) {
                NoSuchFieldError error = new NoSuchFieldError();
                error.initCause(e);
                throw error;
            }
            catch (IllegalAccessException e) {
                IllegalAccessError error = new IllegalAccessError();
                error.initCause(e);
                throw error;
            }
        }
        if (type.isAnnotation()) {
            Class<?> annotationClass = type;
            return AnnotationAccess.toAnnotationInstance(context, dex, annotationClass, reader);
        }
        if (type == String.class) {
            int index = reader.readString();
            return context.getDexCacheString(dex, index);
        }
        if (type == Class.class) {
            int index = reader.readType();
            return context.getDexCacheType(dex, index);
        }
        if (type == Byte.TYPE) {
            return reader.readByte();
        }
        if (type == Short.TYPE) {
            return reader.readShort();
        }
        if (type == Integer.TYPE) {
            return reader.readInt();
        }
        if (type == Long.TYPE) {
            return reader.readLong();
        }
        if (type == Float.TYPE) {
            return Float.valueOf(reader.readFloat());
        }
        if (type == Double.TYPE) {
            return reader.readDouble();
        }
        if (type == Character.TYPE) {
            return Character.valueOf(reader.readChar());
        }
        if (type == Boolean.TYPE) {
            return reader.readBoolean();
        }
        throw new AssertionError((Object)("Unexpected annotation value type: " + type));
    }

    static void __staticInitializer__() {
        NO_ARGUMENTS = null;
    }

    private void __constructor__() {
        this.$$robo$$libcore_reflect_AnnotationAccess$__constructor__();
    }

    private AnnotationAccess() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$libcore_reflect_AnnotationAccess$__constructor__(), 0, this);
    }

    public static <A extends java.lang.annotation.Annotation> A getAnnotation(Class<?> clazz, Class<A> clazz2) {
        return (A)InvokeDynamicSupport.bootstrapStatic("getAnnotation", $$robo$$libcore_reflect_AnnotationAccess$getAnnotation(java.lang.Class<?> java.lang.Class<A> ), 0, clazz, clazz2);
    }

    private static boolean isInherited(Class<? extends java.lang.annotation.Annotation> clazz) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isInherited", $$robo$$libcore_reflect_AnnotationAccess$isInherited(java.lang.Class<? extends java.lang.annotation.Annotation> ), 0, clazz);
    }

    public static java.lang.annotation.Annotation[] getAnnotations(Class<?> clazz) {
        return InvokeDynamicSupport.bootstrapStatic("getAnnotations", $$robo$$libcore_reflect_AnnotationAccess$getAnnotations(java.lang.Class<?> ), 0, clazz);
    }

    public static boolean isAnnotationPresent(Class<?> clazz, Class<? extends java.lang.annotation.Annotation> clazz2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isAnnotationPresent", $$robo$$libcore_reflect_AnnotationAccess$isAnnotationPresent(java.lang.Class<?> java.lang.Class<? extends java.lang.annotation.Annotation> ), 0, clazz, clazz2);
    }

    public static List<java.lang.annotation.Annotation> getDeclaredAnnotations(AnnotatedElement annotatedElement) {
        return InvokeDynamicSupport.bootstrapStatic("getDeclaredAnnotations", $$robo$$libcore_reflect_AnnotationAccess$getDeclaredAnnotations(java.lang.reflect.AnnotatedElement ), 0, (AnnotatedElement)annotatedElement);
    }

    public static <A extends java.lang.annotation.Annotation> A getDeclaredAnnotation(AnnotatedElement annotatedElement, Class<A> clazz) {
        return (A)InvokeDynamicSupport.bootstrapStatic("getDeclaredAnnotation", $$robo$$libcore_reflect_AnnotationAccess$getDeclaredAnnotation(java.lang.reflect.AnnotatedElement java.lang.Class<A> ), 0, (AnnotatedElement)annotatedElement, clazz);
    }

    public static boolean isDeclaredAnnotationPresent(AnnotatedElement annotatedElement, Class<? extends java.lang.annotation.Annotation> clazz) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isDeclaredAnnotationPresent", $$robo$$libcore_reflect_AnnotationAccess$isDeclaredAnnotationPresent(java.lang.reflect.AnnotatedElement java.lang.Class<? extends java.lang.annotation.Annotation> ), 0, (AnnotatedElement)annotatedElement, clazz);
    }

    private static Annotation getAnnotation(AnnotatedElement annotatedElement, Class<? extends java.lang.annotation.Annotation> clazz) {
        return InvokeDynamicSupport.bootstrapStatic("getAnnotation", $$robo$$libcore_reflect_AnnotationAccess$getAnnotation(java.lang.reflect.AnnotatedElement java.lang.Class<? extends java.lang.annotation.Annotation> ), 0, (AnnotatedElement)annotatedElement, clazz);
    }

    private static int getAnnotationSetOffset(AnnotatedElement annotatedElement) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getAnnotationSetOffset", $$robo$$libcore_reflect_AnnotationAccess$getAnnotationSetOffset(java.lang.reflect.AnnotatedElement ), 0, (AnnotatedElement)annotatedElement);
    }

    private static Class<?> getDexClass(AnnotatedElement annotatedElement) {
        return InvokeDynamicSupport.bootstrapStatic("getDexClass", $$robo$$libcore_reflect_AnnotationAccess$getDexClass(java.lang.reflect.AnnotatedElement ), 0, (AnnotatedElement)annotatedElement);
    }

    public static java.lang.annotation.Annotation[][] getParameterAnnotations(Class<?> clazz, int n) {
        return InvokeDynamicSupport.bootstrapStatic("getParameterAnnotations", $$robo$$libcore_reflect_AnnotationAccess$getParameterAnnotations(java.lang.Class<?> int ), 0, clazz, (int)n);
    }

    public static Object getDefaultValue(Method method) {
        return InvokeDynamicSupport.bootstrapStatic("getDefaultValue", $$robo$$libcore_reflect_AnnotationAccess$getDefaultValue(java.lang.reflect.Method ), 0, (Method)method);
    }

    public static Class<?> getEnclosingClass(Class<?> clazz) {
        return InvokeDynamicSupport.bootstrapStatic("getEnclosingClass", $$robo$$libcore_reflect_AnnotationAccess$getEnclosingClass(java.lang.Class<?> ), 0, clazz);
    }

    public static AccessibleObject getEnclosingMethodOrConstructor(Class<?> clazz) {
        return InvokeDynamicSupport.bootstrapStatic("getEnclosingMethodOrConstructor", $$robo$$libcore_reflect_AnnotationAccess$getEnclosingMethodOrConstructor(java.lang.Class<?> ), 0, clazz);
    }

    public static Class<?>[] getMemberClasses(Class<?> clazz) {
        return InvokeDynamicSupport.bootstrapStatic("getMemberClasses", $$robo$$libcore_reflect_AnnotationAccess$getMemberClasses(java.lang.Class<?> ), 0, clazz);
    }

    public static String getSignature(AnnotatedElement annotatedElement) {
        return InvokeDynamicSupport.bootstrapStatic("getSignature", $$robo$$libcore_reflect_AnnotationAccess$getSignature(java.lang.reflect.AnnotatedElement ), 0, (AnnotatedElement)annotatedElement);
    }

    public static Class<?>[] getExceptions(AnnotatedElement annotatedElement) {
        return InvokeDynamicSupport.bootstrapStatic("getExceptions", $$robo$$libcore_reflect_AnnotationAccess$getExceptions(java.lang.reflect.AnnotatedElement ), 0, (AnnotatedElement)annotatedElement);
    }

    public static int getInnerClassFlags(Class<?> clazz, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getInnerClassFlags", $$robo$$libcore_reflect_AnnotationAccess$getInnerClassFlags(java.lang.Class<?> int ), 0, clazz, (int)n);
    }

    public static String getInnerClassName(Class<?> clazz) {
        return InvokeDynamicSupport.bootstrapStatic("getInnerClassName", $$robo$$libcore_reflect_AnnotationAccess$getInnerClassName(java.lang.Class<?> ), 0, clazz);
    }

    public static boolean isAnonymousClass(Class<?> clazz) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isAnonymousClass", $$robo$$libcore_reflect_AnnotationAccess$isAnonymousClass(java.lang.Class<?> ), 0, clazz);
    }

    private static EncodedValueReader getAnnotationReader(Dex dex, AnnotatedElement annotatedElement, String string2, int n) {
        return InvokeDynamicSupport.bootstrapStatic("getAnnotationReader", $$robo$$libcore_reflect_AnnotationAccess$getAnnotationReader(com.android.dex.Dex java.lang.reflect.AnnotatedElement java.lang.String int ), 0, (Dex)dex, (AnnotatedElement)annotatedElement, (String)string2, (int)n);
    }

    private static EncodedValueReader getOnlyAnnotationValue(Dex dex, AnnotatedElement annotatedElement, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getOnlyAnnotationValue", $$robo$$libcore_reflect_AnnotationAccess$getOnlyAnnotationValue(com.android.dex.Dex java.lang.reflect.AnnotatedElement java.lang.String ), 0, (Dex)dex, (AnnotatedElement)annotatedElement, (String)string2);
    }

    private static Class<? extends java.lang.annotation.Annotation> getAnnotationClass(Class<?> clazz, Dex dex, int n) {
        return InvokeDynamicSupport.bootstrapStatic("getAnnotationClass", $$robo$$libcore_reflect_AnnotationAccess$getAnnotationClass(java.lang.Class<?> com.android.dex.Dex int ), 0, clazz, (Dex)dex, (int)n);
    }

    private static AccessibleObject indexToMethod(Class<?> clazz, Dex dex, int n) {
        return InvokeDynamicSupport.bootstrapStatic("indexToMethod", $$robo$$libcore_reflect_AnnotationAccess$indexToMethod(java.lang.Class<?> com.android.dex.Dex int ), 0, clazz, (Dex)dex, (int)n);
    }

    private static List<java.lang.annotation.Annotation> annotationSetToAnnotations(Class<?> clazz, int n) {
        return InvokeDynamicSupport.bootstrapStatic("annotationSetToAnnotations", $$robo$$libcore_reflect_AnnotationAccess$annotationSetToAnnotations(java.lang.Class<?> int ), 0, clazz, (int)n);
    }

    private static <A extends java.lang.annotation.Annotation> A toAnnotationInstance(Class<?> clazz, Class<A> clazz2, Annotation annotation) {
        return (A)InvokeDynamicSupport.bootstrapStatic("toAnnotationInstance", $$robo$$libcore_reflect_AnnotationAccess$toAnnotationInstance(java.lang.Class<?> java.lang.Class<A> com.android.dex.Annotation ), 0, clazz, clazz2, (Annotation)annotation);
    }

    private static <A extends java.lang.annotation.Annotation> A toAnnotationInstance(Class<?> clazz, Dex dex, Class<A> clazz2, EncodedValueReader encodedValueReader) {
        return (A)InvokeDynamicSupport.bootstrapStatic("toAnnotationInstance", $$robo$$libcore_reflect_AnnotationAccess$toAnnotationInstance(java.lang.Class<?> com.android.dex.Dex java.lang.Class<A> com.android.dex.EncodedValueReader ), 0, clazz, (Dex)dex, clazz2, (EncodedValueReader)encodedValueReader);
    }

    private static Object decodeValue(Class<?> clazz, Class<?> clazz2, Dex dex, EncodedValueReader encodedValueReader) {
        return InvokeDynamicSupport.bootstrapStatic("decodeValue", $$robo$$libcore_reflect_AnnotationAccess$decodeValue(java.lang.Class<?> java.lang.Class<?> com.android.dex.Dex com.android.dex.EncodedValueReader ), 0, clazz, clazz2, (Dex)dex, (EncodedValueReader)encodedValueReader);
    }

    static {
        RobolectricInternals.classInitializing(AnnotationAccess.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AnnotationAccess)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

