/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.fortress;

import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import org.apache.harmony.security.fortress.Engine;

public class Services {
    private static final HashMap<String, ArrayList<Provider.Service>> services = new HashMap(600);
    private static Provider.Service cachedSecureRandomService;
    private static boolean needRefresh;
    private static int cacheVersion;
    private static final ArrayList<Provider> providers;
    private static final HashMap<String, Provider> providersNames;

    public static synchronized ArrayList<Provider> getProviders() {
        return providers;
    }

    public static synchronized Provider getProvider(String name) {
        if (name == null) {
            return null;
        }
        return providersNames.get(name);
    }

    public static synchronized int insertProviderAt(Provider provider, int position) {
        int size = providers.size();
        if (position < 1 || position > size) {
            position = size + 1;
        }
        providers.add(position - 1, provider);
        providersNames.put(provider.getName(), provider);
        Services.setNeedRefresh();
        return position;
    }

    public static synchronized void removeProvider(int providerNumber) {
        Provider p = providers.remove(providerNumber - 1);
        providersNames.remove(p.getName());
        Services.setNeedRefresh();
    }

    public static synchronized void initServiceInfo(Provider p) {
        for (Provider.Service service : p.getServices()) {
            String type = service.getType();
            if (cachedSecureRandomService == null && type.equals("SecureRandom")) {
                cachedSecureRandomService = service;
            }
            String key = type + "." + service.getAlgorithm().toUpperCase(Locale.US);
            Services.appendServiceLocked(key, service);
            for (String alias : Engine.door.getAliases(service)) {
                key = type + "." + alias.toUpperCase(Locale.US);
                Services.appendServiceLocked(key, service);
            }
        }
    }

    private static void appendServiceLocked(String key, Provider.Service service) {
        ArrayList<Provider.Service> serviceList = services.get(key);
        if (serviceList == null) {
            serviceList = new ArrayList(1);
            services.put(key, serviceList);
        }
        serviceList.add(service);
    }

    public static synchronized boolean isEmpty() {
        return services.isEmpty();
    }

    public static synchronized ArrayList<Provider.Service> getServices(String key) {
        return services.get(key);
    }

    public static synchronized Provider.Service getSecureRandomService() {
        Services.getCacheVersion();
        return cachedSecureRandomService;
    }

    public static synchronized void setNeedRefresh() {
        needRefresh = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized int getCacheVersion() {
        if (needRefresh) {
            ++cacheVersion;
            HashMap<String, ArrayList<Provider.Service>> hashMap = services;
            synchronized (hashMap) {
                services.clear();
            }
            cachedSecureRandomService = null;
            for (Provider p : providers) {
                Services.initServiceInfo(p);
            }
            needRefresh = false;
        }
        return cacheVersion;
    }

    static {
        cacheVersion = 1;
        providers = new ArrayList(20);
        providersNames = new HashMap(20);
        String providerClassName = null;
        int i = 1;
        ClassLoader cl = ClassLoader.getSystemClassLoader();
        while ((providerClassName = Security.getProperty("security.provider." + i++)) != null) {
            try {
                Class<?> providerClass = Class.forName(providerClassName.trim(), true, cl);
                Provider p = (Provider)providerClass.newInstance();
                providers.add(p);
                providersNames.put(p.getName(), p);
                Services.initServiceInfo(p);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InstantiationException instantiationException) {}
        }
        Engine.door.renumProviders();
    }
}

