/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.x509.tsp;

import java.security.InvalidParameterException;

public enum PKIFailureInfo {
    BAD_ALG(0),
    BAD_REQUEST(2),
    BAD_DATA_FORMAT(5),
    TIME_NOT_AVAILABLE(14),
    UNACCEPTED_POLICY(15),
    UNACCEPTED_EXTENSION(16),
    ADD_INFO_NOT_AVAILABLE(17),
    SYSTEM_FAILURE(25);

    private final int value;
    private static int maxValue;

    private PKIFailureInfo(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static int getMaxValue() {
        if (maxValue == 0) {
            for (PKIFailureInfo cur : PKIFailureInfo.values()) {
                if (cur.value <= maxValue) continue;
                maxValue = cur.value;
            }
        }
        return maxValue;
    }

    public static PKIFailureInfo getInstance(int value) {
        for (PKIFailureInfo info : PKIFailureInfo.values()) {
            if (value != info.value) continue;
            return info;
        }
        throw new InvalidParameterException("Unknown PKIFailureInfo value");
    }
}

