/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.auth;

import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthSchemeFactory;
import org.apache.http.params.HttpParams;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class AuthSchemeRegistry
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private Map<String, AuthSchemeFactory> registeredSchemes;

    private void $$robo$$org_apache_http_auth_AuthSchemeRegistry$__constructor__() {
        this.registeredSchemes = new LinkedHashMap<String, AuthSchemeFactory>();
    }

    private final synchronized void $$robo$$org_apache_http_auth_AuthSchemeRegistry$register(String name, AuthSchemeFactory factory) {
        if (name == null) {
            throw new IllegalArgumentException("Name may not be null");
        }
        if (factory == null) {
            throw new IllegalArgumentException("Authentication scheme factory may not be null");
        }
        this.registeredSchemes.put(name.toLowerCase(Locale.ENGLISH), factory);
    }

    private final synchronized void $$robo$$org_apache_http_auth_AuthSchemeRegistry$unregister(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name may not be null");
        }
        this.registeredSchemes.remove(name.toLowerCase(Locale.ENGLISH));
    }

    private final synchronized AuthScheme $$robo$$org_apache_http_auth_AuthSchemeRegistry$getAuthScheme(String name, HttpParams params) throws IllegalStateException {
        if (name == null) {
            throw new IllegalArgumentException("Name may not be null");
        }
        AuthSchemeFactory factory = this.registeredSchemes.get(name.toLowerCase(Locale.ENGLISH));
        if (factory != null) {
            return factory.newInstance(params);
        }
        throw new IllegalStateException("Unsupported authentication scheme: " + name);
    }

    private final synchronized List<String> $$robo$$org_apache_http_auth_AuthSchemeRegistry$getSchemeNames() {
        return new ArrayList<String>(this.registeredSchemes.keySet());
    }

    private final synchronized void $$robo$$org_apache_http_auth_AuthSchemeRegistry$setItems(Map<String, AuthSchemeFactory> map) {
        if (map == null) {
            return;
        }
        this.registeredSchemes.clear();
        this.registeredSchemes.putAll(map);
    }

    private void __constructor__() {
        this.$$robo$$org_apache_http_auth_AuthSchemeRegistry$__constructor__();
    }

    public AuthSchemeRegistry() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_auth_AuthSchemeRegistry$__constructor__(), 0, this);
    }

    public synchronized void register(String string2, AuthSchemeFactory authSchemeFactory) {
        InvokeDynamicSupport.bootstrap("register", $$robo$$org_apache_http_auth_AuthSchemeRegistry$register(java.lang.String org.apache.http.auth.AuthSchemeFactory ), 0, this, string2, authSchemeFactory);
    }

    public synchronized void unregister(String string2) {
        InvokeDynamicSupport.bootstrap("unregister", $$robo$$org_apache_http_auth_AuthSchemeRegistry$unregister(java.lang.String ), 0, this, string2);
    }

    public synchronized AuthScheme getAuthScheme(String string2, HttpParams httpParams) throws IllegalStateException {
        return InvokeDynamicSupport.bootstrap("getAuthScheme", $$robo$$org_apache_http_auth_AuthSchemeRegistry$getAuthScheme(java.lang.String org.apache.http.params.HttpParams ), 0, this, string2, httpParams);
    }

    public synchronized List<String> getSchemeNames() {
        return InvokeDynamicSupport.bootstrap("getSchemeNames", $$robo$$org_apache_http_auth_AuthSchemeRegistry$getSchemeNames(), 0, this);
    }

    public synchronized void setItems(Map<String, AuthSchemeFactory> map) {
        InvokeDynamicSupport.bootstrap("setItems", $$robo$$org_apache_http_auth_AuthSchemeRegistry$setItems(java.util.Map<java.lang.String, org.apache.http.auth.AuthSchemeFactory> ), 0, this, map);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AuthSchemeRegistry)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

