/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.methods;

import java.io.IOException;
import java.net.URI;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.http.ProtocolVersion;
import org.apache.http.RequestLine;
import org.apache.http.client.methods.AbortableHttpRequest;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.CloneUtils;
import org.apache.http.conn.ClientConnectionRequest;
import org.apache.http.conn.ConnectionReleaseTrigger;
import org.apache.http.message.AbstractHttpMessage;
import org.apache.http.message.BasicRequestLine;
import org.apache.http.message.HeaderGroup;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class HttpRequestBase
extends AbstractHttpMessage
implements HttpUriRequest,
AbortableHttpRequest,
Cloneable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private Lock abortLock;
    private boolean aborted;
    private URI uri;
    private ClientConnectionRequest connRequest;
    private ConnectionReleaseTrigger releaseTrigger;

    private void $$robo$$org_apache_http_client_methods_HttpRequestBase$__constructor__() {
        this.abortLock = new ReentrantLock();
    }

    @Override
    public abstract String getMethod();

    private final ProtocolVersion $$robo$$org_apache_http_client_methods_HttpRequestBase$getProtocolVersion() {
        return HttpProtocolParams.getVersion(this.getParams());
    }

    private final URI $$robo$$org_apache_http_client_methods_HttpRequestBase$getURI() {
        return this.uri;
    }

    private final RequestLine $$robo$$org_apache_http_client_methods_HttpRequestBase$getRequestLine() {
        String method = this.getMethod();
        ProtocolVersion ver = this.getProtocolVersion();
        URI uri = this.getURI();
        String uritext = null;
        if (uri != null) {
            uritext = uri.toASCIIString();
        }
        if (uritext == null || uritext.length() == 0) {
            uritext = "/";
        }
        return new BasicRequestLine(method, uritext, ver);
    }

    private final void $$robo$$org_apache_http_client_methods_HttpRequestBase$setURI(URI uri) {
        this.uri = uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$org_apache_http_client_methods_HttpRequestBase$setConnectionRequest(ClientConnectionRequest connRequest) throws IOException {
        this.abortLock.lock();
        try {
            if (this.aborted) {
                throw new IOException("Request already aborted");
            }
            this.releaseTrigger = null;
            this.connRequest = connRequest;
        }
        finally {
            this.abortLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$org_apache_http_client_methods_HttpRequestBase$setReleaseTrigger(ConnectionReleaseTrigger releaseTrigger) throws IOException {
        this.abortLock.lock();
        try {
            if (this.aborted) {
                throw new IOException("Request already aborted");
            }
            this.connRequest = null;
            this.releaseTrigger = releaseTrigger;
        }
        finally {
            this.abortLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$org_apache_http_client_methods_HttpRequestBase$abort() {
        ConnectionReleaseTrigger localTrigger;
        ClientConnectionRequest localRequest;
        this.abortLock.lock();
        try {
            if (this.aborted) {
                return;
            }
            this.aborted = true;
            localRequest = this.connRequest;
            localTrigger = this.releaseTrigger;
        }
        finally {
            this.abortLock.unlock();
        }
        if (localRequest != null) {
            localRequest.abortRequest();
        }
        if (localTrigger != null) {
            try {
                localTrigger.abortConnection();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private final boolean $$robo$$org_apache_http_client_methods_HttpRequestBase$isAborted() {
        return this.aborted;
    }

    private final Object $$robo$$org_apache_http_client_methods_HttpRequestBase$clone() throws CloneNotSupportedException {
        HttpRequestBase clone = (HttpRequestBase)super.clone();
        clone.abortLock = new ReentrantLock();
        clone.aborted = false;
        clone.releaseTrigger = null;
        clone.connRequest = null;
        clone.headergroup = (HeaderGroup)CloneUtils.clone(this.headergroup);
        clone.params = (HttpParams)CloneUtils.clone(this.params);
        return clone;
    }

    private void __constructor__() {
        this.$$robo$$org_apache_http_client_methods_HttpRequestBase$__constructor__();
    }

    public HttpRequestBase() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_client_methods_HttpRequestBase$__constructor__(), 0, this);
    }

    @Override
    public ProtocolVersion getProtocolVersion() {
        return InvokeDynamicSupport.bootstrap("getProtocolVersion", $$robo$$org_apache_http_client_methods_HttpRequestBase$getProtocolVersion(), 0, this);
    }

    @Override
    public URI getURI() {
        return InvokeDynamicSupport.bootstrap("getURI", $$robo$$org_apache_http_client_methods_HttpRequestBase$getURI(), 0, this);
    }

    @Override
    public RequestLine getRequestLine() {
        return InvokeDynamicSupport.bootstrap("getRequestLine", $$robo$$org_apache_http_client_methods_HttpRequestBase$getRequestLine(), 0, this);
    }

    public void setURI(URI uRI) {
        InvokeDynamicSupport.bootstrap("setURI", $$robo$$org_apache_http_client_methods_HttpRequestBase$setURI(java.net.URI ), 0, this, uRI);
    }

    @Override
    public void setConnectionRequest(ClientConnectionRequest clientConnectionRequest) throws IOException {
        InvokeDynamicSupport.bootstrap("setConnectionRequest", $$robo$$org_apache_http_client_methods_HttpRequestBase$setConnectionRequest(org.apache.http.conn.ClientConnectionRequest ), 0, this, clientConnectionRequest);
    }

    @Override
    public void setReleaseTrigger(ConnectionReleaseTrigger connectionReleaseTrigger) throws IOException {
        InvokeDynamicSupport.bootstrap("setReleaseTrigger", $$robo$$org_apache_http_client_methods_HttpRequestBase$setReleaseTrigger(org.apache.http.conn.ConnectionReleaseTrigger ), 0, this, connectionReleaseTrigger);
    }

    @Override
    public void abort() {
        InvokeDynamicSupport.bootstrap("abort", $$robo$$org_apache_http_client_methods_HttpRequestBase$abort(), 0, this);
    }

    @Override
    public boolean isAborted() {
        return (boolean)InvokeDynamicSupport.bootstrap("isAborted", $$robo$$org_apache_http_client_methods_HttpRequestBase$isAborted(), 0, this);
    }

    public Object clone() throws CloneNotSupportedException {
        return InvokeDynamicSupport.bootstrap("clone", $$robo$$org_apache_http_client_methods_HttpRequestBase$clone(), 0, this);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (HttpRequestBase)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

