/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.protocol;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;
import org.apache.http.protocol.HttpContext;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class RequestProxyAuthentication
implements HttpRequestInterceptor,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private Log log;

    private void $$robo$$org_apache_http_client_protocol_RequestProxyAuthentication$__constructor__() {
        this.log = LogFactory.getLog(this.getClass());
    }

    private final void $$robo$$org_apache_http_client_protocol_RequestProxyAuthentication$process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        block9: {
            if (request == null) {
                throw new IllegalArgumentException("HTTP request may not be null");
            }
            if (context == null) {
                throw new IllegalArgumentException("HTTP context may not be null");
            }
            if (request.containsHeader("Proxy-Authorization")) {
                return;
            }
            AuthState authState = (AuthState)context.getAttribute("http.auth.proxy-scope");
            if (authState == null) {
                return;
            }
            AuthScheme authScheme = authState.getAuthScheme();
            if (authScheme == null) {
                return;
            }
            Credentials creds = authState.getCredentials();
            if (creds == null) {
                this.log.debug("User credentials not available");
                return;
            }
            if (authState.getAuthScope() != null || !authScheme.isConnectionBased()) {
                try {
                    request.addHeader(authScheme.authenticate(creds, request));
                }
                catch (AuthenticationException ex) {
                    if (!this.log.isErrorEnabled()) break block9;
                    this.log.error("Proxy authentication error: " + ex.getMessage());
                }
            }
        }
    }

    private void __constructor__() {
        this.$$robo$$org_apache_http_client_protocol_RequestProxyAuthentication$__constructor__();
    }

    public RequestProxyAuthentication() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_client_protocol_RequestProxyAuthentication$__constructor__(), 0, this);
    }

    @Override
    public void process(HttpRequest httpRequest, HttpContext httpContext) throws HttpException, IOException {
        InvokeDynamicSupport.bootstrap("process", $$robo$$org_apache_http_client_protocol_RequestProxyAuthentication$process(org.apache.http.HttpRequest org.apache.http.protocol.HttpContext ), 0, this, httpRequest, httpContext);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RequestProxyAuthentication)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

