/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.utils;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.HttpHost;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class URIUtils
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;

    private static final URI $$robo$$org_apache_http_client_utils_URIUtils$createURI(String scheme, String host, int port, String path, String query, String fragment) throws URISyntaxException {
        StringBuilder buffer = new StringBuilder();
        if (host != null) {
            if (scheme != null) {
                buffer.append(scheme);
                buffer.append("://");
            }
            buffer.append(host);
            if (port > 0) {
                buffer.append(':');
                buffer.append(port);
            }
        }
        if (path == null || !path.startsWith("/")) {
            buffer.append('/');
        }
        if (path != null) {
            buffer.append(path);
        }
        if (query != null) {
            buffer.append('?');
            buffer.append(query);
        }
        if (fragment != null) {
            buffer.append('#');
            buffer.append(fragment);
        }
        return new URI(buffer.toString());
    }

    private static final URI $$robo$$org_apache_http_client_utils_URIUtils$rewriteURI(URI uri, HttpHost target, boolean dropFragment) throws URISyntaxException {
        if (uri == null) {
            throw new IllegalArgumentException("URI may nor be null");
        }
        if (target != null) {
            return URIUtils.createURI(target.getSchemeName(), target.getHostName(), target.getPort(), uri.getRawPath(), uri.getRawQuery(), dropFragment ? null : uri.getRawFragment());
        }
        return URIUtils.createURI(null, null, -1, uri.getRawPath(), uri.getRawQuery(), dropFragment ? null : uri.getRawFragment());
    }

    private static final URI $$robo$$org_apache_http_client_utils_URIUtils$rewriteURI(URI uri, HttpHost target) throws URISyntaxException {
        return URIUtils.rewriteURI(uri, target, false);
    }

    private static final URI $$robo$$org_apache_http_client_utils_URIUtils$resolve(URI baseURI, String reference) {
        return URIUtils.resolve(baseURI, URI.create(reference));
    }

    private static final URI $$robo$$org_apache_http_client_utils_URIUtils$resolve(URI baseURI, URI reference) {
        boolean emptyReference;
        if (baseURI == null) {
            throw new IllegalArgumentException("Base URI may nor be null");
        }
        if (reference == null) {
            throw new IllegalArgumentException("Reference URI may nor be null");
        }
        boolean bl = emptyReference = reference.toString().length() == 0;
        if (emptyReference) {
            reference = URI.create("#");
        }
        URI resolved = baseURI.resolve(reference);
        if (emptyReference) {
            String resolvedString = resolved.toString();
            resolved = URI.create(resolvedString.substring(0, resolvedString.indexOf(35)));
        }
        return resolved;
    }

    private void $$robo$$org_apache_http_client_utils_URIUtils$__constructor__() {
    }

    public static URI createURI(String string2, String string3, int n, String string4, String string5, String string6) throws URISyntaxException {
        return InvokeDynamicSupport.bootstrapStatic("createURI", $$robo$$org_apache_http_client_utils_URIUtils$createURI(java.lang.String java.lang.String int java.lang.String java.lang.String java.lang.String ), 0, (String)string2, (String)string3, (int)n, (String)string4, (String)string5, (String)string6);
    }

    public static URI rewriteURI(URI uRI, HttpHost httpHost, boolean bl) throws URISyntaxException {
        return InvokeDynamicSupport.bootstrapStatic("rewriteURI", $$robo$$org_apache_http_client_utils_URIUtils$rewriteURI(java.net.URI org.apache.http.HttpHost boolean ), 0, (URI)uRI, (HttpHost)httpHost, (boolean)bl);
    }

    public static URI rewriteURI(URI uRI, HttpHost httpHost) throws URISyntaxException {
        return InvokeDynamicSupport.bootstrapStatic("rewriteURI", $$robo$$org_apache_http_client_utils_URIUtils$rewriteURI(java.net.URI org.apache.http.HttpHost ), 0, (URI)uRI, (HttpHost)httpHost);
    }

    public static URI resolve(URI uRI, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("resolve", $$robo$$org_apache_http_client_utils_URIUtils$resolve(java.net.URI java.lang.String ), 0, (URI)uRI, (String)string2);
    }

    public static URI resolve(URI uRI, URI uRI2) {
        return InvokeDynamicSupport.bootstrapStatic("resolve", $$robo$$org_apache_http_client_utils_URIUtils$resolve(java.net.URI java.net.URI ), 0, (URI)uRI, (URI)uRI2);
    }

    private void __constructor__() {
        this.$$robo$$org_apache_http_client_utils_URIUtils$__constructor__();
    }

    private URIUtils() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_client_utils_URIUtils$__constructor__(), 0, this);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (URIUtils)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

